/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.deepl;

import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.config.Config;
import org.eclnt.ccee.deepl.json.DeeplRequestBodyData;
import org.eclnt.ccee.json.jackson.JSONUtil;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.file.StreamUtil;

public class DeeplFreeTranslation {
    static final String DEEPL_URL = "https://api-free.deepl.com/v2/translate";
    static String s_deeplAPIKey = null;
    static DeeplFreeTranslation s_instance = new DeeplFreeTranslation();

    public static void initializeInstance(DeeplFreeTranslation instance) {
        s_instance = instance;
    }

    public static void initializeDeeplAPIKey(String key) {
        s_deeplAPIKey = key;
    }

    public static DeeplFreeTranslation instance() {
        return s_instance;
    }

    public String[] translateLiterals(String[] literals, String fromLanguage, String toLanguage, String context) {
        if (s_deeplAPIKey == null) {
            throw new Error("No API key specified: the API key needs to be passed using the method: initializeDeeplAPIKey");
        }
        if (literals == null) {
            return new String[0];
        }
        if (literals.length == 0) {
            return new String[0];
        }
        try {
            AppLog.L.log(AppLog.LL_INF, "Deepl translation called. Number of literals: " + literals.length);
            String jsonBody = this.createJsonBody(literals, fromLanguage, toLanguage, context);
            String responseString = this.callTranslationService(jsonBody);
            AppLog.L.log(AppLog.LL_INF, "Deepl responded. Repsonse length: " + responseString.length());
            String[] result = this.parseResponseTexts(responseString);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Error when translating literals:", t);
        }
    }

    private String createJsonBody(String[] literals, String fromLanguage, String toLanguage, String context) {
        DeeplRequestBodyData body = new DeeplRequestBodyData();
        body.setSourceLanguage(fromLanguage);
        body.setTargetLanguage(toLanguage);
        for (String literal : literals) {
            body.getLiterals().add(literal);
        }
        String jsonBody = body.toJson();
        return jsonBody;
    }

    private String callTranslationService(String jsonBody) throws Exception {
        URL url = new URL(DEEPL_URL);
        HttpURLConnection con = (HttpURLConnection)url.openConnection();
        con.setRequestMethod("POST");
        con.setDoOutput(true);
        con.setRequestProperty("Authorization", "DeepL-Auth-Key " + s_deeplAPIKey);
        con.setRequestProperty("Content-Type", "application/json");
        con.getOutputStream().write(jsonBody.getBytes("UTF-8"));
        InputStream is = con.getInputStream();
        byte[] isBytes = StreamUtil.transferStreamContentIntoBytes((InputStream)is);
        String responseString = new String(isBytes, "UTF-8");
        return responseString;
    }

    private String[] parseResponseTexts(String responseString) {
        ArrayList<String> resultList = new ArrayList<String>();
        Map<String, Object> m = JSONUtil.unmarshalMap(responseString);
        List items = (List)m.get("translations");
        for (Object item : items) {
            Map mItem = (Map)item;
            String text = mItem.get("text") + "";
            resultList.add(text);
        }
        String[] result = new String[resultList.size()];
        resultList.toArray(result);
        return result;
    }

    static {
        String deeplAPIKey = Config.getConfigValue("deepl_apikey");
        if (deeplAPIKey != null) {
            DeeplFreeTranslation.initializeDeeplAPIKey(deeplAPIKey);
        }
    }
}

