/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.dyndata.functions;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.dyndata.DynDataMap;
import org.eclnt.ccee.dyndata.DynDataReaderContext;
import org.eclnt.ccee.dyndata.DynDataUtil;
import org.eclnt.ccee.dyndata.functions.IFunctionExecutor;
import org.eclnt.ccee.dyndata.literals.DynDataLiteralResolver;
import org.eclnt.ccee.dyndata.meta.IDynDataConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.util.valuemgmt.Base64;
import org.eclnt.util.valuemgmt.ValueManager;

public class FunctionExecutor
implements IDynDataConstants {
    static List<IFunctionExecutor> s_executors = new ArrayList<IFunctionExecutor>();
    static List<IFunctionExecutor> s_executorsRT = new ArrayList<IFunctionExecutor>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addFunctionExecutor(IFunctionExecutor executor) {
        List<IFunctionExecutor> list = s_executors;
        synchronized (list) {
            if (!s_executors.contains(executor)) {
                s_executors.add(executor);
            }
            FunctionExecutor.transferIntoRT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeFunctionExecutor(IFunctionExecutor executor) {
        List<IFunctionExecutor> list = s_executors;
        synchronized (list) {
            s_executors.remove(executor);
            FunctionExecutor.transferIntoRT();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearFunctionExecutors() {
        List<IFunctionExecutor> list = s_executors;
        synchronized (list) {
            s_executors.clear();
            FunctionExecutor.transferIntoRT();
        }
    }

    public static Object executeMethod(DynDataReaderContext ddrContext, DynDataMap dynDataMap, String methodName, String[] methodParams) {
        List<IFunctionExecutor> fes = s_executorsRT;
        for (IFunctionExecutor fe : fes) {
            if (!fe.checkIfMethodIsHandled(methodName)) continue;
            return fe.executeMethod(dynDataMap, methodName, methodParams);
        }
        if ("isEmpty".equals(methodName)) {
            return FunctionExecutor.executeMethodIsEmpty(dynDataMap, methodParams);
        }
        if ("isNotEmpty".equals(methodName)) {
            return !FunctionExecutor.executeMethodIsEmpty(dynDataMap, methodParams);
        }
        if ("isNull".equals(methodName)) {
            return FunctionExecutor.executeMethodIsNull(dynDataMap, methodParams);
        }
        if ("isNotNull".equals(methodName)) {
            return !FunctionExecutor.executeMethodIsNull(dynDataMap, methodParams);
        }
        if ("uppercase".equals(methodName)) {
            return FunctionExecutor.executeMethodUppercase(dynDataMap, methodParams, false);
        }
        if ("lowercase".equals(methodName)) {
            return FunctionExecutor.executeMethodLowercase(dynDataMap, methodParams, false);
        }
        if ("uppercaseid".equals(methodName)) {
            return FunctionExecutor.executeMethodUppercase(dynDataMap, methodParams, true);
        }
        if ("lowercaseid".equals(methodName)) {
            return FunctionExecutor.executeMethodLowercase(dynDataMap, methodParams, true);
        }
        if ("parent".equals(methodName)) {
            return FunctionExecutor.executeMethodParent(dynDataMap, methodParams, true);
        }
        if ("top".equals(methodName)) {
            return FunctionExecutor.executeMethodTop(dynDataMap, methodParams, true);
        }
        if ("bigdecimal".equals(methodName)) {
            return FunctionExecutor.executeMethodBigdecimal(dynDataMap, methodParams);
        }
        if ("int".equals(methodName)) {
            return FunctionExecutor.executeMethodInt(dynDataMap, methodParams);
        }
        if ("raw".equals(methodName)) {
            return FunctionExecutor.executeMethodRaw(dynDataMap, methodParams);
        }
        if ("literal".equals(methodName)) {
            return FunctionExecutor.executeMethodLiteral(ddrContext, dynDataMap, methodParams);
        }
        if ("decodeBase64".equals(methodName)) {
            return FunctionExecutor.executeMethodDecodeBase64(ddrContext, dynDataMap, methodParams);
        }
        if ("decodeHex".equals(methodName)) {
            return FunctionExecutor.executeMethodDecodeHex(ddrContext, dynDataMap, methodParams);
        }
        if ("replace".equals(methodName)) {
            return FunctionExecutor.executeMethodReplace(ddrContext, dynDataMap, methodParams);
        }
        throw new Error("unknown method name");
    }

    private static Object executeMethodUppercase(DynDataMap dynDataMap, String[] methodParams, boolean asId) {
        if (methodParams == null || methodParams.length != 1) {
            throw new Error("Wrong number of parameters. Must be 1.");
        }
        String param = methodParams[0];
        Object value = dynDataMap.get(param);
        if (value == null) {
            return null;
        }
        if (!asId) {
            return ValueManager.toUpperCaseText((String)("" + value));
        }
        return ValueManager.toUpperCaseId((String)("" + value));
    }

    private static Object executeMethodLowercase(DynDataMap dynDataMap, String[] methodParams, boolean asId) {
        if (methodParams == null || methodParams.length != 1) {
            throw new Error("Wrong number of parameters. Must be 1.");
        }
        String param = methodParams[0];
        Object value = dynDataMap.get(param);
        if (value == null) {
            return null;
        }
        if (!asId) {
            return ValueManager.toLowerCaseText((String)("" + value));
        }
        return ValueManager.toLowerCaseId((String)("" + value));
    }

    private static boolean executeMethodIsNull(DynDataMap dynDataMap, String[] methodParams) {
        if (methodParams == null || methodParams.length != 1) {
            throw new Error("Wrong number of parameters. Must be 1.");
        }
        String param = methodParams[0];
        Object value = dynDataMap.get(param);
        return value == null;
    }

    private static boolean executeMethodIsEmpty(DynDataMap dynDataMap, String[] methodParams) {
        if (methodParams == null || methodParams.length != 1) {
            throw new Error("Wrong number of parameters. Must be 1.");
        }
        String param = methodParams[0];
        Object value = dynDataMap.get(param);
        if (value == null) {
            return true;
        }
        return ("" + value).length() == 0;
    }

    private static Object executeMethodParent(DynDataMap dynDataMap, String[] methodParams, boolean b) {
        if (methodParams == null || methodParams.length != 1) {
            throw new Error("Wrong number of parameters. Must be 1.");
        }
        String param = methodParams[0];
        DynDataMap parent = FunctionExecutor.findParent(dynDataMap, param);
        return parent;
    }

    private static Object executeMethodTop(DynDataMap dynDataMap, String[] methodParams, boolean b) {
        if (methodParams == null || methodParams.length > 1) {
            throw new Error("Wrong number of parameters. Must be 0 or 1.");
        }
        String target = null;
        if (methodParams != null && methodParams.length > 0) {
            target = methodParams[0];
        }
        DynDataMap parent = FunctionExecutor.findTopParent(dynDataMap, target);
        return parent;
    }

    private static DynDataMap findTopParent(DynDataMap dynDataMap, String target) {
        if (dynDataMap == null) {
            return null;
        }
        DynDataMap current = dynDataMap;
        while (target == null || !target.equals(current.getDataDefinitionId())) {
            DynDataMap parent = current.getParent();
            if (parent == null || "DDEXTRAROOT".equals(parent.getDataDefinitionId())) {
                if (target == null) {
                    return current;
                }
                return null;
            }
            current = parent;
        }
        return current;
    }

    private static DynDataMap findParent(DynDataMap dynDataMap, String param) {
        if (dynDataMap == null) {
            return null;
        }
        if (param == null) {
            return null;
        }
        DynDataMap current = dynDataMap;
        do {
            if ((current = current.getParent()) != null) continue;
            return null;
        } while (!ValueManager.checkIfStringsAreEqual((String)param, (String)current.getDataDefinitionId()));
        return current;
    }

    private static void transferIntoRT() {
        s_executorsRT = new ArrayList<IFunctionExecutor>();
        s_executorsRT.addAll(s_executors);
    }

    private static Object executeMethodBigdecimal(DynDataMap dynDataMap, String[] methodParams) {
        if (methodParams == null || methodParams.length != 1) {
            throw new Error("Wrong number of parameters. Must be 1.");
        }
        String param = methodParams[0];
        Object value = dynDataMap.getContent(param);
        if (value == null) {
            return null;
        }
        try {
            String valueString = ValueManager.convertObject2ValueString((Object)value);
            BigDecimal result = (BigDecimal)ValueManager.convertStringIntoObject((String)valueString, BigDecimal.class);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Trying to convert value into BigDecimal - but failed. Value: " + value, t);
        }
    }

    private static Object executeMethodInt(DynDataMap dynDataMap, String[] methodParams) {
        if (methodParams == null || methodParams.length != 1) {
            throw new Error("Wrong number of parameters. Must be 1.");
        }
        String param = methodParams[0];
        Object value = dynDataMap.getContent(param);
        if (value == null) {
            return null;
        }
        try {
            String valueString = ValueManager.convertObject2ValueString((Object)value);
            Integer result = (Integer)ValueManager.convertStringIntoObject((String)valueString, Integer.class);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Trying to convert value into int - but failed. Value: " + value, t);
        }
    }

    private static Object executeMethodRaw(DynDataMap dynDataMap, String[] methodParams) {
        if (methodParams == null || methodParams.length != 1) {
            throw new Error("Wrong number of parameters. Must be 1.");
        }
        String param = methodParams[0];
        Object value = dynDataMap.getContent(param);
        return value;
    }

    private static Object executeMethodLiteral(DynDataReaderContext ddrContext, DynDataMap dynDataMap, String[] methodParams) {
        if (methodParams == null || methodParams.length < 1) {
            throw new Error("Wrong number of parameters. Must be at least 1.");
        }
        String literalId = methodParams[0];
        String[] literalParams = new String[methodParams.length - 1];
        for (int i = 1; i < methodParams.length; ++i) {
            literalParams[i - 1] = FunctionExecutor.updateLiteralParameterIfDynamic(dynDataMap, methodParams[i]);
        }
        return DynDataLiteralResolver.instance().resolveLiteralText(ddrContext, dynDataMap, literalId, literalParams);
    }

    private static Object executeMethodDecodeBase64(DynDataReaderContext ddrContext, DynDataMap dynDataMap, String[] methodParams) {
        if (methodParams == null || methodParams.length < 1) {
            throw new Error("Wrong number of parameters. Must be at least 1.");
        }
        try {
            String s = (String)dynDataMap.get(methodParams[0]);
            byte[] result = Base64.decode((String)s);
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Object executeMethodDecodeHex(DynDataReaderContext ddrContext, DynDataMap dynDataMap, String[] methodParams) {
        if (methodParams == null || methodParams.length < 1) {
            throw new Error("Wrong number of parameters. Must be at least 1.");
        }
        try {
            String s = (String)dynDataMap.get(methodParams[0]);
            byte[] result = ValueManager.decodeHexString((String)s);
            return result;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static Object executeMethodReplace(DynDataReaderContext ddrContext, DynDataMap dynDataMap, String[] methodParams) {
        if (methodParams == null || methodParams.length < 1) {
            throw new Error("Wrong number of parameters. Must be at least 1.");
        }
        try {
            String s = (String)dynDataMap.get(methodParams[0]);
            if (s == null) {
                return null;
            }
            for (int i = 1; i < methodParams.length; i += 2) {
                try {
                    String from = methodParams[i];
                    String to = methodParams[i + 1];
                    if (from == null || to == null) continue;
                    if (DynDataUtil.checkIfDataExpression(from)) {
                        throw new Exception("From string of replacement must not be data expression: " + from);
                    }
                    if (DynDataUtil.checkIfDataExpression(to)) {
                        Object toValue;
                        String toValueString;
                        String[] toKeys = DynDataUtil.getKeysOfDataExpression(to);
                        DynDataMap rep = dynDataMap.getCurrentDataRequestEntryPoint();
                        if (rep == null || (toValueString = ValueManager.convertObject2ValueString((Object)(toValue = rep.getAttributeValueForChainOfKeys(toKeys)))) == null) continue;
                        s = s.replace(from, toValueString);
                        continue;
                    }
                    s = s.replace(from, to);
                    continue;
                }
                catch (Throwable t) {
                    AppLog.L.log(ICCEEConstants.LL_INF, "Problem during replace method, " + methodParams, t);
                }
            }
            return s;
        }
        catch (Throwable t) {
            return null;
        }
    }

    private static String updateLiteralParameterIfDynamic(DynDataMap dynDataMap, String param) {
        if (param == null) {
            return null;
        }
        if (!DynDataUtil.checkIfDataExpression(param)) {
            return param;
        }
        String dynParamContent = param.substring(2, param.length() - 1);
        Object o = dynDataMap.get(dynParamContent);
        String result = ValueManager.convertObject2ValueString((Object)o);
        return result;
    }
}

