/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.util;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectOutputStream;
import org.eclnt.ccee.bridges.ClassLoaderBridge;
import org.eclnt.ccee.util.CloneUtil;

public class SerializationUtil {
    public static byte[] serialize(Object o) {
        if (o == null) {
            return null;
        }
        return SerializationUtil.serialize(o, 10000);
    }

    public static byte[] serialize(Object o, int size) {
        if (o == null) {
            return null;
        }
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream(size);
            ObjectOutputStream oos = new ObjectOutputStream(bos);
            oos.writeObject(o);
            oos.flush();
            oos.close();
            bos.close();
            byte[] bytes = bos.toByteArray();
            return bytes;
        }
        catch (Throwable t) {
            throw new Error("Problem when serializing object of class: " + o.getClass(), t);
        }
    }

    public static Object deserialize(byte[] bytes) {
        return SerializationUtil.deserialize(bytes, ClassLoaderBridge.findCurrentClassLoader());
    }

    public static Object deserialize(byte[] bytes, ClassLoader classLoader) {
        if (bytes == null) {
            return null;
        }
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            CloneUtil.MyObjectInputStream mois = new CloneUtil.MyObjectInputStream(bais, classLoader);
            Object result = mois.readObject();
            mois.close();
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem when deserializing object", t);
        }
    }
}

