/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.xmlrdf;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDExportSanitizer;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDXmlExporter;
import org.eclnt.jsfserver.elements.util.ENUMExportType;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.util.valuemgmt.XMLWriter;

public class FIXGRIDXmlRdfExporter
implements IFIXGRIDXmlExporter {
    FIXGRIDBinding m_fixgrid;
    boolean m_selectedItemsOnly = false;
    String m_contentNameSpaceURL = "http://demo/demo";
    String m_contentNameSpaceAbbreviation = "co";
    Map<String, String> m_exportReferenceNameMapping = new HashMap<String, String>();

    public String exportGrid(FIXGRIDBinding fixgrid, boolean selectedItemsOnly) {
        this.m_fixgrid = fixgrid;
        this.m_selectedItemsOnly = selectedItemsOnly;
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)bos, ValueManager.CHARSET_UTF8.name());
            this.writeRDFStart(writer);
            List items = this.m_fixgrid.getExporter().exportToStringListWholeGrid(this.m_selectedItemsOnly);
            FIXGRIDExportSanitizer.instance().sanitizeStringDataBeforeExport(ENUMExportType.XML, items);
            this.appendToWriterXML(writer, items, "rdf:Description");
            this.writeRDFEnd(writer);
            writer.close();
            bos.close();
            String result = new String(bos.toByteArray(), ValueManager.CHARSET_UTF8);
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error happened during CSV export", t);
            return null;
        }
    }

    public String getContentNameSpaceURL() {
        return this.m_contentNameSpaceURL;
    }

    public void setContentNameSpaceURL(String contentNameSpaceURL) {
        this.m_contentNameSpaceURL = contentNameSpaceURL;
    }

    public String getContentNameSpaceAbbreviation() {
        return this.m_contentNameSpaceAbbreviation;
    }

    public void setContentNameSpaceAbbreviation(String contentNameSpaceAbbreviation) {
        this.m_contentNameSpaceAbbreviation = contentNameSpaceAbbreviation;
    }

    public Map<String, String> getExportReferenceNameMapping() {
        return this.m_exportReferenceNameMapping;
    }

    protected void writeRDFStart(OutputStreamWriter writer) throws Exception {
        XMLWriter.writer_startElement((Writer)writer, null, (String)"rdf:RDF");
        XMLWriter.writer_writeAttribute((Writer)writer, null, (String)"xmlns:rdf", (Object)"http://www.w3.org/1999/02/22-rdf-syntax-ns#");
        XMLWriter.writer_writeAttribute((Writer)writer, null, (String)("xmlns:" + this.m_contentNameSpaceAbbreviation), (Object)this.m_contentNameSpaceURL);
        XMLWriter.writer_closeStartElement((Writer)writer, null);
    }

    protected void writeRDFEnd(OutputStreamWriter writer) throws Exception {
        XMLWriter.writer_endElement((Writer)writer, null, (String)"rdf:RDF");
    }

    protected void appendToWriterXML(Writer writer, List<List<String>> items, String rowtag) throws Exception {
        List<String> contentNames = this.findColumnContentNames();
        for (List<String> item : items) {
            XMLWriter.writer_startElement((Writer)writer, null, (String)rowtag);
            XMLWriter.writer_closeStartElement((Writer)writer, null);
            int valueCounter = -1;
            for (String value : item) {
                String contentName = "unknown";
                if (++valueCounter < contentNames.size()) {
                    contentName = contentNames.get(valueCounter);
                }
                XMLWriter.writer_startElement((Writer)writer, null, (String)(this.m_contentNameSpaceAbbreviation + ":" + contentNames.get(valueCounter)));
                XMLWriter.writer_closeStartElementWithoutLineFeed((Writer)writer, null);
                XMLWriter.writer_writeText((Writer)writer, null, (String)value);
                XMLWriter.writer_endElement((Writer)writer, null, (String)(this.m_contentNameSpaceAbbreviation + ":" + contentNames.get(valueCounter)));
            }
            XMLWriter.writer_endElement((Writer)writer, null, (String)rowtag);
        }
    }

    protected List<String> findColumnContentNames() {
        ArrayList<String> result = new ArrayList<String>();
        List columns = this.m_fixgrid.getColumnInfos();
        for (FIXGRIDComponent.ColumnInfo column : columns) {
            if (column.getSortreference() == null) continue;
            String contentName = column.getExportReference();
            contentName = this.m_exportReferenceNameMapping.containsKey(contentName) ? this.m_exportReferenceNameMapping.get(contentName) : contentName.replace(".", "").replace("#", "").replace("{", "").replace("}", "").replace("'", "").replace("[", "").replace("]", "");
            result.add(contentName);
        }
        return result;
    }
}

