/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.Statement;
import java.util.Enumeration;
import org.eclnt.ccee.db.DBAccess;
import org.eclnt.ccee.db.dofw.DBConnectionPool;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.jsfserver.util.IStartUpWithShutDown;

public class DBStartUpShutDown
implements IStartUpWithShutDown {
    public void startUp() {
    }

    public void shutDown() {
        boolean shutDownRequired = this.checkIfShutDownIsRequired();
        if (shutDownRequired) {
            this.shutDownExecute();
        }
    }

    protected boolean checkIfShutDownIsRequired() {
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = null;
            try {
                driver = drivers.nextElement();
                if (driver.getClass().getClassLoader() != this.getClass().getClassLoader() || driver.getClass().getName().toLowerCase().indexOf("hsqldb") < 0) continue;
                return true;
            }
            catch (Throwable t) {
                AppLog.L.log(AppLog.LL_INF, "Deregistering driver failed: " + driver, t);
            }
        }
        return false;
    }

    protected void shutDownExecute() {
        AppLog.L.log(AppLog.LL_INF, "Shutting down CCEE-DB layer");
        this.shutDownConnectionPools();
        this.shutDownDatabase();
        this.shutDownDriver();
    }

    protected void shutDownDriver() {
        AppLog.L.log(AppLog.LL_INF, "Sending deregistering drivers ...");
        Enumeration<Driver> drivers = DriverManager.getDrivers();
        while (drivers.hasMoreElements()) {
            Driver driver = null;
            try {
                driver = drivers.nextElement();
                if (driver.getClass().getClassLoader() != this.getClass().getClassLoader()) continue;
                DriverManager.deregisterDriver(driver);
            }
            catch (Throwable t) {
                AppLog.L.log(AppLog.LL_INF, "Deregistering driver failed: " + driver, t);
            }
        }
    }

    protected void shutDownDatabase() {
        Connection c = null;
        try {
            AppLog.L.log(AppLog.LL_INF, "Sending SHUTDOWN to database ...");
            c = DBAccess.createConnection("CCEE_DEFAULTCONTEXT");
            Statement statement = c.createStatement();
            statement.execute("SHUTDOWN");
            statement.close();
            c.close();
        }
        catch (Throwable t) {
            try {
                c.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            AppLog.L.log(AppLog.LL_INF, "Sending SHUTDOWN to database ..." + t.toString(), t);
        }
    }

    protected void shutDownConnectionPools() {
        try {
            AppLog.L.log(AppLog.LL_INF, "Shutting down all DB connection pool ...");
            DBConnectionPool.closeAllConnections();
        }
        catch (Throwable t) {
            AppLog.L.log(AppLog.LL_INF, "Closing connection pool failed: " + t.toString(), t);
        }
    }
}

