/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.cache;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.dofw.DOFWSql;

public class CACHESql
implements ICCEEConstants {
    static long s_maxCacheAge = 60000L;
    Map<String, CachedObject> m_cache = new HashMap<String, CachedObject>();

    public static void initializeMaxCacheAge(long value) {
        s_maxCacheAge = value;
    }

    public <OBJTYPE> OBJTYPE queryOne(Class<OBJTYPE> clazz, Object ... colVals) {
        return this.queryOne("CCEE_DEFAULTCONTEXT", clazz, colVals);
    }

    public <OBJTYPE> OBJTYPE queryOne(String contextName, Class<OBJTYPE> clazz, Object ... colVals) {
        String keyStr = this.generateCacheKey("queryOne", contextName, clazz, colVals);
        CachedObject cachedObject = this.readCachedObject(keyStr);
        if (cachedObject == null) {
            OBJTYPE obj = DOFWSql.queryOne(contextName, clazz, colVals);
            cachedObject = new CachedObject(obj);
            this.m_cache.put(keyStr, cachedObject);
        }
        return (OBJTYPE)cachedObject.getObject();
    }

    public <OBJTYPE> List<OBJTYPE> query(Class<OBJTYPE> clazz, Object ... colVals) {
        return this.query("CCEE_DEFAULTCONTEXT", clazz, colVals);
    }

    public <OBJTYPE> List<OBJTYPE> query(String contextName, Class<OBJTYPE> clazz, Object ... colVals) {
        String keyStr = this.generateCacheKey("query", contextName, clazz, colVals);
        CachedObject cachedObject = this.readCachedObject(keyStr);
        if (cachedObject == null) {
            List<OBJTYPE> obj = DOFWSql.query(contextName, clazz, colVals);
            cachedObject = new CachedObject(obj);
            this.m_cache.put(keyStr, cachedObject);
        }
        return (List)cachedObject.getObject();
    }

    public <OBJTYPE> List<OBJTYPE> queryTop(Class<OBJTYPE> clazz, int top, Object ... colVals) {
        return this.queryTop("CCEE_DEFAULTCONTEXT", clazz, top, colVals);
    }

    public <OBJTYPE> List<OBJTYPE> queryTop(String contextName, Class<OBJTYPE> clazz, int top, Object ... colVals) {
        String keyStr = this.generateCacheKey("queryTop|" + top, contextName, clazz, colVals);
        CachedObject cachedObject = this.readCachedObject(keyStr);
        if (cachedObject == null) {
            List<OBJTYPE> obj = DOFWSql.queryTop(contextName, clazz, top, colVals);
            cachedObject = new CachedObject(obj);
            this.m_cache.put(keyStr, cachedObject);
        }
        return (List)cachedObject.getObject();
    }

    protected CachedObject readCachedObject(String keyStr) {
        CachedObject cachedObject = this.m_cache.get(keyStr);
        if (cachedObject != null) {
            if (System.currentTimeMillis() - cachedObject.getTimestampAccessed() > s_maxCacheAge) {
                return null;
            }
            cachedObject.setTimestampAccessed(System.currentTimeMillis());
        }
        return cachedObject;
    }

    private String generateCacheKey(String usage, String contextName, Class<?> clazz, Object ... colVals) {
        StringBuilder key = new StringBuilder();
        key.append(usage).append('|').append(contextName).append('|').append(clazz.getName());
        for (Object o : colVals) {
            key.append('|').append(o);
        }
        return key.toString();
    }

    class CachedObject {
        Object i_object;
        long i_timestampCreated = System.currentTimeMillis();
        long i_timestampAccessed = System.currentTimeMillis();

        public CachedObject(Object object) {
            this.i_object = object;
        }

        public long getTimestampAccessed() {
            return this.i_timestampAccessed;
        }

        public void setTimestampAccessed(long timestampAccessed) {
            this.i_timestampAccessed = timestampAccessed;
        }

        public Object getObject() {
            return this.i_object;
        }

        public long getTimestampCreated() {
            return this.i_timestampCreated;
        }
    }
}

