/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw;

import com.veracode.annotation.SQLQueryCleanser;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.config.Config;
import org.eclnt.ccee.db.DBAction;
import org.eclnt.ccee.db.dofw.DOFWDialect;
import org.eclnt.ccee.db.dofw.DOFWEntity;
import org.eclnt.ccee.db.dofw.DOFWExecutor;
import org.eclnt.ccee.db.dofw.DOFWProperty;
import org.eclnt.ccee.db.dofw.DOFWRepository;
import org.eclnt.ccee.db.dofw.DynSqlAddon;
import org.eclnt.ccee.db.dofw.ISQLQueryUpdate;
import org.eclnt.ccee.db.dofw.trace.Trace;
import org.eclnt.ccee.db.dofw.util.DOFWBuffer;
import org.eclnt.ccee.db.dofw.util.DOFWMapper;
import org.eclnt.ccee.db.dofw.util.DOFWUtils;
import org.eclnt.ccee.db.dofw.util.ENUMMappingInfo;
import org.eclnt.ccee.db.dofw.util.QueryParameterFunction;
import org.eclnt.ccee.db.dofw.util.ValuesBETWEEN;
import org.eclnt.ccee.db.dofw.util.ValuesIN;
import org.eclnt.ccee.db.util.QueryUtils;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.util.ObjectHolder;
import org.eclnt.jsfserver.util.useraccess.TenantAccessMgr;
import org.eclnt.util.map.IBeanWithDataMap;
import org.eclnt.util.mitigation.CCMitigation;
import org.eclnt.util.valuemgmt.ValueManager;

@CCMitigation(cweIds={"89"}, comment="This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.")
public class DOFWSql
implements ICCEEConstants {
    public static final String COMMENT_mitigation = "This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.";
    static final String PREFIX_YYMMDDCENTURYREFERENCE = "@YYMMDDCenturyReference@/";
    static final int NO_OFFSET = -1;
    static final int NO_TOP = -1;
    private static ISQLQueryUpdate s_sqlQueryUpdate = null;
    private static boolean s_valueLoggingActive = false;

    public static void initialize(ISQLQueryUpdate sqlQueryUpdate) {
        s_sqlQueryUpdate = sqlQueryUpdate;
    }

    public static void setValueLoggingActive(boolean valueLoggingActive) {
        s_valueLoggingActive = valueLoggingActive;
        if (valueLoggingActive) {
            AppLog.L.log(LL_WAR, "Value logging for DOFW SQL queries is activated - this is not recommended for productive systems!");
            AppLog.L.log(LL_WAR, "The called of this operation is visible by the following stack trace", new Throwable("Stack trace for activation of value logging - this is not an error! but just some extended logging!"));
        } else {
            AppLog.L.log(LL_WAR, "Value logging for DOFW SQL queries is deactivated.");
        }
    }

    public static boolean getValueLoggingActive() {
        return s_valueLoggingActive;
    }

    @SQLQueryCleanser(userComment="This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.")
    public static <OBJTYPE> OBJTYPE queryOne(Class<OBJTYPE> clazz, Object ... colVals) {
        return DOFWSql.queryOne("CCEE_DEFAULTCONTEXT", clazz, colVals);
    }

    public static <OBJTYPE> OBJTYPE queryOne(Class<OBJTYPE> clazz, Object[] colVals, Object[] orderBy) {
        return DOFWSql.queryOne("CCEE_DEFAULTCONTEXT", clazz, colVals, orderBy);
    }

    public static <OBJTYPE> OBJTYPE queryOne(String contextName, Class<OBJTYPE> clazz, Object ... colVals) {
        DOFWUtils.SplitUpColVals split = DOFWUtils.splitUpQueryColVals(colVals);
        return DOFWSql.queryOne(contextName, clazz, split.getColVals(), split.getOrderBy());
    }

    public static <OBJTYPE> OBJTYPE queryOne(String contextName, Class<OBJTYPE> clazz, Object[] colVals, Object[] orderBy) {
        try {
            DOFWBuffer.BufferResult buffered;
            if (orderBy == null && DOFWBuffer.checkIfBuffered(clazz) && (buffered = DOFWBuffer.readObjectFromBuffer(clazz, colVals)).isBufferedObjectWasAvailable()) {
                return (OBJTYPE)buffered.getBufferedObject();
            }
            List<OBJTYPE> l = DOFWSql.queryTop(contextName, clazz, 1, colVals, orderBy);
            OBJTYPE result = null;
            if (l.size() > 0) {
                result = l.get(0);
            }
            if (DOFWBuffer.checkIfBuffered(clazz)) {
                DOFWBuffer.updateObjectBuffer(clazz, result, colVals);
            }
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem during queryOne: " + clazz.getName(), t);
        }
    }

    public static List<Object[]> queryGuidedSql(Class clazz, String[] colSelections, String conditionString, String orderString, Object[] values) {
        return DOFWSql.queryGuidedSql("CCEE_DEFAULTCONTEXT", clazz, colSelections, conditionString, orderString, values);
    }

    @SQLQueryCleanser(userComment="This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.")
    public static List<Object[]> queryGuidedSql(final String contextName, final Class clazz, final String[] colSelections, final String conditionString, final String orderString, final Object[] values) {
        if (colSelections == null) {
            throw new Error("colSelections must not be null");
        }
        if (colSelections.length == 0) {
            throw new Error("colSelections must contain at least one item");
        }
        final ArrayList<Object[]> result = new ArrayList<Object[]>();
        new DBAction(){

            @Override
            protected void run() throws Exception {
                DOFWEntity entity = DOFWRepository.getEntity(clazz, true);
                if (entity.isTransient()) {
                    throw new Error("Query operation with entity defined as transient is not possible: " + clazz);
                }
                StringBuffer queryCol = new StringBuffer();
                for (String colSelection : colSelections) {
                    if (queryCol.length() > 0) {
                        queryCol.append(",");
                    }
                    queryCol.append(DOFWUtils.replacePropertyNames(contextName, clazz, colSelection));
                }
                String queryCondition = conditionString;
                queryCondition = DOFWUtils.replacePropertyNames(contextName, clazz, queryCondition);
                DOFWUtils.ReplaceResult rr = DOFWUtils.replaceVariables(contextName, clazz, queryCondition);
                queryCondition = rr.getQueryString();
                if (entity.getTenantColumn() != null) {
                    queryCondition = queryCondition == null || queryCondition.length() == 0 ? entity.getTenantColumn() + "=?" : entity.getTenantColumn() + "=? AND (" + queryCondition + ")";
                }
                String queryOrderBy = orderString;
                queryOrderBy = DOFWUtils.replacePropertyNames(contextName, clazz, queryOrderBy);
                String query = "SELECT " + queryCol.toString() + " FROM " + this.withSchema(entity);
                if (queryCondition != null && queryCondition.length() > 0) {
                    query = query + " WHERE " + queryCondition;
                }
                if (orderString != null && orderString.length() > 0) {
                    query = query + " ORDER BY " + queryOrderBy;
                }
                PreparedStatement ps = this.createStatement(query);
                int counter = 1;
                if (entity.getTenantColumn() != null) {
                    DOFWSql.setTenantInPreparedStatement(entity, ps, counter++);
                }
                StringBuffer sbValueLog = new StringBuffer();
                if (values != null) {
                    if (rr.getProperties().size() != values.length) {
                        throw new Error("Number of ?v(...) definitions does not match number of passed values: " + rr.getProperties().size() + " <==> " + values.length);
                    }
                    for (int i = 0; i < values.length; ++i) {
                        DOFWProperty property = rr.getProperties().get(i);
                        Object colValue = values[i];
                        if (property != null) {
                            DOFWSql.psSetValue(contextName, ps, colValue, property, counter++, sbValueLog);
                            continue;
                        }
                        ps.setObject(counter++, colValue);
                    }
                }
                DOFWSql.logValueLog(sbValueLog);
                ResultSet rs = DOFWExecutor.instance().executeQuery(ps);
                List<DOFWProperty> colProperties = DOFWUtils.findPropertiesInColumns(clazz, colSelections);
                while (rs.next()) {
                    Object[] line = new Object[colSelections.length];
                    result.add(line);
                    for (int i = 0; i < colSelections.length; ++i) {
                        DOFWProperty property = colProperties.get(i);
                        Object value = null;
                        value = property != null ? DOFWMapper.readAndMapDBValue(contextName, rs, i + 1, property) : rs.getObject(i + 1);
                        line[i] = value;
                    }
                }
            }
        };
        return result;
    }

    public static <OBJTYPE> List<OBJTYPE> query(Class<OBJTYPE> clazz, Object ... colVals) {
        return DOFWSql.query("CCEE_DEFAULTCONTEXT", clazz, colVals);
    }

    public static <OBJTYPE> List<OBJTYPE> query(String contextName, Class<OBJTYPE> clazz, Object ... colVals) {
        DOFWUtils.SplitUpColVals split = DOFWUtils.splitUpQueryColVals(colVals);
        return DOFWSql.query(contextName, clazz, split.getColVals(), split.getOrderBy());
    }

    public static <OBJTYPE> List<OBJTYPE> queryTop(Class<OBJTYPE> clazz, int top, Object ... colVals) {
        DOFWUtils.SplitUpColVals split = DOFWUtils.splitUpQueryColVals(colVals);
        return DOFWSql.processQuery("CCEE_DEFAULTCONTEXT", clazz, false, null, top, -1, split.getColVals(), split.getOrderBy(), false, top == 1);
    }

    public static <OBJTYPE> List<OBJTYPE> queryTop(String contextName, Class<OBJTYPE> clazz, int top, Object ... colVals) {
        DOFWUtils.SplitUpColVals split = DOFWUtils.splitUpQueryColVals(colVals);
        return DOFWSql.processQuery(contextName, clazz, false, null, top, -1, split.getColVals(), split.getOrderBy(), false, top == 1);
    }

    public static <OBJTYPE> List<OBJTYPE> queryTop(Class<OBJTYPE> clazz, int top, Object[] colVals, Object[] orderBy) {
        return DOFWSql.processQuery("CCEE_DEFAULTCONTEXT", clazz, false, null, top, -1, colVals, orderBy, false, top == 1);
    }

    public static <OBJTYPE> List<OBJTYPE> queryTop(String contextName, Class<OBJTYPE> clazz, int top, Object[] colVals, Object[] orderBy) {
        return DOFWSql.processQuery(contextName, clazz, false, null, top, -1, colVals, orderBy, false, top == 1);
    }

    public static <OBJTYPE> List<OBJTYPE> queryRange(Class<OBJTYPE> clazz, int rangeOffset, int rangeCount, Object ... colVals) {
        DOFWUtils.SplitUpColVals split = DOFWUtils.splitUpQueryColVals(colVals);
        return DOFWSql.processQuery("CCEE_DEFAULTCONTEXT", clazz, false, null, rangeCount, rangeOffset, split.getColVals(), split.getOrderBy(), false, rangeCount == 1);
    }

    public static <OBJTYPE> List<OBJTYPE> queryRange(String contextName, Class<OBJTYPE> clazz, int rangeOffset, int rangeCount, Object ... colVals) {
        DOFWUtils.SplitUpColVals split = DOFWUtils.splitUpQueryColVals(colVals);
        return DOFWSql.processQuery(contextName, clazz, false, null, rangeCount, rangeOffset, split.getColVals(), split.getOrderBy(), false, rangeCount == 1);
    }

    public static <OBJTYPE> List<OBJTYPE> queryRange(Class<OBJTYPE> clazz, int rangeOffset, int rangeCount, Object[] colVals, Object[] orderBy) {
        return DOFWSql.processQuery("CCEE_DEFAULTCONTEXT", clazz, false, null, rangeCount, rangeOffset, colVals, orderBy, false, rangeCount == 1);
    }

    public static <OBJTYPE> List<OBJTYPE> queryRange(String contextName, Class<OBJTYPE> clazz, int rangeOffset, int rangeCount, Object[] colVals, Object[] orderBy) {
        return DOFWSql.processQuery(contextName, clazz, false, null, rangeCount, rangeOffset, colVals, orderBy, false, rangeCount == 1);
    }

    public static <OBJTYPE> List<OBJTYPE> query(Class<OBJTYPE> clazz, Object[] colVals, Object[] orderBy) {
        return DOFWSql.query("CCEE_DEFAULTCONTEXT", clazz, colVals, orderBy);
    }

    public static <OBJTYPE> List<OBJTYPE> query(String contextName, Class<OBJTYPE> clazz, Object[] colVals, Object[] orderBy) {
        return DOFWSql.processQuery(contextName, clazz, false, null, -1, -1, colVals, orderBy, false, false);
    }

    public static <OBJTYPE> List<OBJTYPE> queryColumnData(Class<OBJTYPE> clazz, Object[] colSelection, Object ... colVals) {
        DOFWUtils.SplitUpColVals split = DOFWUtils.splitUpQueryColVals(colVals);
        return DOFWSql.queryColumnData("CCEE_DEFAULTCONTEXT", clazz, colSelection, split.getColVals(), split.getOrderBy());
    }

    public static <OBJTYPE> List<OBJTYPE> queryColumnData(String contextName, Class<OBJTYPE> clazz, Object[] colSelection, Object ... colVals) {
        DOFWUtils.SplitUpColVals split = DOFWUtils.splitUpQueryColVals(colVals);
        return DOFWSql.queryColumnData(contextName, clazz, colSelection, split.getColVals(), split.getOrderBy());
    }

    public static <OBJTYPE> List<OBJTYPE> queryColumnData(Class<OBJTYPE> clazz, Object[] colSelection, Object[] colVals, Object[] orderBy) {
        return DOFWSql.queryColumnData("CCEE_DEFAULTCONTEXT", clazz, colSelection, colVals, orderBy);
    }

    public static <OBJTYPE> List<OBJTYPE> queryColumnData(String contextName, Class<OBJTYPE> clazz, Object[] colSelection, Object[] colVals, Object[] orderBy) {
        return DOFWSql.processQuery(contextName, clazz, false, colSelection, -1, -1, colVals, orderBy, false, false);
    }

    public static <OBJTYPE> List<OBJTYPE> queryColumnDataDistinct(Class<OBJTYPE> clazz, Object[] colSelection, Object[] colVals, Object[] orderBy) {
        return DOFWSql.queryColumnDataDistinct("CCEE_DEFAULTCONTEXT", clazz, colSelection, colVals, orderBy);
    }

    public static <OBJTYPE> List<OBJTYPE> queryColumnDataDistinct(String contextName, Class<OBJTYPE> clazz, Object[] colSelection, Object[] colVals, Object[] orderBy) {
        return DOFWSql.processQuery(contextName, clazz, true, colSelection, -1, -1, colVals, orderBy, false, false);
    }

    public static <OBJTYPE> List<OBJTYPE> queryColumnDataTop(Class<OBJTYPE> clazz, Object[] colSelection, int top, Object ... colVals) {
        DOFWUtils.SplitUpColVals split = DOFWUtils.splitUpQueryColVals(colVals);
        return DOFWSql.processQuery("CCEE_DEFAULTCONTEXT", clazz, false, colSelection, top, -1, split.getColVals(), split.getOrderBy(), false, top == 1);
    }

    public static <OBJTYPE> List<OBJTYPE> queryColumnDataTop(String contextName, Class<OBJTYPE> clazz, Object[] colSelection, int top, Object ... colVals) {
        DOFWUtils.SplitUpColVals split = DOFWUtils.splitUpQueryColVals(colVals);
        return DOFWSql.processQuery(contextName, clazz, false, colSelection, top, -1, split.getColVals(), split.getOrderBy(), false, top == 1);
    }

    public static <OBJTYPE> List<OBJTYPE> queryColumnDataTop(Class<OBJTYPE> clazz, Object[] colSelection, int top, Object[] colVals, Object[] orderBy) {
        return DOFWSql.processQuery("CCEE_DEFAULTCONTEXT", clazz, false, colSelection, top, -1, colVals, orderBy, false, top == 1);
    }

    public static <OBJTYPE> List<OBJTYPE> queryColumnDataTop(String contextName, Class<OBJTYPE> clazz, Object[] colSelection, int top, Object[] colVals, Object[] orderBy) {
        return DOFWSql.processQuery(contextName, clazz, false, colSelection, top, -1, colVals, orderBy, false, top == 1);
    }

    public static <OBJTYPE> List<OBJTYPE> queryColumnDataDistinctTop(Class<OBJTYPE> clazz, Object[] colSelection, int top, Object[] colVals, Object[] orderBy) {
        return DOFWSql.queryColumnDataDistinctTop("CCEE_DEFAULTCONTEXT", clazz, colSelection, top, colVals, orderBy);
    }

    public static <OBJTYPE> List<OBJTYPE> queryColumnDataDistinctTop(String contextName, Class<OBJTYPE> clazz, Object[] colSelection, int top, Object[] colVals, Object[] orderBy) {
        return DOFWSql.processQuery(contextName, clazz, true, colSelection, top, -1, colVals, orderBy, false, top == 1);
    }

    public static <OBJTYPE> List<OBJTYPE> queryCrossTenant(Class<OBJTYPE> clazz, Object[] colVals, Object[] orderBy) {
        return DOFWSql.queryCrossTenant("CCEE_DEFAULTCONTEXT", clazz, colVals, orderBy);
    }

    public static <OBJTYPE> List<OBJTYPE> queryCrossTenant(String contextName, Class<OBJTYPE> clazz, Object[] colVals, Object[] orderBy) {
        return DOFWSql.processQuery(contextName, clazz, false, null, -1, -1, colVals, orderBy, true, false);
    }

    private static List processQuery(final String contextName, final Class clazz, final boolean distinct, final Object[] colSelection, final int top, final int offset, Object[] colVals, final Object[] orderBy, final boolean crossTenant, final boolean asSingleRead) {
        PreparseSqlForDynSqlAddonResult r = DOFWSql.preparseSqlForDynSqlAddon(colVals);
        final DynSqlAddon dynSqlAddon = r.addon;
        final DOFWEntity entity = DOFWRepository.getEntity(clazz);
        if (entity.isTransient()) {
            throw new Error("Query operation with entity defined as transient is not possible: " + clazz);
        }
        final Object[] parsedColVals = DOFWSql.preparseSql(clazz, entity, r.colVals);
        final ArrayList result = new ArrayList();
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                boolean withTenantQuery = true;
                if (crossTenant) {
                    withTenantQuery = false;
                }
                if (entity.getTenantColumn() == null) {
                    withTenantQuery = false;
                }
                int selectTopVariant = -1;
                int selectOffsetVariant = -1;
                if (top > 0) {
                    selectTopVariant = DOFWDialect.getSelectTopVariant(contextName);
                }
                if (offset >= 0) {
                    if (!DOFWDialect.checkIfRangeSelectionIsSupported(contextName)) {
                        throw new Error("Range selection not supported with the current database " + DOFWDialect.findSqlDialect(contextName));
                    }
                    selectOffsetVariant = DOFWDialect.getSelectTopVariant(contextName);
                }
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT");
                if (distinct) {
                    sb.append(" DISTINCT");
                }
                if (top >= 0 && selectTopVariant == 0) {
                    sb.append(" TOP " + top + " ");
                }
                Object[] myColSelection = colSelection;
                if (!asSingleRead && (myColSelection == null || myColSelection.length == 0) && DOFWRepository.checkIfClassContainsPropertiesWithOnlyReadWithSingleReadOperations(clazz)) {
                    List<DOFWProperty> allProperties = DOFWRepository.getProperties(clazz);
                    ArrayList propNames = new ArrayList();
                    for (DOFWProperty property : allProperties) {
                        if (property.getOnlyReadWithSingleReadOperations()) continue;
                        propNames.add(property.getName());
                    }
                    myColSelection = new Object[propNames.size()];
                    propNames.toArray(myColSelection);
                }
                sb.append(" ");
                if (myColSelection != null && myColSelection.length > 0) {
                    int counter = -1;
                    for (Object col : myColSelection) {
                        DOFWProperty p;
                        if (++counter > 0) {
                            sb.append(",");
                        }
                        if ((p = DOFWRepository.getProperty(clazz, col + "")) == null) {
                            throw new Error("Could not find property for name: " + col + ", class: " + clazz.getName());
                        }
                        sb.append(p.getColumn());
                    }
                } else {
                    sb.append("*");
                }
                sb.append(" FROM ");
                String table = null;
                table = dynSqlAddon != null && dynSqlAddon.getTableName() != null ? DOFWUtils.qut(contextName, dynSqlAddon.getTableName()) : DOFWUtils.qut(contextName, this.withSchema(entity));
                if (s_sqlQueryUpdate != null) {
                    table = s_sqlQueryUpdate.updateTable(table);
                }
                sb.append(table);
                if (parsedColVals != null && parsedColVals.length > 0 || withTenantQuery || selectTopVariant == 3 || dynSqlAddon != null && dynSqlAddon.getAdditionalQuery() != null) {
                    sb.append(" WHERE ");
                }
                if (selectTopVariant == 3) {
                    sb.append(" ROWNUM <= " + top + " ");
                    if (parsedColVals != null && parsedColVals.length > 0 || withTenantQuery) {
                        sb.append(" AND ( ");
                    }
                }
                ArrayList columnIndices = new ArrayList();
                ArrayList valueIndices = new ArrayList();
                DOFWSql.buildConditionString(contextName, sb, clazz, entity, parsedColVals, columnIndices, valueIndices, withTenantQuery, dynSqlAddon);
                if (selectTopVariant == 3 && (parsedColVals != null && parsedColVals.length > 0 || withTenantQuery)) {
                    sb.append(" ) ");
                }
                DOFWSql.buildOrderByString(contextName, sb, clazz, entity, orderBy);
                if (selectTopVariant == 1) {
                    sb.append(" LIMIT " + top);
                }
                if (selectOffsetVariant == 1) {
                    sb.append(" OFFSET " + offset);
                }
                if (selectTopVariant == 2) {
                    sb.append(" FETCH FIRST " + top + " ROWS ONLY");
                }
                PreparedStatement ps = this.createStatement(sb.toString());
                int counter = 1;
                if (withTenantQuery) {
                    DOFWSql.setTenantInPreparedStatement(entity, ps, counter++);
                }
                DOFWSql.transferConditionValuesIntoResultSet(contextName, clazz, parsedColVals, columnIndices, valueIndices, ps, counter, dynSqlAddon);
                ResultSet rs = DOFWExecutor.instance().executeQuery(ps);
                DOFWSql.mapResultSetList(contextName, rs, clazz, myColSelection, result);
            }
        };
        return result;
    }

    private static PreparseSqlForDynSqlAddonResult preparseSqlForDynSqlAddon(Object[] colVals) {
        if (colVals == null) {
            return new PreparseSqlForDynSqlAddonResult(null, colVals);
        }
        int counter = -1;
        for (Object colVal : colVals) {
            int i;
            ++counter;
            if (!(colVal instanceof DynSqlAddon)) continue;
            ArrayList<Object> newColValsList = new ArrayList<Object>();
            for (i = 0; i < counter; ++i) {
                newColValsList.add(colVals[i]);
            }
            for (i = counter + 1; i < colVals.length; ++i) {
                newColValsList.add(colVals[i]);
            }
            return new PreparseSqlForDynSqlAddonResult((DynSqlAddon)colVal, newColValsList.toArray());
        }
        return new PreparseSqlForDynSqlAddonResult(null, colVals);
    }

    public static int updateColumnsByQuery(Class clazz, Object[] queryColVals, Object[] updateColVals) {
        return DOFWSql.updateColumnsByQuery("CCEE_DEFAULTCONTEXT", clazz, queryColVals, updateColVals);
    }

    @SQLQueryCleanser(userComment="This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.")
    public static int updateColumnsByQuery(final String contextName, final Class clazz, Object[] queryColVals, final Object[] updateColVals) {
        if (updateColVals == null) {
            throw new Error("Parameter updateColVals must be passed!");
        }
        if (updateColVals.length == 0) {
            throw new Error("Parameter updateColVals must contain values");
        }
        if (updateColVals.length % 2 != 0) {
            throw new Error("Parameter updateColVals must contain pairs of <propertyName> and <propertyValue>. Length of updateColVals is: " + updateColVals.length);
        }
        final DOFWEntity entity = DOFWRepository.getEntity(clazz, true);
        if (entity.isTransient()) {
            throw new Error("Query operation with entity defined as transient is not possible: " + clazz);
        }
        final Object[] parsedColVals = DOFWSql.preparseSql(clazz, entity, queryColVals);
        final ObjectHolder<Integer> result = new ObjectHolder<Integer>();
        result.setInstance(0);
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                boolean withTenantQuery = true;
                if (entity.getTenantColumn() == null) {
                    withTenantQuery = false;
                }
                StringBuffer sb = new StringBuffer();
                sb.append("UPDATE ");
                sb.append(DOFWUtils.qut(contextName, this.withSchema(entity)));
                sb.append(" SET ");
                ArrayList<String> colqms = new ArrayList<String>();
                if (withTenantQuery) {
                    String tenantCol = entity.getTenantColumn();
                    sb.append(tenantCol);
                    sb.append("=?");
                    if (updateColVals.length != 0) {
                        sb.append(",");
                    }
                }
                for (int i = 0; i < updateColVals.length; i += 2) {
                    String propertyName = (String)updateColVals[i];
                    DOFWProperty property = DOFWRepository.getProperty(clazz, propertyName);
                    if (property == null) {
                        throw new Error("Could not find property: " + clazz.getName() + ", " + property);
                    }
                    colqms.add(DOFWSql.quc(contextName, property.getColumn()) + "=?");
                }
                sb.append(DOFWSql.concatenateStrings(colqms));
                sb.append(" WHERE ");
                ArrayList columnIndices = new ArrayList();
                ArrayList valueIndices = new ArrayList();
                DOFWSql.buildConditionString(contextName, sb, clazz, entity, parsedColVals, columnIndices, valueIndices, withTenantQuery, null);
                PreparedStatement ps = this.createStatement(sb.toString());
                StringBuffer sbValueLog = new StringBuffer();
                int counter = 1;
                if (withTenantQuery) {
                    DOFWSql.setTenantInPreparedStatement(entity, ps, counter++);
                }
                for (int i = 0; i < updateColVals.length; i += 2) {
                    String propertyName = (String)updateColVals[i];
                    DOFWProperty property = DOFWRepository.getProperty(clazz, propertyName);
                    Object propertyValue = updateColVals[i + 1];
                    DOFWSql.psSetValue(contextName, ps, propertyValue, property, counter++, sbValueLog);
                }
                if (withTenantQuery) {
                    DOFWSql.setTenantInPreparedStatement(entity, ps, counter++);
                }
                DOFWSql.logValueLog(sbValueLog);
                DOFWSql.transferConditionValuesIntoResultSet(contextName, clazz, parsedColVals, columnIndices, valueIndices, ps, counter, null);
                int n = DOFWExecutor.instance().executeUpdate(ps);
                result.setInstance(n);
            }
        };
        return (Integer)result.getInstance();
    }

    public static List<Map<String, Object>> queryDistinct(Class clazz, String[] propertyNames, Object[] colVals) {
        return DOFWSql.queryDistinct("CCEE_DEFAULTCONTEXT", clazz, propertyNames, colVals);
    }

    @SQLQueryCleanser(userComment="This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.")
    public static List<Map<String, Object>> queryDistinct(final String contextName, final Class clazz, final String[] propertyNames, Object[] colVals) {
        final DOFWEntity entity = DOFWRepository.getEntity(clazz);
        if (entity.isTransient()) {
            throw new Error("Query operation with entity defined as transient is not possible: " + clazz);
        }
        final Object[] parsedColVals = DOFWSql.preparseSql(clazz, entity, colVals);
        final ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                DOFWProperty[] properties = new DOFWProperty[propertyNames.length];
                for (int i = 0; i < propertyNames.length; ++i) {
                    properties[i] = DOFWRepository.getProperty(clazz, propertyNames[i]);
                    if (properties[i] != null) continue;
                    throw new Error("Could not find property: " + clazz.getName() + ", " + propertyNames[i]);
                }
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT DISTINCT ");
                for (int i = 0; i < properties.length; ++i) {
                    if (i != 0) {
                        sb.append(",");
                    }
                    sb.append(DOFWSql.quc(contextName, properties[i].getColumn()));
                }
                sb.append(" FROM ");
                sb.append(DOFWUtils.qut(contextName, this.withSchema(entity)));
                if (parsedColVals != null && parsedColVals.length > 0 || entity.getTenantColumn() != null) {
                    sb.append(" WHERE ");
                }
                ArrayList columnIndices = new ArrayList();
                ArrayList valueIndices = new ArrayList();
                DOFWSql.buildConditionString(contextName, sb, clazz, entity, parsedColVals, columnIndices, valueIndices, true, null);
                PreparedStatement ps = this.createStatement(sb.toString());
                int counter = 1;
                if (entity.getTenantColumn() != null) {
                    DOFWSql.setTenantInPreparedStatement(entity, ps, counter++);
                }
                DOFWSql.transferConditionValuesIntoResultSet(contextName, clazz, parsedColVals, columnIndices, valueIndices, ps, counter, null);
                ResultSet rs = DOFWExecutor.instance().executeQuery(ps);
                while (rs.next()) {
                    HashMap<String, Object> map = new HashMap<String, Object>();
                    result.add(map);
                    for (int i = 0; i < properties.length; ++i) {
                        Object value = DOFWMapper.readAndMapDBValue(contextName, rs, i + 1, properties[i]);
                        map.put(properties[i].getName(), value);
                    }
                }
            }
        };
        return result;
    }

    public static Object queryFunction(Class clazz, String functionName, String property, Object[] colVals) {
        return DOFWSql.queryFunction("CCEE_DEFAULTCONTEXT", clazz, functionName, property, colVals);
    }

    public static Object queryFunction(final String contextName, final Class clazz, final String functionName, final String functionPropertyName, Object[] colVals) {
        final DOFWEntity entity = DOFWRepository.getEntity(clazz);
        if (entity.isTransient()) {
            throw new Error("Query operation with entity defined as transient is not possible: " + clazz);
        }
        PreparseSqlForDynSqlAddonResult r = DOFWSql.preparseSqlForDynSqlAddon(colVals);
        final DynSqlAddon dynSqlAddon = r.addon;
        final Object[] parsedColVals = DOFWSql.preparseSql(clazz, entity, r.colVals);
        final ObjectHolder result = new ObjectHolder();
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                block7: {
                    String functionColName;
                    DOFWProperty functionProperty = null;
                    functionProperty = DOFWRepository.getProperty(clazz, functionPropertyName);
                    if (functionProperty == null) {
                        if (functionName != "COUNT") {
                            throw new Error("Could not find property: " + clazz.getName() + ", " + functionPropertyName);
                        }
                        functionColName = functionPropertyName;
                    } else {
                        functionColName = functionProperty.getColumn();
                    }
                    StringBuffer sb = new StringBuffer();
                    sb.append("SELECT ");
                    sb.append(functionName);
                    sb.append("(");
                    sb.append(DOFWSql.quc(contextName, functionColName));
                    sb.append(")");
                    sb.append(" FROM ");
                    String table = null;
                    table = dynSqlAddon != null && dynSqlAddon.getTableName() != null ? DOFWUtils.qut(contextName, dynSqlAddon.getTableName()) : DOFWUtils.qut(contextName, this.withSchema(entity));
                    if (s_sqlQueryUpdate != null) {
                        table = s_sqlQueryUpdate.updateTable(table);
                    }
                    sb.append(table);
                    if (parsedColVals != null && parsedColVals.length > 0 || entity.getTenantColumn() != null || dynSqlAddon != null && dynSqlAddon.getAdditionalQuery() != null) {
                        sb.append(" WHERE ");
                    }
                    ArrayList columnIndices = new ArrayList();
                    ArrayList valueIndices = new ArrayList();
                    DOFWSql.buildConditionString(contextName, sb, clazz, entity, parsedColVals, columnIndices, valueIndices, true, dynSqlAddon);
                    PreparedStatement ps = this.createStatement(sb.toString());
                    int counter = 1;
                    if (entity.getTenantColumn() != null) {
                        DOFWSql.setTenantInPreparedStatement(entity, ps, counter++);
                    }
                    DOFWSql.transferConditionValuesIntoResultSet(contextName, clazz, parsedColVals, columnIndices, valueIndices, ps, counter, dynSqlAddon);
                    ResultSet rs = DOFWExecutor.instance().executeQuery(ps);
                    if (!rs.next()) break block7;
                    Object value = rs.getObject(1);
                    if (functionName != "COUNT") {
                        value = DOFWMapper.readAndMapDBValue(contextName, rs, 1, functionProperty);
                    }
                    result.setInstance(value);
                }
            }
        };
        return result.getInstance();
    }

    public static List<Object[]> queryFunctionGrouped(Class clazz, String functionName, String functionPropertyName, String[] groupPropertyNames, Object[] colVals, Object[] orderBy) {
        return DOFWSql.queryFunctionGrouped("CCEE_DEFAULTCONTEXT", clazz, functionName, functionPropertyName, groupPropertyNames, colVals, orderBy);
    }

    public static List<Object[]> queryFunctionGrouped(Class clazz, int top, String functionName, String functionPropertyName, String[] groupPropertyNames, Object[] colVals, Object[] orderBy) {
        return DOFWSql.queryFunctionGrouped("CCEE_DEFAULTCONTEXT", clazz, top, functionName, functionPropertyName, groupPropertyNames, colVals, orderBy);
    }

    public static List<Object[]> queryFunctionGrouped(String contextName, Class clazz, String functionName, String functionPropertyName, String[] groupPropertyNames, Object[] colVals, Object[] orderBy) {
        return DOFWSql.queryFunctionGrouped(contextName, clazz, -1, functionName, functionPropertyName, groupPropertyNames, colVals, orderBy);
    }

    public static List<Object[]> queryGrouped(Class clazz, String[] groupPropertyNames, Object[] colVals, Object[] orderBy) {
        return DOFWSql.queryFunctionGrouped("CCEE_DEFAULTCONTEXT", clazz, -1, null, null, groupPropertyNames, colVals, orderBy);
    }

    public static List<Object[]> queryGrouped(String contextName, Class clazz, String[] groupPropertyNames, Object[] colVals, Object[] orderBy) {
        return DOFWSql.queryFunctionGrouped(contextName, clazz, -1, null, null, groupPropertyNames, colVals, orderBy);
    }

    public static List<Object[]> queryGrouped(Class clazz, int top, String[] groupPropertyNames, Object[] colVals, Object[] orderBy) {
        return DOFWSql.queryFunctionGrouped("CCEE_DEFAULTCONTEXT", clazz, top, null, null, groupPropertyNames, colVals, orderBy);
    }

    public static List<Object[]> queryGrouped(String contextName, Class clazz, int top, String[] groupPropertyNames, Object[] colVals, Object[] orderBy) {
        return DOFWSql.queryFunctionGrouped(contextName, clazz, top, null, null, groupPropertyNames, colVals, orderBy);
    }

    @SQLQueryCleanser(userComment="This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.")
    public static List<Object[]> queryFunctionGrouped(final String contextName, final Class clazz, final int top, final String functionName, final String functionPropertyName, final String[] groupPropertyNames, Object[] colVals, final Object[] orderBy) {
        final DOFWEntity entity = DOFWRepository.getEntity(clazz);
        if (entity.isTransient()) {
            throw new Error("Query operation with entity defined as transient is not possible: " + clazz);
        }
        final ArrayList<Object[]> result = new ArrayList<Object[]>();
        final Object[] parsedColVals = DOFWSql.preparseSql(clazz, entity, colVals);
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                int selectTopVariant = -1;
                if (top > 0) {
                    selectTopVariant = DOFWDialect.getSelectTopVariant(contextName);
                }
                DOFWProperty functionProperty = null;
                if (functionPropertyName != null) {
                    functionProperty = DOFWRepository.getProperty(clazz, functionPropertyName);
                }
                String functionColName = null;
                if (functionName != null) {
                    if (functionProperty == null) {
                        if (functionName != "COUNT") {
                            throw new Error("Could not find property: " + clazz.getName() + ", " + functionPropertyName);
                        }
                        functionColName = functionPropertyName;
                    } else {
                        functionColName = functionProperty.getColumn();
                    }
                }
                StringBuffer sb = new StringBuffer();
                sb.append("SELECT ");
                if (selectTopVariant == 0) {
                    sb.append(" TOP " + top + " ");
                }
                if (functionName != null) {
                    sb.append(functionName);
                    sb.append("(");
                    sb.append(DOFWSql.quc(contextName, functionColName));
                    sb.append(")");
                }
                if (groupPropertyNames != null) {
                    int counter = 0;
                    for (String groupPropertyName : groupPropertyNames) {
                        if (counter > 0 || functionName != null) {
                            sb.append(",");
                        }
                        sb.append(DOFWSql.quc(contextName, groupPropertyName));
                        ++counter;
                    }
                }
                sb.append(" FROM ");
                sb.append(DOFWUtils.qut(contextName, this.withSchema(entity)));
                if (parsedColVals != null && parsedColVals.length > 0 || entity.getTenantColumn() != null) {
                    sb.append(" WHERE ");
                }
                if (selectTopVariant == 3) {
                    sb.append(" ROWNUM <= " + top + " ");
                    sb.append(" AND ( ");
                }
                ArrayList columnIndices = new ArrayList();
                ArrayList valueIndices = new ArrayList();
                DOFWSql.buildConditionString(contextName, sb, clazz, entity, parsedColVals, columnIndices, valueIndices, true, null);
                if (selectTopVariant == 3) {
                    sb.append(" ) ");
                }
                if (groupPropertyNames != null && groupPropertyNames.length > 0) {
                    sb.append(" GROUP BY ");
                    int counter = -1;
                    for (String name : groupPropertyNames) {
                        DOFWProperty property;
                        if (++counter != 0) {
                            sb.append(",");
                        }
                        if ((property = DOFWRepository.getProperty(clazz, name)) == null) {
                            throw new Error("Could not find property: " + clazz.getName() + ", " + name);
                        }
                        sb.append(property.getColumn());
                    }
                }
                DOFWSql.buildOrderByString(contextName, sb, clazz, entity, orderBy, functionName, functionColName);
                if (selectTopVariant == 1) {
                    sb.append(" LIMIT " + top);
                }
                if (selectTopVariant == 2) {
                    sb.append(" FETCH FIRST " + top + " ROWS ONLY");
                }
                PreparedStatement ps = this.createStatement(sb.toString());
                int counter = 1;
                if (entity.getTenantColumn() != null) {
                    DOFWSql.setTenantInPreparedStatement(entity, ps, counter++);
                }
                DOFWSql.transferConditionValuesIntoResultSet(contextName, clazz, parsedColVals, columnIndices, valueIndices, ps, counter, null);
                ResultSet rs = DOFWExecutor.instance().executeQuery(ps);
                int numberOfObjectsPerLine = 0;
                if (functionName != null) {
                    ++numberOfObjectsPerLine;
                }
                if (groupPropertyNames != null) {
                    numberOfObjectsPerLine += groupPropertyNames.length;
                }
                while (rs.next()) {
                    Object[] line = new Object[numberOfObjectsPerLine];
                    result.add(line);
                    int startPropertiesIndex = 0;
                    if (functionName != null) {
                        startPropertiesIndex = 1;
                        line[0] = rs.getObject(1);
                        if (functionName != "COUNT") {
                            line[0] = DOFWMapper.readAndMapDBValue(contextName, rs, 1, functionProperty);
                        }
                    }
                    if (groupPropertyNames == null) continue;
                    for (int i = 0; i < groupPropertyNames.length; ++i) {
                        DOFWProperty property = DOFWRepository.getProperty(clazz, groupPropertyNames[i]);
                        line[i + startPropertiesIndex] = DOFWMapper.readAndMapDBValue(contextName, rs, startPropertiesIndex + 1 + i, property);
                    }
                }
            }
        };
        return result;
    }

    public static boolean checkIfObjectAlreadyExists(Object dob) {
        return DOFWSql.checkIfObjectAlreadyExists("CCEE_DEFAULTCONTEXT", dob);
    }

    public static boolean checkIfObjectAlreadyExists(final String contextName, final Object dob) {
        final ObjectHolder<Boolean> result = new ObjectHolder<Boolean>();
        result.setInstance(true);
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                DOFWRepository.getEntity(dob.getClass());
                List<DOFWProperty> keyProperties = DOFWRepository.getKeyProperties(dob.getClass());
                ArrayList<Object> colValList = new ArrayList<Object>();
                for (DOFWProperty property : keyProperties) {
                    colValList.add(property.getName());
                    Object val = property.getGetter().invoke(dob, (Object[])null);
                    colValList.add(val);
                }
                Object[] colVals = new Object[colValList.size()];
                colValList.toArray(colVals);
                Object freshDob = DOFWSql.queryOne(contextName, dob.getClass(), colVals);
                if (freshDob == null) {
                    result.setInstance(false);
                }
            }
        };
        return (Boolean)result.getInstance();
    }

    public static boolean rereadObject(Object dob) {
        return DOFWSql.rereadObject("CCEE_DEFAULTCONTEXT", dob);
    }

    public static boolean rereadObject(String contextName, Object dob) {
        return DOFWSql.rereadObject(contextName, dob, null);
    }

    public static boolean rereadObject(String contextName, Object dob, DynSqlAddon dynSqlAddon) {
        if (dob == null) {
            return true;
        }
        Object freshDob = DOFWSql.querySameObject(contextName, dob, dynSqlAddon);
        if (freshDob == null) {
            return false;
        }
        List<DOFWProperty> valueProperties = DOFWRepository.getValueProperties(dob.getClass());
        for (DOFWProperty property : valueProperties) {
            try {
                Object val = property.getGetter().invoke(freshDob, (Object[])null);
                property.getSetter().invoke(dob, val);
            }
            catch (Throwable t) {
                throw new Error("Problem transferring property value during reread: " + dob.getClass() + ", " + property.getName(), t);
            }
        }
        if (dob instanceof IBeanWithDataMap) {
            ((IBeanWithDataMap)dob).getData().clear();
            ((IBeanWithDataMap)dob).getData().putAll(((IBeanWithDataMap)freshDob).getData());
        }
        return true;
    }

    public static Object querySameObject(Object dob) {
        return DOFWSql.querySameObject("CCEE_DEFAULTCONTEXT", dob);
    }

    public static Object querySameObject(String contextName, Object dob) {
        return DOFWSql.querySameObject(contextName, dob, null);
    }

    public static Object querySameObject(final String contextName, final Object dob, final DynSqlAddon dynSqlAddon) {
        if (dob == null) {
            return null;
        }
        final ObjectHolder result = new ObjectHolder();
        result.setInstance(null);
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                DOFWRepository.getEntity(dob.getClass());
                List<DOFWProperty> keyProperties = DOFWRepository.getKeyProperties(dob.getClass());
                ArrayList<Object> colValList = new ArrayList<Object>();
                if (dynSqlAddon != null) {
                    colValList.add(dynSqlAddon);
                }
                for (DOFWProperty property : keyProperties) {
                    colValList.add(property.getName());
                    Object val = property.getGetter().invoke(dob, (Object[])null);
                    colValList.add(val);
                }
                Object[] colVals = new Object[colValList.size()];
                colValList.toArray(colVals);
                Object freshDob = DOFWSql.queryOne(contextName, dob.getClass(), colVals);
                result.setInstance(freshDob);
            }
        };
        return result.getInstance();
    }

    public static void deleteObjectsInBatch(Object[] dobs) {
        DOFWSql.deleteObjectsInBatch("CCEE_DEFAULTCONTEXT", dobs);
    }

    public static void deleteObjectsInBatch(final String contextName, final Object[] dobs) {
        if (dobs.length == 0) {
            return;
        }
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                Object dob0 = dobs[0];
                DOFWEntity entity = DOFWRepository.getEntity(dob0.getClass());
                List<DOFWProperty> keyProperties = DOFWRepository.getKeyProperties(dob0.getClass());
                if (keyProperties.size() == 0 && entity.getTenantColumn() == null) {
                    throw new Error("No key properties are defined for class " + dob0.getClass() + ". Delete not possible.");
                }
                Statement ps = null;
                for (Object dob : dobs) {
                    ArrayList<Object> colValList = new ArrayList<Object>();
                    for (DOFWProperty property : keyProperties) {
                        colValList.add(property.getName());
                        Object val = property.getGetter().invoke(dob, (Object[])null);
                        colValList.add(val);
                    }
                    Object[] colVals = new Object[colValList.size()];
                    colValList.toArray(colVals);
                    ps = DOFWSql.processDeleteObjectInDBAction((DBAction)this, (String)contextName, dob0.getClass(), (Object[])colVals, (boolean)false).batchPreparedStatement;
                }
                if (ps != null) {
                    ps.executeBatch();
                }
            }
        };
    }

    public static boolean deleteObject(Object dob) {
        return DOFWSql.deleteObject("CCEE_DEFAULTCONTEXT", dob);
    }

    public static boolean deleteObject(final String contextName, final Object dob) {
        DOFWSql.checkThatObjectForUpdateHasKeyDefinitions(dob.getClass());
        final ObjectHolder result = new ObjectHolder();
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                DOFWEntity entity = DOFWRepository.getEntity(dob.getClass());
                if (entity.getDeletedProperty() == null) {
                    List<DOFWProperty> keyProperties = DOFWRepository.getKeyProperties(dob.getClass());
                    if (keyProperties.size() == 0 && entity.getTenantColumn() == null) {
                        throw new Error("No key properties are defined for class " + dob.getClass() + ". Delete not possible.");
                    }
                    ArrayList<Object> colValList = new ArrayList<Object>();
                    for (DOFWProperty property : keyProperties) {
                        colValList.add(property.getName());
                        Object val = property.getGetter().invoke(dob, (Object[])null);
                        colValList.add(val);
                    }
                    Object[] colVals = new Object[colValList.size()];
                    colValList.toArray(colVals);
                    int r = DOFWSql.delete(contextName, dob.getClass(), colVals);
                    result.setInstance(r);
                } else {
                    DOFWProperty dp = DOFWRepository.getProperty(dob.getClass(), entity.getDeletedProperty());
                    dp.getSetter().invoke(dob, true);
                    DOFWSql.saveObject(contextName, dob);
                    result.setInstance(1);
                }
            }
        };
        if ((Integer)result.getInstance() > 0) {
            if (DOFWSql.checkIfTraceIsActive(dob.getClass())) {
                Trace.instance().traceObjectDelete(contextName, dob);
            }
            return true;
        }
        return false;
    }

    public static int delete(Class clazz, Object ... colVals) {
        return DOFWSql.delete("CCEE_DEFAULTCONTEXT", clazz, colVals);
    }

    public static int delete(final String contextName, final Class clazz, final Object ... colVals) {
        final ObjectHolder result = new ObjectHolder();
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                int resi = DOFWSql.processDeleteObjectInDBAction((DBAction)this, (String)contextName, (Class)clazz, (Object[])colVals, (boolean)true).resultDelete;
                result.setInstance(resi);
            }
        };
        return (Integer)result.getInstance();
    }

    public static void truncate(Class clazz) {
        DOFWSql.truncate("CCEE_DEFAULTCONTEXT", clazz);
    }

    @SQLQueryCleanser(userComment="This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.")
    public static void truncate(final String contextName, final Class clazz) {
        if (DOFWBuffer.checkIfBuffered(clazz)) {
            DOFWBuffer.clearObjectCache(clazz);
        }
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                DOFWEntity entity = DOFWRepository.getEntity(clazz);
                if (entity.getTenantColumn() != null) {
                    throw new Error("Truncation of data is only allowed if the table below is NOT used by several tenants. Current entity is: " + clazz.getName() + ", tenant column is: " + entity.getTenantColumn());
                }
                StringBuffer sb = new StringBuffer();
                sb.append("TRUNCATE TABLE ");
                sb.append(DOFWUtils.qut(contextName, this.withSchema(entity)));
                PreparedStatement ps = this.createStatement(sb.toString());
                DOFWExecutor.instance().executeUpdate(ps);
            }
        };
    }

    public static void saveObject(Object dob) {
        DOFWSql.saveObject("CCEE_DEFAULTCONTEXT", dob);
    }

    public static void saveObject(final String contextName, final Object dob) {
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                boolean success = DOFWSql.updateObject(contextName, dob);
                if (!success) {
                    DOFWSql.insertObject(contextName, dob);
                }
            }
        };
    }

    public static void insertObjectsInBatch(Object[] dobs) {
        DOFWSql.insertObjectsInBatch("CCEE_DEFAULTCONTEXT", dobs);
    }

    @SQLQueryCleanser(userComment="This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.")
    public static void insertObjectsInBatch(final String contextName, final Object[] dobs) {
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                Statement ps = null;
                for (Object dob : dobs) {
                    PreparedStatement newPs = DOFWSql.processInsertObjectInDBAction((DBAction)this, (String)contextName, (Object)dob, (boolean)false).batchPreparedStatement;
                    if (ps == null) {
                        ps = newPs;
                        continue;
                    }
                    if (ps == newPs) continue;
                    throw new Error("Batch update not possible - differente PreparedStatements are used. Most likely: inhomogenous array of objects.");
                }
                ps.executeBatch();
            }
        };
    }

    public static boolean insertObject(Object dob) {
        return DOFWSql.insertObject("CCEE_DEFAULTCONTEXT", dob);
    }

    public static boolean insertObject(final String contextName, final Object dob) {
        final ObjectHolder result = new ObjectHolder();
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                int resi = DOFWSql.processInsertObjectInDBAction((DBAction)this, (String)contextName, (Object)dob, (boolean)true).resultInsert;
                result.setInstance(resi);
            }
        };
        if ((Integer)result.getInstance() > 0) {
            if (DOFWSql.checkIfTraceIsActive(dob.getClass())) {
                Trace.instance().traceObjectInsert(contextName, dob);
            }
            return true;
        }
        return false;
    }

    public static void updateObjectsInBatch(Object[] dobs) {
        DOFWSql.updateObjectsInBatch("CCEE_DEFAULTCONTEXT", dobs);
    }

    @SQLQueryCleanser(userComment="This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.")
    public static void updateObjectsInBatch(final String contextName, final Object[] dobs) {
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                Statement ps = null;
                for (Object dob : dobs) {
                    PreparedStatement newPs = DOFWSql.processUpdateObjectInDBAction((DBAction)this, (String)contextName, (Object)dob, (boolean)false).batchPreparedStatement;
                    if (ps == null) {
                        ps = newPs;
                        continue;
                    }
                    if (ps == newPs) continue;
                    throw new Error("Batch update not possible - differente PreparedStatements are used. Most likely: inhomogenous array of objects.");
                }
                ps.executeBatch();
            }
        };
    }

    public static boolean updateObject(Object dob) {
        return DOFWSql.updateObject("CCEE_DEFAULTCONTEXT", dob);
    }

    public static boolean updateObject(final String contextName, final Object dob) {
        DOFWSql.checkThatObjectForUpdateHasKeyDefinitions(dob.getClass());
        final ObjectHolder<Boolean> result = new ObjectHolder<Boolean>();
        result.setInstance(true);
        Object dobBeforeUpdate = null;
        if (DOFWSql.checkIfTraceIsActive(dob.getClass())) {
            dobBeforeUpdate = DOFWSql.querySameObject(contextName, dob);
        }
        new DBAction(contextName){

            @Override
            protected void run() throws Exception {
                boolean res = DOFWSql.processUpdateObjectInDBAction((DBAction)this, (String)contextName, (Object)dob, (boolean)true).resultUpdate;
                result.setInstance(res);
            }
        };
        if (((Boolean)result.getInstance()).booleanValue() && DOFWSql.checkIfTraceIsActive(dob.getClass())) {
            Trace.instance().traceObjectUpdate(contextName, dobBeforeUpdate, dob);
        }
        return (Boolean)result.getInstance();
    }

    public static <OBJTYPE> void mapResultSetList(ResultSet rs, Class<OBJTYPE> dobClass, List<OBJTYPE> dos) {
        DOFWSql.mapResultSetList("CCEE_DEFAULTCONTEXT", rs, dobClass, null, dos);
    }

    public static <OBJTYPE> void mapResultSetList(ResultSet rs, Class<OBJTYPE> dobClass, Object[] colSelection, List<OBJTYPE> dos) {
        DOFWSql.mapResultSetList("CCEE_DEFAULTCONTEXT", rs, dobClass, colSelection, dos);
    }

    public static <OBJTYPE> void mapResultSetList(String contextName, ResultSet rs, Class<OBJTYPE> dobClass, List<OBJTYPE> dos) {
        DOFWSql.mapResultSetList(contextName, rs, dobClass, null, dos);
    }

    public static <OBJTYPE> void mapResultSetList(String contextName, ResultSet rs, Class<OBJTYPE> dobClass, Object[] colSelection, List<OBJTYPE> dos) {
        try {
            while (rs.next()) {
                OBJTYPE dob = DOFWSql.mapResultSet(contextName, rs, dobClass, colSelection);
                dos.add(dob);
            }
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static <OBJTYPE> OBJTYPE mapResultSet(ResultSet rs, Class<OBJTYPE> dobClass, Object[] colSelection) {
        return DOFWSql.mapResultSet("CCEE_DEFAULTCONTEXT", rs, dobClass, colSelection);
    }

    public static <OBJTYPE> OBJTYPE mapResultSet(String contextName, ResultSet rs, Class<OBJTYPE> dobClass, Object[] colSelection) {
        try {
            OBJTYPE dob = dobClass.newInstance();
            return DOFWSql.mapResultSet(contextName, rs, colSelection, dob);
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static <OBJTYPE> OBJTYPE mapResultSet(String contextName, ResultSet rs, Object[] colSelection, OBJTYPE dob) {
        HashSet<Object> colSelectionSet = null;
        if (colSelection != null) {
            colSelectionSet = new HashSet<Object>();
            for (Object colName : colSelection) {
                colSelectionSet.add(colName);
            }
        }
        Class<?> doClass = dob.getClass();
        DOFWEntity entity = DOFWRepository.getEntity(doClass);
        HashSet<String> mappedColumnNames = new HashSet<String>();
        for (DOFWProperty property : DOFWRepository.getProperties(doClass)) {
            if (colSelectionSet != null && !colSelectionSet.contains(property.getName())) continue;
            DOFWMapper.mapDBValue2PropertyValue(contextName, rs, dob, property);
            mappedColumnNames.add(property.getColumn());
        }
        if (entity.getTenantColumn() != null) {
            try {
                String tenantColumn = entity.getTenantColumn();
                String value = rs.getString(tenantColumn);
                String tenantSetterName = "set" + tenantColumn.substring(0, 1).toUpperCase() + tenantColumn.substring(1);
                Method m = dob.getClass().getMethod(tenantSetterName, String.class);
                m.invoke(dob, value);
                mappedColumnNames.add(tenantColumn);
            }
            catch (Throwable tenantColumn) {
                // empty catch block
            }
        }
        if (IBeanWithDataMap.class.isAssignableFrom(doClass)) {
            try {
                for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                    String columnName = rs.getMetaData().getColumnName(i);
                    if (mappedColumnNames.contains(columnName)) continue;
                    Object columnObject = rs.getObject(i);
                    if (columnObject instanceof String && columnObject != null) {
                        columnObject = ((String)columnObject).trim();
                    }
                    ((IBeanWithDataMap)dob).getData().put(columnName, columnObject);
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return dob;
    }

    private static void buildOrderByString(String contextName, StringBuffer sb, Class clazz, DOFWEntity entity, Object[] orderBy) {
        DOFWSql.buildOrderByString(contextName, sb, clazz, entity, orderBy, null, null);
    }

    private static void buildOrderByString(String contextName, StringBuffer sb, Class clazz, DOFWEntity entity, Object[] orderBy, String functionName, String functionColName) {
        if (orderBy == null) {
            return;
        }
        if (orderBy.length == 0) {
            return;
        }
        sb.append(" ORDER BY");
        boolean firstColumnApplied = false;
        for (Object order : orderBy) {
            DOFWProperty property;
            if (QueryUtils.checkIfObjectIsOrderByInstrcution(order)) {
                sb.append(" " + order);
                continue;
            }
            if ("CCEE_FUNCTIONRESULT" == order) {
                if (firstColumnApplied) {
                    sb.append(" ,");
                }
                if (functionName == null) {
                    throw new Error("Ordering by FUNCTIONRESULT is only possible if functionName is defined");
                }
                if (functionColName == null) {
                    throw new Error("Ordering by FUNCTIONRESULT is only possible if functionColName is defined");
                }
                sb.append(" " + functionName + "(" + DOFWSql.quc(contextName, functionColName) + ")");
                firstColumnApplied = true;
                continue;
            }
            if (firstColumnApplied) {
                sb.append(" ,");
            }
            if ((property = DOFWRepository.getProperty(clazz, "" + order)) == null) {
                throw new Error("Could not find property: " + clazz.getName() + ", " + order);
            }
            String colName = property.getColumn();
            sb.append(" " + DOFWSql.quc(contextName, colName));
            firstColumnApplied = true;
        }
    }

    private static void buildConditionString(String contextName, StringBuffer sb, Class clazz, DOFWEntity entity, Object[] colVals, List<Integer> columnIndices, List<Integer> valueIndices, boolean withTenantQuery, DynSqlAddon dynSqlAddon) {
        if (colVals == null) {
            colVals = new Object[]{};
        }
        boolean closeRequiredTenant = false;
        if (withTenantQuery && entity.getTenantColumn() != null) {
            sb.append(" " + entity.getTenantColumn() + "=?");
            if (colVals.length > 0 || dynSqlAddon != null && dynSqlAddon.getAdditionalQuery() != null) {
                sb.append(" AND (");
                closeRequiredTenant = true;
            }
        }
        Map aliasToSQLNameMapping = null;
        boolean waitingForColumn = true;
        boolean waitingForValue = false;
        boolean waitingForLogic = false;
        boolean waitingForComparator = false;
        DOFWProperty currentProperty = null;
        for (int i = 0; i < colVals.length; ++i) {
            String nullValue;
            Object colVal = colVals[i];
            Object nextColVal = null;
            if (i < colVals.length - 1) {
                nextColVal = colVals[i + 1];
            }
            if (QueryUtils.checkIfObjectIsQueryLogic(colVal)) {
                sb.append(" " + colVal);
                waitingForColumn = true;
                waitingForComparator = false;
                waitingForValue = false;
                waitingForLogic = false;
                continue;
            }
            if (QueryUtils.checkIfObjectIsSQLComparator(colVal)) {
                try {
                    if (nextColVal == null) {
                        nextColVal = DOFWMapper.getNullValueForSQLStatement(currentProperty);
                    }
                    if (i < colVals.length - 1) {
                        if (colVal == "=" && (nextColVal == "CCEE_NULL" || nextColVal == null)) {
                            colVal = "IS";
                        }
                        if (colVal == "<>" && (nextColVal == "CCEE_NULL" || nextColVal == null)) {
                            colVal = "IS NOT";
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                sb.append(" " + colVal);
                waitingForColumn = false;
                waitingForComparator = false;
                waitingForValue = true;
                waitingForLogic = false;
                continue;
            }
            if (waitingForColumn) {
                String realSQLName;
                DOFWProperty property;
                if (waitingForLogic) {
                    sb.append(" AND ");
                }
                String propertyName = null;
                if (colVal instanceof String) {
                    propertyName = colVal.toString();
                } else if (colVal instanceof QueryParameterFunction) {
                    propertyName = ((QueryParameterFunction)colVal).getParam();
                    colVals[i] = propertyName;
                } else {
                    throw new Error("Expecting String or QueryParameterFunction as class, but have: " + colVal.toString());
                }
                boolean isYYMMDDReference = false;
                if (propertyName.startsWith(PREFIX_YYMMDDCENTURYREFERENCE)) {
                    propertyName = propertyName.substring(PREFIX_YYMMDDCENTURYREFERENCE.length());
                    isYYMMDDReference = true;
                }
                if ((property = DOFWRepository.getProperty(clazz, propertyName)) == null) {
                    throw new Error("Could not find property for name: " + propertyName);
                }
                currentProperty = property;
                String colName = property.getColumn();
                if (isYYMMDDReference) {
                    colName = property.getYYMMDDCenturyReference();
                }
                if (aliasToSQLNameMapping != null && (realSQLName = (String)aliasToSQLNameMapping.get(colName)) != null) {
                    colName = realSQLName;
                }
                colName = DOFWSql.quc(contextName, colName);
                if (colVal instanceof String) {
                    if (nextColVal == "LIKE" && property.getGetter().getReturnType() != String.class && property.getGetter().getReturnType() != Character.class && property.getGetter().getReturnType() != UUID.class) {
                        colName = DOFWDialect.updateColumnNameForTextConversion(contextName, colName);
                    }
                    sb.append(" " + colName);
                } else {
                    sb.append(" " + ((QueryParameterFunction)colVal).getFunction() + "(" + colName + ")");
                }
                columnIndices.add(i);
                waitingForColumn = false;
                waitingForComparator = true;
                waitingForValue = false;
                waitingForLogic = false;
                continue;
            }
            if (waitingForValue) {
                if (colVal != "CCEE_NULL" && colVal != null) {
                    sb.append(" ?");
                    valueIndices.add(i);
                } else {
                    nullValue = DOFWMapper.getNullValueForSQLStatement(currentProperty);
                    if (nullValue == "CCEE_NULL") {
                        sb.append(" NULL");
                    } else {
                        sb.append(" " + nullValue);
                    }
                    valueIndices.add(null);
                }
                waitingForColumn = true;
                waitingForComparator = false;
                waitingForValue = false;
                waitingForLogic = true;
                continue;
            }
            if (!waitingForComparator || QueryUtils.checkIfObjectIsSQLComparator(colVal)) continue;
            if (colVal != "CCEE_NULL" && colVal != null) {
                sb.append(" =?");
                valueIndices.add(i);
            } else {
                nullValue = DOFWMapper.getNullValueForSQLStatement(currentProperty);
                if ("CCEE_NULL" == nullValue) {
                    sb.append(" IS NULL");
                } else {
                    sb.append(" = " + nullValue);
                }
                valueIndices.add(null);
            }
            waitingForColumn = true;
            waitingForComparator = false;
            waitingForValue = false;
            waitingForLogic = true;
        }
        if (dynSqlAddon != null && dynSqlAddon.getAdditionalQuery() != null) {
            if (colVals.length != 0) {
                sb.append(" AND");
            }
            sb.append(" " + dynSqlAddon.getAdditionalQuery());
        }
        if (closeRequiredTenant) {
            sb.append(")");
        }
    }

    private static void psSet(String contextName, PreparedStatement ps, Object dob, DOFWProperty property, int counter, StringBuffer valueLog) throws Exception {
        Object value = property.getGetter().invoke(dob, (Object[])null);
        DOFWSql.psSetValue(contextName, ps, value, property, counter, valueLog);
    }

    private static void psSetCenturyYYMMDDReference(String contextName, PreparedStatement ps, Object dob, DOFWProperty property, int counter) throws Exception {
        Object value = property.getGetter().invoke(dob, (Object[])null);
        DOFWMapper.mapPropertyValue2PreparedStatement(contextName, value, ps, property, new ENUMMappingInfo[]{ENUMMappingInfo.IS_YYMMDDCENTURYREFRENCE}, counter);
    }

    private static void psSetValue(String contextName, PreparedStatement ps, Object value, DOFWProperty property, int counter, StringBuffer valueLog) throws Exception {
        DOFWMapper.mapPropertyValue2PreparedStatement(contextName, value, ps, property, counter);
        DOFWSql.addValueToValueLog(valueLog, property.getName(), value);
    }

    private static void psSetValueCenturyYYMMDDReference(String contextName, PreparedStatement ps, Object value, DOFWProperty property, int counter) throws Exception {
        DOFWMapper.mapPropertyValue2PreparedStatement(contextName, value, ps, property, new ENUMMappingInfo[]{ENUMMappingInfo.IS_YYMMDDCENTURYREFRENCE}, counter);
    }

    private static String concatenateStrings(List<String> strings) {
        return DOFWSql.concatenateStrings(strings, ",");
    }

    private static String concatenateStrings(List<String> strings, String separator) {
        StringBuffer sb = new StringBuffer();
        for (String s : strings) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(s);
        }
        return sb.toString();
    }

    private static String quc(String contextName, String columnName) {
        return DOFWUtils.quc(contextName, columnName);
    }

    public static Object[] preparseSql(Class clazz, DOFWEntity entity, Object[] sql) {
        if (sql == null) {
            sql = new Object[]{};
        }
        ArrayList<Object> result = new ArrayList<Object>();
        DOFWSql.preparseSqlInBetween(sql, result);
        if (entity != null) {
            DOFWSql.preparseSqlYYMMDDCenturyReference(clazz, entity, result);
        }
        if (entity != null) {
            DOFWSql.preparseSqlDeletedProperty(entity, sql, result);
        }
        if (result.size() == 0) {
            return null;
        }
        Object[] resultArray = new Object[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    private static void preparseSqlDeletedProperty(DOFWEntity entity, Object[] sql, List<Object> result) {
        String deletedProperty = entity.getDeletedProperty();
        if (deletedProperty == null) {
            return;
        }
        for (Object sqlValue : sql) {
            if (!sqlValue.equals(deletedProperty)) continue;
            return;
        }
        boolean containsQuery = result.size() > 0;
        result.add(0, deletedProperty);
        result.add(1, "=");
        result.add(2, false);
        if (containsQuery) {
            result.add(3, "AND");
            result.add(4, "(");
            result.add(")");
        }
    }

    private static void preparseSqlYYMMDDCenturyReference(Class clazz, DOFWEntity entity, List<Object> result) {
        if (clazz == null) {
            return;
        }
        for (int i = result.size() - 1; i >= 0; --i) {
            Object o = result.get(i);
            if (!QueryUtils.checkIfObjectIsSQLComparator(o)) continue;
            int propertyIndex = i - 1;
            int valueIndex = i + 1;
            try {
                String propertyName = (String)result.get(propertyIndex);
                DOFWProperty property = DOFWRepository.getProperty(clazz, propertyName, false);
                if (property == null || !DOFWUtils.checkIfPropertyHasCenturyColumn(property)) continue;
                Object comparator = result.get(i);
                Object value = result.get(valueIndex);
                result.add(valueIndex + 1, ")");
                result.add(valueIndex + 1, value);
                result.add(valueIndex + 1, comparator);
                result.add(valueIndex + 1, PREFIX_YYMMDDCENTURYREFERENCE + propertyName);
                result.add(valueIndex + 1, "AND");
                result.add(propertyIndex, "(");
                continue;
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static void preparseSqlInBetween(Object[] sql, List<Object> result) {
        for (int i = 0; i < sql.length; ++i) {
            if (i < sql.length - 2) {
                Object values;
                Object columnName;
                Object comparator = sql[i + 1];
                if (comparator == "IN") {
                    columnName = sql[i];
                    values = sql[i + 2];
                    if (!(columnName instanceof String)) {
                        throw new Error("Error when preparsing sql statement, there must be a column name in front of the IN operator!");
                    }
                    if (!(values instanceof ValuesIN)) {
                        throw new Error("Error when preparsing sql statement, there must be a value object of type ValueIN behind the IN comparator!");
                    }
                    ValuesIN valuesIn = (ValuesIN)values;
                    if (valuesIn.size() == 0) {
                        throw new Error("Error when preparsing sql statement, the ValuesIN object does not contain any value for column: " + columnName);
                    }
                    result.add("(");
                    int counter = 0;
                    for (Object value : valuesIn) {
                        if (counter > 0) {
                            result.add("OR");
                        }
                        result.add(columnName);
                        result.add("=");
                        result.add(value);
                        ++counter;
                    }
                    result.add(")");
                    i += 2;
                    continue;
                }
                if (comparator == "BETWEEN") {
                    columnName = sql[i];
                    values = sql[i + 2];
                    if (!(columnName instanceof String)) {
                        throw new Error("Error when preparsing sql statement, there must be a column name in front of the IN operator!");
                    }
                    if (!(values instanceof ValuesBETWEEN)) {
                        throw new Error("Error when preparsing sql statement, there must be a value object of type ValueBETWEEN behind the BETWEEN comparator!");
                    }
                    ValuesBETWEEN valuesBetween = (ValuesBETWEEN)values;
                    if (valuesBetween.getFrom() == null) {
                        throw new Error("Error when preparsing sql statement, the ValuesBETWEEN object does not contain any from value for column: " + columnName);
                    }
                    if (valuesBetween.getTo() == null) {
                        throw new Error("Error when preparsing sql statement, the ValuesBETWEEN object does not contain any from value for column: " + columnName);
                    }
                    result.add(columnName);
                    result.add(">=");
                    result.add(valuesBetween.getFrom());
                    result.add("AND");
                    result.add(columnName);
                    result.add("<=");
                    result.add(valuesBetween.getTo());
                    i += 2;
                    continue;
                }
                result.add(sql[i]);
                continue;
            }
            result.add(sql[i]);
        }
    }

    @SQLQueryCleanser(userComment="This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.")
    private static ProcessUpdateObjectInDBActionResult processUpdateObjectInDBAction(DBAction action, String contextName, Object dob, boolean directExecute) throws Exception {
        DOFWEntity entity;
        if (DOFWBuffer.checkIfBuffered(dob.getClass())) {
            DOFWBuffer.clearObjectCache(dob.getClass());
        }
        if ((entity = DOFWRepository.getEntity(dob.getClass())).isView()) {
            throw new Error("Update operation with entity defined as view is not possible: " + dob.getClass());
        }
        if (entity.isTransient()) {
            throw new Error("Update operation with entity defined as transient is not possible: " + dob.getClass());
        }
        List<DOFWProperty> keyProperties = DOFWRepository.getKeyProperties(dob.getClass());
        if (keyProperties.size() == 0 && entity.getTenantColumn() == null) {
            throw new Error("No key properties are defined for class " + dob.getClass() + ". Update not possible.");
        }
        List<DOFWProperty> valueProperties = DOFWRepository.getValueProperties(dob.getClass());
        if (valueProperties.size() == 0) {
            ArrayList<Object> qos = new ArrayList<Object>();
            for (DOFWProperty keyProperty : keyProperties) {
                qos.add(keyProperty.getName());
                qos.add(keyProperty.getGetter().invoke(dob, (Object[])null));
            }
            Object[] qosArray = new Object[qos.size()];
            qos.toArray(qosArray);
            Object qo = DOFWSql.queryOne(contextName, dob.getClass(), qosArray);
            if (qo != null) {
                return new ProcessUpdateObjectInDBActionResult(true, null);
            }
            return new ProcessUpdateObjectInDBActionResult(false, null);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("UPDATE ");
        sb.append(DOFWUtils.qut(contextName, action.withSchema(entity)));
        sb.append(" SET ");
        ArrayList<String> colqms = new ArrayList<String>();
        for (DOFWProperty property : valueProperties) {
            if (property.getAutoIncrement() && property.getAutoIncrementExcludeFromUpdate()) continue;
            colqms.add(DOFWSql.quc(contextName, property.getColumn()) + "=?");
            if (!DOFWUtils.checkIfPropertyHasCenturyColumn(property)) continue;
            colqms.add(DOFWSql.quc(contextName, property.getYYMMDDCenturyReference()) + "=?");
        }
        sb.append(DOFWSql.concatenateStrings(colqms));
        sb.append(" WHERE ");
        colqms = new ArrayList();
        if (entity.getTenantColumn() != null) {
            colqms.add(DOFWSql.quc(contextName, entity.getTenantColumn()) + "=?");
        }
        for (DOFWProperty property : keyProperties) {
            colqms.add(DOFWSql.quc(contextName, property.getColumn()) + "=?");
        }
        sb.append(DOFWSql.concatenateStrings(colqms, " AND "));
        PreparedStatement ps = null;
        ps = directExecute ? action.createStatement(sb.toString()) : action.createBatchStatement(sb.toString());
        StringBuffer sbValueLog = new StringBuffer();
        int counter = 1;
        for (DOFWProperty property : valueProperties) {
            if (property.getAutoIncrement() && property.getAutoIncrementExcludeFromUpdate()) continue;
            DOFWSql.psSet(contextName, ps, dob, property, counter++, sbValueLog);
            if (!DOFWUtils.checkIfPropertyHasCenturyColumn(property)) continue;
            DOFWSql.psSetCenturyYYMMDDReference(contextName, ps, dob, property, counter++);
        }
        if (entity.getTenantColumn() != null) {
            DOFWSql.setTenantInPreparedStatement(entity, ps, counter++);
        }
        for (DOFWProperty property : keyProperties) {
            DOFWSql.psSet(contextName, ps, dob, property, counter++, sbValueLog);
        }
        DOFWSql.logValueLog(sbValueLog);
        if (directExecute) {
            int n = DOFWExecutor.instance().executeUpdate(ps);
            if (n == 0) {
                return new ProcessUpdateObjectInDBActionResult(false, ps);
            }
            return new ProcessUpdateObjectInDBActionResult(true, ps);
        }
        ps.addBatch();
        return new ProcessUpdateObjectInDBActionResult(true, ps);
    }

    @SQLQueryCleanser(userComment="This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.")
    private static ProcessDeleteObjectInDBActionResult processDeleteObjectInDBAction(DBAction action, String contextName, Class clazz, Object[] colVals, boolean directExecute) throws Exception {
        if (DOFWBuffer.checkIfBuffered(clazz)) {
            DOFWBuffer.clearObjectCache(clazz);
        }
        DOFWEntity entity = DOFWRepository.getEntity(clazz);
        Object[] parsedColVals = DOFWSql.preparseSql(clazz, entity, colVals);
        if (entity.isView()) {
            throw new Error("Delete operation with entity defined as view is not possible: " + clazz);
        }
        if (entity.isTransient()) {
            throw new Error("Delete operation with entity defined as transient is not possible: " + clazz);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("DELETE FROM ");
        sb.append(DOFWUtils.qut(contextName, action.withSchema(entity)));
        sb.append(" WHERE ");
        ArrayList<Integer> columnIndices = new ArrayList<Integer>();
        ArrayList<Integer> valueIndices = new ArrayList<Integer>();
        DOFWSql.buildConditionString(contextName, sb, clazz, entity, parsedColVals, columnIndices, valueIndices, true, null);
        PreparedStatement ps = null;
        ps = directExecute ? action.createStatement(sb.toString()) : action.createBatchStatement(sb.toString());
        int counter = 1;
        if (entity.getTenantColumn() != null) {
            DOFWSql.setTenantInPreparedStatement(entity, ps, counter++);
        }
        DOFWSql.transferConditionValuesIntoResultSet(contextName, clazz, parsedColVals, columnIndices, valueIndices, ps, counter, null);
        if (directExecute) {
            int resi = DOFWExecutor.instance().executeUpdate(ps);
            return new ProcessDeleteObjectInDBActionResult(resi, ps);
        }
        ps.addBatch();
        return new ProcessDeleteObjectInDBActionResult(1, ps);
    }

    /*
     * WARNING - void declaration
     */
    @SQLQueryCleanser(userComment="This is the central class of the DOFW persistence framework. It maps Java entity objects (\"Pojos\") to database table operations. As result SQL commands are assembled for querying and updating the database.\nThe SQL commands are all assembled in the same way:\n1. PreparedStatement processing is used so that\n2. any data that is passed by the application is NOT able to influence the SQL command itself.\nAs result the framework is robust against SQL injection attacks.")
    private static ProcessInsertObjectInDBActionResult processInsertObjectInDBAction(DBAction action, String contextName, Object dob, boolean directExecute) throws Exception {
        void var10_18;
        DOFWEntity entity;
        if (DOFWBuffer.checkIfBuffered(dob.getClass())) {
            DOFWBuffer.clearObjectCache(dob.getClass());
        }
        if ((entity = DOFWRepository.getEntity(dob.getClass())).isView()) {
            throw new Error("Insert operation with entity defined as view is not possible: " + dob.getClass());
        }
        if (entity.isTransient()) {
            throw new Error("Insert operation with entity defined as transient is not possible: " + dob.getClass());
        }
        List<DOFWProperty> properties = DOFWRepository.getProperties(dob.getClass());
        properties = new ArrayList<DOFWProperty>(properties);
        ArrayList<DOFWProperty> propertiesWithAutoIncrement = null;
        int maxi = properties.size();
        for (int i = maxi - 1; i >= 0; --i) {
            if (!properties.get(i).getAutoIncrement()) continue;
            if (propertiesWithAutoIncrement == null) {
                propertiesWithAutoIncrement = new ArrayList<DOFWProperty>();
            }
            propertiesWithAutoIncrement.add(properties.get(i));
            properties.remove(i);
        }
        StringBuffer sb = new StringBuffer();
        sb.append("INSERT INTO ");
        sb.append(DOFWUtils.qut(contextName, action.withSchema(entity)));
        sb.append(" (");
        ArrayList<String> columns = new ArrayList<String>();
        if (entity.getTenantColumn() != null) {
            columns.add(DOFWSql.quc(contextName, entity.getTenantColumn()));
        }
        for (DOFWProperty dOFWProperty : properties) {
            columns.add(DOFWSql.quc(contextName, dOFWProperty.getColumn()));
            if (!DOFWUtils.checkIfPropertyHasCenturyColumn(dOFWProperty)) continue;
            columns.add(DOFWSql.quc(contextName, dOFWProperty.getYYMMDDCenturyReference()));
        }
        sb.append(DOFWSql.concatenateStrings(columns));
        sb.append(") VALUES (");
        ArrayList<String> qms = new ArrayList<String>();
        if (entity.getTenantColumn() != null) {
            qms.add("?");
        }
        for (DOFWProperty property : properties) {
            qms.add("?");
            if (!DOFWUtils.checkIfPropertyHasCenturyColumn(property)) continue;
            qms.add("?");
        }
        sb.append(DOFWSql.concatenateStrings(qms));
        sb.append(")");
        Object var10_14 = null;
        if (directExecute) {
            if (propertiesWithAutoIncrement == null || !DOFWDialect.getAutoIncrementGetValueSupported(contextName)) {
                PreparedStatement preparedStatement = action.createStatement(sb.toString());
            } else {
                PreparedStatement preparedStatement = action.createStatement(sb.toString(), 1);
            }
        } else {
            PreparedStatement preparedStatement = action.createBatchStatement(sb.toString());
        }
        int counter = 1;
        if (entity.getTenantColumn() != null) {
            DOFWSql.setTenantInPreparedStatement(entity, (PreparedStatement)var10_18, counter++);
        }
        StringBuffer sbValueLog = new StringBuffer();
        for (DOFWProperty property : properties) {
            DOFWSql.psSet(contextName, (PreparedStatement)var10_18, dob, property, counter++, sbValueLog);
            if (!DOFWUtils.checkIfPropertyHasCenturyColumn(property)) continue;
            DOFWSql.psSetCenturyYYMMDDReference(contextName, (PreparedStatement)var10_18, dob, property, counter++);
        }
        DOFWSql.logValueLog(sbValueLog);
        if (directExecute) {
            try {
                int resi;
                block27: {
                    resi = DOFWExecutor.instance().executeUpdate((PreparedStatement)var10_18);
                    if (propertiesWithAutoIncrement != null && DOFWDialect.getAutoIncrementGetValueSupported(contextName)) {
                        try {
                            ResultSet airs = var10_18.getGeneratedKeys();
                            if (airs.next()) {
                                for (DOFWProperty property : propertiesWithAutoIncrement) {
                                    Object genValue = null;
                                    try {
                                        String columnName = property.getColumn();
                                        String fixName = DOFWDialect.getFixColumnNameForAutoIncrementedColumns(contextName);
                                        if (fixName != null) {
                                            columnName = fixName;
                                        }
                                        if ((genValue = DOFWMapper.readAndMapDBValue(contextName, airs, columnName, property)) == DOFWMapper.NOVALUEAVAILABLE) continue;
                                        Method setter = property.getSetter();
                                        setter.invoke(dob, genValue);
                                    }
                                    catch (Throwable tt) {
                                        throw new Error("Problem mapping generated/autoIncremented key: " + property.getName() + ", " + genValue, tt);
                                    }
                                }
                                break block27;
                            }
                            throw new Error("Did not receive result set of generated keys from database.");
                        }
                        catch (Throwable t) {
                            AppLog.L.log(LL_WAR, "Problem occurred when writing back auto increment to object");
                            AppLog.L.log(LL_WAR, "The INSERT operation is continued: but the object is not updated");
                        }
                    }
                }
                return new ProcessInsertObjectInDBActionResult(resi, (PreparedStatement)var10_18);
            }
            catch (Throwable t) {
                if (t instanceof Error) {
                    throw (Error)t;
                }
                throw new Error("Problem during insert. Context name " + contextName + ", object class " + dob.getClass(), t);
            }
        }
        var10_18.addBatch();
        return new ProcessInsertObjectInDBActionResult(1, (PreparedStatement)var10_18);
    }

    private static void setTenantInPreparedStatement(DOFWEntity entity, PreparedStatement ps, int counter) throws SQLException {
        String tenant = TenantAccessMgr.getCurrentTenant();
        if (!entity.getTenantIsNumeric()) {
            ps.setString(counter, tenant);
        } else {
            long numTenant = ValueManager.decodeLong((String)tenant, (long)0L);
            ps.setLong(counter, numTenant);
        }
    }

    private static void transferConditionValuesIntoResultSet(String contextName, Class clazz, Object[] parsedColVals, List<Integer> columnIndices, List<Integer> valueIndices, PreparedStatement ps, int psParamCounter, DynSqlAddon dynSqlAddon) throws Exception {
        int i;
        StringBuffer sbValueLog = new StringBuffer();
        for (i = 0; i < columnIndices.size(); ++i) {
            DOFWProperty property;
            if (columnIndices.get(i) == null || valueIndices.get(i) == null) continue;
            String colName = "" + parsedColVals[columnIndices.get(i)];
            Object colValue = parsedColVals[valueIndices.get(i)];
            boolean yymmddCenturyReference = false;
            if (colName.startsWith(PREFIX_YYMMDDCENTURYREFERENCE)) {
                colName = colName.substring(PREFIX_YYMMDDCENTURYREFERENCE.length());
                yymmddCenturyReference = true;
            }
            if ((property = DOFWRepository.getProperty(clazz, colName)) == null) {
                throw new Error("Could not find property: " + clazz.getName() + ", " + colName);
            }
            if (!yymmddCenturyReference) {
                DOFWSql.psSetValue(contextName, ps, colValue, property, psParamCounter++, sbValueLog);
                continue;
            }
            DOFWSql.psSetValueCenturyYYMMDDReference(contextName, ps, colValue, property, psParamCounter++);
        }
        if (dynSqlAddon != null && dynSqlAddon.getAdditionalQueryParams() != null) {
            for (i = 0; i < dynSqlAddon.getAdditionalQueryParams().length; ++i) {
                ps.setObject(psParamCounter++, dynSqlAddon.getAdditionalQueryParams()[i]);
                DOFWSql.addValueToValueLog(sbValueLog, "addQueryParam:" + i, dynSqlAddon.getAdditionalQueryParams()[i]);
            }
        }
        DOFWSql.logValueLog(sbValueLog);
    }

    private static void logValueLog(StringBuffer sbTrace) {
        if (DOFWSql.checkIfValueLoggingIsActive()) {
            AppLog.L.log(LL_INF, "SQL VALUES: \n" + sbTrace.toString());
        }
    }

    private static void addValueToValueLog(StringBuffer sbTrace, String propertyName, Object colValue) {
        if (DOFWSql.checkIfValueLoggingIsActive()) {
            if (sbTrace.length() > 0) {
                sbTrace.append(", ");
            }
            sbTrace.append(propertyName + "=" + DOFWSql.convertToTraceValue(colValue));
        }
    }

    private static boolean checkIfValueLoggingIsActive() {
        if (s_valueLoggingActive) {
            return true;
        }
        String s = Config.getConfigValue("db_valueloggingactive");
        return ValueManager.decodeBoolean((String)s, (boolean)false);
    }

    private static String convertToTraceValue(Object colValue) {
        if (colValue == null) {
            return "null";
        }
        String result = ValueManager.convertObject2DisplayString((Object)colValue);
        if (result.length() > 100) {
            result = result.substring(0, 97) + "...";
        }
        return "\"" + result + "\"";
    }

    private static boolean checkIfTraceIsActive(Class<? extends Object> clazz) {
        if (Trace.instance() == null) {
            return false;
        }
        DOFWEntity entity = DOFWRepository.getEntity(clazz, true);
        return entity.isTraceActive();
    }

    private static void checkThatObjectForUpdateHasKeyDefinitions(Class doClass) {
        DOFWEntity entity = DOFWRepository.getEntity(doClass);
        if (entity.isTransient()) {
            throw new Error("Update operation with entity defined as transient is not possible: " + doClass);
        }
        List<DOFWProperty> props = DOFWRepository.getKeyProperties(doClass);
        if (props.size() == 0) {
            throw new Error("No key definitions for class: " + doClass + ". At least one property must be defined as key property.");
        }
    }

    private static class ProcessUpdateObjectInDBActionResult {
        boolean resultUpdate;
        PreparedStatement batchPreparedStatement;

        private ProcessUpdateObjectInDBActionResult(boolean resultUpdate, PreparedStatement batchPreparedStatement) {
            this.resultUpdate = resultUpdate;
            this.batchPreparedStatement = batchPreparedStatement;
        }
    }

    private static class ProcessInsertObjectInDBActionResult {
        int resultInsert;
        PreparedStatement batchPreparedStatement;

        private ProcessInsertObjectInDBActionResult(int resultInsert, PreparedStatement batchPreparedStatement) {
            this.resultInsert = resultInsert;
            this.batchPreparedStatement = batchPreparedStatement;
        }
    }

    private static class ProcessDeleteObjectInDBActionResult {
        int resultDelete;
        PreparedStatement batchPreparedStatement;

        private ProcessDeleteObjectInDBActionResult(int resultDelete, PreparedStatement batchPreparedStatement) {
            this.resultDelete = resultDelete;
            this.batchPreparedStatement = batchPreparedStatement;
        }
    }

    static class PreparseSqlForDynSqlAddonResult {
        DynSqlAddon addon;
        Object[] colVals;

        public PreparseSqlForDynSqlAddonResult(DynSqlAddon addon, Object[] colVals) {
            this.addon = addon;
            this.colVals = colVals;
        }
    }
}

