/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.dofw.util;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclnt.ccee.db.dofw.DOFWEntity;
import org.eclnt.ccee.db.dofw.DOFWRepository;
import org.eclnt.util.buffermgmt.IResetBuffer;
import org.eclnt.util.buffermgmt.ResetBuffers;

public class DOFWBuffer {
    public static final Object BUFFEREDNULL = new Object();
    static Set<Class> s_bufferedClasses = new HashSet<Class>();
    static Set<Class> s_unbufferedClasses = new HashSet<Class>();
    static Map<Class, Map<String, Object>> s_buffer = new Hashtable<Class, Map<String, Object>>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetBuffers() {
        Map<Class, Map<String, Object>> map = s_buffer;
        synchronized (map) {
            s_buffer.clear();
            s_bufferedClasses.clear();
            s_unbufferedClasses.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean checkIfBuffered(Class c) {
        if (s_bufferedClasses.contains(c)) {
            return true;
        }
        if (s_unbufferedClasses.contains(c)) {
            return false;
        }
        try {
            Set<Class> set = s_bufferedClasses;
            synchronized (set) {
                DOFWEntity entity = DOFWRepository.getEntity(c);
                if (entity.isBuffered()) {
                    s_bufferedClasses.add(c);
                    return true;
                }
                s_unbufferedClasses.add(c);
                return false;
            }
        }
        catch (Throwable t) {
            throw new Error("Problem when checking if buffered: " + c.getName(), t);
        }
    }

    public static BufferResult readObjectFromBuffer(Class doClass, Object[] queryParams) {
        String key;
        Map<String, Object> classBuffer = DOFWBuffer.readClassBuffer(doClass);
        Object result = classBuffer.get(key = DOFWBuffer.buildKey(doClass, queryParams));
        if (result == null) {
            return new BufferResult(false, null);
        }
        if (result == BUFFEREDNULL) {
            return new BufferResult(true, null);
        }
        return new BufferResult(true, result);
    }

    public static void updateObjectBuffer(Class doClass, Object object, Object[] queryParams) {
        if (object == null) {
            object = BUFFEREDNULL;
        }
        Map<String, Object> classBuffer = DOFWBuffer.readClassBuffer(doClass);
        String key = DOFWBuffer.buildKey(doClass, queryParams);
        classBuffer.put(key, object);
    }

    public static void clearObjectCache(Class doClass) {
        Map<String, Object> classBuffer = DOFWBuffer.readClassBuffer(doClass);
        classBuffer.clear();
    }

    private static String buildKey(Class doClass, Object[] queryParams) {
        StringBuffer sb = new StringBuffer();
        for (Object param : queryParams) {
            sb.append(param + "/");
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Object> readClassBuffer(Class doClass) {
        Map<String, Object> result = s_buffer.get(doClass);
        if (result == null) {
            Map<Class, Map<String, Object>> map = s_buffer;
            synchronized (map) {
                result = s_buffer.get(doClass);
                if (result == null) {
                    result = new Hashtable<String, Object>();
                    s_buffer.put(doClass, result);
                }
            }
        }
        return result;
    }

    static {
        ResetBuffers.addListenerClassSwap((IResetBuffer)new IResetBuffer(){

            public void reset() {
                DOFWBuffer.resetBuffers();
            }
        });
    }

    public static class BufferResult {
        boolean i_bufferedObjectWasAvailable = false;
        Object i_bufferedObject;

        public BufferResult(boolean bufferedObjectWasAvailable, Object bufferedObject) {
            this.i_bufferedObjectWasAvailable = bufferedObjectWasAvailable;
            this.i_bufferedObject = bufferedObject;
        }

        public boolean isBufferedObjectWasAvailable() {
            return this.i_bufferedObjectWasAvailable;
        }

        public Object getBufferedObject() {
            return this.i_bufferedObject;
        }
    }
}

