/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.db.textquery;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.dofw.DOFWProperty;
import org.eclnt.ccee.db.dofw.DOFWRepository;
import org.eclnt.ccee.db.dofw.DOFWSql;
import org.eclnt.ccee.db.dofw.util.QueryParameterFunction;
import org.eclnt.jsfserver.util.BeanIntrospector;
import org.eclnt.util.valuemgmt.ValueManager;

public class DOFWTextQuery
implements ICCEEConstants {
    private static DOFWTextQuery s_instance = new DOFWTextQuery();

    public static DOFWTextQuery instance() {
        return s_instance;
    }

    public static void initialize(DOFWTextQuery instance) {
        s_instance = instance;
    }

    public <OBJTYPE> List<OBJTYPE> queryByText(Class<OBJTYPE> clazz, String searchText) {
        List<String> queryPropertyNames = this.findPropertyNamesForCrossColumnSearch(clazz);
        return this.queryByText(clazz, queryPropertyNames, searchText);
    }

    public <OBJTYPE> List<OBJTYPE> queryByText(Class<OBJTYPE> clazz, List<String> queryPropertyNames, String searchText) {
        String likeString = ValueManager.toLowerCaseText((String)searchText);
        String[] parts = ValueManager.tokenizeStringWithQuotes((String)likeString, (char)' ');
        Object[] colVals = this.calculateQueryColVals(clazz, queryPropertyNames, parts);
        return DOFWSql.query(clazz, colVals);
    }

    public <OBJTYPE> List<OBJTYPE> queryTopByText(Class<OBJTYPE> clazz, String searchText, int top) {
        List<String> queryPropertyNames = this.findPropertyNamesForCrossColumnSearch(clazz);
        return this.queryTopByText(clazz, queryPropertyNames, searchText, top);
    }

    public <OBJTYPE> List<OBJTYPE> queryTopByText(Class<OBJTYPE> clazz, List<String> queryPropertyNames, String searchText, int top) {
        String likeString = ValueManager.toLowerCaseText((String)searchText);
        String[] parts = ValueManager.tokenizeStringWithQuotes((String)likeString, (char)' ');
        Object[] colVals = this.calculateQueryColVals(clazz, queryPropertyNames, parts);
        return DOFWSql.queryTop(clazz, top, colVals);
    }

    protected Object[] calculateQueryColVals(Class clazz, List<String> queryPropertyNames, String[] parts) {
        ArrayList<Object> queryObjectList = new ArrayList<Object>();
        int partCounter = 0;
        for (String part : parts) {
            part = "%" + part.replace("*", "%") + "%";
            if (partCounter != 0) {
                queryObjectList.add("AND");
            }
            int propertyCounter = 0;
            queryObjectList.add("(");
            for (String propertyName : queryPropertyNames) {
                DOFWProperty property = DOFWRepository.getProperty(clazz, propertyName);
                if (property == null || !this.checkIfPropertyIsIncludedInCrossColumnFiltering(property)) continue;
                if (propertyCounter != 0) {
                    queryObjectList.add("OR");
                }
                if (property.getGetter().getReturnType() == String.class) {
                    queryObjectList.add(new QueryParameterFunction("lower", propertyName));
                } else {
                    queryObjectList.add(propertyName);
                }
                queryObjectList.add("LIKE");
                queryObjectList.add(part);
                ++propertyCounter;
            }
            queryObjectList.add(")");
            ++partCounter;
        }
        queryObjectList.add(0, "(");
        queryObjectList.add(")");
        Object[] colVals = queryObjectList.toArray();
        return colVals;
    }

    protected List<String> findPropertyNamesForCrossColumnSearch(Class clazz) {
        ArrayList<String> result = new ArrayList<String>();
        List piis = BeanIntrospector.readPropertiesAsList((Class)clazz);
        for (BeanIntrospector.PropertyIntrospectionInfo pii : piis) {
            try {
                String propertyName = pii.getPropertyName();
                DOFWProperty property = DOFWRepository.getProperty(clazz, propertyName);
                if (property == null || !this.checkIfPropertyIsIncludedInCrossColumnFiltering(property)) continue;
                result.add(propertyName);
            }
            catch (Throwable throwable) {}
        }
        return result;
    }

    protected boolean checkIfPropertyIsIncludedInCrossColumnFiltering(DOFWProperty property) {
        Class<?> returnType = property.getGetter().getReturnType();
        return returnType == String.class || returnType == Byte.class || returnType == Byte.TYPE || returnType == Short.class || returnType == Short.TYPE || returnType == Integer.class || returnType == Integer.TYPE || returnType == Long.class || returnType == Long.TYPE || returnType == BigInteger.class;
    }
}

