/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.dyndata;

import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.db.dofw.DOFWSql;
import org.eclnt.ccee.db.dofw.util.DOFWUtils;
import org.eclnt.ccee.db.jdbc.JDBCSql;
import org.eclnt.ccee.db.jdbc.JDBCUtils;
import org.eclnt.ccee.db.util.QueryUtils;
import org.eclnt.ccee.dyndata.DynDataMap;
import org.eclnt.ccee.dyndata.DynDataReaderContext;
import org.eclnt.ccee.dyndata.DynDataUtil;
import org.eclnt.ccee.dyndata.meta.DynDataDefinition;
import org.eclnt.ccee.dyndata.meta.IDynDataConstants;
import org.eclnt.ccee.json.jackson.JSONUtil;
import org.eclnt.ccee.simplexml.SimpleXML;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.util.valuemgmt.PojoManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class DynDataReader
implements ICCEEConstants,
IDynDataConstants {
    ScriptEngine m_jsEngine;
    DynDataReaderContext m_ddrContext = new DynDataReaderContext();

    public DynDataReader() {
        this.m_jsEngine = new ScriptEngineManager().getEngineByName("nashorn");
    }

    public DynDataReader(DynDataReaderContext ddrContext) {
        this();
        this.m_ddrContext = ddrContext;
    }

    public DynDataMap createDynDataMap(DynDataDefinition realDdd) {
        if (realDdd.getId() == null) {
            realDdd.setId("CCTOP");
        }
        DynDataDefinition ddd = new DynDataDefinition();
        ddd.setId("DDEXTRAROOT");
        ddd.getChildren().add(realDdd);
        DynDataMap extaRoot = new DynDataMap(this.m_ddrContext, ddd.getId(), null);
        this.processXMLFilesWithDrillDown(ddd, extaRoot);
        this.processJSONFilesWithDrillDown(ddd, extaRoot);
        this.processDOFWQueryWithDrillDown(ddd, extaRoot);
        this.processJDBCQueryWithDrillDown(ddd, extaRoot);
        this.processPropertyFilesWithDrillDown(ddd, extaRoot);
        this.processJavaScriptWithDrillDown(ddd, extaRoot);
        this.processDataTypesWithDrillDown(ddd, extaRoot);
        DynDataMap result = extaRoot.getObjectMap(realDdd.getId());
        if (result == null) {
            result = new DynDataMap(this.m_ddrContext, realDdd.getId(), null);
        }
        result.setParent(null);
        return result;
    }

    public DynDataMap createDynDataMap(DynDataDefinition ddd, Object rootBean) {
        DynDataMap result = new DynDataMap(this.m_ddrContext, ddd.getId(), null);
        result.putAll(PojoManager.transferPojoIntoMap((Object)rootBean));
        if (ddd != null) {
            this.processXMLFilesWithDrillDown(ddd, result);
            this.processJSONFilesWithDrillDown(ddd, result);
            this.processDOFWQueryWithDrillDown(ddd, result);
            this.processJDBCQueryWithDrillDown(ddd, result);
            this.processPropertyFilesWithDrillDown(ddd, result);
            this.processJavaScriptWithDrillDown(ddd, result);
            this.processDataTypesWithDrillDown(ddd, result);
        }
        return result;
    }

    public DynDataMap createDynDataMapFromMap(Map<String, Object> map) {
        return this.createDynDataMapFromMap(null, map);
    }

    public DynDataMap createDynDataMapFromMap(DynDataDefinition ddd, Map<String, Object> map) {
        String id = "ROOT";
        if (ddd != null) {
            id = ddd.getId();
        }
        DynDataMap result = new DynDataMap(this.m_ddrContext, id, null);
        this.fillDynDataMapWithMap(result, map);
        if (ddd != null) {
            this.processXMLFilesWithDrillDown(ddd, result);
            this.processJSONFilesWithDrillDown(ddd, result);
            this.processDOFWQueryWithDrillDown(ddd, result);
            this.processJDBCQueryWithDrillDown(ddd, result);
            this.processPropertyFilesWithDrillDown(ddd, result);
            this.processJavaScriptWithDrillDown(ddd, result);
            this.processDataTypesWithDrillDown(ddd, result);
        }
        return result;
    }

    public void addMapIntoDynDataMap(DynDataMap ddMap, Map<String, Object> map) {
        this.fillDynDataMapWithMap(ddMap, map);
    }

    private void fillDynDataMapWithMap(DynDataMap result, Map<String, Object> map) {
        for (String key : map.keySet()) {
            Object value = map.get(key);
            if ("data".equals(key) || value == null) continue;
            if (ValueManager.checkIfSimpleDataType(value.getClass())) {
                result.put(key, value);
                continue;
            }
            if (value instanceof Map) {
                DynDataMap objMap = result.getObjectMap(key);
                if (objMap == null) {
                    objMap = new DynDataMap(this.m_ddrContext, key, result);
                    result.put(key, objMap);
                }
                this.fillDynDataMapWithMap(objMap, (Map)value);
                continue;
            }
            if (value instanceof List) {
                List valueList = (List)value;
                List<DynDataMap> dddList = result.getObjectMapList(key);
                if (dddList == null) {
                    dddList = new ArrayList<DynDataMap>();
                    result.put(key, dddList);
                }
                for (Object item : valueList) {
                    if (!(item instanceof Map)) continue;
                    DynDataMap itemMap = new DynDataMap(this.m_ddrContext, key, result);
                    dddList.add(itemMap);
                    this.fillDynDataMapWithMap(itemMap, (Map)item);
                }
                continue;
            }
            if (!"object".equals(key)) continue;
            result.putAll(PojoManager.transferPojoIntoMap((Object)value));
        }
    }

    private void addDataFromChildrenByFollowingDOFWQuery(DynDataMap parentMap, DynDataDefinition childDdd, boolean withOwnDrillDown) {
        block7: {
            block6: {
                if (childDdd.getDofwQuery() == null || childDdd.getDofwQuery().length() == 0) {
                    return;
                }
                if (!childDdd.getIsList()) break block6;
                List<?> childInstances = this.readChildrenDOFW(parentMap, childDdd);
                if (childInstances.size() <= 0) break block7;
                ArrayList<DynDataMap> childrenDataMap = new ArrayList<DynDataMap>();
                parentMap.put(childDdd.getId(), childrenDataMap);
                for (Object childInstance : childInstances) {
                    DynDataMap childMap = new DynDataMap(this.m_ddrContext, childDdd.getId(), parentMap);
                    childMap.putAll(PojoManager.transferPojoIntoMap(childInstance));
                    childrenDataMap.add(childMap);
                    if (!withOwnDrillDown) continue;
                    for (DynDataDefinition subDdd : childDdd.getChildren()) {
                        this.addDataFromChildrenByFollowingDOFWQuery(childMap, subDdd, withOwnDrillDown);
                    }
                }
                break block7;
            }
            Object childInstance = this.readChildDOFW(parentMap, childDdd);
            if (childInstance != null) {
                DynDataMap childMap = new DynDataMap(this.m_ddrContext, childDdd.getId(), parentMap);
                parentMap.put(childDdd.getId(), childMap);
                childMap.putAll(PojoManager.transferPojoIntoMap((Object)childInstance));
                if (withOwnDrillDown) {
                    for (DynDataDefinition subDdd : childDdd.getChildren()) {
                        this.addDataFromChildrenByFollowingDOFWQuery(childMap, subDdd, withOwnDrillDown);
                    }
                }
            }
        }
    }

    private void addDataFromChildrenByFollowingJDBCQuery(DynDataMap parentMap, DynDataDefinition childDdd, boolean withOwnDrillDown) {
        block7: {
            block6: {
                if (childDdd.getTableQuery() == null || childDdd.getTableQuery().length() == 0) {
                    return;
                }
                if (!childDdd.getIsList()) break block6;
                List<Map<String, Object>> childInstances = this.readChildrenJDBC(parentMap, childDdd);
                if (childInstances.size() <= 0) break block7;
                ArrayList<DynDataMap> childrenDataMap = new ArrayList<DynDataMap>();
                parentMap.put(childDdd.getId(), childrenDataMap);
                for (Map<String, Object> childInstance : childInstances) {
                    DynDataMap childMap = new DynDataMap(this.m_ddrContext, childDdd.getId(), parentMap);
                    childMap.putAll(childInstance);
                    childrenDataMap.add(childMap);
                    if (!withOwnDrillDown) continue;
                    for (DynDataDefinition subDdd : childDdd.getChildren()) {
                        this.addDataFromChildrenByFollowingJDBCQuery(childMap, subDdd, withOwnDrillDown);
                    }
                }
                break block7;
            }
            Map<String, Object> childInstance = this.readChildJDBC(parentMap, childDdd);
            if (childInstance != null) {
                DynDataMap childMap = new DynDataMap(this.m_ddrContext, childDdd.getId(), parentMap);
                parentMap.put(childDdd.getId(), childMap);
                childMap.putAll(childInstance);
                if (withOwnDrillDown) {
                    for (DynDataDefinition subDdd : childDdd.getChildren()) {
                        this.addDataFromChildrenByFollowingJDBCQuery(childMap, subDdd, withOwnDrillDown);
                    }
                }
            }
        }
    }

    private void executeFunctionOnDataMapWithDrillDown(IFunctionOnDataMap function, DynDataDefinition ddd, DynDataMap ddm) {
        function.execute(ddd, ddm);
        for (String key : ddm.keySet()) {
            Object value;
            if ("data".equals(key) || (value = ddm.get(key)) == null) continue;
            if (value instanceof DynDataMap) {
                DynDataMap childDdm = (DynDataMap)value;
                DynDataDefinition childDdd = this.findChildDynDataDefinition(ddd, childDdm.getDataDefinitionId());
                if (childDdd == null) continue;
                this.executeFunctionOnDataMapWithDrillDown(function, childDdd, childDdm);
                continue;
            }
            if (!(value instanceof List)) continue;
            for (Object item : (List)value) {
                DynDataMap childDdm;
                DynDataDefinition childDdd;
                if (!(item instanceof DynDataMap) || (childDdd = this.findChildDynDataDefinition(ddd, (childDdm = (DynDataMap)item).getDataDefinitionId())) == null) continue;
                this.executeFunctionOnDataMapWithDrillDown(function, childDdd, childDdm);
            }
        }
    }

    private DynDataDefinition findChildDynDataDefinition(DynDataDefinition ddd, String dataDefinitionId) {
        if (ddd == null) {
            return null;
        }
        for (DynDataDefinition childDdd : ddd.getChildren()) {
            if (!ValueManager.checkIfStringsAreEqual((String)dataDefinitionId, (String)childDdd.getId())) continue;
            return childDdd;
        }
        return null;
    }

    private void processJavaScriptWithDrillDown(DynDataDefinition childDdd, DynDataMap childMap) {
        IFunctionOnDataMap f = new IFunctionOnDataMap(){

            @Override
            public void execute(DynDataDefinition childDdd, DynDataMap childMap) {
                DynDataReader.this.processJavaScript(childDdd, childMap);
            }
        };
        this.executeFunctionOnDataMapWithDrillDown(f, childDdd, childMap);
    }

    private void processJavaScript(DynDataDefinition childDdd, DynDataMap childMap) {
        String fullScript = null;
        try {
            if (childDdd.getScript() == null) {
                return;
            }
            String methodName = childDdd.getId() + "_update";
            fullScript = "function " + methodName + "(data)\n{\n" + childDdd.getScript() + "}\n";
            this.m_jsEngine.eval(fullScript);
            ((Invocable)((Object)this.m_jsEngine)).invokeFunction(methodName, childMap);
        }
        catch (Throwable t) {
            throw new Error("Error processing JS: " + fullScript, t);
        }
    }

    private List<?> readChildrenDOFW(DynDataMap rootMap, DynDataDefinition childDdd) {
        try {
            Object[] queryParams = DynDataReader.transferQueryStringIntoDOFWQueryObjects(childDdd);
            int resNofNulls = this.replaceExpressionsInQueryParams(rootMap, queryParams);
            if (resNofNulls > 0) {
                return new ArrayList();
            }
            Object[] sortParams = DOFWUtils.transferSortStringIntoDOFWQueryObjects(childDdd.getDofwSort());
            Class<?> clazz = Class.forName(childDdd.getClassName(), true, HotDeployManager.currentClassLoader());
            List<?> result = DOFWSql.query(this.findDataContextName(childDdd), clazz, queryParams, sortParams);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Could not read children: " + childDdd.getId(), t);
        }
    }

    private List<Map<String, Object>> readChildrenJDBC(DynDataMap rootMap, DynDataDefinition childDdd) {
        try {
            Object[] queryParams = DynDataReader.transferQueryStringIntoJDBCQueryObjects(this.findDataContextName(childDdd), childDdd);
            int resNofNulls = this.replaceExpressionsInQueryParams(rootMap, queryParams);
            if (resNofNulls > 0) {
                return new ArrayList<Map<String, Object>>();
            }
            Object[] sortParams = JDBCUtils.transferSortStringIntoJDBCQueryObjects(childDdd.getTableSort());
            List<Map<String, Object>> result = JDBCSql.query(this.findDataContextName(childDdd), childDdd.getTableName(), queryParams, sortParams);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Could not read children: " + childDdd.getId(), t);
        }
    }

    private String findDataContextName(DynDataDefinition ddd) {
        return DynDataUtil.findDataContextName(this.m_ddrContext, ddd);
    }

    private Map<String, Object> readChildJDBC(DynDataMap rootMap, DynDataDefinition childDdd) {
        try {
            Object[] queryParams = DynDataReader.transferQueryStringIntoJDBCQueryObjects(this.findDataContextName(childDdd), childDdd);
            int resNofNulls = this.replaceExpressionsInQueryParams(rootMap, queryParams);
            if (resNofNulls > 0) {
                return null;
            }
            Map<String, Object> result = JDBCSql.queryOne(this.findDataContextName(childDdd), childDdd.getTableName(), queryParams, null);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Could not read child: " + childDdd.getId(), t);
        }
    }

    private Object readChildDOFW(DynDataMap rootMap, DynDataDefinition childDdd) {
        try {
            Object[] queryParams = DynDataReader.transferQueryStringIntoDOFWQueryObjects(childDdd);
            int resNofNulls = this.replaceExpressionsInQueryParams(rootMap, queryParams);
            if (resNofNulls > 0) {
                return null;
            }
            Class<?> clazz = Class.forName(childDdd.getClassName(), true, HotDeployManager.currentClassLoader());
            Object result = DOFWSql.queryOne(this.findDataContextName(childDdd), clazz, queryParams);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Could not read child: " + childDdd.getId(), t);
        }
    }

    private int replaceExpressionsInQueryParams(DynDataMap rootMap, Object[] queryParams) {
        int numberOfNullObjects = 0;
        int counter = 0;
        for (Object queryParam : queryParams) {
            String qps;
            if (queryParam instanceof String && (qps = (String)queryParam).startsWith("${") && qps.endsWith("}")) {
                Object qpv = this.resolveExpression(rootMap, qps);
                if (qpv == null) {
                    ++numberOfNullObjects;
                }
                queryParams[counter] = qpv;
            }
            ++counter;
        }
        return numberOfNullObjects;
    }

    private Object resolveExpression(DynDataMap rootMap, String qps) {
        int dotIndex = qps.indexOf(46);
        if (dotIndex < 0) {
            throw new Error("Expression does not contain \".\": " + qps);
        }
        String ddId = qps.substring(2, dotIndex);
        String ddPropertyName = qps.substring(dotIndex + 1, qps.length() - 1);
        int orIndex = ddPropertyName.indexOf(124);
        String ddDirectValue = null;
        if (orIndex >= 0) {
            ddDirectValue = ddPropertyName.substring(orIndex + 1);
            ddPropertyName = ddPropertyName.substring(0, orIndex);
        }
        DynDataMap current = rootMap;
        if ("CONTEXT".equals(ddId)) {
            Class resultClass;
            String result = this.m_ddrContext.getGlobals().get(ddPropertyName);
            if (result == null) {
                result = ddDirectValue;
            }
            if ((resultClass = QueryUtils.findPropertyClassFromQueryValueString(result)) != null) {
                result = QueryUtils.cutClassCastInfoFromValueString(result);
                return ValueManager.convertStringIntoObject((String)result, (Class)resultClass);
            }
            return result;
        }
        while (current != null) {
            if (ValueManager.checkIfStringsAreEqual((String)ddId, (String)current.getDataDefinitionId())) {
                Object result = current.getContent(ddPropertyName);
                if (result == null) {
                    result = ddDirectValue;
                    Class resultClass = QueryUtils.findPropertyClassFromQueryValueString(ddDirectValue);
                    if (resultClass != null) {
                        ddDirectValue = QueryUtils.cutClassCastInfoFromValueString(ddDirectValue);
                        return ValueManager.convertStringIntoObject((String)ddDirectValue, (Class)resultClass);
                    }
                }
                return result;
            }
            current = current.getParent();
        }
        return null;
    }

    private void processDataTypesWithDrillDown(DynDataDefinition childDdd, DynDataMap childMap) {
        IFunctionOnDataMap f = new IFunctionOnDataMap(){

            @Override
            public void execute(DynDataDefinition childDdd, DynDataMap childMap) {
                DynDataReader.this.processDataTypes(childMap);
            }
        };
        this.executeFunctionOnDataMapWithDrillDown(f, childDdd, childMap);
    }

    private void processDOFWQueryWithDrillDown(DynDataDefinition childDdd, DynDataMap childMap) {
        IFunctionOnDataMap f = new IFunctionOnDataMap(){

            @Override
            public void execute(DynDataDefinition childDdd, DynDataMap childMap) {
                DynDataReader.this.processDOFWQueries(childDdd, childMap);
            }
        };
        this.executeFunctionOnDataMapWithDrillDown(f, childDdd, childMap);
    }

    private void processJDBCQueryWithDrillDown(DynDataDefinition childDdd, DynDataMap childMap) {
        IFunctionOnDataMap f = new IFunctionOnDataMap(){

            @Override
            public void execute(DynDataDefinition childDdd, DynDataMap childMap) {
                DynDataReader.this.processJDBCQueries(childDdd, childMap);
            }
        };
        this.executeFunctionOnDataMapWithDrillDown(f, childDdd, childMap);
    }

    private void processJDBCQueries(DynDataDefinition ddd, DynDataMap ddm) {
        for (DynDataDefinition childDdd : ddd.getChildren()) {
            if (ddm.get(childDdd.getId()) != null) continue;
            this.addDataFromChildrenByFollowingJDBCQuery(ddm, childDdd, false);
        }
    }

    private void processDOFWQueries(DynDataDefinition ddd, DynDataMap ddm) {
        for (DynDataDefinition childDdd : ddd.getChildren()) {
            if (ddm.get(childDdd.getId()) != null) continue;
            this.addDataFromChildrenByFollowingDOFWQuery(ddm, childDdd, false);
        }
    }

    private void processPropertyFilesWithDrillDown(DynDataDefinition childDdd, DynDataMap childMap) {
        IFunctionOnDataMap f = new IFunctionOnDataMap(){

            @Override
            public void execute(DynDataDefinition childDdd, DynDataMap childMap) {
                DynDataReader.this.processPropertyFiles(childDdd, childMap);
            }
        };
        this.executeFunctionOnDataMapWithDrillDown(f, childDdd, childMap);
    }

    private void processPropertyFiles(DynDataDefinition ddd, DynDataMap ddm) {
        for (DynDataDefinition childDdd : ddd.getChildren()) {
            if (childDdd.getPropertyFilePath() == null || ddm.get(ddd.getId()) != null) continue;
            this.addPropertyFileToDataMap(childDdd, ddm);
        }
    }

    private void addPropertyFileToDataMap(DynDataDefinition childDdd, DynDataMap parentDdm) {
        DynDataMap childDdm = parentDdm.getObjectMap(childDdd.getId());
        if (childDdm == null) {
            childDdm = new DynDataMap(this.m_ddrContext, childDdd.getId(), parentDdm);
            parentDdm.put(childDdd.getId(), childDdm);
            this.transferPropertyFileIntoDataMap(childDdd, childDdm);
        }
    }

    private void transferPropertyFileIntoDataMap(DynDataDefinition childDdd, DynDataMap childDdm) {
        ResourceBundle rb = DynDataUtil.readPropertyFile(childDdd, this.m_ddrContext);
        if (rb != null) {
            Enumeration<String> keysEnum = rb.getKeys();
            while (keysEnum.hasMoreElements()) {
                String key = keysEnum.nextElement();
                String value = rb.getString(key);
                childDdm.put(key, value);
            }
        }
    }

    private void processXMLFilesWithDrillDown(DynDataDefinition childDdd, DynDataMap childMap) {
        IFunctionOnDataMap f = new IFunctionOnDataMap(){

            @Override
            public void execute(DynDataDefinition childDdd, DynDataMap childMap) {
                DynDataReader.this.processXMLFiles(childDdd, childMap);
            }
        };
        this.executeFunctionOnDataMapWithDrillDown(f, childDdd, childMap);
    }

    private void processXMLFiles(DynDataDefinition ddd, DynDataMap ddm) {
        for (DynDataDefinition childDdd : ddd.getChildren()) {
            if (childDdd.getXmlFilePath() == null || ddm.get(ddd.getId()) != null) continue;
            this.addXMLFileToDataMap(childDdd, ddm);
        }
    }

    private void addXMLFileToDataMap(DynDataDefinition childDdd, DynDataMap parentDdm) {
        DynDataMap childDdm = parentDdm.getObjectMap(childDdd.getId());
        if (childDdm == null) {
            childDdm = new DynDataMap(this.m_ddrContext, childDdd.getId(), parentDdm);
            parentDdm.put(childDdd.getId(), childDdm);
            this.transferXMLFileIntoDataMap(childDdd, childDdm);
        }
    }

    private void transferXMLFileIntoDataMap(DynDataDefinition childDdd, DynDataMap childDdm) {
        try {
            if (ValueManager.isEmpty((String)childDdd.getXmlFilePath())) {
                return;
            }
            String xml = DynDataUtil.readFile(childDdd.getXmlFileReadingType(), childDdd.getXmlFilePath(), this.m_ddrContext.getXmlFileRootDirectory(), "ccsjrxml/xmlFiles/");
            if (ValueManager.isEmpty((String)xml)) {
                return;
            }
            SimpleXMLElement sx = SimpleXML.parseXML((String)xml);
            HashMap<String, Object> m = new HashMap<String, Object>();
            DynDataUtil.transferSimpleXMLElementToMap(m, sx);
            this.fillDynDataMapWithMap(childDdm, m);
        }
        catch (Throwable t) {
            throw new Error("Problem occurred when adding XML file: " + childDdd.getXmlFilePath() + ", " + (Object)((Object)childDdd.getXmlFileReadingType()), t);
        }
    }

    private void processJSONFilesWithDrillDown(DynDataDefinition childDdd, DynDataMap childMap) {
        IFunctionOnDataMap f = new IFunctionOnDataMap(){

            @Override
            public void execute(DynDataDefinition childDdd, DynDataMap childMap) {
                DynDataReader.this.processJSONFiles(childDdd, childMap);
            }
        };
        this.executeFunctionOnDataMapWithDrillDown(f, childDdd, childMap);
    }

    private void processJSONFiles(DynDataDefinition ddd, DynDataMap ddm) {
        for (DynDataDefinition childDdd : ddd.getChildren()) {
            if (childDdd.getJsonFilePath() == null || ddm.get(ddd.getId()) != null) continue;
            this.addJSONFileToDataMap(childDdd, ddm);
        }
    }

    private void addJSONFileToDataMap(DynDataDefinition childDdd, DynDataMap parentDdm) {
        DynDataMap childDdm = parentDdm.getObjectMap(childDdd.getId());
        if (childDdm == null) {
            childDdm = new DynDataMap(this.m_ddrContext, childDdd.getId(), parentDdm);
            parentDdm.put(childDdd.getId(), childDdm);
            this.transferJSONFileIntoDataMap(childDdd, childDdm);
        }
    }

    private void transferJSONFileIntoDataMap(DynDataDefinition childDdd, DynDataMap childDdm) {
        try {
            if (ValueManager.isEmpty((String)childDdd.getJsonFilePath())) {
                return;
            }
            String json = DynDataUtil.readFile(childDdd.getJsonFileReadingType(), childDdd.getJsonFilePath(), this.m_ddrContext.getJsonFileRootDirectory(), "ccsjrxml/jsonFiles/");
            if (ValueManager.isEmpty((String)json)) {
                return;
            }
            Map<String, Object> m = JSONUtil.unmarshalMap(json);
            this.fillDynDataMapWithMap(childDdm, m);
        }
        catch (Throwable t) {
            throw new Error("Problem occurred when adding JSON file: " + childDdd.getJsonFilePath() + ", " + (Object)((Object)childDdd.getJsonFileReadingType()), t);
        }
    }

    static Object[] transferQueryStringIntoJDBCQueryObjects(String contextName, String tableName, String query) {
        return JDBCUtils.transferQueryStringIntoJDBCQueryObjects(contextName, tableName, query);
    }

    static Object[] transferQueryStringIntoJDBCQueryObjects(String contextName, DynDataDefinition ddd) {
        if (ddd.getTableQuery() != null) {
            return DynDataReader.transferQueryStringIntoJDBCQueryObjects(contextName, ddd.getTableName(), ddd.getTableQuery());
        }
        return new Object[0];
    }

    static Object[] transferQueryStringIntoDOFWQueryObjects(String className, String query) {
        return DOFWUtils.transferQueryStringIntoDOFWQueryObjects(className, query);
    }

    static Object[] transferQueryStringIntoDOFWQueryObjects(DynDataDefinition ddd) {
        if (ddd.getDofwQuery() != null) {
            return DynDataReader.transferQueryStringIntoDOFWQueryObjects(ddd.getClassName(), ddd.getDofwQuery());
        }
        return new Object[0];
    }

    private void processDataTypes(DynDataMap map) {
    }

    static interface IFunctionOnDataMap {
        public void execute(DynDataDefinition var1, DynDataMap var2);
    }

    static interface IValueClassProvider {
        public Class findTypeForProperty(String var1, String var2);
    }
}

