/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.mail;

import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Message;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import org.eclnt.ccee.config.Config;
import org.eclnt.ccee.mail.IMailAPIParamProvider;
import org.eclnt.ccee.mail.MailAPIParamProviderByConfig;
import org.eclnt.jsfserver.managedbean.DefaultHotDeployListener;
import org.eclnt.jsfserver.managedbean.HotDeployNotifier;
import org.eclnt.jsfserver.managedbean.IHotDeployListener;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;

public class MailManager {
    private static String[] MAIL_PARAM_NAMES = new String[]{"mail.debug", "mail.from", "mail.user", "mail.host", "mail.store.protocol", "mail.transport.protocol", "mail.smtp.host", "mail.smtp.port", "mail.smtp.user", "mail.smtp.auth", "mail.smtp.starttls.enable", "mail.smtp.starttls.required", "mail.smtp.ssl.enable", "mail.smtp.ssl.protocols", "mail.smtp.ssl.trust", "mail.smtp.ssl.checkserveridentity", "mail.smtp.connectiontimeout", "mail.smtp.timeout", "mail.smtp.writetimeout", "mail.smtp.from", "mail.smtp.localhost", "mail.smtp.ehlo", "mail.smtp.auth.mechanisms", "mail.smtp.auth.login.disable", "mail.smtp.auth.plain.disable", "mail.smtp.sendpartial", "mail.smtp.sasl.enable", "mail.smtp.sasl.mechanisms", "mail.smtp.sasl.realm", "mail.smtp.quitwait", "mail.smtp.reportsuccess", "mail.smtp.socketFactory.class", "mail.smtp.socketFactory.port", "mail.smtp.socketFactory.fallback", "mail.smtp.userset", "mail.smtps.host", "mail.smtps.port", "mail.smtps.user", "mail.smtps.auth", "mail.smtps.ssl.enable", "mail.smtps.ssl.protocols", "mail.smtps.ssl.trust", "mail.smtps.connectiontimeout", "mail.smtps.timeout", "mail.imap.host", "mail.imap.port", "mail.imap.user", "mail.imap.auth", "mail.imap.starttls.enable", "mail.imap.ssl.enable", "mail.imap.ssl.protocols", "mail.imap.ssl.trust", "mail.imap.connectiontimeout", "mail.imap.timeout", "mail.imap.writetimeout", "mail.imap.partialfetch", "mail.imap.fetchsize", "mail.imap.peek", "mail.imap.appendbuffersize", "mail.imap.connectionpoolsize", "mail.imap.connectionpooltimeout", "mail.imap.separatestoreconnection", "mail.imaps.host", "mail.imaps.port", "mail.imaps.user", "mail.imaps.auth", "mail.imaps.ssl.enable", "mail.imaps.ssl.protocols", "mail.imaps.ssl.trust", "mail.pop3.host", "mail.pop3.port", "mail.pop3.user", "mail.pop3.auth", "mail.pop3.starttls.enable", "mail.pop3.ssl.enable", "mail.pop3.ssl.protocols", "mail.pop3.ssl.trust", "mail.pop3.connectiontimeout", "mail.pop3.timeout", "mail.pop3.rsetbeforequit", "mail.pop3.disabletop", "mail.pop3.forgettopheaders", "mail.pop3s.host", "mail.pop3s.port", "mail.pop3s.user", "mail.pop3s.auth", "mail.pop3s.ssl.enable", "mail.pop3s.ssl.protocols"};
    private static List<String> s_paramNames = new ArrayList<String>();
    private static IMailAPIParamProvider s_paramProvider;
    private static MailManager s_instance;

    public static MailManager instance() {
        return s_instance;
    }

    public static void initialize(MailManager instance) {
        s_instance = instance;
    }

    public void sendHtmlTextMail(String title, String text, String[] tos, String[] ccs) {
        MailManager.initMailAPIParamProvider();
        Properties props = this.buildProperties();
        final String username = s_paramProvider.getUsername();
        final String password = s_paramProvider.getPassword();
        Session session = Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(username, password);
            }
        });
        try {
            InternetAddress[] recipients;
            String commaSeparated;
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(username));
            if (tos != null && tos.length > 0) {
                commaSeparated = String.join((CharSequence)",", tos);
                recipients = InternetAddress.parse((String)commaSeparated);
                message.setRecipients(Message.RecipientType.TO, (Address[])recipients);
            }
            if (ccs != null && ccs.length > 0) {
                commaSeparated = String.join((CharSequence)",", ccs);
                recipients = InternetAddress.parse((String)commaSeparated);
                message.setRecipients(Message.RecipientType.CC, (Address[])recipients);
            }
            message.setSubject(title);
            message.setContent((Object)text, "text/html;charset=utf-8");
            Transport.send((Message)message);
        }
        catch (Throwable t) {
            throw new Error("Problem sending mail", t);
        }
    }

    private Properties buildProperties() {
        String[] paramNamesArray = s_paramNames.toArray(new String[s_paramNames.size()]);
        return s_paramProvider.getMailAPIParams(paramNamesArray);
    }

    private static void initMailAPIParamProvider() {
        if (s_paramProvider == null) {
            String paramProviderClassName = Config.getConfigValue("mail_paramproviderclassname");
            if (paramProviderClassName == null) {
                s_paramProvider = new MailAPIParamProviderByConfig();
            } else {
                try {
                    Class c = CCClassResolver.resolveClass((String)paramProviderClassName, (ENUMCallerType)ENUMCallerType.APPLICATIONFRAMEWORK);
                    s_paramProvider = (IMailAPIParamProvider)c.getConstructor(new Class[0]).newInstance(new Object[0]);
                }
                catch (Throwable t) {
                    throw new Error("Problem creating mail parameter provider " + paramProviderClassName, t);
                }
            }
        }
    }

    static {
        for (String paramName : MAIL_PARAM_NAMES) {
            s_paramNames.add(paramName);
        }
        HotDeployNotifier.addListener((IHotDeployListener)new DefaultHotDeployListener(){

            public void onClassLoaderUpdate(ClassLoader newClassLoader) {
                s_paramProvider = null;
            }
        });
        s_instance = new MailManager();
    }
}

