/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.mq.clustermessagequeue;

import java.util.Hashtable;
import java.util.Map;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.mq.IMessageQueueListener;
import org.eclnt.ccee.mq.MessageQueueFactory;
import org.eclnt.jsfserver.cluster.IClusterMessageQueue;
import org.eclnt.jsfserver.cluster.IClusterMessageQueueListener;

public class MQBridgeClusterMessageQueue
implements IClusterMessageQueue {
    Map<IClusterMessageQueueListener, MWBridgeListener> m_mqListeners = new Hashtable<IClusterMessageQueueListener, MWBridgeListener>();

    public void publishMessage(String topic, String message) {
        try {
            MessageQueueFactory.instance().publishMessage(topic, message);
        }
        catch (Throwable t) {
            AppLog.L.log(AppLog.LL_INF, "Could not pass message into actual MessageQueue processing: " + t);
        }
    }

    public void addMessageListener(String topic, IClusterMessageQueueListener listener) {
        try {
            MWBridgeListener l = new MWBridgeListener(listener);
            this.m_mqListeners.put(listener, l);
            MessageQueueFactory.instance().addMessageListener(topic, l);
        }
        catch (Throwable t) {
            AppLog.L.log(AppLog.LL_WAR, "Could not aadd message listener into actual MEssageQueue processing: " + t);
        }
    }

    public void removeMessageListener(String topic, IClusterMessageQueueListener listener) {
        try {
            MWBridgeListener l = this.m_mqListeners.get(listener);
            if (l != null) {
                MessageQueueFactory.instance().removeMessageListener(topic, l);
                this.m_mqListeners.remove(listener);
            }
        }
        catch (Throwable t) {
            AppLog.L.log(AppLog.LL_WAR, "Could not remove message listener from actual MessageQueue processing: " + t);
        }
    }

    public class MWBridgeListener
    implements IMessageQueueListener {
        IClusterMessageQueueListener i_mqListener;

        public MWBridgeListener(IClusterMessageQueueListener mqListener) {
            this.i_mqListener = mqListener;
        }

        @Override
        public void processMessage(String topic, String message) {
            if (this.i_mqListener != null) {
                this.i_mqListener.processMessage(topic, message);
            }
        }

        @Override
        public void reactOnClosed() {
            this.close();
        }

        private void close() {
            this.i_mqListener = null;
        }
    }
}

