/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.pdf;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import javax.imageio.ImageIO;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.rendering.ImageType;
import org.apache.pdfbox.rendering.PDFRenderer;
import org.eclnt.ccee.image.ImageShrinker;

public class PDF2ImageConverter {
    public static final int DPI_THUMB = 20;

    public static byte[] convertPDFIntoThumbImagePNG(byte[] pdfBytes, int width, int height) {
        return PDF2ImageConverter.convertPDFIntoThumbImagePNG(pdfBytes, width, height, 0, ImageType.RGB);
    }

    public static byte[] convertPDFIntoThumbImagePNG(byte[] pdfBytes, int width, int height, int pageIndex, ImageType imageType) {
        try {
            byte[] imageBytes = PDF2ImageConverter.convertPDFIntoBytesPNG(pdfBytes, 20, pageIndex, imageType);
            imageBytes = ImageShrinker.sizeImage(imageBytes, width, height, true, false);
            return imageBytes;
        }
        catch (Throwable t) {
            throw new Error("Problem creating thumb image", t);
        }
    }

    public static byte[] convertPDFIntoBytesPNG(byte[] pdfBytes, int dpi) {
        return PDF2ImageConverter.convertPDFIntoBytesPNG(pdfBytes, dpi, 0, ImageType.RGB);
    }

    public static byte[] convertPDFIntoBytesPNG(byte[] pdfBytes, int dpi, int pageIndex, ImageType imageType) {
        try {
            BufferedImage bim = PDF2ImageConverter.convertPDFIntoImage(pdfBytes, dpi, pageIndex, imageType);
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)bim, "png", bos);
            return bos.toByteArray();
        }
        catch (Throwable t) {
            throw new Error("Problem creating bytes from bytes", t);
        }
    }

    public static BufferedImage convertPDFIntoImage(byte[] pdfBytes, int dpi) {
        return PDF2ImageConverter.convertPDFIntoImage(pdfBytes, dpi, 0, ImageType.RGB);
    }

    public static BufferedImage convertPDFIntoImage(byte[] pdfBytes, int dpi, int pageIndex, ImageType imageType) {
        try {
            PDDocument document = PDDocument.load((byte[])pdfBytes);
            PDFRenderer pdfRenderer = new PDFRenderer(document);
            BufferedImage bim = pdfRenderer.renderImageWithDPI(pageIndex, (float)dpi, imageType);
            document.close();
            return bim;
        }
        catch (Throwable t) {
            throw new Error("Problem creating image from bytes", t);
        }
    }

    public static int findNumberOfPages(byte[] pdfBytes) {
        try {
            PDDocument document = PDDocument.load((byte[])pdfBytes);
            return document.getNumberOfPages();
        }
        catch (Throwable t) {
            throw new Error("Problem processing pdf bytes", t);
        }
    }
}

