/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.prompting.chatgpt;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.chatgpt.logic.http.HttpCommunicationChatGPT;
import org.eclnt.ccee.json.jackson.JSONUtil;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.prompting.IEmbeddings;

public class EmbeddingsChatGPT
implements IEmbeddings {
    private static final String MODEL_TEXT_EMBEDDING_3_SMALL = "text-embedding-3-small";
    String m_model = "text-embedding-3-small";

    public String getModel() {
        return this.m_model;
    }

    public void setModel(String model) {
        this.m_model = model;
    }

    @Override
    public float[] createEmbeddings(String text) {
        try {
            String json = this.createRequest(text);
            String response = HttpCommunicationChatGPT.instance().doPost("https://api.openai.com/v1/embeddings", json, null);
            Map<String, Object> m = JSONUtil.unmarshalMap(response);
            return this.parseResponse(m).get(0);
        }
        catch (Throwable t) {
            AppLog.L.log(AppLog.LL_INF, "Problem during createEmbeddings", t);
            throw new Error(t);
        }
    }

    @Override
    public List<float[]> createEmbeddings(String[] texts) {
        try {
            String json = this.createRequest(texts);
            String response = HttpCommunicationChatGPT.instance().doPost("https://api.openai.com/v1/embeddings", json, null);
            Map<String, Object> m = JSONUtil.unmarshalMap(response);
            return this.parseResponse(m);
        }
        catch (Throwable t) {
            AppLog.L.log(AppLog.LL_INF, "Problem during createEmbeddings", t);
            throw new Error(t);
        }
    }

    private List<float[]> parseResponse(Map<String, Object> m) {
        ArrayList<float[]> result = new ArrayList<float[]>();
        List dataList = (List)m.get("data");
        for (Object dataObj : dataList) {
            Map data = (Map)dataObj;
            List embedding = (List)data.get("embedding");
            float[] resultEmbedding = new float[embedding.size()];
            int counter = 0;
            for (Object d : embedding) {
                resultEmbedding[counter] = ((Double)d).floatValue();
                ++counter;
            }
            result.add(resultEmbedding);
        }
        return result;
    }

    private String createRequest(String text) {
        return this.createRequest(new String[]{text});
    }

    private String createRequest(String[] texts) {
        ArrayList<String> l = new ArrayList<String>();
        for (String text : texts) {
            l.add(text);
        }
        HashMap<String, Object> m = new HashMap<String, Object>();
        m.put("model", MODEL_TEXT_EMBEDDING_3_SMALL);
        m.put("input", l);
        m.put("encoding_format", "float");
        m.put("dimensions", 512);
        String json = JSONUtil.marshalMap(m);
        return json;
    }
}

