/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.prompting.chromadb;

import java.util.List;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.prompting.IPrompting;
import org.eclnt.ccee.prompting.PromptingMessage;
import org.eclnt.ccee.prompting.chromadb.http.HttpCommunicationChromaDB;
import org.eclnt.ccee.prompting.ollama.PromptingOllama;
import org.eclnt.ccee.prompting.ollama.http.HttpCommunicationChatOllama;

public class PromptingOllamyByChromaDB
extends PromptingOllama
implements IPrompting {
    String m_dbHost = "http://localhost:8000";
    String m_dbModelName = "nomic-embed-text:latest";
    String m_dbCollectionName = "test";

    public PromptingOllamyByChromaDB(String dbHost, String dbModelName, String dbCollectionName, String ollamaHost, String ollamaModelName) {
        super(ollamaHost, ollamaModelName);
        this.m_dbHost = dbHost;
        this.m_dbModelName = dbModelName;
        this.m_dbCollectionName = dbCollectionName;
    }

    @Override
    public void prepareNewMessage(String text) {
        List<Double> embeddings = new HttpCommunicationChatOllama(this.getHost(), this.m_dbModelName, null).generatedEmbedding(text);
        String collectionId = new HttpCommunicationChromaDB(this.m_dbHost, this.m_dbModelName, null).findChromaDBCollectionId(this.m_dbCollectionName);
        try {
            List<String> dbTexts = new HttpCommunicationChromaDB(this.m_dbHost, this.m_dbModelName, null).queryDocuments(collectionId, embeddings);
            for (String dbText : dbTexts) {
                this.addMessage(new PromptingMessage("system", dbText));
            }
        }
        catch (Throwable t) {
            AppLog.L.log(AppLog.LL_INF, "Problem in CHromaDB prompting", t);
        }
    }
}

