/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.prompting.chromadb.http;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.ccee.json.jackson.JSONUtil;
import org.eclnt.ccee.prompting.ollama.http.HttpCommunicationChatBase;
import org.eclnt.ccee.prompting.ollama.http.IHttpCommunicationStreamCallBack;

public class HttpCommunicationChromaDB
extends HttpCommunicationChatBase {
    String m_tenantChromaDB = "default_tenant";
    String m_databaseChromaDB = "default_database";
    String m_hostChromaDB = "http://localhost:8000";
    String m_model = "";
    IHttpCommunicationStreamCallBack m_callBack;

    public HttpCommunicationChromaDB(String host, String model, IHttpCommunicationStreamCallBack callBack) {
        super(callBack);
        this.m_hostChromaDB = host;
        this.m_model = model;
    }

    public String findChromaDBCollectionId(String name) {
        String response = this.sendRequest(this.m_hostChromaDB + "/api/v2/tenants/" + this.m_tenantChromaDB + "/databases/" + this.m_databaseChromaDB + "/collections/" + name, null, null, false, false, null);
        Map<String, Object> m = JSONUtil.unmarshalMap(response);
        return (String)m.get("id");
    }

    public void createChromaDBCollection(String name) {
        HashMap<String, Object> request = new HashMap<String, Object>();
        request.put("name", name);
        request.put("metaData", new HashMap());
        String json = JSONUtil.marshalSimpleObject(request);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String response = this.sendRequest(this.m_hostChromaDB + "/api/v2/tenants/" + this.m_tenantChromaDB + "/databases/" + this.m_databaseChromaDB + "/collections", json, headers, true, false, null);
    }

    public void addDocument(String collectionId, String docId, List<Double> embeddings, String text) {
        HashMap request = new HashMap();
        ArrayList<String> ids = new ArrayList<String>();
        ids.add(docId);
        ArrayList<List<Double>> embeddingss = new ArrayList<List<Double>>();
        embeddingss.add(embeddings);
        ArrayList<String> texts = new ArrayList<String>();
        texts.add(text);
        request.put("ids", ids);
        request.put("documents", texts);
        request.put("embeddings", embeddingss);
        String json = JSONUtil.marshalSimpleObject(request);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String response = this.sendRequest(this.m_hostChromaDB + "/api/v2/tenants/" + this.m_tenantChromaDB + "/databases/" + this.m_databaseChromaDB + "/collections/" + collectionId + "/add", json, headers, true, false, null);
        System.out.println(response);
    }

    public List<String> queryDocuments(String collectionId, List<Double> textEmbeddings) {
        HashMap<String, Serializable> request = new HashMap<String, Serializable>();
        ArrayList<List<Double>> embeddingss = new ArrayList<List<Double>>();
        embeddingss.add(textEmbeddings);
        request.put("query_embeddings", embeddingss);
        request.put("n_results", Integer.valueOf(3));
        String json = JSONUtil.marshalSimpleObject(request);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "application/json");
        String response = this.sendRequest(this.m_hostChromaDB + "/api/v2/tenants/" + this.m_tenantChromaDB + "/databases/" + this.m_databaseChromaDB + "/collections/" + collectionId + "/query", json, headers, true, false, null);
        System.out.println(response);
        Map<String, Object> m = JSONUtil.unmarshalMap(response);
        List texts = (List)m.get("documents");
        List distances = (List)m.get("distances");
        ArrayList<String> result = new ArrayList<String>();
        int counter1 = -1;
        int counter2 = -1;
        for (Object text : texts) {
            ++counter1;
            List lines = (List)text;
            counter2 = -1;
            for (String line : lines) {
                Double distance = (Double)((List)distances.get(counter1)).get(++counter2);
                if (distance > 380.0) continue;
                result.add(line);
            }
        }
        return result;
    }
}

