/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.prompting.ollama.http;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.eclnt.ccee.prompting.ollama.http.IHttpCommunicationStreamCallBack;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.file.StreamUtil;
import org.eclnt.util.general.IExecuteOnObject;
import org.eclnt.util.valuemgmt.ValueManager;

public class HttpCommunicationChatBase {
    static String s_dirCommunicationProtocol = HttpSessionAccess.getServletTempDirectory() + "/prompting/httplog/";
    IHttpCommunicationStreamCallBack m_callBack;

    public HttpCommunicationChatBase(IHttpCommunicationStreamCallBack callBack) {
        this.m_callBack = callBack;
    }

    protected byte[] readURLByteArray(String url) {
        try {
            URL targetURL = new URL(url);
            this.writeCommunicationProtocol(true, targetURL.toString(), null);
            HttpURLConnection con = (HttpURLConnection)targetURL.openConnection();
            con.setRequestMethod("GET");
            con.setDoOutput(true);
            InputStream is = con.getInputStream();
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            StreamUtil.transferStreamContent((InputStream)is, (OutputStream)bos);
            byte[] result = bos.toByteArray();
            this.writeCommunicationProtocol(false, targetURL.toString(), "Byte array: " + result.length);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem calling url: " + url, t);
        }
    }

    protected String sendRequest(String url, String body, Map<String, String> headers, boolean asPost, boolean inFragments, IExecuteOnObject<String> executor) {
        HttpURLConnection con = null;
        try {
            URL targetURL = new URL(url);
            con = (HttpURLConnection)targetURL.openConnection();
            String requestJson = body == null ? "" : body;
            this.writeCommunicationProtocol(true, targetURL.toString(), requestJson);
            if (asPost) {
                con.setRequestMethod("POST");
            } else {
                con.setRequestMethod("GET");
            }
            con.setDoOutput(true);
            if (headers != null) {
                for (String headerKey : headers.keySet()) {
                    String headerValue = headers.get(headerKey);
                    con.setRequestProperty(headerKey, headerValue);
                }
            }
            if (body != null) {
                byte[] bodyBytes = body.getBytes(ValueManager.CHARSET_UTF8);
                ByteArrayInputStream bis = new ByteArrayInputStream(bodyBytes);
                StreamUtil.transferStreamContent((InputStream)bis, (OutputStream)con.getOutputStream());
            }
            InputStream is = con.getInputStream();
            if (inFragments) {
                try {
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    while ((line = reader.readLine()) != null) {
                        this.writeCommunicationProtocol(false, targetURL.toString(), line);
                        if (executor == null) continue;
                        executor.execute((Object)line);
                    }
                    return "";
                }
                catch (Throwable t) {
                    throw new Error("Problem processing stream.", t);
                }
            }
            byte[] responseBytes = StreamUtil.transferStreamContentIntoBytes((InputStream)is);
            String json = new String(responseBytes, ValueManager.CHARSET_UTF8);
            this.writeCommunicationProtocol(false, targetURL.toString(), json);
            return json;
        }
        catch (Throwable t) {
            String text = null;
            if (con != null) {
                try {
                    InputStream is = con.getErrorStream();
                    byte[] responseBytes = StreamUtil.transferStreamContentIntoBytes((InputStream)is);
                    text = new String(responseBytes, ValueManager.CHARSET_UTF8);
                    System.out.println(text);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            throw new Error("Problem processing: " + url + ", " + text, t);
        }
    }

    protected void writeCommunicationProtocol(boolean isRequest, String url, String request) {
        String date = ValueManager.convertObject2DisplayString((Object)new Date(), (String)"datetime", (String)"yyyyMMdd_HHmmssSSS", (String)TimeZone.getDefault().getID(), (boolean)false);
        String fileUrl = ValueManager.convertStringIntoFileName((String)url, (boolean)false);
        String fileName = null;
        fileName = isRequest ? s_dirCommunicationProtocol + date + "_request_" + fileUrl + ".txt" : s_dirCommunicationProtocol + date + "_response_" + fileUrl + ".txt";
        fileName = ValueManager.encodeIntoValidFileName((String)fileName, (boolean)false);
        FileManager.ensureDirectoryForFileExists((String)fileName);
        request = request != null ? "URL: " + url + "\n\n" + request : "URL: " + url + "\n\n";
        FileManager.writeUTF8File((String)fileName, (String)request, (boolean)false);
    }

    static {
        s_dirCommunicationProtocol = ValueManager.encodeIntoValidFileName((String)s_dirCommunicationProtocol, (boolean)true);
        FileManager.ensureDirectoryExists((String)s_dirCommunicationProtocol);
    }
}

