/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.quartz.logic;

import java.util.Date;
import java.util.List;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.config.Config;
import org.eclnt.ccee.db.dofw.DOFWSql;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.quartz.data.DOActiveScheduler;
import org.eclnt.ccee.quartz.data.DOJob;
import org.eclnt.ccee.quartz.logic.QuartzJobAdapter;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;
import org.quartz.CronScheduleBuilder;
import org.quartz.JobBuilder;
import org.quartz.JobDataMap;
import org.quartz.JobDetail;
import org.quartz.ScheduleBuilder;
import org.quartz.Scheduler;
import org.quartz.Trigger;
import org.quartz.TriggerBuilder;
import org.quartz.impl.StdSchedulerFactory;

public class QuartzSchedulerManager
implements ICCEEConstants {
    static QuartzSchedulerManager s_instance;
    Scheduler m_scheduler = null;
    String m_uniqueId = UniqueIdCreator.createUUID();

    private static synchronized void createScheduler() {
        try {
            s_instance = new QuartzSchedulerManager();
            s_instance.startUp();
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problem starting quartz scheduler", t);
            throw new Error("Problem starting quartz scheduler", t);
        }
    }

    public static void setup() {
        s_instance.setupExecute();
    }

    private void setupExecute() {
        try {
            boolean active = this.checkIfActivated();
            if (!active) {
                throw new Error("Scheduling is not active in this environment (configuration parameter quartz_active set to false)");
            }
            if (this.m_scheduler == null) {
                this.m_scheduler = StdSchedulerFactory.getDefaultScheduler();
                this.m_scheduler.start();
            }
            this.m_scheduler.clear();
            this.registerSchedulerInDatabase();
            if (!this.checkIfActive()) {
                return;
            }
            List<DOJob> jobs = DOFWSql.queryCrossTenant(DOJob.class, null, null);
            for (DOJob job : jobs) {
                this.scheduleJob(job);
            }
        }
        catch (Throwable t) {
            throw new Error("Problem executing quartz setup", t);
        }
    }

    public boolean checkIfActive() {
        try {
            if (this.m_scheduler == null) {
                return false;
            }
            DOActiveScheduler as = DOFWSql.queryOne(DOActiveScheduler.class, new Object[0]);
            if (as == null) {
                return true;
            }
            if (as.getSchedulerInstanceId().equals(this.m_uniqueId)) {
                return true;
            }
            try {
                if (!this.m_scheduler.isShutdown()) {
                    AppLog.L.log(LL_INF, "Scheduler is shut down, it is not the active one anymore: " + this.m_uniqueId);
                    this.m_scheduler.shutdown();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            this.m_scheduler = null;
            return false;
        }
        catch (Throwable t) {
            throw new Error("Problem when checking if scheduler is active", t);
        }
    }

    private void registerSchedulerInDatabase() {
        DOActiveScheduler as = new DOActiveScheduler();
        as.setSchedulerId("DEFAULT");
        as.setSchedulerInstanceId(QuartzSchedulerManager.s_instance.m_uniqueId);
        as.setTimestampActivation(new Date());
        DOFWSql.saveObject(as);
    }

    private void scheduleJob(DOJob job) {
        try {
            if (!this.checkIfActivated()) {
                return;
            }
            if (job.getTenant() == null) {
                throw new Exception("Tenant of job not defined");
            }
            if (job.getId() == null) {
                throw new Exception("Id of job not defined");
            }
            if (job.getClassName() == null) {
                throw new Exception("Class name of job not defined");
            }
            if (job.getTiming() == null) {
                throw new Exception("Timing of job not defined");
            }
            JobDataMap dataMap = new JobDataMap();
            dataMap.put("tenant", job.getTenant());
            dataMap.put("id", job.getId());
            dataMap.put("className", job.getClassName());
            dataMap.put("parameters", job.getParameters());
            dataMap.put("schedulerManager", (Object)this);
            JobDetail jobDetail = JobBuilder.newJob(QuartzJobAdapter.class).withIdentity(job.getTenant() + "/" + job.getId()).setJobData(dataMap).build();
            Trigger trigger = TriggerBuilder.newTrigger().withIdentity(job.getId(), job.getTenant()).withSchedule((ScheduleBuilder)CronScheduleBuilder.cronSchedule((String)job.getTiming())).build();
            this.m_scheduler.scheduleJob(jobDetail, trigger);
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Problem scheduling job; " + job.getId(), t);
        }
    }

    private void startUp() {
        if (this.checkIfActivated() && this.checkIfAutoSetup()) {
            QuartzSchedulerManager.setup();
        }
    }

    private boolean checkIfAutoSetup() {
        String autoSetupString = Config.getConfigValue("quartz_autosetup");
        boolean result = ValueManager.decodeBoolean((String)autoSetupString, (boolean)false);
        return result;
    }

    private boolean checkIfActivated() {
        String activeString = Config.getConfigValue("quartz_active");
        boolean active = ValueManager.decodeBoolean((String)activeString, (boolean)true);
        return active;
    }

    static {
        QuartzSchedulerManager.createScheduler();
    }
}

