/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.solr;

import org.apache.solr.client.solrj.ResponseParser;
import org.apache.solr.client.solrj.impl.HttpSolrClient;
import org.apache.solr.client.solrj.impl.XMLResponseParser;
import org.apache.solr.client.solrj.response.SolrPingResponse;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.config.Config;
import org.eclnt.ccee.log.AppLog;

public class SOLRAccess
implements ICCEEConstants {
    public static HttpSolrClient createSolrClient() {
        String url = null;
        try {
            url = Config.getConfigValue("solr_url");
            HttpSolrClient solr = new HttpSolrClient.Builder(url).build();
            solr.setParser((ResponseParser)new XMLResponseParser());
            return solr;
        }
        catch (Throwable t) {
            throw new Error("Error createing solr client, URL: " + url, t);
        }
    }

    public static boolean checkIfSolrIsAvailable() {
        try {
            HttpSolrClient client = SOLRAccess.createSolrClient();
            SolrPingResponse spr = client.ping();
            return true;
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Solr is not available. Exception: " + t.toString(), t);
            return false;
        }
    }
}

