/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.usagevariants;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.usagevariants.VariantPersistence;
import org.eclnt.jsfserver.util.useraccess.UserAccessMgr;
import org.eclnt.util.extractapply.IExtractApply;
import org.eclnt.util.valuemgmt.ValueManager;

public class UsageVariantManager
implements ICCEEConstants {
    String m_serviceType;
    String m_serviceId;
    IExtractApply m_service;
    String m_userId;
    String m_currentVariantId;
    String m_currentVariantData;
    String m_defaultVariantId;

    public UsageVariantManager(String serviceType, String serviceId, IExtractApply service) {
        this.m_serviceType = serviceType;
        this.m_serviceId = serviceId;
        this.m_service = service;
        this.m_userId = UserAccessMgr.getCurrentUser();
        this.m_defaultVariantId = this.findDefaultVariantId(this.m_userId, null);
    }

    public String getCurrentVariantId() {
        return this.m_currentVariantId;
    }

    public void setCurrentVariantId(String currentVariantId) {
        this.m_currentVariantId = currentVariantId;
    }

    public String getDefaultVariantId() {
        return this.m_defaultVariantId;
    }

    public void setDefaultVariantId(String defaultVariantId) {
        if (ValueManager.checkIfStringsAreEqual((String)defaultVariantId, (String)this.m_defaultVariantId)) {
            return;
        }
        this.m_defaultVariantId = defaultVariantId;
        VariantPersistence.instance().saveDefaultVariantId(this.m_userId, this.m_serviceType, this.m_serviceId, this.m_defaultVariantId);
        this.m_defaultVariantId = this.findDefaultVariantId(this.m_userId, null);
    }

    public void resetToDefault() {
        this.m_currentVariantData = null;
        this.m_currentVariantId = null;
        this.m_service.resetToDefault();
    }

    public List<String> getAllVariantIds(boolean withParentVariants) {
        List<String> parentUserIds;
        ArrayList<String> result = new ArrayList<String>();
        List<String> ownVariantIds = VariantPersistence.instance().queryVariantIds(this.m_userId, this.m_serviceType, this.m_serviceId);
        if (ownVariantIds != null) {
            result.addAll(ownVariantIds);
        }
        if (withParentVariants && (parentUserIds = VariantPersistence.instance().queryParentUserIds(this.m_userId)) != null) {
            for (String parentUserId : parentUserIds) {
                List<String> userVariantIds = VariantPersistence.instance().queryVariantIds(parentUserId, this.m_serviceType, this.m_serviceId);
                if (userVariantIds == null) continue;
                for (String userVariantId : userVariantIds) {
                    result.add(this.encodeUserIdVariantId(parentUserId, userVariantId));
                }
            }
        }
        return result;
    }

    public void saveCurrentVariant() {
        String variantData = this.m_service.extractData();
        UserIdVariantId vs = this.decodeUserIdVariantId(this.m_currentVariantId);
        VariantPersistence.instance().saveVariant(this.m_userId, this.m_serviceType, this.m_serviceId, vs.getVariantId(), variantData);
    }

    public void saveCurrentVariantAs(String newVariantId) {
        UserIdVariantId vs = this.decodeUserIdVariantId(newVariantId);
        this.m_currentVariantId = vs.getVariantId();
        this.saveCurrentVariant();
    }

    public void applyCurrentVariant() {
        if (this.m_currentVariantId != null) {
            UserIdVariantId vs = this.decodeUserIdVariantId(this.m_currentVariantId);
            this.m_currentVariantData = VariantPersistence.instance().readVariant(vs.getUserId(), this.m_serviceType, this.m_serviceId, vs.getVariantId());
            this.applyCurrentVariantData();
        }
    }

    public void removeVariant(String variantId) {
        UserIdVariantId vs = this.decodeUserIdVariantId(variantId);
        if (ValueManager.checkIfStringsAreEqual((String)this.m_userId, (String)vs.getUserId())) {
            VariantPersistence.instance().removeVariant(vs.getUserId(), this.m_serviceType, this.m_serviceId, vs.getVariantId());
            String defaultVariantId = this.getDefaultVariantId();
            if (ValueManager.checkIfStringsAreEqual((String)defaultVariantId, (String)variantId)) {
                this.setDefaultVariantId(null);
            }
            if (ValueManager.checkIfStringsAreEqual((String)variantId, (String)this.m_currentVariantId)) {
                this.m_currentVariantId = null;
                this.m_currentVariantData = null;
                this.m_defaultVariantId = null;
            }
        } else {
            throw new Error("Cannot remove variant of other user.");
        }
    }

    public void activate(boolean applyDefaultVariant) {
        this.m_currentVariantId = this.findDefaultVariantId(this.m_userId, null);
        if (this.m_currentVariantId != null && applyDefaultVariant) {
            this.applyCurrentVariant();
        }
    }

    public void update() {
        if (this.m_currentVariantId != null) {
            this.saveCurrentVariant();
        }
    }

    public boolean checkIfVariantContainsUserId(String variantId) {
        if (variantId == null) {
            return false;
        }
        return variantId.contains("//");
    }

    private String encodeUserIdVariantId(String userId, String variantId) {
        return userId + "//" + variantId;
    }

    private UserIdVariantId decodeUserIdVariantId(String id) {
        if (id == null) {
            return new UserIdVariantId(this.m_userId, null);
        }
        int index = id.indexOf("//");
        if (index < 0) {
            return new UserIdVariantId(this.m_userId, id);
        }
        return new UserIdVariantId(id.substring(0, index), id.substring(index + 2));
    }

    private void applyCurrentVariantData() {
        try {
            if (this.m_currentVariantData == null) {
                return;
            }
            this.m_service.applyData(this.m_currentVariantData);
        }
        catch (Throwable t) {
            AppLog.L.log(LL_INF, "Problem occurred applying current variant data: " + this.m_serviceType + ", " + this.m_serviceId + ", " + this.m_userId + ", " + this.m_currentVariantId, t);
        }
    }

    private String findDefaultVariantId(String userId, Set<String> processedUserIds) {
        List<String> parentUserIds;
        if (processedUserIds == null) {
            processedUserIds = new HashSet<String>();
        }
        if (processedUserIds.contains(userId)) {
            return null;
        }
        processedUserIds.add(userId);
        String result = VariantPersistence.instance().readDefaultVariantId(userId, this.m_serviceType, this.m_serviceId);
        if (result != null) {
            UserIdVariantId uv = this.decodeUserIdVariantId(result);
            String s = VariantPersistence.instance().readVariant(uv.getUserId(), this.m_serviceType, this.m_serviceId, uv.getVariantId());
            if (s != null) {
                return result;
            }
        }
        if ((parentUserIds = VariantPersistence.instance().queryParentUserIds(userId)) != null) {
            for (String parentUserId : parentUserIds) {
                result = this.findDefaultVariantId(parentUserId, processedUserIds);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    class UserIdVariantId {
        String i_userId;
        String i_variantId;

        public UserIdVariantId(String userId, String variantId) {
            this.i_userId = userId;
            this.i_variantId = variantId;
        }

        public String getUserId() {
            return this.i_userId;
        }

        public String getVariantId() {
            return this.i_variantId;
        }
    }
}

