/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.xml;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URI;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.eclnt.ccee.simplexml.SimpleXMLElement;
import org.eclnt.jsfserver.util.BeanIntrospector;
import org.eclnt.util.valuemgmt.Base64;
import org.eclnt.util.valuemgmt.PojoManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class XMLPojoUtil {
    private static final Map<Class<?>, String> TYPE_MAP = new HashMap();
    private static XMLPojoUtil s_instance = new XMLPojoUtil();

    public static XMLPojoUtil instance() {
        return s_instance;
    }

    public static void initialize(XMLPojoUtil instance) {
        s_instance = instance;
    }

    public SimpleXMLElement createXSDElementForBeanClass(Class beanClass) {
        return this.createXSDElementForBeanClass(beanClass, beanClass.getName());
    }

    public SimpleXMLElement createXSDElementForBeanClass(Class beanClass, String beanTagName) {
        SimpleXMLElement complexType = new SimpleXMLElement("xs:complexType");
        complexType.setValue("name", beanTagName);
        this.addXSDAttributeDefinitionsForBeanClass(beanClass, complexType);
        return complexType;
    }

    public void addXSDAttributeDefinitionsForBeanClass(Class beanClass, SimpleXMLElement parentElement) {
        try {
            List piis = BeanIntrospector.readPropertiesAsList((Class)beanClass);
            for (BeanIntrospector.PropertyIntrospectionInfo pii : piis) {
                if (pii.getGetter() == null) continue;
                SimpleXMLElement xe = new SimpleXMLElement("xs:attribute");
                xe.setValue("name", pii.getPropertyName());
                xe.setValue("type", this.findXsdTypeForJavaType(pii.getGetter().getReturnType()));
                parentElement.addSubElement(xe);
            }
        }
        catch (Throwable t) {
            throw new Error("Problem creating XSD attributes: " + beanClass, t);
        }
    }

    public SimpleXMLElement encodePojoSDTToSXMLElement(Object o, String oTagName) {
        SimpleXMLElement result = new SimpleXMLElement(oTagName);
        Map oMap = PojoManager.transferPojoIntoMap((Object)o);
        ArrayList properties = new ArrayList(oMap.keySet());
        Collections.sort(properties);
        for (String property : properties) {
            Object propertyValue;
            String propertyString = this.convertPropertyIntoXMLString(property, propertyValue = oMap.get(property));
            if (propertyString == null) continue;
            result.setValue(property, propertyString);
        }
        return result;
    }

    public <BEANCLASS> BEANCLASS createPojoSDTFromSXMLElement(Class<BEANCLASS> clazz, SimpleXMLElement xmlElement) {
        try {
            BEANCLASS result = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            this.updatePojoSDTFromSXMLElement(result, xmlElement);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem creating pojo from xml element", t);
        }
    }

    public void updatePojoSDTFromSXMLElement(Object result, SimpleXMLElement xmlElement) {
        try {
            for (String key : xmlElement.getValueMap().keySet()) {
                BeanIntrospector.PropertyIntrospectionInfo pii;
                String value = xmlElement.getValue(key);
                if (value == null || (pii = BeanIntrospector.readProperty(result.getClass(), (String)key)) == null || pii.getSetter() == null) continue;
                Object o = this.convertXMLValueStringIntoProperty(value, pii.getGetter().getReturnType());
                pii.getSetter().invoke(result, o);
            }
        }
        catch (Throwable t) {
            throw new Error("Problem creating pojo from xml element", t);
        }
    }

    public String encodePojoSDTToXMLBegin(Object o, String oTagName) {
        StringBuffer sb = new StringBuffer();
        sb.append("<");
        sb.append(oTagName);
        Map oMap = PojoManager.transferPojoIntoMap((Object)o);
        ArrayList properties = new ArrayList(oMap.keySet());
        Collections.sort(properties);
        for (String property : properties) {
            Object propertyValue;
            String propertyString = this.convertPropertyIntoXMLString(property, propertyValue = oMap.get(property));
            if (propertyString == null) continue;
            sb.append(" ");
            sb.append(property);
            sb.append("=");
            sb.append("\"");
            sb.append(ValueManager.encodeIntoValidXMLString((String)propertyString));
            sb.append("\"");
        }
        sb.append(">");
        return sb.toString();
    }

    public String encodePojoSDTToXMLEnd(Object o, String oTagName) {
        StringBuffer sb = new StringBuffer();
        sb.append("</");
        sb.append(oTagName);
        sb.append(">");
        return sb.toString();
    }

    public String findXsdTypeForJavaType(Class<?> javaClass) {
        return TYPE_MAP.getOrDefault(javaClass, "xs:string");
    }

    private Object convertXMLValueStringIntoProperty(String value, Class propertyClass) {
        if (value == null) {
            return null;
        }
        if (propertyClass == byte[].class) {
            return Base64.decode((String)value);
        }
        if (propertyClass == LocalDate.class) {
            return LocalDate.parse(value);
        }
        if (propertyClass == LocalDateTime.class) {
            return LocalDateTime.parse(value);
        }
        if (propertyClass == LocalTime.class) {
            return LocalTime.parse(value);
        }
        return ValueManager.convertStringIntoObject((String)value, (Class)propertyClass);
    }

    protected String convertPropertyIntoXMLString(String property, Object propertyValue) {
        if (propertyValue == null) {
            return null;
        }
        if (propertyValue instanceof byte[]) {
            return Base64.encode((byte[])((byte[])propertyValue));
        }
        if (propertyValue instanceof LocalDate) {
            return ((LocalDate)propertyValue).toString();
        }
        if (propertyValue instanceof LocalDateTime) {
            return ((LocalDateTime)propertyValue).toString();
        }
        if (propertyValue instanceof LocalTime) {
            return ((LocalTime)propertyValue).toString();
        }
        return ValueManager.convertObject2ValueString((Object)propertyValue);
    }

    static {
        TYPE_MAP.put(Boolean.TYPE, "xs:boolean");
        TYPE_MAP.put(Boolean.class, "xs:boolean");
        TYPE_MAP.put(Byte.TYPE, "xs:byte");
        TYPE_MAP.put(Byte.class, "xs:byte");
        TYPE_MAP.put(Short.TYPE, "xs:short");
        TYPE_MAP.put(Short.class, "xs:short");
        TYPE_MAP.put(Integer.TYPE, "xs:int");
        TYPE_MAP.put(Integer.class, "xs:int");
        TYPE_MAP.put(Long.TYPE, "xs:long");
        TYPE_MAP.put(Long.class, "xs:long");
        TYPE_MAP.put(Float.TYPE, "xs:float");
        TYPE_MAP.put(Float.class, "xs:float");
        TYPE_MAP.put(Double.TYPE, "xs:double");
        TYPE_MAP.put(Double.class, "xs:double");
        TYPE_MAP.put(Character.TYPE, "xs:unsignedShort");
        TYPE_MAP.put(Character.class, "xs:unsignedShort");
        TYPE_MAP.put(String.class, "xs:string");
        TYPE_MAP.put(Date.class, "xs:dateTime");
        TYPE_MAP.put(Calendar.class, "xs:dateTime");
        TYPE_MAP.put(LocalDate.class, "xs:date");
        TYPE_MAP.put(LocalTime.class, "xs:time");
        TYPE_MAP.put(LocalDateTime.class, "xs:dateTime");
        TYPE_MAP.put(ZonedDateTime.class, "xs:dateTime");
        TYPE_MAP.put(OffsetDateTime.class, "xs:dateTime");
        TYPE_MAP.put(BigInteger.class, "xs:integer");
        TYPE_MAP.put(BigDecimal.class, "xs:decimal");
        TYPE_MAP.put(byte[].class, "xs:base64Binary");
        TYPE_MAP.put(URI.class, "xs:anyURI");
        TYPE_MAP.put(QName.class, "xs:QName");
    }
}

