/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.spring.context;

import javax.servlet.ServletContext;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ISessionAbstraction;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class DialogSessionApplicationContextFactory {
    public static final String SPRINGNAME_INWEBAPPLICATIONCONTEXT = "DialogSessionApplicationContext";
    static final String SESSIONKEY = DialogSessionApplicationContextFactory.class.getName();

    public static AbstractApplicationContext instance() {
        ISessionAbstraction dialogSession = HttpSessionAccess.getCurrentDialogSession();
        return DialogSessionApplicationContextFactory.instance(dialogSession);
    }

    public static AbstractApplicationContext instance(ISessionAbstraction dialogSession) {
        AbstractApplicationContext result = (AbstractApplicationContext)dialogSession.getAttribute(SESSIONKEY);
        if (result == null) {
            ApplicationContext springApplicationContext = DialogSessionApplicationContextFactory.findSpringApplicationContext();
            if (springApplicationContext == null) {
                throw new Error("Could not find Spring Application Context");
            }
            result = (AbstractApplicationContext)springApplicationContext.getBean(SPRINGNAME_INWEBAPPLICATIONCONTEXT);
            if (result == null) {
                throw new Error("Could not find DialogSessionApplicationContext");
            }
            DialogSessionApplicationContextFactory.registerContextInDialogSession(dialogSession, result);
        }
        return result;
    }

    private static ApplicationContext findSpringApplicationContext() {
        WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionAccess.getServletContext());
        return wac;
    }

    private static void registerContextInDialogSession(ISessionAbstraction dialogSession, AbstractApplicationContext applicationContext) {
        dialogSession.setAttribute(SESSIONKEY, (Object)applicationContext);
    }
}

