/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.spring.v2.context.util;

import javax.servlet.ServletContext;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.spring.v2.context.util.ErrorNoApplicationContextRegistered;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.springframework.web.context.support.WebApplicationContextUtils;

public class SpringApplicationContextFinder
implements ApplicationContextAware,
ICCEEConstants {
    static SpringApplicationContextFinder s_instance;
    ApplicationContext m_springApplicationContext;

    public SpringApplicationContextFinder() {
        s_instance = this;
        AppLog.L.log(LL_INF, "Instance of SpringApplicationContextFinder created");
    }

    public static void initInstance(SpringApplicationContextFinder instance) {
        s_instance = instance;
    }

    public static ApplicationContext getContext() {
        try {
            if (s_instance == null || SpringApplicationContextFinder.s_instance.m_springApplicationContext == null) {
                throw new Exception("No instance s_instance available.");
            }
            return s_instance.getApplicationContext();
        }
        catch (Throwable t) {
            try {
                WebApplicationContext wac = WebApplicationContextUtils.getWebApplicationContext((ServletContext)HttpSessionAccess.getServletContext());
                return wac;
            }
            catch (Throwable tt) {
                throw new ErrorNoApplicationContextRegistered("Application context not available. ...used two strategies to search:\n1. Class SpringApplicationContextFinder is not view-able for Spring scan.\n   You might add by e.g. placing @Import(SpringApplicationContextFinder.class) into your configuration class.\n   Exception from Spring is: " + t.toString() + "\n2. WebApplicationContext did not contain context. Add Spring listener ContextLoaderListener into your web.xml.\n   Exception from Spring is: " + tt.toString());
            }
        }
    }

    public void setApplicationContext(ApplicationContext ac) throws BeansException {
        this.m_springApplicationContext = ac;
        AppLog.L.log(LL_INF, "ApplicationContext injected");
    }

    public ApplicationContext getApplicationContext() {
        return this.m_springApplicationContext;
    }
}

