/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.spring.context;

import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.spring.context.DialogSessionApplicationContextFactory;
import org.eclnt.jsfserver.managedbean.DefaultDispatchedBean;
import org.eclnt.jsfserver.managedbean.DefaultDispatchedPageBean;
import org.eclnt.jsfserver.managedbean.DefaultDispatcher;
import org.eclnt.jsfserver.managedbean.IDispatcher;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.IWorkpageContainer;
import org.eclnt.workplace.WorkpageDispatcher;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.support.AbstractApplicationContext;

public abstract class DispatcherBySpringAccess
extends WorkpageDispatcher
implements ICCEEConstants {
    static boolean s_ignoreSpringErrors = false;
    static boolean s_resolveBeanWithLowerCaseKey = true;
    protected AbstractApplicationContext m_springContext = this.createSpringContext();

    public DispatcherBySpringAccess() {
    }

    public DispatcherBySpringAccess(IWorkpageContainer workpageContainer) {
        super(workpageContainer);
    }

    public static void initializeIgnoreSpringInitializationErrors(boolean value) {
        s_ignoreSpringErrors = value;
    }

    public static void initializeResolveBeanWithLowerCaseKey(boolean value) {
        s_resolveBeanWithLowerCaseKey = value;
    }

    public AbstractApplicationContext getSpringContext() {
        return this.m_springContext;
    }

    protected Object readObject(String key) throws Exception {
        Object result = null;
        Throwable springError = null;
        Throwable superError = null;
        if (this.m_springContext != null) {
            try {
                result = this.resolveBeanFromSpringContext(this.m_springContext, key);
            }
            catch (NoSuchBeanDefinitionException e) {
                springError = null;
            }
            catch (Throwable t) {
                springError = t;
            }
        }
        if (result == null && springError == null) {
            try {
                result = super.readObject(key);
            }
            catch (Throwable t) {
                superError = t;
            }
        }
        if (result == null) {
            if (springError != null) {
                throw new Error("Problem creating bean in dispatcher: " + key, springError);
            }
            if (superError != null) {
                throw new Error("Problem creating bean in dispatcher: " + key, superError);
            }
            throw new Error("Problem creating bean in dispatcher: " + key);
        }
        if (result instanceof DefaultDispatchedBean && ((DefaultDispatchedBean)result).getOwningDispatcher() == null) {
            ((DefaultDispatchedBean)result).setDispatcher((IDispatcher)this);
        } else if (result instanceof DefaultDispatchedPageBean && ((DefaultDispatchedPageBean)result).getOwningDispatcher() == null) {
            ((DefaultDispatchedPageBean)result).setDispatcher((IDispatcher)this);
        }
        return result;
    }

    private Object resolveBeanFromSpringContext(AbstractApplicationContext springContext, String key) {
        try {
            return springContext.getBean(key);
        }
        catch (NoSuchBeanDefinitionException exc) {
            if (s_resolveBeanWithLowerCaseKey && key.length() > 0) {
                String lowerCaseKey = ValueManager.toLowerCaseId((String)key.substring(0, 1)) + key.substring(1);
                try {
                    return springContext.getBean(lowerCaseKey);
                }
                catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                    // empty catch block
                }
            }
            throw exc;
        }
    }

    protected AbstractApplicationContext createSpringContext() {
        try {
            return DialogSessionApplicationContextFactory.instance();
        }
        catch (Throwable t) {
            if (s_ignoreSpringErrors) {
                return null;
            }
            AppLog.L.log(LL_ERR, "Problem creating spring context", t);
            throw new Error("Problem creating spring context", t);
        }
    }

    public static DefaultDispatcher.DispatcherInfo getStaticDispatcherInfo() {
        return new DefaultDispatcher.DispatcherInfo(DispatcherBySpringAccess.class);
    }
}

