/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.spring.v2.context.xmlbased;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.SAXParser;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.jsfserver.util.parse.SAXParserCreator;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class SpringXmlParser
implements ICCEEConstants {
    List<SpringBeanInfo> m_springBeanInfos = new ArrayList<SpringBeanInfo>();

    public SpringXmlParser(String xml) {
        try {
            SAXParser parser = SAXParserCreator.createSAXParser();
            InputSource is = new InputSource(new StringReader(xml));
            parser.parse(is, (DefaultHandler)new MyParser());
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Error when reading and parsing spring xml", t);
        }
    }

    public List<SpringBeanInfo> getSpringBeanInfos() {
        return this.m_springBeanInfos;
    }

    class MyParser
    extends DefaultHandler {
        MyParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("bean")) {
                String id = attributes.getValue("id");
                String className = attributes.getValue("class");
                String scope = attributes.getValue("scope");
                if (id == null) {
                    return;
                }
                if (className == null) {
                    return;
                }
                SpringBeanInfo sbi = new SpringBeanInfo(id, className, scope);
                SpringXmlParser.this.m_springBeanInfos.add(sbi);
            }
        }
    }

    public class SpringBeanInfo {
        private String i_id;
        private String i_className;
        private String i_scope;

        public SpringBeanInfo(String id, String className, String scope) {
            this.i_id = id;
            this.i_className = className;
            this.i_scope = scope;
        }

        public String getId() {
            return this.i_id;
        }

        public String getScope() {
            return this.i_scope;
        }

        public String getClassName() {
            return this.i_className;
        }
    }
}

