/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.ccee.spring.context;

import java.util.List;
import org.eclnt.ccee.ICCEEConstants;
import org.eclnt.ccee.log.AppLog;
import org.eclnt.ccee.spring.context.SpringXmlParser;
import org.eclnt.jsfserver.managedbean.DefaultDispatcher;
import org.eclnt.util.file.ClassloaderReader;

public class SpringDispatcherInfo
extends DefaultDispatcher.DispatcherInfo
implements ICCEEConstants {
    String[] m_xmlPaths = new String[0];

    public SpringDispatcherInfo(Class dispatcherClass, String ... springXmlPaths) {
        super(dispatcherClass);
        this.m_xmlPaths = springXmlPaths;
    }

    public List<DefaultDispatcher.DispatchedBeanInfo> getDispatchedBeans() {
        List result = super.getDispatchedBeans();
        for (String xmlPath : this.m_xmlPaths) {
            this.addDispatchedBeansFromXmlPath(xmlPath, result);
        }
        return result;
    }

    protected void addDispatchedBeansFromXmlPath(String xmlPath, List<DefaultDispatcher.DispatchedBeanInfo> result) {
        try {
            AppLog.L.log(LL_INF, "SpringDispatcherInfo: analyzing " + xmlPath);
            String xml = new ClassloaderReader(((Object)((Object)this)).getClass().getClassLoader()).readUTF8File(xmlPath, true);
            this.addDispatchedBeansFromXml(xml, result);
        }
        catch (Throwable t) {
            AppLog.L.log(LL_ERR, "Could not add beans of xml path: " + xmlPath, t);
        }
    }

    protected void addDispatchedBeansFromXml(String xml, List<DefaultDispatcher.DispatchedBeanInfo> result) {
        try {
            SpringXmlParser xmlp = new SpringXmlParser(xml);
            List<SpringXmlParser.SpringBeanInfo> sbis = xmlp.getSpringBeanInfos();
            for (SpringXmlParser.SpringBeanInfo sbi : sbis) {
                try {
                    Class<?> c = Class.forName(sbi.getClassName(), false, ((Object)((Object)this)).getClass().getClassLoader());
                    DefaultDispatcher.DispatchedBeanInfo dbi = new DefaultDispatcher.DispatchedBeanInfo(c, sbi.getId(), sbi.getClassName());
                    result.add(dbi);
                }
                catch (Throwable t) {
                    AppLog.L.log(LL_ERR, "SpringDispatcherInfo: Problem loading spring bean: " + sbi.getId() + ", " + sbi.getClassName(), t);
                }
            }
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }
}

