/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.cluster;

import org.eclnt.jsfserver.cluster.IClusterMessageQueue;
import org.eclnt.jsfserver.configuration.CCConfigurationObjectLoader;
import org.eclnt.jsfserver.messages.CrossDialogMessage;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.JAXBManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class ClusterMessageBus {
    static ClusterMessageBus s_instance = new ClusterMessageBus();
    IClusterMessageQueue m_queue;
    String m_topic = null;

    public ClusterMessageBus() {
        this.initializeBySystemXml();
    }

    public static ClusterMessageBus instance() {
        return s_instance;
    }

    public boolean isActive() {
        return this.m_queue != null;
    }

    public void publishMessageToAllClusterClientDialogs(CrossDialogMessage message) {
        if (!this.isActive()) {
            return;
        }
        String messageType = this.m_topic;
        String messageContent = JAXBManager.marshal(message);
        this.m_queue.publishMessage(messageType, messageContent);
    }

    public IClusterMessageQueue getClusterMessageQueue() {
        return this.m_queue;
    }

    public String getTopicForCluster() {
        return this.m_topic;
    }

    protected void initializeBySystemXml() {
        try {
            this.m_topic = SystemXml.getClusterMessageBusTopic();
            String className = SystemXml.getClusterMessageBusQueueClassName();
            if (ValueManager.isEmpty(this.m_topic) || ValueManager.isEmpty(className)) {
                return;
            }
            this.m_queue = (IClusterMessageQueue)CCConfigurationObjectLoader.instance().loadInstance(className, true);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem initializing the message queue connection", t);
        }
    }
}

