/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.defaultscreens.IImageCaptureProvider;
import org.eclnt.jsfserver.defaultscreens.ImageCaptureProviderDefault;
import org.eclnt.jsfserver.elements.BaseActionEvent;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.elements.impl.ICONComponentTag;
import org.eclnt.jsfserver.elements.impl.LINKComponentTag;
import org.eclnt.jsfserver.elements.impl.PANEComponent;
import org.eclnt.jsfserver.elements.impl.ROWComponentTag;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.util.valuemgmt.ValueManager;

public class ImageCapture
implements Serializable {
    private static final String BGPAINT_SELECTED_AVAILABLE = "rectangle(0,0,100%,100%,#C0C0C0)";
    private static final String BGPAINT_SELECTED_NOTAVAILABLE = "rectangle(0,0,100%,100%,#FFB0B0)";
    private static final String BGPAINT_UNSELECTED_AVAILABLE = "rectangle(0,0,100%,100%,#F0F0F0)";
    private static final String BGPAINT_UNSELECTED_NOTAVAILABLE = "rectangle(0,0,100%,100%,#FFE0E0)";
    static int s_idCounter;
    IImageCaptureProvider m_logic;
    IImageCaptureProvider m_lastPreparedLogic;
    String m_refExpression = "v_imagecapture";
    PANEComponent m_iconPane;
    PANEComponent m_commandPane;
    IImageCaptureProvider.ImageData m_selImageData;
    Map<String, IconInvoker> m_iconInvokers = new HashMap<String, IconInvoker>();
    Map<String, LinkInvoker> m_linkInvokers = new HashMap<String, LinkInvoker>();
    transient byte[] m_bufferedImage = null;
    transient String m_bufferedImageHexString = null;
    Trigger m_uploadTrigger = new Trigger();

    public ImageCapture() {
        this.prepare(new ImageCaptureProviderDefault());
    }

    public ImageCapture(IImageCaptureProvider logic) {
        this.prepare(logic);
    }

    public void setRefExpression(String value) {
        if (value == null) {
            return;
        }
        if (value.trim().equals("")) {
            return;
        }
        this.m_refExpression = value;
    }

    public Trigger getUploadTrigger() {
        return this.m_uploadTrigger;
    }

    public String getRefExpression() {
        return this.m_refExpression;
    }

    public void prepare(IImageCaptureProvider logic) {
        this.m_logic = logic;
    }

    public Map<String, IconInvoker> getInvokers() {
        return this.m_iconInvokers;
    }

    public Map<String, LinkInvoker> getLinkInvokers() {
        return this.m_linkInvokers;
    }

    public IImageCaptureProvider.ImageData getSelImageData() {
        return this.m_selImageData;
    }

    public String getSelHexImage() {
        if (this.m_selImageData == null) {
            this.m_bufferedImage = null;
            return null;
        }
        byte[] image = this.m_selImageData.getImage();
        if (image == this.m_bufferedImage) {
            return this.m_bufferedImageHexString;
        }
        String result = ValueManager.encodeHexString(image);
        this.m_bufferedImage = image;
        this.m_bufferedImageHexString = result;
        return result;
    }

    public PANEComponent getIconPane() {
        return this.m_iconPane;
    }

    public void setIconPane(PANEComponent value) {
        if (this.m_iconPane == value) {
            return;
        }
        this.m_iconPane = value;
        this.m_lastPreparedLogic = this.m_logic;
        this.updateIconPane();
    }

    public PANEComponent getCommandPane() {
        return this.m_commandPane;
    }

    public void setCommandPane(PANEComponent value) {
        if (this.m_commandPane == value) {
            return;
        }
        this.m_commandPane = value;
        this.updateCommandPane();
    }

    public boolean getUploadRendered() {
        if (this.m_selImageData == null) {
            return false;
        }
        for (int i = 0; i < this.m_selImageData.getCommands().size(); ++i) {
            IImageCaptureProvider.ImageCommand command = (IImageCaptureProvider.ImageCommand)this.m_selImageData.getCommands().get(i);
            if (!command.getId().equals("UPLOAD")) continue;
            return true;
        }
        return false;
    }

    public void uploadRequest(ActionEvent ae) {
        this.m_uploadTrigger.trigger();
        this.processLinkInvoke(this.m_linkInvokers.get("UPLOAD_REQUEST"));
    }

    public void uploadExecute(ActionEvent ae) {
        BaseActionEvent bae = (BaseActionEvent)ae;
        String hexString = bae.getParams()[0];
        byte[] bytes = ValueManager.decodeHexString(hexString);
        this.m_selImageData.setImage(bytes);
        this.processLinkInvoke(this.m_linkInvokers.get("UPLOAD"));
    }

    public void onNext(ActionEvent ae) {
        if (this.m_selImageData == null) {
            return;
        }
        List<IImageCaptureProvider.ImageData> all = this.getListOfAllImageData();
        int index = all.indexOf(this.m_selImageData);
        if (++index >= all.size()) {
            index = 0;
        }
        this.selectImageData(all.get(index));
    }

    public void onPrevious(ActionEvent ae) {
        if (this.m_selImageData == null) {
            return;
        }
        List<IImageCaptureProvider.ImageData> all = this.getListOfAllImageData();
        int index = all.indexOf(this.m_selImageData);
        if (--index < 0) {
            index = all.size() - 1;
        }
        this.selectImageData(all.get(index));
    }

    public void onHexImageAction(ActionEvent ae) {
        this.m_logic.reactOnImageDoubleClick();
    }

    public void selectImageData(IImageCaptureProvider.ImageData sel) {
        this.m_selImageData = sel;
        if (this.m_commandPane != null) {
            this.updateCommandPane();
        }
        if (this.m_logic != null) {
            this.m_logic.reactOnIconSelection(this.m_selImageData);
        }
    }

    public void updateComponent() {
        this.updateComponent(true);
    }

    public void updateComponent(boolean applyDefaultSelection) {
        if (applyDefaultSelection) {
            this.selectImageData(null);
        }
        this.updateCommandPane();
        this.updateIconPane();
    }

    private List<IImageCaptureProvider.ImageData> getListOfAllImageData() {
        ArrayList<IImageCaptureProvider.ImageData> result = new ArrayList<IImageCaptureProvider.ImageData>();
        for (int i = 0; i < this.m_logic.getImageDataBlock().size(); ++i) {
            IImageCaptureProvider.ImageDataRow row = (IImageCaptureProvider.ImageDataRow)this.m_logic.getImageDataBlock().get(i);
            for (int j = 0; j < row.size(); ++j) {
                IImageCaptureProvider.ImageData id = (IImageCaptureProvider.ImageData)row.get(j);
                result.add(id);
            }
        }
        return result;
    }

    private void updateCommandPane() {
        if (this.m_commandPane == null) {
            return;
        }
        this.m_commandPane.getChildren().clear();
        this.m_linkInvokers.clear();
        if (this.m_selImageData == null) {
            return;
        }
        IImageCaptureProvider.ImageCommandList commands = this.m_selImageData.getCommands();
        for (int i = 0; i < commands.size(); ++i) {
            LinkInvoker li;
            LINKComponentTag lct;
            IImageCaptureProvider.ImageCommand command = (IImageCaptureProvider.ImageCommand)commands.get(i);
            ROWComponentTag rct = new ROWComponentTag();
            this.assignId(rct);
            BaseComponent rc = rct.createBaseComponent();
            this.m_commandPane.getChildren().add(rc);
            if (command.getId().equals("UPLOAD")) {
                lct = new LINKComponentTag();
                this.assignId(lct);
                lct.setText(command.getText());
                lct.setEnabled("#{" + this.m_refExpression + ".linkInvokers." + command.getId() + ".enabled}");
                lct.setActionListener("#{" + this.m_refExpression + ".uploadRequest}");
                rc.getChildren().add(lct.createBaseComponent());
                li = new LinkInvoker(command);
                this.m_linkInvokers.put(command.getId(), li);
                continue;
            }
            if (command.getId().equals("UPLOAD_REQUEST")) {
                LinkInvoker li2 = new LinkInvoker(command);
                this.m_linkInvokers.put(command.getId(), li2);
                continue;
            }
            lct = new LINKComponentTag();
            this.assignId(lct);
            lct.setText(command.getText());
            lct.setEnabled("#{" + this.m_refExpression + ".linkInvokers." + command.getId() + ".enabled}");
            lct.setActionListener("#{" + this.m_refExpression + ".linkInvokers." + command.getId() + ".invoke}");
            rc.getChildren().add(lct.createBaseComponent());
            li = new LinkInvoker(command);
            this.m_linkInvokers.put(command.getId(), li);
        }
    }

    private void processLinkInvoke(LinkInvoker li) {
        if (li == null) {
            return;
        }
        if (this.m_logic != null) {
            this.m_logic.reactOnCommand(this.m_selImageData, li.i_command);
        }
    }

    private void updateIconPane() {
        this.m_iconPane.getChildren().clear();
        this.m_selImageData = null;
        int invokerCounter = 0;
        this.m_iconInvokers.clear();
        IImageCaptureProvider.ImageDataBlock block = this.m_logic.getImageDataBlock();
        for (int i = 0; i < block.size(); ++i) {
            ROWComponentTag rct = new ROWComponentTag();
            this.assignId(rct);
            BaseComponent rc = rct.createBaseComponent();
            this.m_iconPane.getChildren().add(rc);
            IImageCaptureProvider.ImageDataRow row = (IImageCaptureProvider.ImageDataRow)block.get(i);
            for (int j = 0; j < row.size(); ++j) {
                IImageCaptureProvider.ImageData imageData = (IImageCaptureProvider.ImageData)row.get(j);
                if (this.m_selImageData == null) {
                    this.selectImageData(imageData);
                }
                ICONComponentTag ict = new ICONComponentTag();
                this.assignId(ict);
                ict.setImage(imageData.getIconUrl());
                ict.setTooltip(imageData.getIconTooltip());
                ict.setActionListener("#{" + this.m_refExpression + ".invokers.i" + invokerCounter + ".invoke}");
                ict.setBgpaint("#{" + this.m_refExpression + ".invokers.i" + invokerCounter + ".bgpaint}");
                IconInvoker invoker = new IconInvoker(imageData);
                this.m_iconInvokers.put("i" + invokerCounter, invoker);
                ++invokerCounter;
                rc.getChildren().add(ict.createBaseComponent());
            }
        }
    }

    private void assignId(BaseComponentTag tag) {
        tag.setId("IC_" + s_idCounter++);
    }

    public class LinkInvoker
    implements Serializable {
        IImageCaptureProvider.ImageCommand i_command;

        public LinkInvoker(IImageCaptureProvider.ImageCommand command) {
            this.i_command = command;
        }

        public void invoke(ActionEvent ae) {
            ImageCapture.this.processLinkInvoke(this);
        }

        public boolean getEnabled() {
            return this.i_command.getEnabled();
        }
    }

    public class IconInvoker
    implements Serializable {
        IImageCaptureProvider.ImageData i_imageData;

        public IconInvoker(IImageCaptureProvider.ImageData imageData) {
            this.i_imageData = imageData;
        }

        public void invoke(ActionEvent ae) {
            ImageCapture.this.selectImageData(this.i_imageData);
        }

        public String getBgpaint() {
            if (this.i_imageData.getPostBgpaint() == null) {
                return this.getBgpaintDyn();
            }
            String bgpaint = this.getBgpaintDyn();
            if (bgpaint != null) {
                return bgpaint + ";" + this.i_imageData.getPostBgpaint();
            }
            return this.i_imageData.getPostBgpaint();
        }

        public String getBgpaintDyn() {
            if (ImageCapture.this.m_selImageData != this.i_imageData) {
                if (!this.i_imageData.isAvailable()) {
                    if (ImageCapture.this.m_logic.getBgpaintUnselectedNotAvailable() == null) {
                        return ImageCapture.BGPAINT_UNSELECTED_NOTAVAILABLE;
                    }
                    return ImageCapture.this.m_logic.getBgpaintUnselectedNotAvailable();
                }
                if (ImageCapture.this.m_logic.getBgpaintUnselectedAvailable() == null) {
                    return ImageCapture.BGPAINT_UNSELECTED_AVAILABLE;
                }
                return ImageCapture.this.m_logic.getBgpaintUnselectedAvailable();
            }
            if (!this.i_imageData.isAvailable()) {
                if (ImageCapture.this.m_logic.getBgpaintSelectedNotAvailable() == null) {
                    return ImageCapture.BGPAINT_SELECTED_NOTAVAILABLE;
                }
                return ImageCapture.this.m_logic.getBgpaintSelectedNotAvailable();
            }
            if (ImageCapture.this.m_logic.getBgpaintSelectedAvailable() == null) {
                return ImageCapture.BGPAINT_SELECTED_AVAILABLE;
            }
            return ImageCapture.this.m_logic.getBgpaintSelectedAvailable();
        }
    }
}

