/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.defaultscreens;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.faces.event.ActionEvent;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import org.eclnt.jsfserver.defaultscreens.DefaultScreens;
import org.eclnt.jsfserver.defaultscreens.MessageToast;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.OKPopup;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.impl.COLDISTANCEComponentTag;
import org.eclnt.jsfserver.elements.impl.IMAGEComponentTag;
import org.eclnt.jsfserver.elements.impl.LABELComponentTag;
import org.eclnt.jsfserver.elements.impl.ROWComponentTag;
import org.eclnt.jsfserver.elements.phases.PhaseManager;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.i18n.I18N;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.JAXBManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class Statusbar
implements Serializable {
    public static String INTBGPAINT_MESSAGE = "rectangle(#FFFFFF)";
    public static String INTBGPAINT_ERROR = "rectangle(0,0,100%,100%,#FFC0C0,#FFF0F0,vertical);border(0,0,100%,100%,#00000040,1)";
    public static String INTBGPAINT_WARNING = "rectangle(0,0,100%,100%,#FFFFC0,#FFFFF0,vertical);border(0,0,100%,100%,#00000040,1)";
    public static String INTBGPAINT_SUCCESS = "rectangle(0,0,100%,100%,#C0FFC0,#F0FFF0,vertical);border(0,0,100%,100%,#00000040,1)";
    public static String INTBGPAINT_BACK = "rectangle(10,10,100%-20,100%-20,#FFFFFF80,#FFFFFFC0,vertical);border(0,0,100%,100%,#00000040,1)";
    public static String SBTEXTCOLOR_ERROR = "#000000";
    public static String SBTEXTCOLOR_WARNING = "#000000";
    public static String SBTEXTCOLOR_SUCCESS = "#000000";
    public static String SBTEXTCOLOR_MESSAGE = null;
    public static String POPUPTEXTCOLOR_ERROR = "#000000";
    public static String POPUPTEXTCOLOR_WARNING = "#000000";
    public static String POPUPTEXTCOLOR_SUCCESS = "#000000";
    public static String POPUPTEXTCOLOR_MESSAGE = "#000000";
    public static final int TYPE_MESSAGE = 0;
    public static final int TYPE_SUCCESS = 1;
    public static final int TYPE_WARNING = 2;
    public static final int TYPE_ERROR = 3;
    public static final int TYPE_ALERT = 4;
    public static int POPUP_OPACITY = 95;
    public static boolean POPUP_UNDECORATED = true;
    public static boolean POPUP_ANIMATED = true;
    private static boolean s_avoidDoubleOccuranceOfMessages = false;
    private static boolean s_avoidConcatenationOfMessagesInPopup = false;
    private static ENUMPopupMode s_popupMode = ENUMPopupMode.POPUP;
    String m_text = "";
    String m_textColor = null;
    String m_image = null;
    String m_bgpaint = null;
    String m_font = null;
    Trigger m_soundTrigger = new Trigger();
    String m_htStyle = "classstatusbartextmessage";
    boolean m_messsagesAreaShown = false;
    boolean m_immediatelyShowAllMessages = false;
    Clearer m_clearer = new Clearer();
    IStatusBarDrillDownInfoProvider m_statusBarDrillDownInfoProvider;
    String m_requestIdOfLastMessage = "";
    boolean m_avoidNextClearing = false;
    List<StatusBarMessage> m_messages = new ArrayList<StatusBarMessage>();
    String m_previousText = null;
    String m_previousImage = null;
    String m_previousBgpaint = null;
    String m_previousFont = null;
    List<StatusBarMessage> m_previousMessages = null;
    String m_messageToClientTester = null;
    int m_clearTimerDuration = 0;
    OKPopup m_lastOKPopup = null;
    int m_changeCounter = 0;
    Set<String> m_statusbarComponentIds = new HashSet<String>();

    private static String BGPAINT_ERROR() {
        String result = StyleManager.getStyleValue("ccStatusbarBgpaintError");
        if (result != null) {
            return result;
        }
        return INTBGPAINT_ERROR;
    }

    private static String BGPAINT_MESSAGE() {
        String result = StyleManager.getStyleValue("ccStatusbarBgpaintMessage");
        if (result != null) {
            return result;
        }
        return INTBGPAINT_MESSAGE;
    }

    private static String BGPAINT_WARNING() {
        String result = StyleManager.getStyleValue("ccStatusbarBgpaintWarning");
        if (result != null) {
            return result;
        }
        return INTBGPAINT_WARNING;
    }

    private static String BGPAINT_SUCCESS() {
        String result = StyleManager.getStyleValue("ccStatusbarBgpaintSuccess");
        if (result != null) {
            return result;
        }
        return INTBGPAINT_SUCCESS;
    }

    private static String BGPAINT_BACK() {
        String result = StyleManager.getStyleValue("ccStatusbarBgpaintDialogBackground");
        if (result != null) {
            return result;
        }
        return INTBGPAINT_BACK;
    }

    public Statusbar() {
    }

    public Statusbar(IStatusBarDrillDownInfoProvider statusBarDrillDownInfoProvider) {
        this.m_statusBarDrillDownInfoProvider = statusBarDrillDownInfoProvider;
    }

    public static void initAvoidDoubleOccuranceOfMessages(boolean value) {
        s_avoidDoubleOccuranceOfMessages = value;
    }

    public static void setAvoidConcatenationOfMessagesInPopup(boolean avoidConcatenationOfMessagesInPopup) {
        s_avoidConcatenationOfMessagesInPopup = avoidConcatenationOfMessagesInPopup;
    }

    public static void initPopupMode(ENUMPopupMode mode) {
        s_popupMode = mode;
    }

    public static void avoidNextClearing() {
        Statusbar sb = DefaultScreens.getSessionAccess().getStatusbar();
        sb.m_avoidNextClearing = true;
    }

    public static void outputMessage(String text) {
        Statusbar sb = DefaultScreens.getSessionAccess().getStatusbar();
        sb.addMessageToStatusbar(new StatusBarMessage(0, text));
        sb.notifyMessageWasAdded();
        sb.setText(text);
        sb.setImage(StyleManager.getStyleValue("ccStatusbarOutput"));
        sb.setTextColor(SBTEXTCOLOR_MESSAGE);
        sb.setFont("weight:bold");
        sb.setHtStyle("classstatusbartextmessage");
        sb.setBgpaint(Statusbar.BGPAINT_MESSAGE());
        PhaseManager.runBeforeUpdatePhase(sb.m_clearer);
    }

    public static void outputMessage(String text, String longText) {
        if (longText != null) {
            Statusbar.outputMessage(text + "\n\n" + longText);
        } else {
            Statusbar.outputMessage(text);
        }
    }

    public static ModalPopup outputMessageWithPopup(String text) {
        return Statusbar.outputMessageWithPopup(text, null, null);
    }

    public static ModalPopup outputMessageWithPopup(String text, String longText) {
        return Statusbar.outputMessageWithPopup(text, null, longText);
    }

    public static ModalPopup outputMessageWithPopup(String text, String title, String longText) {
        if (title == null) {
            title = "";
        }
        String wholeText = text;
        if (longText != null && longText.length() > 0) {
            wholeText = text + "\n\n" + longText;
        }
        Statusbar.outputMessage(wholeText);
        return Statusbar.openPopup(title, text, longText, 0, StyleManager.getStyleValue("ccStatusbarOutputBig"));
    }

    private static ModalPopup openPopup(String title, String text, String longText, int type, String icon) {
        if (s_popupMode == ENUMPopupMode.POPUP) {
            if (longText != null && longText.length() > 0) {
                text = text + "\n\n" + longText;
            }
            OKPopup okp = OKPopup.createInstance(title, text);
            okp.setIcon(icon);
            okp.setButtonImage(null);
            Statusbar sb = DefaultScreens.getSessionAccess().getStatusbar();
            sb.treatPopup(okp, type, text);
            return okp.getModalPopup();
        }
        if (s_popupMode == ENUMPopupMode.MESSAGETOAST) {
            String messageToastType = "info";
            switch (type) {
                case 1: {
                    messageToastType = "success";
                    break;
                }
                case 2: {
                    messageToastType = "warning";
                    break;
                }
                case 3: 
                case 4: {
                    messageToastType = "error";
                }
            }
            MessageToast.showMessage(messageToastType, icon, null, text);
            return null;
        }
        throw new Error("Should never happen!");
    }

    public void writeMessage(String text) {
        if (this.m_statusBarDrillDownInfoProvider == null || this.m_statusBarDrillDownInfoProvider.checkIfToDrillDownToGlobalStatusbar()) {
            Statusbar.outputMessage(text);
        }
        this.addMessageToStatusbar(new StatusBarMessage(0, text));
        this.notifyMessageWasAdded();
        this.setText(text);
        this.setTextColor(SBTEXTCOLOR_MESSAGE);
        this.setFont("weight:bold");
        this.setImage(StyleManager.getStyleValue("ccStatusbarOutput"));
        this.setHtStyle("classstatusbartextmessage");
        PhaseManager.runBeforeUpdatePhase(this.m_clearer);
    }

    public void writeMessage(String text, String longText) {
        this.writeMessage(text + "\n\n" + longText);
    }

    public ModalPopup writeMessageWithPopup(String text) {
        return this.writeMessageWithPopup(text, null, null);
    }

    public ModalPopup writeMessageWithPopup(String text, String longText) {
        return this.writeMessageWithPopup(text, null, longText);
    }

    public ModalPopup writeMessageWithPopup(String text, String title, String longText) {
        if (title == null) {
            title = "";
        }
        if (longText != null && longText.length() > 0) {
            text = text + "\n\n" + longText;
        }
        this.writeSuccess(text);
        OKPopup okp = OKPopup.createInstance(title, text);
        okp.setIcon(StyleManager.getStyleValue("ccStatusbarOutputBig"));
        okp.setButtonImage(null);
        this.treatPopup(okp, 0, text);
        return okp.getModalPopup();
    }

    public static void outputSuccess(String text) {
        Statusbar sb = DefaultScreens.getSessionAccess().getStatusbar();
        sb.addMessageToStatusbar(new StatusBarMessage(1, text));
        sb.notifyMessageWasAdded();
        sb.setText(text);
        sb.setImage(StyleManager.getStyleValue("ccStatusbarMessage"));
        sb.setTextColor(SBTEXTCOLOR_SUCCESS);
        sb.setBgpaint(Statusbar.BGPAINT_SUCCESS());
        sb.setFont("weight:bold");
        sb.setHtStyle("classstatusbartextsuccess");
        PhaseManager.runBeforeUpdatePhase(sb.m_clearer);
    }

    public static void outputSuccess(String text, String longText) {
        if (longText != null) {
            Statusbar.outputSuccess(text + "\n\n" + longText);
        } else {
            Statusbar.outputSuccess(text);
        }
    }

    public static ModalPopup outputSuccessWithPopup(String text) {
        return Statusbar.outputSuccessWithPopup(text, null, null);
    }

    public static ModalPopup outputSuccessWithPopup(String text, String longText) {
        return Statusbar.outputSuccessWithPopup(text, null, longText);
    }

    public static ModalPopup outputSuccessWithPopup(String text, String title, String longText) {
        if (title == null) {
            title = "";
        }
        String wholeText = text;
        if (longText != null && longText.length() > 0) {
            wholeText = text + "\n\n" + longText;
        }
        Statusbar.outputSuccess(wholeText);
        return Statusbar.openPopup(title, text, longText, 1, StyleManager.getStyleValue("ccStatusbarMessageBig"));
    }

    public void writeSuccess(String text) {
        if (this.m_statusBarDrillDownInfoProvider == null || this.m_statusBarDrillDownInfoProvider.checkIfToDrillDownToGlobalStatusbar()) {
            Statusbar.outputSuccess(text);
        }
        this.addMessageToStatusbar(new StatusBarMessage(1, text));
        this.notifyMessageWasAdded();
        this.setText(text);
        this.setImage(StyleManager.getStyleValue("ccStatusbarMessage"));
        this.setTextColor(SBTEXTCOLOR_SUCCESS);
        this.setFont("weight:bold");
        this.setBgpaint(Statusbar.BGPAINT_SUCCESS());
        this.setHtStyle("classstatusbartextsuccess");
        PhaseManager.runBeforeUpdatePhase(this.m_clearer);
    }

    public void writeSuccess(String text, String longText) {
        this.writeSuccess(text + "\n\n" + longText);
    }

    public ModalPopup writeSuccessWithPopup(String text) {
        return this.writeSuccessWithPopup(text, null, null);
    }

    public ModalPopup writeSuccessWithPopup(String text, String longText) {
        return this.writeSuccessWithPopup(text, null, longText);
    }

    public ModalPopup writeSuccessWithPopup(String text, String title, String longText) {
        if (title == null) {
            title = "";
        }
        if (longText != null && longText.length() > 0) {
            text = text + "\n\n" + longText;
        }
        this.writeSuccess(text);
        OKPopup okp = OKPopup.createInstance(title, text);
        okp.setIcon(StyleManager.getStyleValue("ccStatusbarSuccess"));
        okp.setButtonImage(null);
        this.treatPopup(okp, 1, text);
        return okp.getModalPopup();
    }

    public static void outputWarning(String text) {
        Statusbar sb = DefaultScreens.getSessionAccess().getStatusbar();
        sb.addMessageToStatusbar(new StatusBarMessage(2, text));
        sb.notifyMessageWasAdded();
        sb.setText(text);
        sb.setImage(StyleManager.getStyleValue("ccStatusbarWarning"));
        sb.setTextColor(SBTEXTCOLOR_WARNING);
        sb.setBgpaint(Statusbar.BGPAINT_WARNING());
        sb.setFont("weight:bold");
        sb.setHtStyle("classstatusbartextwarning");
        PhaseManager.runBeforeUpdatePhase(sb.m_clearer);
    }

    public static void outputWarning(String text, String longText) {
        if (longText != null) {
            Statusbar.outputWarning(text + "\n\n" + longText);
        } else {
            Statusbar.outputWarning(text);
        }
    }

    public static ModalPopup outputWarningWithPopup(String text) {
        return Statusbar.outputWarningWithPopup(text, null, null);
    }

    public static ModalPopup outputWarningWithPopup(String text, String longText) {
        return Statusbar.outputWarningWithPopup(text, null, longText);
    }

    public static ModalPopup outputWarningWithPopup(String text, String title, String longText) {
        if (title == null) {
            title = "";
        }
        String wholeText = text;
        if (longText != null && longText.length() > 0) {
            wholeText = text + "\n\n" + longText;
        }
        Statusbar.outputWarning(wholeText);
        return Statusbar.openPopup(title, text, longText, 2, StyleManager.getStyleValue("ccStatusbarWarningBig"));
    }

    public void writeWarning(String text) {
        if (this.m_statusBarDrillDownInfoProvider == null || this.m_statusBarDrillDownInfoProvider.checkIfToDrillDownToGlobalStatusbar()) {
            Statusbar.outputWarning(text);
        }
        this.addMessageToStatusbar(new StatusBarMessage(2, text));
        this.notifyMessageWasAdded();
        this.setText(text);
        this.setImage(StyleManager.getStyleValue("ccStatusbarWarning"));
        this.setTextColor(SBTEXTCOLOR_WARNING);
        this.setBgpaint(Statusbar.BGPAINT_WARNING());
        this.setFont("weight:bold");
        this.setHtStyle("classstatusbartextwarning");
        PhaseManager.runBeforeUpdatePhase(this.m_clearer);
    }

    public void writeWarning(String text, String longText) {
        this.writeWarning(text + "\n\n" + longText);
    }

    public ModalPopup writeWarningWithPopup(String text) {
        return this.writeWarningWithPopup(text, null, null);
    }

    public ModalPopup writeWarningWithPopup(String text, String longText) {
        return this.writeWarningWithPopup(text, null, longText);
    }

    public ModalPopup writeWarningWithPopup(String text, String title, String longText) {
        if (title == null) {
            title = "";
        }
        if (longText != null && longText.length() > 0) {
            text = text + "\n\n" + longText;
        }
        this.writeWarning(text);
        OKPopup okp = OKPopup.createInstance(title, text);
        okp.setIcon(StyleManager.getStyleValue("ccStatusbarWarningBig"));
        okp.setButtonImage(null);
        this.treatPopup(okp, 2, text);
        return okp.getModalPopup();
    }

    public static void outputError(String text) {
        Statusbar sb = DefaultScreens.getSessionAccess().getStatusbar();
        sb.addMessageToStatusbar(new StatusBarMessage(3, text));
        sb.notifyMessageWasAdded();
        sb.setText(text);
        sb.setImage(StyleManager.getStyleValue("ccStatusbarError"));
        sb.setTextColor(SBTEXTCOLOR_ERROR);
        sb.setBgpaint(Statusbar.BGPAINT_ERROR());
        sb.setFont("weight:bold");
        sb.setHtStyle("classstatusbartexterror");
        PhaseManager.runBeforeUpdatePhase(sb.m_clearer);
    }

    public static void outputError(String text, String longText) {
        if (longText != null) {
            Statusbar.outputError(text + "\n\n" + longText);
        } else {
            Statusbar.outputError(text);
        }
    }

    public void writeError(String text) {
        if (this.m_statusBarDrillDownInfoProvider == null || this.m_statusBarDrillDownInfoProvider.checkIfToDrillDownToGlobalStatusbar()) {
            Statusbar.outputError(text);
        }
        this.addMessageToStatusbar(new StatusBarMessage(3, text));
        this.notifyMessageWasAdded();
        this.setText(text);
        this.setImage(StyleManager.getStyleValue("ccStatusbarError"));
        this.setTextColor(SBTEXTCOLOR_ERROR);
        this.setBgpaint(Statusbar.BGPAINT_ERROR());
        this.setFont("weight:bold");
        this.setHtStyle("classstatusbartexterror");
        PhaseManager.runBeforeUpdatePhase(this.m_clearer);
    }

    public void writeError(String text, String longText) {
        this.writeError(text + "\n\n" + longText);
    }

    public static ModalPopup outputAlert(String text) {
        return Statusbar.outputAlert(text, I18N.getBundle().getString("ALERTMessage"));
    }

    public static ModalPopup outputAlert(String text, String title) {
        return Statusbar.outputAlert(text, title, null);
    }

    public static ModalPopup outputAlert(String text, String title, String longText) {
        String wholeText = text;
        if (longText != null) {
            wholeText = text + "\n\n" + longText;
        }
        Statusbar sb = DefaultScreens.getSessionAccess().getStatusbar();
        sb.addMessageToStatusbar(new StatusBarMessage(4, text));
        sb.notifyMessageWasAdded();
        sb.setText(wholeText);
        sb.setImage(StyleManager.getStyleValue("ccStatusbarError"));
        sb.setTextColor(SBTEXTCOLOR_ERROR);
        sb.setBgpaint(Statusbar.BGPAINT_ERROR());
        sb.setFont("weight:bold");
        sb.setHtStyle("classstatusbartexterror");
        sb.getSoundTrigger().trigger();
        PhaseManager.runBeforeUpdatePhase(sb.m_clearer);
        return Statusbar.openPopup(title, text, longText, 3, StyleManager.getStyleValue("ccStatusbarErrorBig"));
    }

    public ModalPopup writeAlert(String text) {
        return this.writeAlert(text, I18N.getBundle().getString("ALERTMessage"));
    }

    public ModalPopup writeAlert(String text, String title) {
        ModalPopup result = null;
        if (this.m_statusBarDrillDownInfoProvider == null || this.m_statusBarDrillDownInfoProvider.checkIfToDrillDownToGlobalStatusbar()) {
            result = Statusbar.outputAlert(text, title);
        } else {
            OKPopup okp = OKPopup.createInstance(title, text);
            okp.setIcon(StyleManager.getStyleValue("ccStatusbarErrorBig"));
            okp.setButtonImage(null);
            this.treatPopup(okp, 3, text);
            result = okp.getModalPopup();
        }
        this.addMessageToStatusbar(new StatusBarMessage(4, text));
        this.notifyMessageWasAdded();
        this.setText(text);
        this.setImage(StyleManager.getStyleValue("ccStatusbarError"));
        this.setTextColor(SBTEXTCOLOR_ERROR);
        this.setBgpaint(Statusbar.BGPAINT_ERROR());
        this.setFont("weight:bold");
        this.setHtStyle("classstatusbartexterror");
        this.getSoundTrigger().trigger();
        PhaseManager.runBeforeUpdatePhase(this.m_clearer);
        return result;
    }

    public List<StatusBarMessage> getMessages() {
        return this.m_messages;
    }

    public String getMessageToClientTester() {
        return this.m_messageToClientTester;
    }

    public String getMessagesAsXML() {
        try {
            if (this.m_messages.size() == 0) {
                return null;
            }
            if (this.m_messages.size() == 1) {
                return null;
            }
            StatusBarMessagesInfo sbmi = new StatusBarMessagesInfo();
            for (int i = 0; i < this.m_messages.size() - 1; ++i) {
                sbmi.i_messages.add(this.m_messages.get(i));
            }
            return JAXBManager.marshal(sbmi);
        }
        catch (Throwable t) {
            return null;
        }
    }

    public String getRequestIdOfLastMessage() {
        return this.m_requestIdOfLastMessage;
    }

    public static void setImmediatelyShowAllMessages(boolean immediatelyShowAllMessages) {
        Statusbar sb = DefaultScreens.getSessionAccess().getStatusbar();
        sb.m_immediatelyShowAllMessages = immediatelyShowAllMessages;
    }

    public static boolean getImmediatelyShowAllMessages() {
        Statusbar sb = DefaultScreens.getSessionAccess().getStatusbar();
        return sb.m_immediatelyShowAllMessages;
    }

    public void setImmediatelyShowAllMessagesForInstance(boolean immediatelyShowAllMessages) {
        this.m_immediatelyShowAllMessages = immediatelyShowAllMessages;
    }

    public boolean getImmediatelyShowAllMessagesForInstance() {
        return this.m_immediatelyShowAllMessages;
    }

    public void clear() {
        this.m_previousText = this.m_text;
        this.m_previousImage = this.m_image;
        this.m_previousBgpaint = this.m_bgpaint;
        this.m_previousFont = this.m_font;
        this.m_previousMessages = this.m_messages;
        this.m_text = "";
        this.m_image = StyleManager.getStyleValue("ccStatusbarEmpty");
        this.m_bgpaint = null;
        this.m_font = null;
        this.m_messages = new ArrayList<StatusBarMessage>();
        this.m_messsagesAreaShown = false;
        this.m_htStyle = "classstatusbartextmessage";
        this.m_clearTimerDuration = 0;
        this.m_messageToClientTester = null;
        final int currentChangeCounter = this.m_changeCounter;
        PhaseManager.runAfterRenderResponsePhase(new Runnable(){

            @Override
            public void run() {
                if (Statusbar.this.m_changeCounter == currentChangeCounter) {
                    Statusbar.this.clearRewriteBuffer();
                }
            }
        });
    }

    private void clearRewriteBuffer() {
        this.m_previousText = null;
    }

    public static void reoutputLastMessages() {
        Statusbar sb = DefaultScreens.getSessionAccess().getStatusbar();
        sb.rewriteLastMessages();
    }

    public void rewriteLastMessages() {
        if (this.m_previousText == null || this.m_previousText.equals("")) {
            return;
        }
        if (this.m_text != null && !this.m_text.equals("")) {
            return;
        }
        this.m_text = new String(this.m_previousText);
        this.m_image = this.m_previousImage;
        this.m_bgpaint = this.m_previousBgpaint;
        this.m_font = this.m_previousFont;
        this.m_messages = this.m_previousMessages;
        PhaseManager.runBeforeUpdatePhase(this.m_clearer);
    }

    public void setText(String value) {
        this.m_text = value;
        if (this.m_text == null) {
            this.m_text = "";
        }
        if (this.m_text == null || this.m_text.equals("")) {
            this.m_image = StyleManager.getStyleValue("ccStatusbarEmpty");
            this.m_bgpaint = null;
            this.m_font = null;
        }
    }

    public String getText() {
        return this.m_text;
    }

    public void setTextColor(String value) {
        this.m_textColor = value;
    }

    public String getTextColor() {
        return this.m_textColor;
    }

    public int getClearTimerDuration() {
        return this.m_clearTimerDuration;
    }

    public void setImage(String value) {
        this.m_image = value;
    }

    public String getImage() {
        String result = this.m_image;
        return result;
    }

    public int getChangeCounter() {
        return this.m_changeCounter;
    }

    public String getPopupimage() {
        String image = this.getImage();
        if (image != null) {
            int index = image.indexOf("16x16");
            if (index > 0) {
                image = image.replace("16x16", "48x48");
            } else {
                index = image.lastIndexOf(46);
                image = image.substring(0, index) + "_big" + image.substring(index);
            }
        }
        return image;
    }

    public void setBgpaint(String value) {
        this.m_bgpaint = value;
    }

    public String getBgpaint() {
        String result = this.m_bgpaint;
        return result;
    }

    public void setFont(String value) {
        this.m_font = value;
    }

    public String getFont() {
        String result = this.m_font;
        return result;
    }

    public void setHtStyle(String value) {
        this.m_htStyle = value;
    }

    public String getHtStyle() {
        String result = this.m_htStyle;
        return result;
    }

    public Trigger getSoundTrigger() {
        return this.m_soundTrigger;
    }

    public boolean getMoreThanOneMessageIconShown() {
        if (!this.getMoreThanOneMessage()) {
            return false;
        }
        return !this.getMessagesAreaShown();
    }

    public boolean getMoreThanOneMessage() {
        return this.m_messages.size() > 1;
    }

    public boolean getMessagesAreaShown() {
        return this.m_messsagesAreaShown;
    }

    public void onToggleMessagesArea(ActionEvent event) {
        this.rewriteLastMessages();
        this.m_messsagesAreaShown = true;
        PhaseManager.runBeforeUpdatePhase(this.m_clearer);
    }

    public void onCloseMessagesArea(ActionEvent event) {
        this.rewriteLastMessages();
        this.m_messsagesAreaShown = false;
        PhaseManager.runBeforeUpdatePhase(this.m_clearer);
    }

    public void setMessagesPane(BaseComponent pane) {
        if (this.m_immediatelyShowAllMessages) {
            this.m_previousMessages = new ArrayList<StatusBarMessage>();
            for (StatusBarMessage message : this.m_messages) {
                this.m_previousMessages.add(message);
            }
        }
        pane.getChildren().clear();
        int maxi = this.m_previousMessages.size();
        if (this.m_immediatelyShowAllMessages) {
            --maxi;
        }
        for (int i = 0; i < maxi; ++i) {
            StatusBarMessage message = this.m_previousMessages.get(i);
            ROWComponentTag rt = new ROWComponentTag();
            BaseComponent r = rt.createBaseComponent();
            pane.getChildren().add(r);
            COLDISTANCEComponentTag cd = new COLDISTANCEComponentTag();
            cd.setWidth("5");
            r.getChildren().add(cd.createBaseComponent());
            IMAGEComponentTag it = new IMAGEComponentTag();
            switch (message.i_type) {
                case 0: {
                    it.setImage(StyleManager.getStyleValue("ccStatusbarEmpty"));
                    break;
                }
                case 1: {
                    it.setImage(StyleManager.getStyleValue("ccStatusbarMessage"));
                    break;
                }
                case 2: {
                    it.setImage(StyleManager.getStyleValue("ccStatusbarWarning"));
                    break;
                }
                case 3: {
                    it.setImage(StyleManager.getStyleValue("ccStatusbarError"));
                    break;
                }
                case 4: {
                    it.setImage(StyleManager.getStyleValue("ccStatusbarError"));
                }
            }
            r.getChildren().add(it.createBaseComponent());
            cd = new COLDISTANCEComponentTag();
            cd.setWidth("10");
            r.getChildren().add(cd.createBaseComponent());
            LABELComponentTag lt = new LABELComponentTag();
            lt.setText(message.i_message);
            lt.setPopuptextonclick("true");
            r.getChildren().add(lt.createBaseComponent());
        }
    }

    public void destroy() {
        this.m_statusBarDrillDownInfoProvider = null;
    }

    private void notifyMessageWasAdded() {
        if (this.m_immediatelyShowAllMessages && this.m_messages.size() > 1 && !this.m_messsagesAreaShown) {
            this.onToggleMessagesArea(null);
        }
        this.m_requestIdOfLastMessage = HttpSessionAccess.getCurrentRequestId();
    }

    private void treatPopup(OKPopup popup, int messageType, String text) {
        popup.getModalPopup().setOpacity(POPUP_OPACITY);
        popup.getModalPopup().setWithanimation(POPUP_ANIMATED);
        popup.getModalPopup().setUndecorated(POPUP_UNDECORATED);
        popup.getModalPopup().setScreenBackgroundColor("#00000008");
        popup.getModalPopup().setCloseonclickoutside(true);
        popup.getModalPopup().showAsTopPopup();
        popup.setBodyBgpaint(Statusbar.BGPAINT_BACK());
        if (HttpSessionAccess.checkIfCurrentClientTypeIsRisc()) {
            popup.getModalPopup().setStartfromrootwindow(false);
        }
        switch (messageType) {
            case 0: {
                popup.setImageBgpaint(Statusbar.BGPAINT_MESSAGE());
                popup.setTextColor(POPUPTEXTCOLOR_MESSAGE);
                break;
            }
            case 1: {
                popup.setImageBgpaint(Statusbar.BGPAINT_SUCCESS());
                popup.setTextColor(POPUPTEXTCOLOR_SUCCESS);
                break;
            }
            case 2: {
                popup.setImageBgpaint(Statusbar.BGPAINT_WARNING());
                popup.setTextColor(POPUPTEXTCOLOR_WARNING);
                break;
            }
            case 3: 
            case 4: {
                popup.setImageBgpaint(Statusbar.BGPAINT_ERROR());
                popup.setTextColor(POPUPTEXTCOLOR_ERROR);
                break;
            }
        }
        if (s_avoidConcatenationOfMessagesInPopup) {
            popup.setText(text);
        }
        this.m_avoidNextClearing = true;
        this.m_lastOKPopup = popup;
    }

    public static void autoClearStatusbar(int duration) {
        Statusbar sb = DefaultScreens.getSessionAccess().getStatusbar();
        sb.autoClearStatusbarContent(duration);
    }

    public void autoClearStatusbarContent(int duration) {
        this.m_clearTimerDuration = duration;
        PhaseManager.runBeforeUpdatePhase(this.m_clearer);
    }

    public void onAutoClear(ActionEvent e) {
        if (this.m_lastOKPopup != null) {
            try {
                this.m_lastOKPopup.close();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        this.clear();
    }

    public int checkIfMessageAlreadyWasOutput(int messageType, String messageText) {
        int counter = -1;
        for (StatusBarMessage message : this.m_messages) {
            ++counter;
            if (message.i_type != messageType || !ValueManager.checkIfStringsAreEqual(messageText, message.i_message)) continue;
            return counter;
        }
        return -1;
    }

    public int checkIfMessageAlreadyWasOutput(String messageText) {
        int counter = -1;
        for (StatusBarMessage message : this.m_messages) {
            ++counter;
            if (!ValueManager.checkIfStringsAreEqual(messageText, message.i_message)) continue;
            return counter;
        }
        return -1;
    }

    public void registerStatusbarComponent(String id) {
        this.m_statusbarComponentIds.add(id);
    }

    public void unregisterStatusbarComponent(String id) {
        this.m_statusbarComponentIds.remove(id);
    }

    public boolean getRenderDefaultStatusbar() {
        String id;
        if (!HttpSessionAccess.checkIfCurrentClientTypeIsRisc()) {
            return false;
        }
        if (!SystemXml.getStatusbarAutoAdd()) {
            return false;
        }
        if (this.m_statusbarComponentIds.size() == 0) {
            return true;
        }
        return this.m_statusbarComponentIds.size() == 1 && (id = this.m_statusbarComponentIds.iterator().next()).contains("CCMP_SBASPOPUP");
    }

    private void addMessageToStatusbar(StatusBarMessage message) {
        ++this.m_changeCounter;
        this.clearRewriteBuffer();
        if (!s_avoidDoubleOccuranceOfMessages) {
            this.m_messages.add(message);
        } else {
            int index = this.checkIfMessageAlreadyWasOutput(message.i_type, message.i_message);
            if (index < 0) {
                this.m_messages.add(message);
            } else {
                this.m_messages.remove(index);
                this.m_messages.add(message);
            }
        }
    }

    public static class StatusBarDrillDownInforProviderNoDrillDown
    implements IStatusBarDrillDownInfoProvider {
        @Override
        public boolean checkIfToDrillDownToGlobalStatusbar() {
            return false;
        }
    }

    public static interface IStatusBarDrillDownInfoProvider {
        public boolean checkIfToDrillDownToGlobalStatusbar();
    }

    public static class StatusBarMessage
    implements Serializable {
        int i_type;
        String i_message;

        public StatusBarMessage() {
        }

        public StatusBarMessage(int type, String message) {
            this.i_type = type;
            this.i_message = message;
        }

        @XmlAttribute
        public int getType() {
            return this.i_type;
        }

        @XmlAttribute
        public String getMessage() {
            return this.i_message;
        }

        @XmlAttribute
        public String getImage() {
            switch (this.i_type) {
                case 0: {
                    return StyleManager.getStyleValue("ccStatusbarOutput");
                }
                case 1: {
                    return StyleManager.getStyleValue("ccStatusbarMessage");
                }
                case 2: {
                    return StyleManager.getStyleValue("ccStatusbarWarning");
                }
                case 3: {
                    return StyleManager.getStyleValue("ccStatusbarError");
                }
            }
            return null;
        }

        @XmlAttribute
        public String getBgpaint() {
            switch (this.i_type) {
                case 0: {
                    return Statusbar.BGPAINT_MESSAGE();
                }
                case 1: {
                    return Statusbar.BGPAINT_SUCCESS();
                }
                case 2: {
                    return Statusbar.BGPAINT_WARNING();
                }
                case 3: {
                    return Statusbar.BGPAINT_ERROR();
                }
            }
            return null;
        }
    }

    @XmlRootElement
    public static class StatusBarMessagesInfo {
        List<StatusBarMessage> i_messages = new ArrayList<StatusBarMessage>();

        public StatusBarMessagesInfo() {
        }

        public StatusBarMessagesInfo(List<StatusBarMessage> messages) {
            this.i_messages = messages;
        }

        @XmlElement(name="message")
        public List<StatusBarMessage> getMessages() {
            return this.i_messages;
        }
    }

    public class Clearer
    implements Serializable,
    Runnable {
        @Override
        public void run() {
            if (UsageWithoutSessionContext.isUsedWithSessionContext() && HttpSessionAccess.getCurrentComponentDump(HttpSessionAccess.getCurrentFacesContext()) != null && HttpSessionAccess.getCurrentComponentDump(HttpSessionAccess.getCurrentFacesContext()).isAutoTriggered() || Statusbar.this.m_avoidNextClearing) {
                CLog.L.log(CLog.LL_INF, "Statusbar clearing is postponed - request is an automatically created one!");
                Statusbar.this.m_avoidNextClearing = false;
                PhaseManager.runBeforeUpdatePhase(this);
            } else {
                Statusbar.this.clear();
            }
        }
    }

    public static enum ENUMPopupMode {
        POPUP,
        MESSAGETOAST;

    }
}

