/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.faces.application.Application;
import org.eclnt.editor.tools.ProjectInfo;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.elements.CRN;
import org.eclnt.jsfserver.elements.ICCComponentProperties;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.session.UsageWithoutSessionContext;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.WebResourceClassloaderReader;
import org.eclnt.jsfserver.util.parse.SAXParserUtil;
import org.eclnt.tool.TransferJEE9;
import org.eclnt.util.classresolver.CCClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.log.CLogConstants;
import org.eclnt.util.valuemgmt.ValueManager;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class ComponentRepository
implements CLogConstants,
ICCComponentProperties {
    static final String DESIGNTIMEPREFIX = "DESIGNTIME_";
    static final Object s_syncherInGetInstance = new Object();
    static Map<String, String> s_packages = new HashMap<String, String>();
    static Map<String, TLDInfo> s_tldInfos = new HashMap<String, TLDInfo>();
    static Map<String, ComponentRepository> s_repositories = new HashMap<String, ComponentRepository>();
    static Set<String> s_serverOnlyAttributes = new HashSet<String>();
    static Set<String> s_referenceAttributes = new HashSet<String>();
    static Set<String> s_ccDefaultAttributes = new HashSet<String>();
    static Set<String> s_ccClientInfoAttributes = new HashSet<String>();
    Map<String, ComponentInfo> m_components = null;
    List<String> m_componentList = new ArrayList<String>();

    private ComponentRepository(String prefix, String xml) {
        this.initializeContent(prefix, null, xml);
    }

    public static synchronized void registerLibrary(TLDInfo info) {
        CLog.L.log(CLog.LL_INF, "Controllibrary registration: " + info.getPrefix() + "/" + info.getTldFileName() + "/" + info.getPackageName() + "/" + info.getUri());
        s_tldInfos.put(info.getPrefix(), info);
        s_packages.put(info.getPackageName(), info.getPrefix());
    }

    public static synchronized void registerDesignTimeLibrary(ProjectInfo.DesignTimeTLDInfo info) {
        CLog.L.log(CLog.LL_INF, "Design time controllibrary registration: " + info.getPrefix() + "/" + info.getTldFileName() + "/" + info.getPackageName() + "/" + info.getUri());
        s_tldInfos.put(DESIGNTIMEPREFIX + info.getPrefix(), info);
        if (!s_packages.containsKey(info.getPackageName())) {
            s_packages.put(info.getPackageName(), DESIGNTIMEPREFIX + info.getPrefix());
        }
    }

    public static synchronized void unregisterAllDesignTimeLibraries() {
        CLog.L.log(CLog.LL_INF, "Unregistering all component library instances");
        String[] keys = new String[s_tldInfos.size()];
        s_tldInfos.keySet().toArray(keys);
        for (String key : keys) {
            if (!key.startsWith(DESIGNTIMEPREFIX)) continue;
            TLDInfo tldInfo = s_tldInfos.get(key);
            s_tldInfos.remove(key);
            s_repositories.remove(key);
        }
    }

    public static TLDInfo getTLDInfo(String prefix) {
        return s_tldInfos.get(prefix);
    }

    public static TLDInfo[] getRunTimeTLDInfos() {
        ArrayList<TLDInfo> result = new ArrayList<TLDInfo>();
        for (String key : s_tldInfos.keySet()) {
            if (key.startsWith(DESIGNTIMEPREFIX)) continue;
            result.add(s_tldInfos.get(key));
        }
        TLDInfo[] resultArray = new TLDInfo[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public static TLDInfo[] getDesignTimeTLDInfos() {
        ArrayList<TLDInfo> result = new ArrayList<TLDInfo>();
        for (String key : s_tldInfos.keySet()) {
            if (!key.startsWith(DESIGNTIMEPREFIX)) continue;
            result.add(s_tldInfos.get(key));
        }
        TLDInfo[] resultArray = new TLDInfo[result.size()];
        result.toArray(resultArray);
        return resultArray;
    }

    public static TLDInfo getRunTimeTLDInfo(String prefix) {
        return s_tldInfos.get(prefix);
    }

    public static TLDInfo[] getRunTimeTLDInfosTFIRST() {
        TLDInfo[] result = ComponentRepository.getRunTimeTLDInfos();
        ComponentRepository.sortTLibraryAsFirst(result);
        return result;
    }

    public static TLDInfo[] getDesignTimeTLDInfosTFIRST() {
        TLDInfo[] result = ComponentRepository.getDesignTimeTLDInfos();
        ComponentRepository.sortTLibraryAsFirst(result);
        return result;
    }

    private static void sortTLibraryAsFirst(TLDInfo[] result) {
        for (int i = 1; i < result.length; ++i) {
            if (!"t".equals(result[i].getPrefix())) continue;
            TLDInfo dummy = result[0];
            result[0] = result[i];
            result[i] = dummy;
            break;
        }
    }

    public static synchronized void registerServerOnlyAttribute(String attribute) {
        s_serverOnlyAttributes.add(attribute);
    }

    private ComponentRepository(String prefix) {
        String content = null;
        TLDInfo info = ComponentRepository.getTLDInfo(prefix);
        if (info == null) {
            throw new Error("Could not find Tag Library Definition info for prefix: " + prefix);
        }
        if (info.isTypeJSFControlLibary()) {
            String tldFileName = info.getTldFileName();
            ClassLoader classLoader = this.getClass().getClassLoader();
            if (info instanceof ProjectInfo.DesignTimeTLDInfo && ((ProjectInfo.DesignTimeTLDInfo)info).getDesignTimeClassLoader() != null) {
                classLoader = ((ProjectInfo.DesignTimeTLDInfo)info).getDesignTimeClassLoader();
            }
            if (!((content = new ClassloaderReader(classLoader).readUTF8File("META-INF/" + tldFileName, false)) != null && content.length() != 0 || (content = WebResourceClassloaderReader.readUTF8FileIntoString("/WEB-INF/" + tldFileName, false)) != null && content.length() != 0 || (content = FileManager.readUTF8File(tldFileName, false)) != null && content.length() != 0 || (content = new ClassloaderReader(classLoader = this.getClass().getClassLoader()).readUTF8File("META-INF/" + tldFileName, false)) != null && content.length() != 0)) {
                throw new Error("Could not read the tag library definition file: " + tldFileName);
            }
            this.initializeContent(prefix, info, content);
        } else {
            this.initializeContent(prefix, info, info.getCcControlLibraryXml());
        }
    }

    private static void registerControllibraries() {
        new ControllibrariesParser();
        List<TLDInfo> libraries = ComponentRepository.readCCControllibrariesFromClassLoader(HotDeployManager.currentClassLoader());
        for (TLDInfo library : libraries) {
            ComponentRepository.registerLibrary(library);
        }
    }

    public static List<TLDInfo> readCCControllibrariesFromClassLoader() {
        return ComponentRepository.readCCControllibrariesFromClassLoader(HotDeployManager.currentClassLoader());
    }

    public static List<TLDInfo> readCCControllibrariesFromClassLoader(ClassLoader cl) {
        ArrayList<TLDInfo> result = new ArrayList<TLDInfo>();
        try {
            List<String> xmls = new ClassloaderReader(cl).readUTF8Files("cccontrollibrary.xml", true);
            for (String xml : xmls) {
                try {
                    if (xml == null || xml.length() == 0) continue;
                    TLDInfo ti = ComponentRepository.parseTLDInfoForCCControlLibraryXml(xml);
                    result.add(ti);
                }
                catch (Throwable tt) {
                    CLog.L.log(CLog.LL_ERR, "Problems parsing control libraries from classloader: " + tt + ", xml: " + xml, tt);
                }
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "No control library file cccontrollibrary.xml found: " + t);
        }
        return result;
    }

    public static TLDInfo parseTLDInfoForCCControlLibraryXml(String xml) {
        try {
            CCControlLibraryXmlTLDInfoParser parser = new CCControlLibraryXmlTLDInfoParser(xml);
            SAXParserUtil.parse(xml, (DefaultHandler)parser);
            return parser.i_tldInfo;
        }
        catch (Throwable t) {
            throw new Error("Problem parsing TLDInfo for control library definition: " + xml, t);
        }
    }

    public static ComponentRepository createComponentRepository_junit(String prefix, String xml) {
        return new ComponentRepository(prefix, xml);
    }

    private void initializeContent(String prefix, TLDInfo info, String content) {
        try {
            this.m_components = new HashMap<String, ComponentInfo>();
            SAXParserUtil.parse(content, (DefaultHandler)new TLDParser());
        }
        catch (Throwable t) {
            CLog.L.log(LL_ERR, "Error when reading and parsing eclnt.tld, tag library prefix: " + prefix, t);
            throw new RuntimeException("Error when reading and parsing tag library content, tag library prefix: " + prefix, t);
        }
        try {
            if (info != null) {
                String resourceName = info.getPackageName();
                resourceName = resourceName.replace('.', '/') + "/resources/controlattributeusage.xml";
                String resourceContent = new ClassloaderReader(HotDeployManager.currentClassLoader()).readUTF8File(resourceName, true);
                SAXParserUtil.parse(resourceContent, (DefaultHandler)new AttributeUsageParser());
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Could not read controlattributeusage, assume to read in design mode, prefix: " + prefix);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ComponentRepository getInstance(String prefix) {
        ComponentRepository result = s_repositories.get(prefix);
        if (result == null) {
            Object object = s_syncherInGetInstance;
            synchronized (object) {
                result = s_repositories.get(prefix);
                if (result == null) {
                    result = new ComponentRepository(prefix);
                    s_repositories.put(prefix, result);
                }
            }
        }
        return result;
    }

    public static ComponentRepository getDesignTimeInstance(String prefix) {
        prefix = DESIGNTIMEPREFIX + prefix;
        return ComponentRepository.getInstance(prefix);
    }

    public static boolean checkIfControlLibraryIsRegistered(String prefix) {
        TLDInfo info = s_tldInfos.get(prefix);
        return info != null;
    }

    public ComponentInfo getComponentInfo(String tag) {
        int index;
        ComponentInfo result = this.m_components.get(tag);
        if (result == null && (index = tag.indexOf(58)) >= 0) {
            String tagWithoutPrefix = tag.substring(index + 1);
            result = this.m_components.get(tagWithoutPrefix);
        }
        return result;
    }

    public Collection<ComponentInfo> getComponentInfos() {
        return this.m_components.values();
    }

    public static String[] getTagNameForComponentClass(Class componentClass) {
        String className = componentClass.getName();
        int index = className.lastIndexOf(46) + 1;
        if (index < 0) {
            index = 0;
        }
        String tagName = className.substring(index);
        tagName = ValueManager.toLowerCaseId(tagName);
        tagName = tagName.substring(0, tagName.length() - 9);
        tagName = CRN.t(tagName);
        String packageName = className.substring(0, index - 1);
        if (packageName.endsWith(".selfcontaining")) {
            packageName = packageName.substring(0, packageName.length() - 15);
        }
        String tagPrefix = s_packages.get(packageName);
        return new String[]{tagPrefix, tagName};
    }

    public static String[] getTagNameForComponentTagClass(Class componentTagClass) {
        String className = componentTagClass.getName();
        int index = className.lastIndexOf(46) + 1;
        if (index < 0) {
            index = 0;
        }
        String tagName = className.substring(index);
        tagName = ValueManager.toLowerCaseId(tagName);
        tagName = tagName.substring(0, tagName.length() - 12);
        String packageName = className.substring(0, index - 1);
        String tagPrefix = s_packages.get(packageName);
        if (tagPrefix == null && packageName.equals("org.eclnt.ccserver.base.elements.impl")) {
            tagPrefix = "t";
        }
        return new String[]{tagPrefix, tagName};
    }

    public static String getTagPrefixForComponentClass(Class componentClass) {
        String[] tagName = ComponentRepository.getTagNameForComponentClass(componentClass);
        return tagName[0];
    }

    public static String getTagPrefixForComponentTagClass(Class componentTagClass) {
        String[] tagName = ComponentRepository.getTagNameForComponentTagClass(componentTagClass);
        return tagName[0];
    }

    public static boolean checkIfKeyIsAnAction(String key) {
        return key.indexOf("action") >= 0;
    }

    public static boolean checkIfAttributeNameIsServerOnly(String attrName) {
        return s_serverOnlyAttributes.contains(attrName);
    }

    public static boolean checkIfAttributeIsAReference(String attrName) {
        return s_referenceAttributes.contains(attrName);
    }

    public static boolean checkIfAttributeIsRelevantForClientInfo(String attrName) {
        return s_ccClientInfoAttributes.contains(attrName);
    }

    public static boolean checkIfAttributeIsCCDefault(String attrName) {
        return s_ccDefaultAttributes.contains(attrName);
    }

    public static BaseComponent createComponentInstanceForComponentTagClass(Class componentTagClass) {
        try {
            String baseComponentClassName = componentTagClass.getName();
            baseComponentClassName = baseComponentClassName.substring(0, baseComponentClassName.length() - 3);
            if (HttpSessionAccess.getCurrentFacesContext() != null) {
                Application application = HttpSessionAccess.getCurrentFacesContext().getApplication();
                BaseComponent result = (BaseComponent)application.createComponent(baseComponentClassName);
                return result;
            }
            CLog.L.log(CLog.LL_WAR, "FacesContext not available - not running in faces context");
            Class baseComponentClass = CCClassResolver.resolveClass(baseComponentClassName, ENUMCallerType.COMPONENT);
            BaseComponent result = (BaseComponent)baseComponentClass.newInstance();
            return result;
        }
        catch (Throwable t) {
            throw new Error("Could not create component instance for component tag class: " + componentTagClass, t);
        }
    }

    public static BaseComponentTag createComponentTagInstsanceForComponentClass(Class componentClass) {
        try {
            String className = componentClass.getName() + "Tag";
            Class clazz = CCClassResolver.resolveClass(className, ENUMCallerType.COMPONENT);
            return (BaseComponentTag)clazz.newInstance();
        }
        catch (Throwable t) {
            throw new Error("Could not create tage instance for " + componentClass, t);
        }
    }

    public static Class createComponentTagClass(String tagPrefix, String tagName) {
        try {
            String tagPackage = "org.eclnt.jsfserver.elements.impl";
            if (!tagPrefix.equals("t")) {
                tagPackage = ComponentRepository.getTLDInfo(tagPrefix).getPackageName();
            }
            String componentClassName = tagPackage + "." + ValueManager.toUpperCaseId(tagName) + "ComponentTag";
            String componentTagClassName = componentClassName + "Tag";
            Class result = CCClassResolver.resolveClass(componentClassName, ENUMCallerType.COMPONENT);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Could not create component tag class: " + tagPrefix + ":" + tagName, t);
        }
    }

    public static String findCSSResourcePathForControlLibary(TLDInfo library) {
        try {
            if (library == null) {
                return null;
            }
            String result = library.getPackageName().replace(".", "/") + "/webresources/extension.css";
            boolean exists = new ClassloaderReader(true).checkIfFileExists(result);
            if (exists) {
                return result;
            }
            return null;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when finding JS resource path for control library", t);
            return null;
        }
    }

    public static String findJSResourcePathForControlLibary(TLDInfo library) {
        try {
            if (library == null) {
                return null;
            }
            String result = library.getPackageName().replace(".", "/") + "/webresources/extension.js";
            boolean exists = new ClassloaderReader(true).checkIfFileExists(result);
            if (exists) {
                return result;
            }
            return null;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Problem when finding JS resource path for control library", t);
            return null;
        }
    }

    static {
        ComponentRepository.registerLibrary(new TLDInfo("t", "eclnt.tld", "org.eclnt.jsfserver.elements.impl", "/WEB-INF/eclnt"));
        ComponentRepository.registerControllibraries();
        ComponentRepository.registerServerOnlyAttribute("adapterbinding");
        ComponentRepository.registerServerOnlyAttribute("componentbinding");
        ComponentRepository.registerServerOnlyAttribute("objectbinding");
        ComponentRepository.registerServerOnlyAttribute("rendered");
        ComponentRepository.registerServerOnlyAttribute(ATT_gp_rendered);
        ComponentRepository.registerServerOnlyAttribute("contentreplace");
        ComponentRepository.registerServerOnlyAttribute("attributemacro");
        ComponentRepository.registerServerOnlyAttribute("comment");
        ComponentRepository.registerServerOnlyAttribute("persistid");
        ComponentRepository.registerServerOnlyAttribute("workpagebinding");
        ComponentRepository.registerServerOnlyAttribute("shadowdistance");
        ComponentRepository.registerServerOnlyAttribute("shadowbackground");
        ComponentRepository.registerServerOnlyAttribute("shadowbgpaint");
        ComponentRepository.registerServerOnlyAttribute("convertemptystringtonull");
        ComponentRepository.registerServerOnlyAttribute("configinfo");
        ComponentRepository.registerServerOnlyAttribute(ATT_datatypeinfo);
        ComponentRepository.registerServerOnlyAttribute(ATT_inputmaskvaluemode);
        s_referenceAttributes.add("image");
        s_referenceAttributes.add("badgeimage");
        s_referenceAttributes.add("hoverimage");
        s_referenceAttributes.add("page");
        s_referenceAttributes.add("sound");
        s_referenceAttributes.add("url");
        s_referenceAttributes.add("selectorcolumntitleimage");
        s_referenceAttributes.add("selectorcolumnimagefalse");
        s_referenceAttributes.add("selectorcolumnimagetrue");
        s_referenceAttributes.add("textimage");
        s_referenceAttributes.add("fixstatusimageopened");
        s_referenceAttributes.add("fixstatusimageclosed");
        s_referenceAttributes.add("fixstatusimageendnode");
        s_referenceAttributes.add("imagepressed");
        s_referenceAttributes.add("imagerollover");
        s_referenceAttributes.add("imagedisabled");
        s_referenceAttributes.add("imagesortup");
        s_referenceAttributes.add("imagesortdown");
        s_referenceAttributes.add("imagefalse");
        s_referenceAttributes.add("imagetrue");
        s_referenceAttributes.add("imageselected");
        s_referenceAttributes.add("imagedeselected");
        s_referenceAttributes.add("popupimage");
        s_referenceAttributes.add("posterimage");
        s_referenceAttributes.add("treenodeimage");
        s_referenceAttributes.add("selectorcolumnimagefalse");
        s_referenceAttributes.add("selectorcolumnimagetrue");
        s_referenceAttributes.add("imagenull");
        s_referenceAttributes.add("statusimage");
        s_referenceAttributes.add("closeiconimage");
        s_referenceAttributes.add("closeiconactiveimage");
        s_referenceAttributes.add("closeiconinactiveimage");
        s_referenceAttributes.add("wpcloseimage");
        s_referenceAttributes.add("wpopenimage");
        s_ccDefaultAttributes.add("id");
        s_ccDefaultAttributes.add("adapterbinding");
        s_ccDefaultAttributes.add("attributemacro");
        s_ccDefaultAttributes.add("comment");
        s_ccDefaultAttributes.add("configinfo");
        s_ccDefaultAttributes.add("reference");
        s_ccDefaultAttributes.add("stylevariant");
        s_ccClientInfoAttributes.add(ATT_text);
        s_ccClientInfoAttributes.add(ATT_value);
        s_ccClientInfoAttributes.add(ATT_selected);
        s_ccClientInfoAttributes.add(ATT_ADAPTERBINDING);
        s_ccClientInfoAttributes.add(ATT_OBJECTBINDING);
    }

    public static class TLDInfo {
        String m_prefix;
        String m_tldFileName;
        String m_packageName;
        String m_uri;
        String m_ccControlLibraryXml = null;
        String m_clientprefix = null;

        public TLDInfo(String prefix, String tldFileName, String packageName, String uri) {
            this.m_prefix = prefix;
            this.m_tldFileName = TransferJEE9.updateTLDFileName(tldFileName);
            this.m_packageName = packageName;
            this.m_uri = uri;
        }

        public TLDInfo(String prefix, String packageName, String xml) {
            this.m_prefix = prefix;
            this.m_packageName = packageName;
            this.m_ccControlLibraryXml = xml;
        }

        public String getPrefix() {
            return this.m_prefix;
        }

        public String getTldFileName() {
            return this.m_tldFileName;
        }

        public String getPackageName() {
            return this.m_packageName;
        }

        public String getUri() {
            return this.m_uri;
        }

        public String getCcControlLibraryXml() {
            return this.m_ccControlLibraryXml;
        }

        public String getClientprefix() {
            return this.m_clientprefix;
        }

        public void setClientprefix(String clientprefix) {
            this.m_clientprefix = clientprefix;
        }

        public boolean isTypeCCControlLibraryXml() {
            return this.m_ccControlLibraryXml != null;
        }

        public boolean isTypeJSFControlLibary() {
            return this.m_ccControlLibraryXml == null;
        }
    }

    class TLDParser
    extends DefaultHandler {
        String i_currentTagCharacters;
        ComponentInfo i_currentComponentInfo;
        boolean i_inAttribute = false;
        boolean i_inTag = false;
        boolean i_isInputAttribute = false;

        TLDParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            this.i_currentTagCharacters = null;
            super.startElement(uri, localName, name, attributes);
            if (name.equals("tag")) {
                this.i_currentComponentInfo = new ComponentInfo();
                this.i_inTag = true;
            } else if (name.equals("attribute")) {
                this.i_inAttribute = true;
            }
        }

        @Override
        public void characters(char[] ch, int start, int length) throws SAXException {
            super.characters(ch, start, length);
            String s = new String(ch, start, length);
            this.i_currentTagCharacters = this.i_currentTagCharacters == null ? s : this.i_currentTagCharacters + s;
        }

        @Override
        public void endElement(String uri, String localName, String name) throws SAXException {
            super.endElement(uri, localName, name);
            if (name.equals("tag")) {
                ComponentRepository.this.m_components.put(this.i_currentComponentInfo.i_tagName, this.i_currentComponentInfo);
                this.i_inTag = false;
                CLog.L.log(CLogConstants.LL_INF, "Component added: " + this.i_currentComponentInfo.toString());
            }
            if (name.equals("name")) {
                if (this.i_currentTagCharacters == null) {
                    return;
                }
                if (this.i_inAttribute) {
                    this.i_currentTagCharacters = CRN.a(this.i_currentTagCharacters);
                    if (this.i_currentTagCharacters.equals("id")) {
                        return;
                    }
                    if (this.i_currentTagCharacters.equals("action")) {
                        this.i_currentComponentInfo.i_hasAction = true;
                    } else if (this.i_currentTagCharacters.equals("actionListener")) {
                        this.i_currentComponentInfo.i_hasActionListener = true;
                    } else {
                        this.i_currentComponentInfo.i_attributes.add(this.i_currentTagCharacters);
                        if (this.i_isInputAttribute) {
                            this.i_currentComponentInfo.i_defaultUpdateAttribute = this.i_currentTagCharacters;
                        }
                    }
                } else if (this.i_inTag) {
                    this.i_currentComponentInfo.i_tagName = this.i_currentTagCharacters;
                }
            }
            if (name.equals("attribute")) {
                this.i_inAttribute = false;
                this.i_isInputAttribute = false;
            }
            if (name.equals("isinput")) {
                this.i_isInputAttribute = true;
            }
        }
    }

    static class CCControlLibraryXmlTLDInfoParser
    extends DefaultHandler {
        TLDInfo i_tldInfo;
        String i_xml;

        public CCControlLibraryXmlTLDInfoParser(String xml) {
            this.i_xml = xml;
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("taglib")) {
                String prefix = attributes.getValue("prefix");
                String packagename = attributes.getValue("packagename");
                this.i_tldInfo = new TLDInfo(prefix, packagename, this.i_xml);
                String clientprefix = attributes.getValue("clientprefix");
                if (clientprefix != null) {
                    this.i_tldInfo.setClientprefix(clientprefix);
                }
            }
        }
    }

    class AttributeUsageParser
    extends DefaultHandler {
        AttributeUsageParser() {
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            if (name.equals("tag")) {
                String tagName = attributes.getValue("name");
                String tagInput = attributes.getValue("input");
                if (tagName != null && tagInput != null) {
                    ComponentInfo ci = ComponentRepository.this.getComponentInfo(tagName);
                    if (ci == null) {
                        throw new Error("Mismatch in component definition: " + name);
                    }
                    ci.i_defaultUpdateAttribute = CRN.a(tagInput);
                }
            }
        }
    }

    static class ControllibrariesParser
    extends DefaultHandler {
        public ControllibrariesParser() {
            try {
                List<String> fileNames = WebResourceClassloaderReader.getFileNameVariantsInPathDirectoryByPattern("/eclntjsfserver/config/", "controllibraries", ".xml");
                for (String fileName : fileNames) {
                    try {
                        CLog.L.log(CLog.LL_INF, "Initializing control libraries: " + fileName);
                        String xml = WebResourceClassloaderReader.readUTF8FileIntoString("/eclntjsfserver/config/" + fileName, false);
                        if (xml == null) continue;
                        SAXParserUtil.parse(xml, (DefaultHandler)this);
                    }
                    catch (Throwable t) {
                        CLog.L.log(CLog.LL_INF, "Problems when initializing control library, file name: " + fileName);
                    }
                }
            }
            catch (RuntimeException t) {
                if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                    return;
                }
                throw t;
            }
            catch (Error t) {
                if (UsageWithoutSessionContext.isUsedWithoutSessionContext()) {
                    return;
                }
                throw t;
            }
        }

        @Override
        public void startElement(String uri, String localName, String name, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, name, attributes);
            if (name.equals("controllibrary")) {
                TLDInfo tldi = new TLDInfo(attributes.getValue("prefix"), attributes.getValue("tldfilename"), attributes.getValue("packagename"), attributes.getValue("uri"));
                ComponentRepository.registerLibrary(tldi);
            }
        }
    }

    public static class ComponentInfo
    implements Serializable,
    Comparable<ComponentInfo> {
        String i_tagName;
        int i_ctype;
        List<String> i_attributes = new ArrayList<String>();
        List<String> i_encodeAttributes = null;
        Set<String> i_encodeAttributesSet = null;
        String i_defaultUpdateAttribute;
        boolean i_hasAction = false;
        boolean i_hasActionListener = false;

        public String getTagName() {
            return this.i_tagName;
        }

        public String getDefaultUpdateAttribute() {
            return this.i_defaultUpdateAttribute;
        }

        private ComponentInfo() {
        }

        @Override
        public int compareTo(ComponentInfo o) {
            String s1 = this.i_tagName;
            String s2 = o.i_tagName;
            if (s1 == null) {
                s1 = "";
            }
            if (s2 == null) {
                s2 = "";
            }
            return s1.compareTo(s2);
        }

        public String toString() {
            return this.i_tagName + "/" + this.i_attributes.size() + "/" + this.i_defaultUpdateAttribute;
        }

        public boolean hasAction() {
            return this.i_hasAction;
        }

        public boolean hasActionListener() {
            return this.i_hasActionListener;
        }

        public List<String> getAttributes() {
            return this.i_attributes;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public List<String> getEncodeAttributes() {
            if (this.i_encodeAttributes == null) {
                ComponentInfo componentInfo = this;
                synchronized (componentInfo) {
                    if (this.i_encodeAttributes == null) {
                        ArrayList<String> newEncodeAttributes = new ArrayList<String>();
                        newEncodeAttributes.addAll(this.i_attributes);
                        newEncodeAttributes.add("avoidselection");
                        newEncodeAttributes.add(ICCComponentProperties.ATT_pageinfo);
                        newEncodeAttributes.add(ICCComponentProperties.ATT_editorreference);
                        HashSet<String> newEncodeAttributesSet = new HashSet<String>();
                        newEncodeAttributesSet.addAll(newEncodeAttributes);
                        this.i_encodeAttributesSet = newEncodeAttributesSet;
                        this.i_encodeAttributes = newEncodeAttributes;
                    }
                }
            }
            return this.i_encodeAttributes;
        }

        public Set<String> getEncodeAttributesSet() {
            if (this.i_encodeAttributes == null) {
                this.getEncodeAttributes();
            }
            return this.i_encodeAttributesSet;
        }

        public List<String> getAttibutesInclActions(boolean sorted) {
            ArrayList<String> result = new ArrayList<String>();
            for (int i = 0; i < this.i_attributes.size(); ++i) {
                result.add(this.i_attributes.get(i));
            }
            if (this.hasAction()) {
                result.add("action");
            }
            if (this.hasActionListener()) {
                result.add("actionListener");
            }
            if (sorted) {
                Collections.sort(result);
            }
            return result;
        }
    }
}

