/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclnt.jsfserver.elements.BaseActionComponent;
import org.eclnt.jsfserver.elements.ICCComponentProperties;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class CLIENTCOOKIEComponent
extends BaseActionComponent
implements ICCComponentProperties {
    String m_lastDecodeName = null;
    String m_lastDecodeValue = null;
    String m_lastEncodeValue = null;

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        CLIENTCOOKIEComponent.ensureSessionIsValid(HttpSessionAccess.getCurrentHttpSessionIfAvailable(context));
        String name = this.getAttributeValueAsString(ATT_name);
        String value = this.getAttributeValueAsString(ATT_value);
        if (name == null) {
            return;
        }
        if (value == null) {
            return;
        }
        if (ValueManager.checkIfStringsAreEqual(this.m_lastDecodeName + "//" + this.m_lastDecodeValue, name + "//" + value)) {
            return;
        }
        this.m_lastEncodeValue = value;
        String httponly = this.getAttributeValueAsString(ATT_httponly);
        String samesite = this.getAttributeValueAsString(ATT_samesite);
        String secure = this.getAttributeValueAsString(ATT_secure);
        HttpServletResponse resp = HttpSessionAccess.getCurrentResponse();
        ServletUtil.writeCookie(resp, name, null, value, "true".equals(httponly), samesite, "true".equals(secure));
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
    }

    @Override
    public void decode(FacesContext context) {
        try {
            HttpServletRequest req = HttpSessionAccess.getCurrentRequest();
            String name = this.getAttributeValueAsString(ATT_name);
            Cookie c = this.findCookie(req, name);
            String value = null;
            if (c != null) {
                value = c.getValue();
            }
            if (ValueManager.checkIfStringsAreEqual(value, this.m_lastEncodeValue)) {
                return;
            }
            Object vb = ExpressionManagerV.getExpressionFromComponentAttribute((UIComponent)this, ATT_value);
            if (vb == null) {
                return;
            }
            this.setDecodeValueInValueBinding(context, vb, value, true);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Error in decode phaseof CLIENTCOOKIE: " + t.toString());
        }
    }

    private Cookie findCookie(HttpServletRequest req, String name) {
        Cookie[] cookies;
        for (Cookie cookie : cookies = req.getCookies()) {
            if (!ValueManager.checkIfStringsAreEqual(name, cookie.getName())) continue;
            return cookie;
        }
        return null;
    }
}

