/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.elements.util.IValueByToString;
import org.eclnt.jsfserver.util.valuemgmt.IDynamicContentBindingObject;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;

public class CLIENTSECIDBinding
implements Serializable,
IValueByToString,
IDynamicContentBindingObject {
    String m_secid;
    List<String> m_lastSecids = new ArrayList<String>();
    protected int m_lastSecidsBufferLength = 5;

    public CLIENTSECIDBinding() {
        this.createNextSecid();
    }

    public CLIENTSECIDBinding(int tolerance) {
        this.createNextSecid();
        this.m_lastSecidsBufferLength = tolerance;
    }

    public String getSecid() {
        return this.m_secid;
    }

    public void checkSecid(String secid) {
        if (secid == null) {
            CLog.L.log(CLog.LL_ERR, "Secid passed is null");
            throw new ErrorCLIENTSECIDBinding();
        }
        if (secid.equals(this.m_secid)) {
            return;
        }
        if (this.m_lastSecidsBufferLength > 0 && this.m_lastSecids.contains(secid)) {
            return;
        }
        CLog.L.log(CLog.LL_ERR, "Secid passed does not fit to session secids");
        throw new ErrorCLIENTSECIDBinding();
    }

    public void createNextSecid() {
        if (this.m_lastSecidsBufferLength > 0 && this.m_secid != null) {
            this.m_lastSecids.add(0, this.m_secid);
        }
        this.m_secid = UniqueIdCreator.createRandomId();
        if (this.m_lastSecidsBufferLength > 0) {
            while (this.m_lastSecids.size() > this.m_lastSecidsBufferLength) {
                this.m_lastSecids.remove(this.m_lastSecidsBufferLength - 1);
            }
        }
    }

    public final String toString() {
        return this.getSecid();
    }

    public class ErrorCLIENTSECIDBinding
    extends Error {
    }
}

