/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.util.List;
import javax.faces.component.UIComponent;
import org.eclnt.jsfserver.elements.BaseActionComponent;
import org.eclnt.jsfserver.elements.BaseComponent;
import org.eclnt.jsfserver.elements.BaseComponentTag;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.MaskedValueManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class FIELDComponent
extends BaseActionComponent {
    boolean m_withTextSelectionInfo = true;
    String m_textAttribute = ATT_text;

    @Override
    protected Object retrieveNullValueFromComponent(String attribute) {
        if (this.m_withTextSelectionInfo) {
            Object vb;
            if (BaseComponentTag.ATT_textselectioninfo.equals(attribute) && (vb = ExpressionManagerV.getExpressionFromComponentAttribute((UIComponent)this, attribute)) != null) {
                return "-1;-1;-1";
            }
            return null;
        }
        return null;
    }

    @Override
    protected void appendDecodeInformation(List<BaseComponent.DecodePassData> decodeInfos) {
        super.appendDecodeInformation(decodeInfos);
        if (this.m_withTextSelectionInfo) {
            decodeInfos.add(new BaseComponent.DecodePassData(".textselectioninfo", "textselectioninfo"));
        }
    }

    @Override
    protected String convertValueDuringDecode(String attribute, String value) {
        try {
            value = super.convertValueDuringDecode(attribute, value);
            if (value == null) {
                return value;
            }
            if (this.m_textAttribute.equals(attribute)) {
                String inputMaskValueMode = this.getAttributeValueAsString(ATT_inputmaskvaluemode);
                if ("withoutMask".equals(inputMaskValueMode)) {
                    return this.convertMaskedValueIntoNetValue(value);
                }
                return value;
            }
            return value;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Problem during decode value conversion: " + attribute + "/" + value, t);
            return value;
        }
    }

    @Override
    protected Object convertValueDuringGetAttribute(String attribute, Object value) {
        try {
            value = super.convertValueDuringGetAttribute(attribute, value);
            if (value == null) {
                return null;
            }
            if (this.m_textAttribute.equals(attribute)) {
                String inputMaskValueMode = this.getAttributeValueAsString(ATT_inputmaskvaluemode);
                if ("withoutMask".equals(inputMaskValueMode)) {
                    String strValue = ValueManager.convertObject2ValueString(value);
                    return this.convertNetValueIntoMaskedValue(strValue);
                }
                if ("withoutMask".equals(inputMaskValueMode)) {
                    String strValue = ValueManager.convertObject2ValueString(value);
                    return this.convertNetValueIntoMaskedValue(strValue);
                }
                return value;
            }
            return value;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Problem during get value conversion: " + attribute + "/" + value, t);
            return value;
        }
    }

    private String convertMaskedValueIntoNetValue(String value) {
        if (value == null) {
            return value;
        }
        String mask = this.getAttributeValueAsString(ATT_inputmask);
        if (mask == null) {
            return value;
        }
        char maskPlaceHolder = this.findMaskPlaceHolder();
        return MaskedValueManager.convertMaskedValueIntoNetValue(value, mask, maskPlaceHolder);
    }

    private char findMaskPlaceHolder() {
        char maskPlaceHolder = '_';
        String maskPlaceHolderStr = this.getAttributeValueAsString(ATT_inputmaskplaceholder);
        if (maskPlaceHolderStr != null && maskPlaceHolderStr.length() > 0) {
            maskPlaceHolder = maskPlaceHolderStr.charAt(0);
        }
        return maskPlaceHolder;
    }

    public static String junit_convertMaskedValueIntoNetValue(String value, String mask, char maskPlaceHolder) {
        return MaskedValueManager.convertMaskedValueIntoNetValue(value, mask, maskPlaceHolder);
    }

    private String convertNetValueIntoMaskedValue(String value) {
        if (value == null) {
            return value;
        }
        String mask = this.getAttributeValueAsString(ATT_inputmask);
        if (mask == null) {
            return value;
        }
        char maskPlaceHolder = this.findMaskPlaceHolder();
        return MaskedValueManager.convertNetValueIntoMaskedValue(value, mask, maskPlaceHolder);
    }

    public static String junit_convertNetValueIntoMaskedValue(String value, String mask, char maskPlaceHolder) {
        return MaskedValueManager.convertNetValueIntoMaskedValue(value, mask, maskPlaceHolder);
    }
}

