/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import java.io.IOException;
import java.io.Writer;
import java.util.Iterator;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.eclnt.jsfserver.elements.BaseHTMLActionComponent;
import org.eclnt.jsfserver.elements.impl.HTCOMBOBOXITEMComponentTag;
import org.eclnt.jsfserver.elements.util.ValidValuesBinding;
import org.eclnt.jsfserver.util.ExpressionManagerV;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.util.valuemgmt.XMLWriter;

public class HTCOMBOBOXComponent
extends BaseHTMLActionComponent {
    long m_lastChangeIndex = -1L;

    @Override
    public Object saveState(FacesContext context) {
        return new Object[]{super.saveState(context), this.m_lastChangeIndex};
    }

    @Override
    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this.m_lastChangeIndex = ((Long)values[1]).intValue();
    }

    @Override
    protected int getActionType() {
        return ACTIONTYPE_NEVER;
    }

    @Override
    public void encodeBegin(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        Object vb = this.getExpressionFromComponentAttribute("validvaluesbinding");
        if (vb != null) {
            try {
                ValidValuesBinding vvb = (ValidValuesBinding)ExpressionManagerV.getValue(context, vb);
                if (vvb != null && vvb.getChangeCounter() != this.m_lastChangeIndex) {
                    this.m_lastChangeIndex = vvb.getChangeCounter();
                    this.getChildren().clear();
                    Iterator<ValidValuesBinding.ValidValue> iter = vvb.getValidValues();
                    while (iter.hasNext()) {
                        ValidValuesBinding.ValidValue vv = iter.next();
                        HTCOMBOBOXITEMComponentTag cit = new HTCOMBOBOXITEMComponentTag();
                        cit.setValue(vv.getValue());
                        cit.setText(vv.getText());
                        this.getChildren().add(cit.createBaseComponent());
                    }
                    this.setRendersChildren(true);
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_ERR, "validvaluesbinding is defined, but error occurred in processing", t);
            }
        }
        ResponseWriter writer = context.getResponseWriter();
        String clientId = this.getClientId(context);
        XMLWriter.writer_writeFormattedText((Writer)writer, null, "\n\n<!-- HTCOMBOBOX begin -->\n");
        boolean flush = ValueManager.decodeBoolean(this.getAttributeValueAsString("flush"), false);
        if (flush) {
            super.addCallServerHiddenField(context, writer, ".FLUSH");
        }
        String width = this.writeTdAroundControl(writer, null, false);
        XMLWriter.writer_startElement((Writer)writer, null, "select");
        XMLWriter.writer_writeAttribute((Writer)writer, null, "name", clientId);
        XMLWriter.writer_writeAttribute((Writer)writer, null, "class", this.getCurrentStyleClass("classcombobox"));
        StringBuffer style = new StringBuffer();
        HTCOMBOBOXComponent.appendToStyle(style, this.getAttributeValueAsString("style"));
        if (width != null) {
            HTCOMBOBOXComponent.appendToStyle(style, "width:" + width);
        }
        if (style.length() > 0) {
            XMLWriter.writer_writeAttribute((Writer)writer, null, "style", style.toString());
        }
        if (flush) {
            this.addCallServerJavaScript(context, writer, "onChange", ".FLUSH");
        }
        if (!this.getCurrentEnabled()) {
            XMLWriter.writer_writeAttribute((Writer)writer, null, "disabled", "true");
        }
        XMLWriter.writer_closeStartElement((Writer)writer, null);
        boolean withNullItem = ValueManager.decodeBoolean(this.getAttributeValueAsString("withnullitem"), false);
        if (withNullItem) {
            XMLWriter.writer_startElement((Writer)writer, null, "option");
            XMLWriter.writer_closeStartElement((Writer)writer, null);
            XMLWriter.writer_endElement((Writer)writer, null, "option");
        }
        this.updateComponentBinding(context);
    }

    @Override
    public void encodeEnd(FacesContext context) throws IOException {
        if (!this.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        XMLWriter.writer_writeFormattedText((Writer)writer, null, "\n\n<!-- HTCOMBOBOX end -->\n");
        XMLWriter.writer_endElement((Writer)writer, null, "select");
        XMLWriter.writer_endElement((Writer)writer, null, "td");
    }

    public String getComboboxValue() {
        return this.getAttributeValueAsString("value");
    }

    @Override
    public void reactOnSetPropertiesByTagFinished() {
        super.reactOnSetPropertiesByTagFinished();
        Object vb = this.getExpressionFromComponentAttribute("validvaluesbinding");
        if (vb != null) {
            this.setRendersChildren(true);
        }
    }
}

