/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.impl;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.SerializedName;
import java.util.ArrayList;
import java.util.List;
import org.eclnt.jsfserver.elements.events.BaseActionEventInvoke;
import org.eclnt.jsfserver.elements.util.IValueByToString;

public class MULTILABELBinding
implements IValueByToString {
    MultiLabelInfo m_multiLabelInfo = new MultiLabelInfo();
    int m_changeIndex = 0;
    String m_lastJSONString = null;
    int m_lastWidth = 0;
    int m_lastJSONChangeIndex = -1;

    public void addTextInfo(TextInfo textInfo) {
        this.m_multiLabelInfo.m_textInfos.add(textInfo);
        ++this.m_changeIndex;
    }

    public void clear() {
        this.m_multiLabelInfo.m_textInfos.clear();
        ++this.m_changeIndex;
    }

    public int getChangeIndex() {
        return this.m_changeIndex;
    }

    public String toJSONString() {
        this.recalculate();
        return this.m_lastJSONString;
    }

    public String toString() {
        return this.toJSONString();
    }

    public int getWidth() {
        this.recalculate();
        return this.m_lastWidth;
    }

    public TextInfo getTextInfoForEvent(BaseActionEventInvoke event) {
        return this.getTextInfoForXPosition(event.getX());
    }

    public TextInfo getTextInfoForXPosition(int x) {
        int total = 0;
        for (TextInfo ti : this.m_multiLabelInfo.m_textInfos) {
            if (x >= total && x < total + ti.i_width) {
                return ti;
            }
            total += ti.i_width;
        }
        return null;
    }

    public List<TextInfo> getAllTextInfos() {
        return this.m_multiLabelInfo.m_textInfos;
    }

    private void recalculate() {
        if (this.m_lastJSONChangeIndex == this.m_changeIndex) {
            return;
        }
        this.m_lastJSONChangeIndex = this.m_changeIndex;
        Gson gson = new GsonBuilder().create();
        this.m_lastJSONString = gson.toJson((Object)this.m_multiLabelInfo);
        this.m_lastWidth = 0;
        for (TextInfo ti : this.m_multiLabelInfo.m_textInfos) {
            this.m_lastWidth += ti.getWidth();
        }
    }

    public static class MultiLabelInfo {
        @SerializedName(value="textInfos")
        List<TextInfo> m_textInfos = new ArrayList<TextInfo>();
    }

    public static class TextInfo {
        transient String i_id;
        @SerializedName(value="text")
        String i_text = "";
        @SerializedName(value="width")
        int i_width = 100;
        @SerializedName(value="foreground")
        String i_foreground;
        @SerializedName(value="background")
        String i_background;
        @SerializedName(value="align")
        String i_align;
        @SerializedName(value="font")
        String i_font;
        @SerializedName(value="image")
        String i_image;

        public String getId() {
            return this.i_id;
        }

        public TextInfo setId(String id) {
            this.i_id = id;
            return this;
        }

        public String getText() {
            return this.i_text;
        }

        public TextInfo setText(String text) {
            this.i_text = text;
            return this;
        }

        public String getForeground() {
            return this.i_foreground;
        }

        public TextInfo setForeground(String foreground) {
            this.i_foreground = foreground;
            return this;
        }

        public int getWidth() {
            return this.i_width;
        }

        public TextInfo setWidth(int width) {
            this.i_width = width;
            return this;
        }

        public String getBackground() {
            return this.i_background;
        }

        public TextInfo setBackground(String background) {
            this.i_background = background;
            return this;
        }

        public String getAlign() {
            return this.i_align;
        }

        public TextInfo setAlign(String align) {
            this.i_align = align;
            return this;
        }

        public String getFont() {
            return this.i_font;
        }

        public TextInfo setFont(String font) {
            this.i_font = font;
            return this;
        }

        public String getImage() {
            return this.i_image;
        }

        public TextInfo setImage(String image) {
            this.i_image = image;
            return this;
        }
    }
}

