/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.elements.util;

import java.util.List;
import org.eclnt.jsfserver.elements.impl.FIXGRIDBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDComponent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDExportSanitizer;
import org.eclnt.jsfserver.elements.impl.IFIXGRIDHtmlExporter;
import org.eclnt.jsfserver.elements.util.ENUMExportType;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.valuemgmt.ValueManager;

public class FIXGRIDHtmlExporter
implements IFIXGRIDHtmlExporter {
    String m_templatePath = "org/eclnt/jsfserver/elements/util/FIXGRIDHtmlExporter_template.txt";
    String m_gridTitle = null;
    String m_styleClassDataTable = "datatable";
    String m_styleClassDataCell = "datacell";
    String m_styleClassHeaderCell = "headercell";
    String m_styleClassFooterCell = "footercell";

    public String getGridTitle() {
        return this.m_gridTitle;
    }

    @Override
    public void setGridTitle(String gridTitle) {
        this.m_gridTitle = gridTitle;
    }

    public String getStyleClassDataTable() {
        return this.m_styleClassDataTable;
    }

    public void setStyleClassDataTable(String styleClassDataTable) {
        this.m_styleClassDataTable = styleClassDataTable;
    }

    public String getStyleClassDataCell() {
        return this.m_styleClassDataCell;
    }

    public void setStyleClassDataCell(String styleClassDataCell) {
        this.m_styleClassDataCell = styleClassDataCell;
    }

    public String getStyleClassHeaderCell() {
        return this.m_styleClassHeaderCell;
    }

    public void setStyleClassHeaderCell(String styleClassHeaderCell) {
        this.m_styleClassHeaderCell = styleClassHeaderCell;
    }

    public String getStyleClassFooterCell() {
        return this.m_styleClassFooterCell;
    }

    public void setStyleClassFooterCell(String styleClassFooterCell) {
        this.m_styleClassFooterCell = styleClassFooterCell;
    }

    public String getTemplatePath() {
        return this.m_templatePath;
    }

    public void setTemplatePath(String templateName) {
        this.m_templatePath = templateName;
    }

    @Override
    public String exportGridToHtml(FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<List<String>> data, boolean selctedItemsOnly) {
        FIXGRIDExportSanitizer.instance().sanitizeStringDataBeforeExport(ENUMExportType.HTML, data);
        StringBuffer html = new StringBuffer();
        if (this.m_gridTitle != null) {
            this.exportTitle(html, fixgrid, columns, data);
        }
        this.openHtmlTable(html);
        this.exportHeaderRows(html, fixgrid, columns);
        this.exportBodyRows(html, fixgrid, columns, data);
        this.exportFooterRows(html, fixgrid, columns);
        this.closeHtmlTable(html);
        String template = this.readTemplate();
        template = template.replace("@CONTENT@", html.toString());
        return template;
    }

    protected String readTemplate() {
        return new ClassloaderReader(true).readUTF8File(this.m_templatePath, true);
    }

    protected void exportBodyRows(StringBuffer html, FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<List<String>> data) {
        this.exportBodyBegin(html, fixgrid);
        int counter = -1;
        for (List<String> dataRow : data) {
            this.exportBodyRow(html, fixgrid, columns, dataRow, ++counter);
        }
        this.exportBodyEnd(html, fixgrid);
    }

    protected void exportBodyBegin(StringBuffer html, FIXGRIDBinding fixgrid) {
        html.append("<tbody>\n");
    }

    protected void exportBodyEnd(StringBuffer html, FIXGRIDBinding fixgrid) {
        html.append("</tbody>\n");
    }

    private void exportBodyRow(StringBuffer html, FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<String> row, int counter) {
        html.append("<tr " + this.addBodyTr() + ">\n");
        for (int i = 0; i < row.size(); ++i) {
            FIXGRIDComponent.ColumnInfo ci = columns.get(i);
            this.exportBodyCol(html, fixgrid, ci, row, counter, i);
        }
        html.append("</tr>\n");
    }

    protected void exportBodyCol(StringBuffer html, FIXGRIDBinding fixgrid, FIXGRIDComponent.ColumnInfo ci, List<String> row, int rowCounter, int colCounter) {
        String style = this.findStyleForBodyCol(fixgrid, ci, row, rowCounter, colCounter);
        html.append("<td class='" + this.m_styleClassDataCell + "' style='" + style + "' " + this.addBodyTd() + ">");
        String cellValue = this.findCellValue(fixgrid, rowCounter, colCounter, row, ci);
        html.append(cellValue);
        html.append("</td>\n");
    }

    protected String findStyleForBodyCol(FIXGRIDBinding fixgrid, FIXGRIDComponent.ColumnInfo ci, List<String> row, int rowCounter, int colCounter) {
        String align;
        String textColor;
        String style = "";
        String colData = row.get(colCounter);
        String background = this.findBackgroundtForDataCell(colCounter, colData, ci);
        if (background != null) {
            style = style + "background-color:" + background + ";";
        }
        if ((textColor = this.findTextColorForDataCell(colCounter, colData, ci)) != null) {
            style = style + "color:" + textColor + ";";
        }
        if ((align = this.findAlignmentForDataCell(colCounter, colData, ci)) != null) {
            style = style + "text-align:" + align + ";";
        }
        return style;
    }

    protected String findCellValue(FIXGRIDBinding fixgrid, int rowCounter, int colCounter, List<String> row, FIXGRIDComponent.ColumnInfo ci) {
        return this.sanitizeCellContentString(row.get(colCounter));
    }

    protected void openHtmlTable(StringBuffer html) {
        html.append("<table class='datatable' " + this.addTable() + ">\n");
    }

    protected void closeHtmlTable(StringBuffer html) {
        html.append("</table>\n");
    }

    protected void exportHeaderRows(StringBuffer html, FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns) {
        List<List<FIXGRIDBinding.FormattedValue>> headerRows = this.readHeaderRows(fixgrid);
        FIXGRIDExportSanitizer.instance().sanitizeValueDataBeforeExport(ENUMExportType.HTML, headerRows);
        if (headerRows.size() > 0) {
            html.append("<thead>\n");
            int rowCounter = -1;
            for (List<FIXGRIDBinding.FormattedValue> row : headerRows) {
                this.exportHeaderRow(html, fixgrid, columns, row, ++rowCounter);
            }
            html.append("</thead>\n");
        }
    }

    protected void exportHeaderRow(StringBuffer html, FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<FIXGRIDBinding.FormattedValue> row, int rowCounter) {
        html.append("<tr " + this.addHeaderTr() + ">\n");
        for (int i = 0; i < row.size(); ++i) {
            String style = this.findStyleForHeaderCol(fixgrid, columns, row, rowCounter, i);
            int colspan = this.findColspan(row, i);
            html.append("<th class='" + this.m_styleClassHeaderCell + "' style='" + style + "' colspan='" + colspan + "' " + this.addHeaderTh() + ">");
            html.append(this.sanitizeCellContentString(row.get(i).toDisplayString()));
            html.append("</th>\n");
            if (colspan <= 1) continue;
            i += colspan - 1;
        }
        html.append("</tr>\n");
    }

    protected String findStyleForHeaderCol(FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<FIXGRIDBinding.FormattedValue> row, int rowCounter, int colCounter) {
        String align;
        String textColor;
        String style = "";
        FIXGRIDComponent.ColumnInfo ci = columns.get(colCounter);
        String background = this.findBackgroundColorForHeaderCell(rowCounter, row.get(colCounter).toDisplayString(), columns.get(colCounter));
        if (background != null) {
            style = style + "background-color:" + background + ";";
        }
        if ((textColor = this.findTextColorForHeaderCell(rowCounter, row.get(colCounter).toDisplayString(), columns.get(colCounter))) != null) {
            style = style + "color:" + textColor + ";";
        }
        if ((align = this.findAlignmentForHeaderCell(rowCounter, row.get(colCounter), columns.get(colCounter))) != null) {
            style = style + "text-align:" + align + ";";
        }
        return style;
    }

    protected void exportFooterRows(StringBuffer html, FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns) {
        List<List<FIXGRIDBinding.FormattedValue>> footerRows = this.readFooterRows(fixgrid);
        FIXGRIDExportSanitizer.instance().sanitizeValueDataBeforeExport(ENUMExportType.HTML, footerRows);
        if (footerRows.size() > 0) {
            html.append("<tfoot>\n");
            int rowCounter = -1;
            for (List<FIXGRIDBinding.FormattedValue> row : footerRows) {
                this.exportFooterRow(html, fixgrid, columns, row, ++rowCounter);
            }
            html.append("</tfoot>\n");
        }
    }

    protected void exportFooterRow(StringBuffer html, FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<FIXGRIDBinding.FormattedValue> row, int rowCounter) {
        html.append("<tr " + this.addFooterTr() + ">\n");
        for (int i = 0; i < row.size(); ++i) {
            String style = this.findStyleForFooterCol(fixgrid, columns, row, rowCounter, i);
            int colspan = this.findColspan(row, i);
            html.append("<th class='" + this.m_styleClassFooterCell + "' style='" + style + "' colspan='" + colspan + "' " + this.addFooterTh() + ">");
            html.append(this.sanitizeCellContentString(row.get(i).toDisplayString()));
            html.append("</th>\n");
            if (colspan <= 1) continue;
            i += colspan - 1;
        }
        html.append("</tr>\n");
    }

    protected String findStyleForFooterCol(FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<FIXGRIDBinding.FormattedValue> row, int rowCounter, int colCounter) {
        String align;
        String textColor;
        String style = "";
        FIXGRIDComponent.ColumnInfo ci = columns.get(colCounter);
        String background = this.findBackgroundColorForFooterCell(rowCounter, row.get(colCounter).toDisplayString(), columns.get(colCounter));
        if (background != null) {
            style = style + "background-color:" + background + ";";
        }
        if ((textColor = this.findTextColorForFooterCell(rowCounter, row.get(colCounter).toDisplayString(), columns.get(colCounter))) != null) {
            style = style + "color:" + textColor + ";";
        }
        if ((align = this.findAlignmentForFooterCell(rowCounter, row.get(colCounter), columns.get(colCounter))) != null) {
            style = style + "text-align:" + align + ";";
        }
        return style;
    }

    protected List<List<FIXGRIDBinding.FormattedValue>> readFooterRows(FIXGRIDBinding fixgrid) {
        return fixgrid.getExporter().getFooterHeaderRowValues(true);
    }

    protected List<List<FIXGRIDBinding.FormattedValue>> readHeaderRows(FIXGRIDBinding fixgrid) {
        return fixgrid.getExporter().getFooterHeaderRowValues(false);
    }

    protected void exportTitle(StringBuffer html, FIXGRIDBinding fixgrid, List<FIXGRIDComponent.ColumnInfo> columns, List<List<String>> data) {
        html.append("<p class='title'>" + this.m_gridTitle + "</p>");
    }

    private int findColspan(List<FIXGRIDBinding.FormattedValue> row, int currentIndex) {
        String value;
        int colspan = 1;
        for (int i = currentIndex + 1; i < row.size() && ValueManager.checkIfStringsAreEqual(value = row.get(i).toString(), ".%."); ++i) {
            ++colspan;
        }
        return colspan;
    }

    protected String sanitizeCellContentString(String s) {
        return ValueManager.encodeIntoValidXMLValueString(s);
    }

    protected String findAlignmentForHeaderCell(int rowIndex, FIXGRIDBinding.FormattedValue dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        return this.updateAlignment(dataCellValue.getAlign());
    }

    protected String findAlignmentForFooterCell(int rowIndex, FIXGRIDBinding.FormattedValue dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        return this.updateAlignment(dataCellValue.getAlign());
    }

    protected String findAlignmentForDataCell(int rowIndex, String dataCellValue, FIXGRIDComponent.ColumnInfo column) {
        return this.updateAlignment(column.getAlignment());
    }

    protected String findTextColorForDataCell(int i, String string, FIXGRIDComponent.ColumnInfo columnInfo) {
        return null;
    }

    protected String findBackgroundtForDataCell(int i, String string, FIXGRIDComponent.ColumnInfo columnInfo) {
        return null;
    }

    protected String findTextColorForHeaderCell(int rowCounter, String string, FIXGRIDComponent.ColumnInfo columnInfo) {
        return null;
    }

    protected String findBackgroundColorForHeaderCell(int rowCounter, String string, FIXGRIDComponent.ColumnInfo columnInfo) {
        return null;
    }

    protected String findTextColorForFooterCell(int rowCounter, String string, FIXGRIDComponent.ColumnInfo columnInfo) {
        return null;
    }

    protected String findBackgroundColorForFooterCell(int rowCounter, String string, FIXGRIDComponent.ColumnInfo columnInfo) {
        return null;
    }

    protected String addTable() {
        return "";
    }

    protected String addBodyTr() {
        return "";
    }

    protected String addBodyTd() {
        return "";
    }

    protected String addHeaderTr() {
        return "";
    }

    protected String addFooterTr() {
        return "";
    }

    protected String addHeaderTh() {
        return "";
    }

    protected String addFooterTh() {
        return "";
    }

    private String updateAlignment(String alignment) {
        if (alignment == null) {
            return null;
        }
        alignment = alignment.replace("!", "");
        return alignment;
    }
}

