/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.pagebean;

import java.util.HashMap;
import java.util.Map;
import org.eclnt.jsfserver.defaultscreens.BasePopup;
import org.eclnt.jsfserver.defaultscreens.ModalPopup;
import org.eclnt.jsfserver.defaultscreens.ModelessPopup;
import org.eclnt.jsfserver.elements.pagemodifier.IPageModifier;
import org.eclnt.jsfserver.pagebean.IPageBean;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponentRepository;
import org.eclnt.jsfserver.util.PageReader;
import org.eclnt.jsfserver.util.valuemgmt.IDynamicContentBindingObject;
import org.eclnt.util.log.CLog;

public abstract class PageBean
implements IPageBean,
IDynamicContentBindingObject {
    static int s_stampCounter = 1;
    int m_popupCounter = 0;
    String m_actualRootExpression;
    Map<String, IPageBean> m_popupPageBeans = new HashMap<String, IPageBean>(0);
    Map<String, BasePopup> m_popups = new HashMap<String, BasePopup>(0);
    protected IPageModifier m_pageModifier = null;
    private int m_stamp = s_stampCounter++;

    public PageBean() {
        if (this.m_stamp == 0) {
            ++s_stampCounter;
        }
        this.initializePageModifier();
    }

    @Override
    public abstract String getPageName();

    @Override
    public abstract String getRootExpressionUsedInPage();

    @Override
    public final IPageModifier getPageModifier() {
        return this.m_pageModifier;
    }

    @Override
    public final String getActualRootExpression() {
        String result = this.m_actualRootExpression != null ? this.m_actualRootExpression : this.getRootExpressionUsedInPage();
        if (CLog.L.isLoggable(CLog.LL_DBG)) {
            CLog.L.log(CLog.LL_DBG, "Root expression, get was called: result = " + result);
        }
        return result;
    }

    @Override
    public final void setActualRootExpression(String rootExpression) {
        this.m_actualRootExpression = rootExpression;
        if (CLog.L.isLoggable(CLog.LL_DBG)) {
            CLog.L.log(CLog.LL_DBG, "Root expression was set to: " + rootExpression);
        }
        for (String key : this.m_popupPageBeans.keySet()) {
            IPageBean pageBean = this.m_popupPageBeans.get(key);
            String actualExpressionOfPopup = this.m_actualRootExpression;
            actualExpressionOfPopup = actualExpressionOfPopup.substring(0, actualExpressionOfPopup.length() - 1) + ".popups." + key + "}";
            pageBean.setActualRootExpression(actualExpressionOfPopup);
            BasePopup popup = this.m_popups.get(key);
            popup.setContentReplace(this.buildContentReplaceString(pageBean));
            popup.setPopupPageBeanExpression(actualExpressionOfPopup);
        }
    }

    public Map<String, IPageBean> getPopups() {
        return this.m_popupPageBeans;
    }

    public BasePopup getModalModelessPopupForPopupPageBean(IPageBean pageBean) {
        if (pageBean == null) {
            return null;
        }
        for (String key : this.m_popupPageBeans.keySet()) {
            IPageBean pb = this.m_popupPageBeans.get(key);
            if (pb != pageBean) continue;
            return this.m_popups.get(key);
        }
        return null;
    }

    @Override
    public ModalPopup openModalPopup(IPageBean pageBean, String title, int width, int height, ModalPopup.IModalPopupListener popupListener) {
        if (pageBean == this) {
            throw new Error("You cannot open a pageBean as dialog on its own instance.");
        }
        this.closePopup(pageBean);
        String key = "P" + this.m_popupCounter;
        ++this.m_popupCounter;
        String actualExpressionOfPopup = this.getActualRootExpression();
        actualExpressionOfPopup = actualExpressionOfPopup.substring(0, actualExpressionOfPopup.length() - 1) + ".popups." + key + "}";
        pageBean.setActualRootExpression(actualExpressionOfPopup);
        this.m_popupPageBeans.put(key, pageBean);
        ModalPopup mp = ModalPopup.createInstance();
        mp.open(pageBean.getPageName(), title, width, height, popupListener);
        mp.setContentReplace(this.buildContentReplaceString(pageBean));
        mp.setStartfromrootwindow(false);
        mp.setPopupPageBeanExpression(actualExpressionOfPopup);
        this.m_popups.put(key, mp);
        return mp;
    }

    @Override
    public void closePopup(IPageBean pageBean) {
        String[] keys = new String[this.m_popupPageBeans.size()];
        this.m_popupPageBeans.keySet().toArray(keys);
        for (String key : keys) {
            IPageBean pageBeanForKey = this.m_popupPageBeans.get(key);
            if (pageBeanForKey != pageBean) continue;
            BasePopup popup = this.m_popups.get(key);
            popup.close();
            this.m_popups.remove(key);
            this.m_popupPageBeans.remove(key);
        }
    }

    @Override
    public ModelessPopup openModelessPopup(IPageBean pageBean, String title, int width, int height, ModelessPopup.IModelessPopupListener popupListener) {
        if (pageBean == this) {
            throw new Error("You cannot open a pageBean as dialog on its own instance.");
        }
        this.closePopup(pageBean);
        String key = "P" + this.m_popupCounter;
        ++this.m_popupCounter;
        String actualExpressionOfPopup = this.getActualRootExpression();
        actualExpressionOfPopup = actualExpressionOfPopup.substring(0, actualExpressionOfPopup.length() - 1) + ".popups." + key + "}";
        pageBean.setActualRootExpression(actualExpressionOfPopup);
        this.m_popupPageBeans.put(key, pageBean);
        ModelessPopup mp = ModelessPopup.createInstance();
        mp.open(pageBean.getPageName(), title, width, height, popupListener);
        mp.setContentReplace(this.buildContentReplaceString(pageBean));
        mp.setStartfromrootwindow(false);
        mp.setPopupPageBeanExpression(actualExpressionOfPopup);
        this.m_popups.put(key, mp);
        return mp;
    }

    public String pbx(String partialExpression) {
        if (partialExpression == null) {
            return null;
        }
        String rex = this.getRootExpressionUsedInPage();
        if (rex == null) {
            return null;
        }
        return rex.replace("}", "." + partialExpression + "}");
    }

    public String readPageLayoutXML() {
        return PageReader.readXMLForAbsolutePageName(this.getPageName());
    }

    @Override
    public void onBeforeRendering() {
    }

    @Override
    public long getStamp() {
        return this.m_stamp;
    }

    public String buildContentReplaceString(IPageBean pageBean) {
        String replaceFrom = pageBean.getRootExpressionUsedInPage();
        String replaceTo = pageBean.getActualRootExpression();
        if (replaceTo != null && replaceFrom != null) {
            replaceFrom = replaceFrom.substring(0, replaceFrom.length() - 1);
            replaceTo = replaceTo.substring(0, replaceTo.length() - 1);
            return replaceFrom + ":" + replaceTo;
        }
        return null;
    }

    protected void initializePageModifier() {
        this.m_pageModifier = PageBeanComponentRepository.readPageModification(this.getClass());
    }
}

