/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclnt.editor.tools.ProjectInfo;
import org.eclnt.jsfserver.managedbean.HotDeployManager;
import org.eclnt.jsfserver.pagebean.component.PageBeanComponentRepository;
import org.eclnt.jsfserver.starter.RISCStarter;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.jsfserver.util.style.StyleFileAccess;
import org.eclnt.tool.BuildCSSViaXML;
import org.eclnt.tool.CSSStyleClass;
import org.eclnt.util.file.ClassloaderReader;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class CSSStyleManager {
    static Map<String, RuntimeStyleFiles> s_runtimeBuffer = new HashMap<String, RuntimeStyleFiles>();
    private static final Object s_syncher = new Object();

    public static String findCSSFilesAsCSVString(String ccStyleName) {
        List<String> result = CSSStyleManager.findCSSFiles(ccStyleName, false);
        return ValueManager.encodeCSV(result);
    }

    public static List<String> findCSSFiles(String styleName, boolean filterAgainstSystemlXml) {
        if (styleName == null) {
            styleName = "defaultrisc";
        }
        String cssVersionStamp = RISCStarter.buildStyleVersionStamp(styleName);
        ArrayList<String> cssList = new ArrayList<String>();
        List<String> cssSet = StyleFileAccess.findFiles("/eclntjsfserver/styles/" + styleName + "/", ".css");
        cssList.addAll(cssSet);
        Collections.sort(cssList);
        ArrayList<String> result = new ArrayList<String>();
        result.add("eclntjsfserver/styles/" + styleName + "/riscstyle.css" + cssVersionStamp);
        for (String css : cssList) {
            if (css.endsWith(".risc.css") || css.equals("riscstyle.css")) continue;
            String cssPath = "eclntjsfserver/styles/" + styleName + "/" + css;
            if (filterAgainstSystemlXml && CSSStyleManager.checkIfAlreadyIncludedInSystemXmlCssDefinitions(cssPath)) continue;
            result.add(cssPath + cssVersionStamp);
        }
        return result;
    }

    public static String readCSS(String styleName) {
        return CSSStyleManager.readStyleFiles((String)styleName).i_css;
    }

    public static List<CSSStyleClass> readCSSStyleClasses(String styleName) {
        return CSSStyleManager.readStyleFiles((String)styleName).i_cssStyleClasses;
    }

    public static String readJSON(String styleName) {
        return CSSStyleManager.readStyleFiles((String)styleName).i_json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reset() {
        Object object = s_syncher;
        synchronized (object) {
            s_runtimeBuffer.clear();
        }
    }

    public static String readRiscStyleXMLDesignTime(ProjectInfo pi, String styleName, ClassLoader cl) {
        String styleDir = pi.getStyleDirectoryName(styleName);
        String styleFileName = CSSStyleManager.findRiscStyleNameInDirectory(styleDir);
        String cssXml = FileManager.readUTF8File(styleDir + styleFileName, true);
        String result = CSSStyleManager.combineCSSStyleWithAdditionalStyles(cssXml, styleName, styleFileName, cl);
        return result;
    }

    public static String findRiscStyleNameInDirectory(String directory) {
        List<File> files = FileManager.getFilesOfDirectory(directory);
        for (File file : files) {
            String fileName = file.getName();
            if (!fileName.startsWith("riscstyle") || !fileName.endsWith(".xml") || file.length() <= 0L) continue;
            return fileName;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static RuntimeStyleFiles readStyleFiles(String styleName) {
        try {
            CLog.L.log(CLog.LL_INF, "STYLEMGMT: readStyleFiles started: " + styleName);
            RuntimeStyleFiles result = s_runtimeBuffer.get(styleName);
            if (result == null) {
                Object object = s_syncher;
                synchronized (object) {
                    result = s_runtimeBuffer.get(styleName);
                    if (result == null) {
                        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Reading style: " + styleName);
                        result = CSSStyleManager.readRuntimeStyle(styleName);
                        s_runtimeBuffer.put(styleName, result);
                        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Reading style finished");
                    }
                }
            }
            CLog.L.log(CLog.LL_INF, "STYLEMGMT: readStyleFiles finished: " + styleName);
            return result;
        }
        catch (Throwable t) {
            throw new Error("Problem reading style files for style: " + styleName, t);
        }
    }

    private static RuntimeStyleFiles readRuntimeStyle(String styleName) {
        ArrayList<String> xmlParts = new ArrayList<String>();
        List<String> styleInheritanceSequence = StyleManager.getStyleExtensionSequence(styleName);
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Reading riscstyle-xmls");
        for (String style : styleInheritanceSequence) {
            CLog.L.log(CLog.LL_INF, "STYLEMGMT: Reading riscstyle-xmls - Style: " + style);
            String xml = CSSStyleManager.readRiscStyleXML(style);
            xmlParts.add(xml);
        }
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Processing style");
        boolean edged = true;
        List<String> extSeqNames = StyleManager.getStyleExtensionSequence(styleName);
        for (String extSeqName : extSeqNames) {
            if (!"ccclassicrisc".equals(extSeqName)) continue;
            edged = false;
            break;
        }
        BuildCSSViaXML.StyleGenerationResult sgr = BuildCSSViaXML.process(styleName, xmlParts, edged);
        CLog.L.log(CLog.LL_INF, "STYLEMGMT: Processing style - finished");
        RuntimeStyleFiles result = new RuntimeStyleFiles();
        result.i_css = sgr.getCss();
        result.i_json = sgr.getJson();
        result.i_cssStyleClasses = sgr.getCssStyleClasses();
        return result;
    }

    public static String readRiscStyleXML(String styleName) {
        String path = "/eclntjsfserver/styles/" + styleName;
        String styleXMLFileName = null;
        String styleXML = null;
        List<String> candidates = StyleFileAccess.findFiles(path, ".xml");
        for (String candidate : candidates) {
            if (!candidate.startsWith("riscstyle")) continue;
            styleXMLFileName = candidate;
            String wholePath = path + "/" + styleXMLFileName;
            styleXML = StyleFileAccess.readStyleUTF8File(wholePath);
            if (styleXML != null && styleXML.length() > 0) break;
            styleXMLFileName = null;
            styleXML = null;
        }
        if (styleXMLFileName == null) {
            throw new Error("Could not find riscstyle*.xml for style: " + styleName);
        }
        String result = CSSStyleManager.combineCSSStyleWithAdditionalStyles(styleXML, styleName, styleXMLFileName, HotDeployManager.currentClassLoader());
        return result;
    }

    public static String combineCSSStyleWithAdditionalStyles(String cssXml, String styleName, String styleXMLFileName, ClassLoader cl) {
        StringBuffer sb = new StringBuffer();
        sb.append("<stylesheets>\n");
        sb.append(cssXml);
        sb.append("\n");
        if (cl != null) {
            ClassloaderReader clReader = new ClassloaderReader(cl);
            List<String> extensions = clReader.readUTF8FilesWithVariants("/eclntjsfserver/styleextensions/" + styleName + "/" + styleXMLFileName);
            for (String extension : extensions) {
                if (extension == null || extension.length() <= 0) continue;
                sb.append(extension);
                sb.append("\n");
            }
            List<String> addonPackages = PageBeanComponentRepository.readPackageNamesOfStyleExtensions(cl);
            for (String p : addonPackages) {
                try {
                    String resourcePath = "/" + p.replace(".", "/") + "/" + styleName + "/" + styleXMLFileName;
                    String pxml = clReader.readUTF8File(resourcePath, false);
                    if (pxml == null || pxml.length() <= 0) continue;
                    sb.append(pxml);
                    sb.append("\n");
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_ERR, "Problem reading style extension of package: " + p);
                }
            }
        }
        sb.append("</stylesheets>");
        return sb.toString();
    }

    private static boolean checkIfAlreadyIncludedInSystemXmlCssDefinitions(String cssPath) {
        for (SystemXml.RISCClientStyle rss : SystemXml.getRISCClientStyles()) {
            if (rss.getSrc() == null || !rss.getSrc().trim().equals(cssPath)) continue;
            return true;
        }
        return false;
    }

    static class RuntimeStyleFiles {
        String i_json;
        String i_css;
        List<CSSStyleClass> i_cssStyleClasses;

        RuntimeStyleFiles() {
        }
    }
}

