/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.awt.Dimension;
import java.io.IOException;
import java.net.URLDecoder;
import java.util.Hashtable;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclnt.jsfserver.util.CCServletBaseWithContextMgmt;
import org.eclnt.jsfserver.util.ServletUtil;
import org.eclnt.util.image.ServerImageManager;
import org.eclnt.util.log.CLog;

public class ImageSizeServlet
extends CCServletBaseWithContextMgmt {
    public Map<String, Dimension> s_bufferedSizes = new Hashtable<String, Dimension>();

    @Override
    protected boolean checkIfToAbortOnMissingHttpSession(HttpServletRequest req) {
        return false;
    }

    @Override
    protected void processRequest(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        try {
            String uri = req.getRequestURI();
            uri = URLDecoder.decode(uri, "UTF-8");
            int index = uri.indexOf("/ccimagesize/");
            String image = uri.substring(index + "/ccimagesize/".length());
            if ("ccExtURL".equals(image)) {
                image = req.getParameter("url");
            }
            Dimension d = this.getImageSize(image);
            String result = d.width + ";" + d.height;
            ServletUtil.setResponseContentType(resp, "text/plain");
            resp.getWriter().write(result);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Problem finding image size for: " + req.getRequestURI(), t);
            ServletUtil.setResponseContentType(resp, "text/plain");
            resp.getWriter().write("ERROR");
        }
    }

    protected Dimension getImageSize(String imageName) throws Exception {
        int index;
        if (imageName.startsWith("ccdynamicimage/")) {
            imageName = "/" + imageName;
        }
        if (imageName.startsWith("ccbuffer/")) {
            imageName = "/" + imageName;
        }
        if (imageName.startsWith("cctempfileaccess/") && (index = (imageName = "/" + imageName).indexOf(";")) >= 0) {
            imageName = imageName.substring(0, index);
        }
        return ServerImageManager.getInstance().getDimensionOfImage(imageName);
    }
}

