/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import javax.faces.el.EvaluationException;
import javax.faces.el.PropertyNotFoundException;
import javax.faces.el.PropertyResolver;
import org.eclnt.jsfserver.util.IAcceleratedPropertyAccess;
import org.eclnt.jsfserver.util.IPropertyResolverAware;
import org.eclnt.jsfserver.util.IPropertyTypeResolver;
import org.eclnt.jsfserver.util.IPropertyValueConverter;
import org.eclnt.jsfserver.util.InitEclntJsfServer;
import org.eclnt.util.log.CLog;

public class LastPropertyResolverByDelegation
extends PropertyResolver {
    PropertyResolver m_delegateTo;

    public LastPropertyResolverByDelegation(PropertyResolver delegateTo) {
        this.m_delegateTo = delegateTo;
    }

    public Class getType(Object arg0, Object arg1) throws EvaluationException, PropertyNotFoundException {
        Class result = null;
        if (arg0 instanceof IPropertyTypeResolver) {
            try {
                result = ((IPropertyTypeResolver)arg0).resolveType(arg1.toString());
                if (result != null) {
                    return result;
                }
            }
            catch (Throwable t) {
                CLog.L.log(CLog.LL_WAR, "Error in IPropertyTypeResolver: " + t.toString());
            }
        }
        try {
            return this.m_delegateTo.getType(arg0, arg1);
        }
        catch (Throwable throwable) {
            return Object.class;
        }
    }

    public Class getType(Object arg0, int arg1) throws EvaluationException, PropertyNotFoundException {
        try {
            return this.m_delegateTo.getType(arg0, arg1);
        }
        catch (Throwable throwable) {
            return Object.class;
        }
    }

    public Object getValue(Object object, Object property) throws EvaluationException, PropertyNotFoundException {
        try {
            Object result;
            if (object != null && object instanceof IAcceleratedPropertyAccess && (result = ((IAcceleratedPropertyAccess)object).getPropertyValue(property.toString())) != IAcceleratedPropertyAccess.NOT_AVAILABLE) {
                return result;
            }
            result = this.m_delegateTo.getValue(object, property);
            return result;
        }
        catch (Throwable t) {
            CLog.L.log(InitEclntJsfServer.s_logLevelMissingPropertyGet, "No property value available for: " + object + "/" + property);
            if (CLog.L.isLoggable(CLog.LL_DBG)) {
                CLog.L.log(CLog.LL_DBG, "No property value available for: " + object + "/" + property, t);
            }
            return null;
        }
    }

    public Object getValue(Object arg0, int arg1) throws EvaluationException, PropertyNotFoundException {
        Object result = this.m_delegateTo.getValue(arg0, arg1);
        return result;
    }

    public boolean isReadOnly(Object arg0, int arg1) throws EvaluationException, PropertyNotFoundException {
        return this.m_delegateTo.isReadOnly(arg0, arg1);
    }

    public boolean isReadOnly(Object arg0, Object arg1) throws EvaluationException, PropertyNotFoundException {
        return this.m_delegateTo.isReadOnly(arg0, arg1);
    }

    public void setValue(Object object, int arrayIndex, Object value) throws EvaluationException, PropertyNotFoundException {
        try {
            if (object instanceof IPropertyValueConverter) {
                value = ((IPropertyValueConverter)object).convertObject(arrayIndex, value);
            }
            if (CLog.L.isLoggable(CLog.LL_INF)) {
                try {
                    CLog.L.log(CLog.LL_INF, "Setting property: " + arrayIndex);
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.m_delegateTo.setValue(object, arrayIndex, value);
            if (object instanceof IPropertyResolverAware) {
                ((IPropertyResolverAware)object).reactOnSetValue(arrayIndex, value);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when setting property: " + object + "/" + arrayIndex);
            CLog.L.log(CLog.LL_ERR, "Error when setting property: " + t.toString());
            throw new Error(t);
        }
    }

    public void setValue(Object object, Object property, Object value) throws EvaluationException, PropertyNotFoundException {
        try {
            if (object instanceof IPropertyValueConverter) {
                value = ((IPropertyValueConverter)object).convertObject(property, value);
            }
            if (CLog.L.isLoggable(CLog.LL_INF)) {
                try {
                    CLog.L.log(CLog.LL_INF, "Setting property: " + property.toString());
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            this.m_delegateTo.setValue(object, property, value);
            if (object instanceof IPropertyResolverAware) {
                ((IPropertyResolverAware)object).reactOnSetValue(property, value);
            }
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when setting property: " + object + "/" + property);
            CLog.L.log(CLog.LL_ERR, "Error when setting property: " + t.toString());
            throw new Error(t);
        }
    }
}

