/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util;

import java.awt.Color;
import java.util.HashSet;
import java.util.Set;
import org.eclnt.jsfserver.util.StyleManager;
import org.eclnt.util.valuemgmt.ValueManager;

public class StyleUtil {
    public static boolean checkIfColorIsDark(String color) {
        try {
            Color c = ValueManager.decodeColor(color);
            int brightness = (int)Math.sqrt((double)(c.getRed() * c.getRed()) * 0.241 + (double)(c.getGreen() * c.getGreen()) * 0.691 + (double)(c.getBlue() * c.getBlue()) * 0.068);
            return brightness < 130;
        }
        catch (Throwable t) {
            return false;
        }
    }

    public static ColorUpdateInfo findColorUpdateIfColor(String s) {
        if (s == null) {
            return new ColorUpdateInfo(0, s);
        }
        if (ValueManager.countOccurrancesInString(s, '@') == 2 && s.startsWith("@")) {
            if (s.endsWith("+@")) {
                int colorUpdate = ValueManager.countOccurrancesInString(s, '+');
                s = s.replace("+", "");
                return new ColorUpdateInfo(colorUpdate, s);
            }
            if (s.endsWith("-@")) {
                int colorUpdate = -1 * ValueManager.countOccurrancesInString(s, '-');
                s = s.replace("-", "");
                return new ColorUpdateInfo(colorUpdate, s);
            }
        }
        return new ColorUpdateInfo(0, s);
    }

    public static Set<String> parseStringForVariables(String s) {
        HashSet<String> result = new HashSet<String>();
        int firstIndex = -1;
        for (int i = 0; i < s.length(); ++i) {
            if (s.charAt(i) != '@') continue;
            if (firstIndex < 0) {
                firstIndex = i;
                continue;
            }
            String variable = s.substring(firstIndex, i + 1);
            result.add(variable);
            firstIndex = -1;
        }
        return result;
    }

    public static String getStyleBaseColor() {
        return StyleManager.getStyleValue("@baseColor@");
    }

    public static String getStyleTextColorForLightBackground() {
        return StyleManager.getStyleValue("@textColorForLightBackground@");
    }

    public static String getStyleTextColorForDarkBackground() {
        return StyleManager.getStyleValue("@textColorForDarkBackground@");
    }

    public static String getStyleTextColorForBackground(String background) {
        boolean dark = StyleUtil.checkIfColorIsDark(background);
        if (dark) {
            return StyleUtil.getStyleTextColorForDarkBackground();
        }
        return StyleUtil.getStyleTextColorForLightBackground();
    }

    public static class ColorUpdateInfo {
        public int colorUpdate = 0;
        public String updatedValue;

        public ColorUpdateInfo(int colorUpdate, String updatedString) {
            this.colorUpdate = colorUpdate;
            this.updatedValue = updatedString;
        }
    }
}

