/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.jsfserver.util.quadrantplot;

import java.util.Vector;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.util.valuemgmt.ValueManager;

public class QuadrantPlot {
    private long m_changeIndex = UniqueIdCreator.createCounter();
    private boolean m_changeData;
    private String m_selId;
    private String m_quadrantplotprop;
    private double m_width = 1000.0;
    private double m_height = 1000.0;
    private String m_backgroundColor;
    private String m_scaleLineColor;
    private String m_selectionColor = "#808080";
    private int m_selectionStrokeWidth = 20;
    private boolean m_printFrameAround;
    private String m_html;
    private String m_shapeSessionbufferName;
    private String m_xAxisDescription;
    private String m_xAxisDescriptionColor;
    private double m_xAxisDescriptionFontSize;
    private double m_xAxisDescriptionHeight;
    private String m_xAxisColor;
    private String[] m_xAxisStringArray;
    private String[] m_xAxisColorArray;
    private double[] m_xAxisSizeArray;
    private double m_rotateXAxisScale;
    private double m_xAxisScaleHeight;
    private String m_yAxisDescription;
    private String m_yAxisDescriptionColor;
    private double m_yAxisDescriptionFontSize;
    private double m_yAxisDescriptionWidth;
    private String m_yAxisColor;
    private String[] m_yAxisStringArray;
    private String[] m_yAxisColorArray;
    private double[] m_yAxisSizeArray;
    private double m_yAxisScaleWidth;
    private Vector m_PlotDataArray = new Vector();
    private Vector m_QuadrantInfoArray = new Vector();
    private String m_jpegSessionBufferName = "";

    public QuadrantPlot() {
        this.clearDrawAreaData();
        this.m_changeData = false;
    }

    public void clearDrawAreaData() {
        this.m_html = null;
        this.m_printFrameAround = true;
        this.m_scaleLineColor = "black";
        this.m_backgroundColor = "white";
        this.m_xAxisColor = "black";
        this.m_yAxisColor = "black";
        this.m_xAxisStringArray = new String[0];
        this.m_yAxisStringArray = new String[0];
        this.m_PlotDataArray.clear();
        this.m_QuadrantInfoArray.clear();
        this.m_xAxisDescription = null;
        this.m_rotateXAxisScale = 0.0;
        this.m_xAxisScaleHeight = 0.0;
        this.m_yAxisScaleWidth = 0.0;
        ++this.m_changeIndex;
        this.m_changeData = true;
    }

    public void setXAxisDescription(String description, String color, double fontSize, double height) {
        this.m_xAxisDescription = description;
        this.m_xAxisDescriptionColor = color;
        this.m_xAxisDescriptionFontSize = fontSize >= 8.0 && fontSize <= 24.0 ? fontSize : 12.0;
        this.m_xAxisDescriptionHeight = height;
        ++this.m_changeIndex;
        this.m_changeData = true;
    }

    public void setXAxis(String[] outputXAxis) {
        this.m_xAxisStringArray = outputXAxis;
        int lineCount = 1;
        this.m_xAxisSizeArray = new double[this.m_xAxisStringArray.length];
        this.m_xAxisColorArray = new String[this.m_xAxisStringArray.length];
        for (int i = 0; i < this.m_xAxisStringArray.length; ++i) {
            String[] lines = ValueManager.tokenize(this.m_xAxisStringArray[i], "\n");
            if (lineCount < lines.length) {
                lineCount = lines.length;
            }
            this.m_xAxisSizeArray[i] = 12.0;
            this.m_xAxisColorArray[i] = "black";
        }
        this.m_xAxisScaleHeight = 156 * lineCount;
        ++this.m_changeIndex;
        this.m_changeData = true;
    }

    public void setXAxis(String[] outputXAxis, double[] size, String[] color) {
        if (outputXAxis.length != size.length || outputXAxis.length != color.length) {
            throw new Error("Size of the x axis arrays is not the same!");
        }
        this.m_xAxisStringArray = outputXAxis;
        this.m_xAxisSizeArray = size;
        this.m_xAxisColorArray = color;
        this.m_xAxisScaleHeight = 0.0;
        for (int i = 0; i < this.m_xAxisStringArray.length; ++i) {
            String[] lines = ValueManager.tokenize(this.m_xAxisStringArray[i], "\n");
            if (!(this.m_xAxisScaleHeight < 13.0 * this.m_xAxisSizeArray[i] * (double)lines.length)) continue;
            this.m_xAxisScaleHeight = 13.0 * this.m_xAxisSizeArray[i] * (double)lines.length;
        }
        ++this.m_changeIndex;
        this.m_changeData = true;
    }

    public void setYAxisDescription(String description, String color, double fontSize, double width) {
        this.m_yAxisDescription = description;
        this.m_yAxisDescriptionColor = color;
        this.m_yAxisDescriptionFontSize = fontSize >= 8.0 && fontSize <= 24.0 ? fontSize : 12.0;
        this.m_yAxisDescriptionWidth = width;
        ++this.m_changeIndex;
        this.m_changeData = true;
    }

    public void setYAxis(String[] outputYAxis) {
        this.m_yAxisStringArray = outputYAxis;
        this.m_yAxisSizeArray = new double[this.m_yAxisStringArray.length];
        this.m_yAxisColorArray = new String[this.m_yAxisStringArray.length];
        for (int i = 0; i < this.m_yAxisStringArray.length; ++i) {
            this.m_yAxisSizeArray[i] = 12.0;
            this.m_yAxisColorArray[i] = "black";
        }
        ++this.m_changeIndex;
        this.m_changeData = true;
    }

    public void setYAxis(String[] outputYAxis, double[] size, String[] color) {
        if (outputYAxis.length != size.length || outputYAxis.length != color.length) {
            throw new Error("Size of the y axis arrays is not the same!");
        }
        this.m_yAxisStringArray = outputYAxis;
        this.m_yAxisSizeArray = size;
        this.m_yAxisColorArray = color;
        ++this.m_changeIndex;
        this.m_changeData = true;
    }

    public void addQuadrantInfo(int x, int y, String color, String id) {
        QuadrantAreaData item = new QuadrantAreaData(x, y, color, id);
        this.m_QuadrantInfoArray.add(item);
        ++this.m_changeIndex;
        this.m_changeData = true;
    }

    public void addPlotData(double x, double y, String text, double size, String color) {
        QuadrantItemData data = new QuadrantItemData(x, y, text, size, color);
        this.m_PlotDataArray.add(data);
        ++this.m_changeIndex;
        this.m_changeData = true;
    }

    public void addPlotData(double x, double y, String text, double size, String color, String id) {
        QuadrantItemData data = new QuadrantItemData(x, y, text, size, color);
        data.m_id = id;
        this.m_PlotDataArray.add(data);
        ++this.m_changeIndex;
        this.m_changeData = true;
    }

    public void rotateXAxisScaleText(double degrees, double height) {
        this.m_rotateXAxisScale = degrees >= -90.0 && degrees <= 90.0 ? degrees : 0.0;
        this.m_xAxisScaleHeight = height > 0.0 ? height : 0.0;
        ++this.m_changeIndex;
        this.m_changeData = true;
    }

    public void setLeftYAxisDistance(double width) {
        this.m_yAxisScaleWidth = width;
        ++this.m_changeIndex;
        this.m_changeData = true;
    }

    public void printFrameAround(boolean printFrame) {
        this.m_printFrameAround = printFrame;
        ++this.m_changeIndex;
        this.m_changeData = true;
    }

    public void setScaleLineColor(String color) {
        this.m_scaleLineColor = color;
        this.m_changeData = true;
        ++this.m_changeIndex;
    }

    public void setBackgroundColor(String color) {
        this.m_backgroundColor = color;
        this.m_changeData = true;
        ++this.m_changeIndex;
    }

    public void setSelectedID(String selectedID) {
        this.m_selId = selectedID;
        this.m_changeData = true;
        ++this.m_changeIndex;
    }

    public void setSelectionColor(String selectionColor) {
        this.m_selectionColor = selectionColor;
    }

    public void setSelectionStrokeWidth(int selectionStrokeWidth) {
        this.m_selectionStrokeWidth = selectionStrokeWidth;
    }

    public final long getCi() {
        return this.m_changeIndex;
    }

    public void setQuadrantplotprop(String value) {
        this.m_quadrantplotprop = value;
    }

    public void setSelId(String value) {
        this.m_selId = value;
        this.m_changeData = true;
    }

    public String getSvg() {
        StringBuffer svgData = new StringBuffer();
        this.createPlot(svgData);
        this.createSVGChart(svgData);
        return svgData.toString();
    }

    public long computeOutputWidth(int height) {
        double widthViewport = (double)(350 + 1000 * this.m_xAxisStringArray.length) + this.m_yAxisScaleWidth + this.m_yAxisDescriptionWidth;
        double heightViewport = (double)(350 + 1000 * this.m_yAxisStringArray.length) + this.m_xAxisScaleHeight + this.m_xAxisDescriptionHeight;
        return Math.round(widthViewport * (double)height / heightViewport);
    }

    public void setSVGOutputWidth(int height) {
        this.m_height = height;
        this.m_width = this.computeOutputWidth(height);
    }

    protected void createSVGChart(StringBuffer chartData) {
        if (chartData == null || chartData.length() < 4) {
            return;
        }
        String svgData = chartData.toString();
        svgData = svgData.replace("svg:", "");
        svgData = svgData.substring(4);
        String header = "<?xml version=\"1.0\"?>\n";
        header = header + "<svg xmlns=\"http://www.w3.org/2000/svg\" \n";
        svgData = header + svgData;
        chartData.delete(0, chartData.length());
        chartData.append(svgData);
    }

    private void createPlot(StringBuffer svgData) {
        int i;
        int widthXAxis = 1000 * this.m_xAxisStringArray.length;
        int heightYAxis = 1000 * this.m_yAxisStringArray.length;
        double widthViewport = (double)(350 + widthXAxis) + this.m_yAxisDescriptionWidth;
        double heightViewport = (double)(350 + heightYAxis) + this.m_xAxisDescriptionHeight;
        double translateChartX = 100.0 + this.m_yAxisScaleWidth + this.m_yAxisDescriptionWidth;
        double translateChartY = -heightViewport + 100.0 + this.m_xAxisDescriptionHeight;
        double widthLeft = 150.0;
        widthLeft += this.m_yAxisScaleWidth;
        svgData.append("<svg:svg width=\"" + this.m_width + "\" height=\"" + this.m_height + "\" viewBox=\"0 0 " + (widthViewport += this.m_yAxisScaleWidth) + " " + (heightViewport += this.m_xAxisScaleHeight) + "\" preserveAspectRatio=\"none\" >\n");
        svgData.append("  <svg:g>\n");
        if (this.m_printFrameAround) {
            svgData.append("    <svg:rect x=\"0\" y=\"0\" width=\"" + widthViewport + "\" height=\"" + heightViewport + "\" style=\"fill:none; stroke:black; stroke-width:1\" />\n");
            svgData.append("    <svg:rect x=\"2\" y=\"2\" width=\"" + (widthViewport - 4.0) + "\" height=\"" + (heightViewport - 4.0) + "\" style=\"fill:none; stroke:white; stroke-width:1\" />\n");
            svgData.append("    <svg:rect x=\"4\" y=\"4\" width=\"" + (widthViewport - 8.0) + "\" height=\"" + (heightViewport - 8.0) + "\" style=\"fill:" + this.m_backgroundColor + "; stroke:black; stroke-width:1\" />\n");
        }
        svgData.append("  </svg:g>\n");
        svgData.append("  <svg:g transform=\"scale(1,-1) translate(" + translateChartX + "," + translateChartY + ")\">\n");
        if (this.m_xAxisDescription != null) {
            svgData.append("    <svg:g transform=\"scale(1,1) translate(" + (widthXAxis / 2 + 100) + ", " + (-this.m_xAxisDescriptionHeight - 50.0 - this.m_xAxisScaleHeight) + ")\">\n");
            svgData.append("      <svg:g transform=\"scale(" + this.m_xAxisDescriptionFontSize + "," + -this.m_xAxisDescriptionFontSize + ") translate(1, -1)\">\n");
            svgData.append("        <svg:g fill=\"" + this.m_xAxisDescriptionColor + "\" >\n");
            svgData.append("        <svg:text x=\"0\" y=\"0\" text-anchor=\"middle\" >" + this.m_xAxisDescription + "</svg:text>\n");
            svgData.append("        </svg:g>\n");
            svgData.append("      </svg:g>\n");
            svgData.append("    </svg:g>\n");
        }
        if (this.m_yAxisDescription != null) {
            svgData.append("    <svg:g transform=\"scale(1,1) translate(" + -this.m_yAxisScaleWidth + ", " + (heightYAxis / 2 + 100) + ")\">\n");
            svgData.append("      <svg:g transform=\"rotate(90) scale(" + this.m_yAxisDescriptionFontSize + "," + -this.m_yAxisDescriptionFontSize + ") translate(1, -1)\">\n");
            svgData.append("        <svg:text x=\"0\" y=\"0\" text-anchor=\"middle\" style=\"fill:" + this.m_yAxisDescriptionColor + "\" >" + this.m_yAxisDescription + "</svg:text>\n");
            svgData.append("      </svg:g>\n");
            svgData.append("    </svg:g>\n");
        }
        double xAxisGap = 1000.0;
        double yAxisGap = 1000.0;
        for (int quarantIndex = 0; quarantIndex < this.m_QuadrantInfoArray.size(); ++quarantIndex) {
            QuadrantAreaData areaItem = (QuadrantAreaData)this.m_QuadrantInfoArray.get(quarantIndex);
            double bottom = (double)areaItem.m_y * yAxisGap + 150.0;
            double left = (double)areaItem.m_x * xAxisGap + 150.0;
            double top = (double)(areaItem.m_y + 1) * yAxisGap + 150.0;
            double right = (double)(areaItem.m_x + 1) * xAxisGap + 150.0;
            String ccIdWithValue = "";
            if (areaItem.m_id != null) {
                ccIdWithValue = "cc_id=\"" + areaItem.m_id + "\"";
            }
            String quadrantFillColor = areaItem.m_color;
            svgData.append("    <svg:polygon " + ccIdWithValue + " fill=\"" + quadrantFillColor + "\"");
            svgData.append(" points=\"" + left + "," + bottom + " " + left + "," + top + " " + right + "," + top + " " + right + "," + bottom + " \" ");
            if (areaItem.m_id != null && areaItem.m_id.equals(this.m_selId)) {
                svgData.append(" selected=\"true\"");
                svgData.append(" stroke=\"" + this.m_selectionColor + "\" stroke-width=\"" + this.m_selectionStrokeWidth + "\"");
            } else {
                svgData.append(" selected=\"false\"");
                svgData.append(" stroke=\"none\" stroke-width=\"0\"");
            }
            svgData.append(" />\n");
        }
        svgData.append("    <svg:line x1=\"0\" y1=\"150\" x2=\"" + (widthXAxis + 200) + "\" y2=\"150\" style=\"fill:none; stroke:" + this.m_xAxisColor + "; stroke-width:4\" />\n");
        svgData.append("    <svg:line x1=\"150\" y1=\"0\" x2=\"150\" y2=\"" + (heightYAxis + 200) + "\" style=\"fill:none; stroke:" + this.m_yAxisColor + "; stroke-width:4\" />\n");
        for (i = 0; i < this.m_xAxisStringArray.length; ++i) {
            double translateY = 0.0;
            String svgAlign = "middle";
            translateY = 150.0 - this.m_xAxisSizeArray[i] * 12.0;
            if (this.m_rotateXAxisScale > 0.0) {
                svgAlign = "start";
            }
            if (this.m_rotateXAxisScale < 0.0) {
                svgAlign = "end";
            }
            svgData.append("    <svg:g transform=\"scale(1,1) translate(" + (650 + i * 1000) + ", " + translateY + ")\">\n");
            svgData.append("      <svg:g transform=\"scale(" + this.m_xAxisSizeArray[i] + "," + -this.m_xAxisSizeArray[i] + ") translate(1, -1)\">\n");
            svgData.append("        <svg:g transform=\"rotate(" + this.m_rotateXAxisScale + ")\">\n");
            String[] lines = ValueManager.tokenize(this.m_xAxisStringArray[i], "\n");
            for (int li = 0; li < lines.length; ++li) {
                svgData.append("          <svg:text x=\"1\" y=\"" + (1 + li * 12) + "\" text-anchor=\"" + svgAlign + "\" style=\"fill:" + this.m_xAxisColorArray[i] + "\" >" + lines[li] + "</svg:text>\n");
            }
            svgData.append("        </svg:g>\n");
            svgData.append("      </svg:g>\n");
            svgData.append("    </svg:g>\n");
            svgData.append("    <svg:line x1=\"" + (150.0 + (double)(i + 1) * xAxisGap) + "\" y1=\"0\" x2=\"" + (150.0 + (double)(i + 1) * xAxisGap) + "\" y2=\"" + (heightYAxis + 200) + "\" style=\"fill:none; stroke:" + this.m_scaleLineColor + "; stroke-width:3\" />\n");
        }
        for (i = 0; i < this.m_yAxisStringArray.length; ++i) {
            String[] lines = ValueManager.tokenize(this.m_yAxisStringArray[i], "\n");
            svgData.append("    <svg:g transform=\"scale(1,1) translate(100, " + (660.0 + (double)(lines.length - 1) * this.m_yAxisSizeArray[i] * 5.0 + (double)(i * 1000)) + ") \">\n");
            svgData.append("      <svg:g transform=\"scale(" + this.m_yAxisSizeArray[i] + "," + -this.m_yAxisSizeArray[i] + ") translate(1, -1)\">\n");
            for (int li = 0; li < lines.length; ++li) {
                svgData.append("          <svg:text x=\"1\" y=\"" + (1 + li * 12) + "\" text-anchor=\"end\" style=\"fill:" + this.m_yAxisColorArray[i] + "\" >" + lines[li] + "</svg:text>\n");
            }
            svgData.append("      </svg:g>\n");
            svgData.append("    </svg:g>\n");
            svgData.append("    <svg:line y1=\"" + (150.0 + (double)(i + 1) * yAxisGap) + "\" x1=\"0\" y2=\"" + (150.0 + (double)(i + 1) * yAxisGap) + "\" x2=\"" + (widthXAxis + 200) + "\" style=\"fill:none; stroke:" + this.m_scaleLineColor + "; stroke-width:3\" />\n");
        }
        for (i = 0; i < this.m_PlotDataArray.size(); ++i) {
            QuadrantItemData dataItem = (QuadrantItemData)this.m_PlotDataArray.get(i);
            double yPos = dataItem.m_y * yAxisGap + 150.0;
            double xPos = dataItem.m_x * xAxisGap + 150.0;
            String ccIdWithValue = "";
            if (dataItem.m_id != null) {
                ccIdWithValue = "cc_id=\"" + dataItem.m_id + "\"";
            }
            svgData.append("    <svg:g transform=\"scale(1,1) translate(" + xPos + ", " + yPos + ") \">\n");
            svgData.append("      <svg:g transform=\"scale(" + dataItem.m_size + "," + -dataItem.m_size + ") translate(1, -1)\">\n");
            svgData.append("        <svg:text " + ccIdWithValue + " x=\"0\" y=\"0\" text-anchor=\"start\" style=\"fill:" + dataItem.m_color + "\" >" + dataItem.m_text + "</svg:text>\n");
            svgData.append("      </svg:g>\n");
            svgData.append("    </svg:g>\n");
        }
        svgData.append("  </svg:g>\n</svg:svg>\n");
    }

    private class QuadrantAreaData {
        int m_x;
        int m_y;
        String m_color;
        String m_id;

        public QuadrantAreaData(int x, int y, String color, String id) {
            if (color == null || color == "") {
                color = "none";
            }
            this.m_x = x;
            this.m_y = y;
            this.m_color = color;
            this.m_id = id;
        }
    }

    private class QuadrantItemData {
        double m_x;
        double m_y;
        double m_size;
        String m_text;
        String m_color;
        String m_id;

        public QuadrantItemData(double x, double y, String text, double size, String color) {
            if (color == null || color == "") {
                color = "none";
            }
            this.m_x = x;
            this.m_y = y;
            this.m_text = text;
            this.m_color = color;
            this.m_size = size;
        }
    }
}

