/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.tool;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclnt.jsfserver.util.StyleUtil;
import org.eclnt.tool.BuildCSSViaXML;
import org.eclnt.tool.CSSStyle;
import org.eclnt.tool.CSSStyleClassRISCInfo;
import org.eclnt.tool.CSSStyleClassStyle;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;

public class CSSStyleClass
implements Comparable<CSSStyleClass>,
Serializable {
    private boolean m_internal = false;
    private boolean m_directcss = false;
    private boolean m_resolved = false;
    private String m_name;
    private String m_extends;
    Map<String, String> m_variableValues = new HashMap<String, String>();
    Map<String, CSSStyleClass> m_subClasses = new HashMap<String, CSSStyleClass>();
    Map<String, CSSStyleClassRISCInfo> m_riscInfos = new HashMap<String, CSSStyleClassRISCInfo>();
    Map<String, CSSStyleClassStyle> m_styleInfos = new HashMap<String, CSSStyleClassStyle>();

    public String getName() {
        return this.m_name;
    }

    public void setName(String name) {
        this.m_name = name;
    }

    public String getExtends() {
        return this.m_extends;
    }

    public void setExtends(String extends1) {
        this.m_extends = extends1;
    }

    public void setInternal(boolean internal) {
        this.m_internal = internal;
    }

    public Map<String, String> getVariableValues() {
        return this.m_variableValues;
    }

    public Map<String, CSSStyleClass> getSubClasses() {
        return this.m_subClasses;
    }

    public Map<String, CSSStyleClassRISCInfo> getRiscInfos() {
        return this.m_riscInfos;
    }

    public Map<String, CSSStyleClassStyle> getStyleInfos() {
        return this.m_styleInfos;
    }

    public boolean getDirectcss() {
        return this.m_directcss;
    }

    public void setDirectcss(boolean directcss) {
        this.m_directcss = directcss;
    }

    @Override
    public int compareTo(CSSStyleClass o) {
        return this.m_name.compareTo(o.m_name);
    }

    public void addRISCInfo(CSSStyleClassRISCInfo ri) {
        this.m_riscInfos.put(ri.m_name, ri);
    }

    public void removeRISCInfo(String name) {
        this.m_riscInfos.remove(name);
    }

    public void addStyle(CSSStyleClassStyle si) {
        this.m_styleInfos.put(si.m_name, si);
    }

    public void removeStyle(String name) {
        this.m_styleInfos.remove(name);
    }

    public void addSubClass(CSSStyleClass sc) {
        this.m_subClasses.put(sc.m_name, sc);
    }

    public void removeSubClass(String name) {
        this.m_subClasses.remove(name);
    }

    public void addVariableValue(String name, String value) {
        this.m_variableValues.put(name, value);
    }

    public void removeVariableValue(String name) {
        this.m_variableValues.remove(name);
    }

    public void resolveExtensions() {
        if (this.m_resolved) {
            return;
        }
        if (this.m_extends == null) {
            return;
        }
        CSSStyleClass xsc = this.findExtensionClass(this.m_extends);
        if (xsc == null) {
            return;
        }
        xsc.resolveExtensions();
        for (String name : xsc.m_riscInfos.keySet()) {
            if (this.m_riscInfos.containsKey(name)) continue;
            this.m_riscInfos.put(name, xsc.m_riscInfos.get(name));
        }
        for (String name : xsc.m_styleInfos.keySet()) {
            if (this.m_styleInfos.containsKey(name)) continue;
            this.m_styleInfos.put(name, xsc.m_styleInfos.get(name));
        }
        for (String name : xsc.m_subClasses.keySet()) {
            if (this.m_subClasses.containsKey(name)) {
                CSSStyleClass xSubClass = xsc.m_subClasses.get(name);
                CSSStyleClass subClass = this.m_subClasses.get(name);
                if (subClass.m_extends != null) continue;
                subClass.m_extends = xSubClass.m_extends;
                continue;
            }
            this.m_subClasses.put(name, xsc.m_subClasses.get(name));
        }
        for (String name : xsc.m_variableValues.keySet()) {
            if (this.m_variableValues.containsKey(name)) continue;
            this.m_variableValues.put(name, xsc.m_variableValues.get(name));
        }
        for (CSSStyleClass sc : this.m_subClasses.values()) {
            try {
                sc.resolveExtensions();
            }
            catch (Throwable t) {
                throw new Error("Problem occurred when resolving: " + sc.getName() + ", extending: " + sc.getExtends(), t);
            }
        }
        if (xsc.getDirectcss()) {
            this.m_directcss = true;
        }
        this.m_resolved = true;
    }

    private CSSStyleClass findExtensionClass(String extendString) {
        String[] exts = ValueManager.tokenize(extendString, "-->");
        CSSStyleClass result = BuildCSSViaXML.s_style.m_styleClasses.get(exts[0]);
        if (result == null) {
            throw new Error("Could not find style class to extend from: " + extendString);
        }
        for (int i = 1; i < exts.length; ++i) {
            CSSStyleClass subClass = result.m_subClasses.get(exts[i]);
            if (subClass == null) {
                return null;
            }
            result = subClass;
        }
        return result;
    }

    public void outputXML(StringBuffer sb, int level) {
        String value;
        String prefix = "";
        for (int i = 0; i < level; ++i) {
            prefix = prefix + "    ";
        }
        sb.append(prefix + "<class");
        sb.append(" n=\"" + this.getName() + "\"");
        if (this.getExtends() != null && !this.getExtends().contains("-->")) {
            sb.append(" extends=\"" + this.getExtends() + "\"");
        }
        sb.append(">\n");
        ArrayList<String> names = new ArrayList<String>(this.m_variableValues.keySet());
        Collections.sort(names);
        for (String name : names) {
            value = ValueManager.encodeIntoValidXMLString(this.m_variableValues.get(name));
            name = ValueManager.encodeIntoValidXMLString(name);
            sb.append(prefix + "    <var   n=\"" + name + "\" v=\"" + value + "\"/>\n");
        }
        names = new ArrayList<String>(this.m_riscInfos.keySet());
        Collections.sort(names);
        for (String name : names) {
            try {
                value = ValueManager.encodeIntoValidXMLString(this.m_riscInfos.get(name).getValue());
                name = ValueManager.encodeIntoValidXMLString(name);
                sb.append(prefix + "    <risc  n=\"" + name + "\" v=\"" + value + "\"/>\n");
            }
            catch (Throwable value2) {}
        }
        names = new ArrayList<String>(this.m_styleInfos.keySet());
        Collections.sort(names);
        for (String name : names) {
            try {
                value = ValueManager.encodeIntoValidXMLString(this.m_styleInfos.get(name).getValue());
                name = ValueManager.encodeIntoValidXMLString(name);
                sb.append(prefix + "    <style n=\"" + name + "\" v=\"" + value + "\"/>\n");
            }
            catch (Throwable value3) {}
        }
        names = new ArrayList<String>(this.m_subClasses.keySet());
        Collections.sort(names);
        for (String name : names) {
            try {
                CSSStyleClass sc = this.m_subClasses.get(name);
                sc.outputXML(sb, level + 1);
            }
            catch (Throwable throwable) {}
        }
        sb.append(prefix + "</class>\n");
    }

    public void outputCSS(StringBuffer sb, List<CSSStyleClass> classStack, Map<String, String> variables) {
        this.outputCSS(sb, classStack, variables, 1);
    }

    public void outputCSS(StringBuffer sb, List<CSSStyleClass> classStack, Map<String, String> variables, int callLevel) {
        CLog.L.log(CLog.LL_DBG, "STYLEMGMT: CSS: Processing style class: " + this.m_name);
        if (callLevel > 100) {
            CLog.L.log(CLog.LL_WAR, "Maximum nesting level reached: ");
            for (CSSStyleClass sc : classStack) {
                CLog.L.log(CLog.LL_WAR, "Style class: " + sc.getName());
            }
            throw new Error("Maximum nesting level reached");
        }
        this.resolveExtensions();
        if (this.m_internal) {
            return;
        }
        variables = new HashMap<String, String>(variables);
        for (String name : this.m_variableValues.keySet()) {
            variables.put(name, this.m_variableValues.get(name));
        }
        if (classStack.size() == 0) {
            sb.append("\n\n/* -------------------- " + this.m_name);
            if (this.m_extends != null) {
                sb.append(", extends: " + this.m_extends);
            }
            sb.append(" */");
        }
        classStack = new ArrayList<CSSStyleClass>(classStack);
        classStack.add(this);
        boolean withDot = true;
        if (classStack.get((int)0).m_directcss) {
            withDot = false;
        }
        sb.append("\n");
        if (withDot) {
            sb.append(".");
        }
        sb.append(this.buildFullName(classStack));
        sb.append("\n{");
        ArrayList<String> names = new ArrayList<String>(this.m_styleInfos.keySet());
        Collections.sort(names);
        for (String name : names) {
            String value = this.m_styleInfos.get((Object)name).m_value;
            value = CSSStyleClass.resolveValue(value, variables, 0);
            if ("directcontent".equals(name)) {
                sb.append("\n    " + value);
                continue;
            }
            if (value.contains("url(") && !value.contains("url(..")) {
                value = value.replace("url(", "url(../../../");
            }
            sb.append("\n    " + name + ":" + value + ";");
        }
        sb.append("\n}");
        ArrayList<CSSStyleClass> l = new ArrayList<CSSStyleClass>(this.m_subClasses.values());
        Collections.sort(l);
        for (CSSStyleClass sc : l) {
            sc.outputCSS(sb, classStack, variables, callLevel + 1);
        }
    }

    public void outputJsonMap(Map<String, Object> globalsMap, Map<String, Object> map, List<CSSStyleClass> classStack, Map<String, String> variables) {
        List<String> parts;
        CLog.L.log(CLog.LL_DBG, "STYLEMGMT: JSON: Processing style class: " + this.m_name);
        this.resolveExtensions();
        if (this.m_name.startsWith("EXTENDED_")) {
            return;
        }
        if (this.m_name.equals("riscinternal_riscglobal")) {
            for (CSSStyleClassRISCInfo ri : this.m_riscInfos.values()) {
                if (ri.m_name.equals("defaultFont")) {
                    String value = CSSStyleClass.resolveValue(ri.m_value, variables, 0);
                    if ((value = value.trim()).startsWith("new RISCFont(")) {
                        value = value.substring("new RISCFont(".length(), value.length() - 1);
                    }
                    parts = this.parseValue(CSSStyleClass.resolveValue(value, variables, 0), true);
                    for (int i = 0; i < parts.size(); ++i) {
                        if (!parts.get(i).startsWith(",")) continue;
                        parts.set(i, parts.get(i).substring(1));
                    }
                    globalsMap.put("defaultFont", parts);
                    continue;
                }
                globalsMap.put(ri.m_name, CSSStyleClass.resolveValue(ri.m_value, variables, 0));
            }
        }
        if (this.m_internal || "riscinternal_riscglobal".equals(this.m_name)) {
            return;
        }
        variables = new HashMap<String, String>(variables);
        for (String name : this.m_variableValues.keySet()) {
            String toName = this.m_variableValues.get(name);
            variables.put(name, toName);
        }
        classStack = new ArrayList<CSSStyleClass>(classStack);
        classStack.add(this);
        if (this.m_riscInfos.size() != 0) {
            int i;
            String className = this.buildFullName(classStack);
            HashMap<String, Object> classNameMap = new HashMap<String, Object>();
            map.put(className, classNameMap);
            Object si = this.m_riscInfos.get("font");
            if (si != null && ((CSSStyleClassRISCInfo)si).m_value != null) {
                parts = this.parseValue(CSSStyleClass.resolveValue(((CSSStyleClassRISCInfo)si).m_value, variables, 0), true);
                classNameMap.put("font", parts);
            }
            if ((si = this.m_riscInfos.get("background")) != null && ((CSSStyleClassRISCInfo)si).m_value != null) {
                classNameMap.put("background", CSSStyleClass.resolveValue(((CSSStyleClassRISCInfo)si).m_value, variables, 0));
            }
            if ((si = this.m_riscInfos.get("border")) != null && ((CSSStyleClassRISCInfo)si).m_value != null) {
                parts = this.parseValue(CSSStyleClass.resolveValue(((CSSStyleClassRISCInfo)si).m_value, variables, 0));
                String[] borders = new String[]{"0", "0", "0", "0"};
                for (i = 0; i < parts.size(); ++i) {
                    borders[i] = parts.get(i);
                }
                classNameMap.put("borderTop", borders[0]);
                classNameMap.put("borderRight", borders[1]);
                classNameMap.put("borderBottom", borders[2]);
                classNameMap.put("borderLeft", borders[3]);
            }
            if ((si = this.m_riscInfos.get("margin")) != null && ((CSSStyleClassRISCInfo)si).m_value != null) {
                parts = this.parseValue(CSSStyleClass.resolveValue(((CSSStyleClassRISCInfo)si).m_value, variables, 0));
                String[] borders = new String[]{"0", "0", "0", "0"};
                for (i = 0; i < parts.size(); ++i) {
                    borders[i] = parts.get(i);
                }
                classNameMap.put("marginTop", borders[0]);
                classNameMap.put("marginRight", borders[1]);
                classNameMap.put("marginBottom", borders[2]);
                classNameMap.put("marginLeft", borders[3]);
            }
            if ((si = this.m_riscInfos.get("inset")) != null && ((CSSStyleClassRISCInfo)si).m_value != null) {
                parts = this.parseValue(CSSStyleClass.resolveValue(((CSSStyleClassRISCInfo)si).m_value, variables, 0));
                String[] insets = new String[]{"0", "0", "0", "0"};
                for (i = 0; i < parts.size(); ++i) {
                    insets[i] = parts.get(i);
                }
                classNameMap.put("insetTop", insets[0]);
                classNameMap.put("insetRight", insets[1]);
                classNameMap.put("insetBottom", insets[2]);
                classNameMap.put("insetLeft", insets[3]);
            }
            for (String key : this.m_riscInfos.keySet()) {
                String value = this.m_riscInfos.get((Object)key).m_value;
                if (value == null || "font_background_border_margin_inset".contains(key)) continue;
                String value2write = CSSStyleClass.resolveValue(value, variables, 0);
                value2write = CSSStyle.updateJSValueContent(value2write);
                classNameMap.put(key, value2write);
            }
        }
        ArrayList<CSSStyleClass> l = new ArrayList<CSSStyleClass>(this.m_subClasses.values());
        Collections.sort(l);
        for (CSSStyleClass sc : l) {
            sc.outputJsonMap(globalsMap, map, classStack, variables);
        }
    }

    private String buildFullName(List<CSSStyleClass> classStack) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < classStack.size() - 1; ++i) {
            sb.append(classStack.get((int)i).m_name);
        }
        String parentClassName = sb.toString();
        String result = parentClassName + this.m_name;
        result = result.replace("@PARENTCLASSNAME@", parentClassName);
        return result;
    }

    public static String resolveValue(String value, Map<String, String> variables, int counter) {
        if (counter > 10) {
            CLog.L.log(CLog.LL_INF, "PROBLEM DURING VALUE RESOLUTION: loop on variable: " + value);
            return value;
        }
        if (value == null) {
            return value;
        }
        Set<String> containedVariables = StyleUtil.parseStringForVariables(value);
        if (containedVariables.size() == 0) {
            return value;
        }
        for (String containedVariable : containedVariables) {
            StyleUtil.ColorUpdateInfo colorUpdateInfo = StyleUtil.findColorUpdateIfColor(containedVariable);
            String variableName = colorUpdateInfo.updatedValue;
            String variableValue = variables.get(variableName);
            if (variableValue == null) continue;
            if (colorUpdateInfo.colorUpdate != 0) {
                variableValue = ValueManager.updateColor(variableValue, colorUpdateInfo.colorUpdate);
            }
            value = value.replace(containedVariable, variableValue);
        }
        value = CSSStyleClass.resolveValue(value, variables, ++counter);
        return value;
    }

    private List<String> parseValue(String value) {
        return this.parseValue(value, false);
    }

    private List<String> parseValue(String value, boolean avoidQuotes) {
        ArrayList<String> result = new ArrayList<String>();
        Matcher m = Pattern.compile("([^\"]\\S*|\".+?\")\\s*").matcher(value);
        while (m.find()) {
            String part = m.group(1);
            if (part.startsWith("\"") && part.endsWith("\"")) {
                part = part.substring(1, part.length() - 1);
            }
            result.add(part);
        }
        return result;
    }
}

