/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.image;

import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import javax.imageio.ImageIO;
import org.eclnt.util.file.FileManager;
import org.eclnt.util.log.CLog;

public class ImageCreator {
    BufferedImage m_bufferedImage;
    int m_width;
    int m_height;

    public ImageCreator(int width, int height) {
        this.m_width = width;
        this.m_height = height;
        this.m_bufferedImage = new BufferedImage(width, height, 1);
    }

    public static void main(String[] args) {
        ImageCreator ic = new ImageCreator(100, 100);
        Graphics2D g2 = ic.getGraphics2D();
        GradientPaint grp = new GradientPaint(0.0f, 0.0f, Color.BLUE, 0.0f, 100.0f, Color.GRAY, true);
        g2.setPaint(grp);
        g2.fill(new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0));
        g2.setColor(Color.RED);
        g2.drawLine(0, 0, 100, 100);
        byte[] jpg = ic.exportToJPG();
        FileManager.writeFile("c:/temp/abcddcba.jpg", jpg, true);
        jpg = ic.exportToPNG();
        FileManager.writeFile("c:/temp/abcddcba.png", jpg, true);
        jpg = ic.exportToGIF();
        FileManager.writeFile("c:/temp/abcddcba.gif", jpg, true);
        System.out.println("Image was created.");
    }

    public Graphics2D getGraphics2D() {
        return (Graphics2D)this.m_bufferedImage.getGraphics();
    }

    public byte[] exportToJPG() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.m_bufferedImage, "jpg", bos);
            return bos.toByteArray();
        }
        catch (IOException exc) {
            CLog.L.log(CLog.LL_ERR, "Error when transferring image into JPG", exc);
            throw new Error(exc);
        }
    }

    public byte[] exportToPNG() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.m_bufferedImage, "png", bos);
            return bos.toByteArray();
        }
        catch (IOException exc) {
            CLog.L.log(CLog.LL_ERR, "Error when transferring image into PNG", exc);
            throw new Error(exc);
        }
    }

    public byte[] exportToGIF() {
        try {
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            ImageIO.write((RenderedImage)this.m_bufferedImage, "gif", bos);
            return bos.toByteArray();
        }
        catch (IOException exc) {
            CLog.L.log(CLog.LL_ERR, "Error when transferring image into GIF", exc);
            throw new Error(exc);
        }
    }
}

