/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.util.valuemgmt.impl;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.eclnt.jsfserver.util.ClientI18NReader;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.SmartText;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.impl.ValueManagerInfoProviderUtilImpl;

public class ValueManagerInfoProviderJsfserverImpl
extends ValueManagerInfoProviderUtilImpl {
    @Override
    public Locale getCurrentLocale() {
        try {
            return HttpSessionAccess.getCurrentLocale();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Could not find locale by current dialog session, will use default", t);
            return Locale.getDefault();
        }
    }

    @Override
    public Locale getCurrentLocaleClient() {
        try {
            return HttpSessionAccess.getCurrentClientLocale();
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_WAR, "Could not find client locale by current dialog session, will use default", t);
            return Locale.getDefault();
        }
    }

    @Override
    public String getValueManagerTrueString() {
        return SystemXml.getValueManagerTrueString();
    }

    @Override
    public String getValueManagerTrueStringExport() {
        return SystemXml.getValueManagerTrueStringExport();
    }

    @Override
    public String getValueManagerFalseString() {
        return SystemXml.getValueManagerFalseString();
    }

    @Override
    public String getValueManagerFalseStringExport() {
        return SystemXml.getValueManagerFalseStringExport();
    }

    @Override
    public boolean getUseJavaClientFormatter() {
        return SystemXml.getUseJavaClientFormatter();
    }

    @Override
    public String getCountryYmdSequence(String country) {
        Map<String, String> map = ClientI18NReader.getCountryInfoMap(country);
        if (map != null) {
            return map.get("ymdSequence");
        }
        return super.getCountryYmdSequence(country);
    }

    @Override
    public String getCountryDateSep(String country) {
        Map<String, String> map = ClientI18NReader.getCountryInfoMap(country);
        if (map != null) {
            return map.get("dateSeparator");
        }
        return super.getCountryDateSep(country);
    }

    @Override
    public String getCountryTimeSep(String country) {
        Map<String, String> map = ClientI18NReader.getCountryInfoMap(country);
        if (map != null) {
            return map.get("timeSeparator");
        }
        return super.getCountryTimeSep(country);
    }

    @Override
    public Object convertStringIntoExtendedObject(String attrValue, Class attrClass) {
        if (attrClass == SmartText.class) {
            return new SmartText(attrValue);
        }
        return super.convertStringIntoExtendedObject(attrValue, attrClass);
    }

    @Override
    public Map<String, String> findAdditionalReplacementsForReplaceSystemProperties() {
        Map<String, String> result = super.findAdditionalReplacementsForReplaceSystemProperties();
        if (result == null) {
            result = new HashMap<String, String>();
        }
        try {
            String from = "${webappName}";
            String to = HttpSessionAccess.getWebApplicationName();
            result.put(from, to);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }
}

