/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.util.ArrayList;
import java.util.List;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.componentnodes.STACKEDPANEITEMNode;
import org.eclnt.jsfserver.elements.events.BaseActionEventDrop;
import org.eclnt.jsfserver.elements.impl.DYNAMICCONTENTBinding;
import org.eclnt.jsfserver.elements.impl.ROWDYNAMICCONTENTBinding;
import org.eclnt.jsfserver.elements.util.Trigger;
import org.eclnt.jsfserver.pagebean.PageBean;
import org.eclnt.workplace.IWorkpage;
import org.eclnt.workplace.IWorkpageContainer;
import org.eclnt.workplace.IWorkpageContainerListener;
import org.eclnt.workplace.IWorkpageContainerRenderer;
import org.eclnt.workplace.WorkpageContainer;
import org.eclnt.workplace.WorkplaceTileInfo;

public class WorkpageContainerRendererStackedPane
extends PageBean
implements IWorkpageContainerRenderer {
    DYNAMICCONTENTBinding m_content = new DYNAMICCONTENTBinding();
    WorkpageContainer m_wpContainer;
    MyWorkpageContainerListener m_wpContainerListener = new MyWorkpageContainerListener();
    List<StackedPaneItemInfo> m_stackedPaneItemInfos = new ArrayList<StackedPaneItemInfo>();

    @Override
    public boolean checkIfAlsoUsedForSubContainers() {
        return false;
    }

    @Override
    public String getPageName() {
        return "/eclntjsfserver/includes/wp_workpagecontainer_stackedpane.jsp";
    }

    @Override
    public String getRootExpressionUsedInPage() {
        return "#{wpr}";
    }

    public DYNAMICCONTENTBinding getContent() {
        return this.m_content;
    }

    public List<StackedPaneItemInfo> getStackedPaneItemInfos() {
        return this.m_stackedPaneItemInfos;
    }

    @Override
    public void initWorkpageContainer(WorkpageContainer wpContainer) {
        this.m_wpContainer = wpContainer;
        this.m_wpContainer.addWorkpageContainerListener(this.m_wpContainerListener);
        this.render();
    }

    public void onStackedPaneAction(ActionEvent event) {
        BaseActionEventDrop e;
        String dragsend;
        if (event instanceof BaseActionEventDrop && (dragsend = (e = (BaseActionEventDrop)event).getDragInfo()).startsWith("CCWORKPAGE:")) {
            String wpuid = dragsend.substring("CCWORKPAGE:".length());
            this.m_wpContainer.getRootWorkpageContainer().moveWorkpage(wpuid, this.m_wpContainer.getOwnSubContainerId());
        }
    }

    public void render() {
        List<IWorkpage> wps = this.m_wpContainer.getAllWorkpages();
        ArrayList<ROWDYNAMICCONTENTBinding.ComponentNode> nodes = new ArrayList<ROWDYNAMICCONTENTBinding.ComponentNode>();
        this.m_stackedPaneItemInfos.clear();
        int counter = 0;
        for (IWorkpage wp : wps) {
            StackedPaneItemInfo spii = new StackedPaneItemInfo(wp);
            this.m_stackedPaneItemInfos.add(spii);
            String wpUid = wp.getUniqueTechnicalId();
            STACKEDPANEITEMNode spn = new STACKEDPANEITEMNode();
            spn.addAttribute("id", wpUid);
            spn.addAttribute("trigger", this.getRootExpressionUsedInPage().replace("}", ".stackedPaneItemInfos[" + counter + "].trigger}"));
            nodes.add(spn);
            this.m_wpContainer.renderWorkpageNode(wp, spn, wpUid);
            ++counter;
        }
        this.m_content.setContentNodes(nodes);
    }

    private void switchToWorkpage(IWorkpage workpage) {
        for (StackedPaneItemInfo spii : this.m_stackedPaneItemInfos) {
            if (spii.i_workpage != workpage) continue;
            spii.getTrigger().trigger();
            break;
        }
    }

    public class StackedPaneItemInfo {
        IWorkpage i_workpage;
        Trigger i_trigger = new Trigger();

        public StackedPaneItemInfo(IWorkpage workpage) {
            this.i_workpage = workpage;
        }

        public Trigger getTrigger() {
            return this.i_trigger;
        }
    }

    class MyWorkpageContainerListener
    implements IWorkpageContainerListener {
        MyWorkpageContainerListener() {
        }

        @Override
        public void reactOnWorkpageDrop(String workpageContainerId, String workpageTechId, int horizontalPercentage, int verticalPercentage) {
        }

        @Override
        public void reactOnWorkpageAdded(IWorkpage workpage) {
            WorkpageContainerRendererStackedPane.this.render();
        }

        @Override
        public void reactOnWorkpageRemoved(IWorkpage workpage) {
            WorkpageContainerRendererStackedPane.this.render();
        }

        @Override
        public void reactOnWorkpageSwitchedTo(IWorkpage workpage) {
            WorkpageContainerRendererStackedPane.this.switchToWorkpage(workpage);
        }

        @Override
        public void reactOnWorkpageMoved(IWorkpage workpage, IWorkpageContainer from, IWorkpageContainer to) {
            if (WorkpageContainerRendererStackedPane.this.m_wpContainer == from || WorkpageContainerRendererStackedPane.this.m_wpContainer == to) {
                WorkpageContainerRendererStackedPane.this.render();
            }
            if (WorkpageContainerRendererStackedPane.this.m_wpContainer == to) {
                WorkpageContainerRendererStackedPane.this.switchToWorkpage(workpage);
            }
        }

        @Override
        public void reactOnWorkpageContainerGotEmpty(String workpageContainerId) {
        }

        @Override
        public void reactOnPerspectiveUpdate(WorkplaceTileInfo perspective) {
        }

        @Override
        public boolean reactOnSelectorUserSelection(IWorkpageContainer workpageContainer, int fromIndex, int toIndex, IWorkpage fromWorkpage, IWorkpage toWorkpage) {
            return false;
        }
    }
}

