/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import javax.faces.event.ActionEvent;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeBinding;
import org.eclnt.jsfserver.elements.impl.FIXGRIDTreeItem;
import org.eclnt.jsfserver.managedbean.DefaultDispatchedBean;
import org.eclnt.jsfserver.managedbean.IDispatcher;
import org.eclnt.jsfserver.resources.ResourceManager;
import org.eclnt.jsfserver.util.HttpSessionAccess;
import org.eclnt.jsfserver.util.SystemXml;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.UniqueIdCreator;
import org.eclnt.workplace.IWorkpage;
import org.eclnt.workplace.IWorkpageContainer;
import org.eclnt.workplace.IWorkpageDispatcher;
import org.eclnt.workplace.IWorkpageStartInfo;
import org.eclnt.workplace.MultiWorkplaceConnector;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkpageStarterFactory;
import org.eclnt.workplace.WorkplaceUtil;

public abstract class WorkplaceFunctionTree
extends DefaultDispatchedBean
implements Serializable {
    String m_contentPage = "/eclntjsfserver/includes/empty.jsp";
    boolean m_withFunctions = true;
    int m_category = 0;
    FIXGRIDTreeBinding<FunctionNode> m_ftree = new FIXGRIDTreeBinding(new FunctionNode(null), true);
    IFunctionNodeActionListener m_functionNodeActionListener;
    String m_functionNodeDefaultDropReceive = null;

    public WorkplaceFunctionTree(IDispatcher owner) {
        super(owner);
        this.loadFunctionTree();
    }

    public FIXGRIDTreeBinding<FunctionNode> getFtree() {
        return this.m_ftree;
    }

    protected abstract void loadFunctionTree();

    public IFunctionNodeActionListener getFunctionNodeActionListener() {
        return this.m_functionNodeActionListener;
    }

    public void setFunctionNodeActionListener(IFunctionNodeActionListener functionNodeActionListener) {
        this.m_functionNodeActionListener = functionNodeActionListener;
    }

    public String getFunctionNodeDefaultDropReceive() {
        return this.m_functionNodeDefaultDropReceive;
    }

    public void setFunctionNodeDefaultDropReceive(String functionNodeDefaultDropReceive) {
        this.m_functionNodeDefaultDropReceive = functionNodeDefaultDropReceive;
    }

    protected IWorkpageContainer getWorkpageContainer() {
        if (this.getOwningDispatcher() == null) {
            return null;
        }
        if (this.getOwningDispatcher() instanceof IWorkpageDispatcher) {
            return ((IWorkpageDispatcher)this.getOwningDispatcher()).getWorkpageContainer();
        }
        throw new Error("This function tree is not ownede by an instance of IWorkpageDispatcher.");
    }

    protected IWorkpage loadContentPage(WorkpageStartInfo wpi) {
        return WorkpageStarterFactory.getWorkpageStarter().startWorkpage((IWorkpageDispatcher)this.getOwningDispatcher().getTopOwner(), this.getWorkpageContainer(), wpi);
    }

    protected void startPageInNewBrowser(WorkpageStartInfo wpsi) {
        String newBrowserName = UniqueIdCreator.createUUID();
        MultiWorkplaceConnector mwp = MultiWorkplaceConnector.instance();
        mwp.startWorkpage((IWorkpageDispatcher)this.getOwningDispatcher(), newBrowserName, null, wpsi, true);
    }

    public static interface IFunctionNodeActionListener {
        public void reacOnActionEvent(FunctionNode var1, ActionEvent var2);
    }

    public static class DefaultFunctionNodeActionListener
    implements IFunctionNodeActionListener {
        @Override
        public void reacOnActionEvent(FunctionNode node, ActionEvent event) {
        }
    }

    public class FunctionNode
    extends FIXGRIDTreeItem
    implements IWorkpageStartInfo,
    Serializable {
        String i_dropReceive;
        String i_dragSend;
        WorkpageStartInfo i_wpsi;
        String i_lastToggleRequestId;
        String i_nodeTooltip;
        String i_clientName;

        public FunctionNode(FIXGRIDTreeItem parentNode) {
            super(parentNode);
            this.i_wpsi = null;
            this.i_lastToggleRequestId = "inittini";
            this.i_nodeTooltip = null;
            this.i_clientName = null;
        }

        public FunctionNode(FIXGRIDTreeItem parentNode, String page) {
            super(parentNode);
            this.i_wpsi = null;
            this.i_lastToggleRequestId = "inittini";
            this.i_nodeTooltip = null;
            this.i_clientName = null;
            this.i_wpsi = new WorkpageStartInfo();
            this.i_wpsi.setJspPage(page);
        }

        public FunctionNode(FIXGRIDTreeItem parentNode, WorkpageStartInfo wpsi) {
            super(parentNode);
            this.i_wpsi = null;
            this.i_lastToggleRequestId = "inittini";
            this.i_nodeTooltip = null;
            this.i_clientName = null;
            this.i_wpsi = wpsi;
            this.setText(wpsi.getText());
        }

        @Override
        public void processTREENDOEAction(ActionEvent event) {
            super.processTREENDOEAction(event);
            if (WorkplaceFunctionTree.this.m_functionNodeActionListener != null) {
                try {
                    WorkplaceFunctionTree.this.m_functionNodeActionListener.reacOnActionEvent(this, event);
                }
                catch (Throwable t) {
                    CLog.L.log(CLog.LL_WAR, "Error returned from function node listener processing: " + this.getText(), t);
                }
            }
        }

        public void setClientName(String clientName) {
            this.i_clientName = clientName;
        }

        @Override
        public void setDecorated(boolean value) {
            if (this.i_wpsi != null) {
                this.i_wpsi.setDecorated(value);
            }
        }

        @Override
        public void setOpenMultipleInstances(boolean value) {
            if (this.i_wpsi != null) {
                this.i_wpsi.setOpenMultipleInstances(value);
            }
        }

        @Override
        public String getWindowTitle() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getWindowTitle();
            }
            return null;
        }

        @Override
        public boolean isDecorated() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.isDecorated();
            }
            return false;
        }

        @Override
        public boolean getOpenMultipleInstances() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getOpenMultipleInstances();
            }
            return false;
        }

        @Override
        public boolean getOpenAsPopupByDefault() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getOpenAsPopupByDefault();
            }
            return false;
        }

        @Override
        public String getJspPage() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getJspPage();
            }
            return null;
        }

        @Override
        public String getId() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getId();
            }
            return null;
        }

        @Override
        public String getParam(String paramName) {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getParam(paramName);
            }
            return null;
        }

        @Override
        public Map<String, String> getParamMap() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getParamMap();
            }
            return new HashMap<String, String>();
        }

        @Override
        public void setFunctionClassName(String functionClassName) {
            if (this.i_wpsi != null) {
                this.i_wpsi.setFunctionClassName(functionClassName);
            }
        }

        @Override
        public String getFunctionClassName() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getFunctionClassName();
            }
            return null;
        }

        @Override
        public int getSortIndex() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getSortIndex();
            }
            return -1;
        }

        @Override
        public String getClientName() {
            if (this.i_clientName != null) {
                return this.i_clientName;
            }
            if (this.i_wpsi != null && this.i_wpsi.getClientName() != null) {
                return this.i_wpsi.getClientName();
            }
            int index = WorkplaceFunctionTree.this.m_ftree.getRows().indexOf(this);
            return "wp_functiontree_treenode_" + index;
        }

        @Override
        public void onRowExecute() {
            super.onRowExecute();
            if (this.i_wpsi != null) {
                WorkplaceFunctionTree.this.loadContentPage(this.i_wpsi);
            }
            if (!this.i_lastToggleRequestId.equals(HttpSessionAccess.getCurrentRequestId())) {
                if (this.i_wpsi == null && this.getStatusInt() != 2) {
                    if (this.getStatusInt() == 0) {
                        this.setStatus(1);
                    } else {
                        this.setStatus(0);
                    }
                }
                this.i_lastToggleRequestId = HttpSessionAccess.getCurrentRequestId();
            }
        }

        @Override
        public void onToggle() {
            super.onToggle();
            if (this.i_lastToggleRequestId.equals(HttpSessionAccess.getCurrentRequestId()) && this.getStatusInt() != 2) {
                if (this.getStatusInt() == 0) {
                    this.setStatus(1);
                } else {
                    this.setStatus(0);
                }
            }
            this.i_lastToggleRequestId = HttpSessionAccess.getCurrentRequestId();
        }

        @Override
        public void onRowSelect() {
            super.onRowSelect();
        }

        public void onStartInNewBrowser(ActionEvent event) {
            WorkplaceFunctionTree.this.startPageInNewBrowser(this.i_wpsi);
        }

        public String getDragSend() {
            String result = null;
            if (this.i_wpsi != null) {
                result = WorkplaceUtil.encodePageInfo(this.i_wpsi);
            }
            if (this.i_dragSend != null) {
                result = result != null ? result + ";" + this.i_dragSend : this.i_dragSend;
            }
            return result;
        }

        @Override
        public void setText(String value) {
            super.setText(value);
            if (this.i_wpsi != null) {
                this.i_wpsi.setText(value);
            }
        }

        @Override
        public void setImage(String value) {
            super.setImage(value);
            if (value != null && this.i_wpsi != null && this.i_wpsi.getImage() == null) {
                this.i_wpsi.setImage(value);
            }
        }

        @Override
        public void setId(String value) {
            if (this.i_wpsi != null) {
                this.i_wpsi.setId(value);
            }
        }

        @Override
        public String getText() {
            String result = ResourceManager.findText(this.getTextOriginal());
            return result;
        }

        public String getTextOriginal() {
            String text = null;
            text = this.i_wpsi != null ? this.i_wpsi.getText() : super.getText();
            return text;
        }

        @Override
        public String getImage() {
            String result = null;
            result = super.getImage();
            if (result == null && this.i_wpsi != null) {
                result = this.i_wpsi.getImage();
            }
            return result;
        }

        @Override
        public void setParam(String paramName, String paramValue) {
            if (this.i_wpsi != null) {
                this.i_wpsi.setParam(paramName, paramValue);
            }
        }

        @Override
        public void removeParam(String paramName) {
            if (this.i_wpsi != null) {
                this.i_wpsi.removeParam(paramName);
            }
        }

        @Override
        public void setJspPage(String jspPage) {
            if (this.i_wpsi != null) {
                this.i_wpsi.setJspPage(jspPage);
            }
        }

        @Override
        public void setPopupSupported(boolean value) {
            if (this.i_wpsi != null) {
                this.i_wpsi.setPopupSupported(value);
            }
        }

        @Override
        public void setCloseSupported(boolean value) {
            if (this.i_wpsi != null) {
                this.i_wpsi.setCloseSupported(value);
            }
        }

        @Override
        public void setOpenAsPopupByDefault(boolean value) {
            if (this.i_wpsi != null) {
                this.i_wpsi.setOpenAsPopupByDefault(value);
            }
        }

        @Override
        public void setSelectorTitle(String value) {
            if (this.i_wpsi != null) {
                this.i_wpsi.setSelectorTitle(value);
            }
        }

        @Override
        public void setWindowTitle(String value) {
            if (this.i_wpsi != null) {
                this.i_wpsi.setWindowTitle(value);
            }
        }

        public void setDropReceive(String value) {
            this.i_dropReceive = value;
        }

        public String getDropReceive() {
            String result = null;
            if (WorkplaceFunctionTree.this.m_functionNodeDefaultDropReceive != null) {
                result = WorkplaceFunctionTree.this.m_functionNodeDefaultDropReceive;
            }
            if (this.i_dropReceive != null) {
                result = result != null ? result + ";" + this.i_dropReceive : this.i_dropReceive;
            }
            return result;
        }

        public void setDragSend(String value) {
            this.i_dragSend = value;
        }

        public WorkpageStartInfo getWorkpageStartInfo() {
            return this.i_wpsi;
        }

        @Override
        public void setStartSubWorkpageContainerId(String value) {
            if (this.i_wpsi != null) {
                this.i_wpsi.setStartSubWorkpageContainerId(value);
            }
        }

        @Override
        public boolean getPopupSuppoted() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getPopupSuppoted();
            }
            return true;
        }

        @Override
        public boolean getCloseSupported() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getCloseSupported();
            }
            return true;
        }

        @Override
        public String getStartSubWorkpageContainerId() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getStartSubWorkpageContainerId();
            }
            return null;
        }

        @Override
        public String getSelectorTitle() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getSelectorTitle();
            }
            return null;
        }

        @Override
        public String getSelectorBgpaint() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getSelectorBgpaint();
            }
            return null;
        }

        @Override
        public void setSelectorBgpaint(String selectorBgpaint) {
        }

        @Override
        public void setPageBeanName(String pageBeanName) {
            if (this.i_wpsi != null) {
                this.i_wpsi.setPageBeanName(pageBeanName);
            }
        }

        @Override
        public String getPageBeanName() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getPageBeanName();
            }
            return null;
        }

        public void setNodeTooltip(String nodeTooltip) {
            this.i_nodeTooltip = nodeTooltip;
        }

        public String getTooltip() {
            String result = null;
            result = this.i_wpsi != null && this.i_wpsi.getComment() != null ? ResourceManager.findText(this.i_wpsi.getComment()) : (this.i_nodeTooltip != null && this.i_nodeTooltip.length() > 0 ? ResourceManager.findText(this.i_nodeTooltip) : this.getText());
            if (this.i_wpsi != null && this.i_wpsi.getCode() != null && this.i_wpsi.getCode().length() > 0) {
                result = result + " (" + this.i_wpsi.getCode() + ")";
            }
            return result;
        }

        @Override
        public boolean getExcludeFromSavePerspective() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getExcludeFromSavePerspective();
            }
            return false;
        }

        @Override
        public void setExcludeFromSavePerspective(boolean excludeFromSavePerspective) {
            this.i_wpsi.setExcludeFromSavePerspective(excludeFromSavePerspective);
        }

        @Override
        public String getComment() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getComment();
            }
            return null;
        }

        @Override
        public void setComment(String comment) {
            this.i_wpsi.setComment(comment);
        }

        @Override
        public String getCommentImage() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getCommentImage();
            }
            return null;
        }

        @Override
        public void setCommentImage(String commentImage) {
            this.i_wpsi.setCommentImage(commentImage);
        }

        @Override
        public String getCode() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getCode();
            }
            return null;
        }

        @Override
        public void setCode(String code) {
            this.i_wpsi.setCode(code);
        }

        @Override
        public String getAppReference1() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getAppReference1();
            }
            return null;
        }

        @Override
        public void setAppReference1(String appReference1) {
            this.i_wpsi.setAppReference1(appReference1);
        }

        @Override
        public String getAppReference2() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getAppReference2();
            }
            return null;
        }

        @Override
        public void setAppReference2(String appReference2) {
            this.i_wpsi.setAppReference2(appReference2);
        }

        @Override
        public String getAppReference3() {
            if (this.i_wpsi != null) {
                return this.i_wpsi.getAppReference3();
            }
            return null;
        }

        @Override
        public void setAppReference3(String appReference3) {
            this.i_wpsi.setAppReference3(appReference3);
        }

        public boolean getOverlayAreaRendered() {
            if (this.i_wpsi != null) {
                return SystemXml.getWorkplaceMultiScreenStartInFunctionTree();
            }
            return false;
        }
    }
}

