/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.io.Serializable;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import org.eclnt.jsfserver.streamstore.StreamStore;
import org.eclnt.util.log.CLog;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.WorkplaceUserInfo;

public class WorkplaceUserInfoManager
implements Serializable {
    public static WorkplaceUserInfo loadUserInfo(String userName) {
        Throwable t1 = null;
        Throwable t2 = null;
        try {
            String streamStoreName = WorkplaceUserInfoManager.buildStreamStoreName(userName);
            String xml = StreamStore.getInstance().readUTF8(streamStoreName, true);
            return WorkplaceUserInfoManager.unmarshalUserInfo(xml);
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_INF, "Accessing user info for username " + userName + "failed: " + t.toString());
            t1 = t;
            try {
                String streamStoreName = WorkplaceUserInfoManager.buildStreamStoreName("undefined");
                String xml = StreamStore.getInstance().readUTF8(streamStoreName, true);
                return WorkplaceUserInfoManager.unmarshalUserInfo(xml);
            }
            catch (Throwable t3) {
                CLog.L.log(CLog.LL_INF, "Accessing user info for username undefined failed: " + t3.toString());
                t2 = t3;
                if (CLog.L.isLoggable(CLog.LL_DBG)) {
                    CLog.L.log(CLog.LL_DBG, "No user info found, Exception when accessing " + userName, t1);
                }
                if (CLog.L.isLoggable(CLog.LL_DBG)) {
                    CLog.L.log(CLog.LL_DBG, "No user info found, Exception when accessing undefined", t2);
                }
                throw new Error(t1);
            }
        }
    }

    public static WorkplaceUserInfo unmarshalUserInfo(String xml) {
        try {
            Source r = ValueManager.convertStringIntoXMLSource(xml);
            JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{WorkplaceUserInfo.class});
            Unmarshaller um = jbContext.createUnmarshaller();
            WorkplaceUserInfo result = (WorkplaceUserInfo)um.unmarshal(r);
            return result;
        }
        catch (Throwable t) {
            throw new Error(t);
        }
    }

    public static String marshalUserInfo(WorkplaceUserInfo wui) {
        try {
            JAXBContext jbContext = JAXBContext.newInstance((Class[])new Class[]{WorkplaceUserInfo.class});
            Marshaller m = jbContext.createMarshaller();
            m.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            m.setProperty("jaxb.encoding", (Object)"UTF-8");
            StringWriter writer = new StringWriter();
            m.marshal((Object)wui, (Writer)writer);
            String xml = ((Object)writer).toString();
            return xml;
        }
        catch (Throwable t) {
            CLog.L.log(CLog.LL_ERR, "Error when marshalling tree");
            throw new Error(t);
        }
    }

    private static String buildStreamStoreName(String userName) {
        return "ccworkplace/userinfo/" + userName + ".xml";
    }

    public static void main(String[] args) {
        WorkplaceUserInfo wui = new WorkplaceUserInfo();
        wui.getPerspectives().add("Perspective1");
        wui.getPerspectives().add("Perspective2");
        wui.getPerspectives().add("Perspective3");
        wui.setDefaultPerspective("Perspective1");
        wui.setFunctionTree("default");
        String s = WorkplaceUserInfoManager.marshalUserInfo(wui);
        System.out.println(s);
    }
}

