/*
 * Decompiled with CFR 0.152.
 */
package org.eclnt.workplace;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclnt.util.valuemgmt.ValueManager;
import org.eclnt.workplace.WorkpageStartInfo;
import org.eclnt.workplace.WorkplaceFunctionTreeInfoNode;

public class WorkplaceUtil {
    public static WorkpageStartInfo decodeWorkpageStartInfoFromCSV(String csv) {
        if (csv == null) {
            return null;
        }
        if (csv.startsWith("VERSION2//")) {
            csv = csv.substring("VERSION2//".length());
            return WorkplaceUtil.decodeWorkpageStartInfoFromCSVVersion2(csv);
        }
        return WorkplaceUtil.decodeWorkpageStartInfoFromCSVVersion1(csv);
    }

    private static WorkpageStartInfo decodeWorkpageStartInfoFromCSVVersion1(String csv) {
        String[] sl = ValueManager.decodeCSV(csv);
        WorkpageStartInfo result = new WorkpageStartInfo();
        result.setJspPage(sl[0]);
        result.setId(sl[1]);
        result.setText(sl[2]);
        result.setOpenMultipleInstances(ValueManager.decodeBoolean(sl[3], false));
        result.setDecorated(ValueManager.decodeBoolean(sl[4], true));
        if (!sl[5].equals("null")) {
            result.setImage(sl[5]);
        }
        if (!sl[6].equals("null")) {
            result.setSelectorTitle(sl[6]);
        }
        if (!sl[7].equals("null")) {
            result.setWindowTitle(sl[7]);
        }
        result.setPopupSupported(ValueManager.decodeBoolean(sl[8], true));
        result.setCloseSupported(ValueManager.decodeBoolean(sl[9], true));
        if (!sl[10].equals("null")) {
            result.setStartSubWorkpageContainerId(sl[10]);
        }
        result.setExcludeFromSavePerspective(ValueManager.decodeBoolean(sl[11], false));
        if (!sl[12].equals("null")) {
            result.setPageBeanName(sl[12]);
        }
        if (!sl[13].equals("null")) {
            result.setFunctionClassName(sl[13]);
        }
        try {
            for (int i = 14; i < sl.length; i += 2) {
                if ("ccparam_comment".equals(sl[i])) {
                    result.setComment(sl[i + 1]);
                    continue;
                }
                if ("ccparam_commentImage".equals(sl[i])) {
                    result.setCommentImage(sl[i + 1]);
                    continue;
                }
                result.setParam(sl[i], sl[i + 1]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    private static WorkpageStartInfo decodeWorkpageStartInfoFromCSVVersion2(String csv) {
        String[] sl = ValueManager.decodeCSV(csv);
        WorkpageStartInfo result = new WorkpageStartInfo();
        result.setJspPage(sl[0]);
        result.setId(sl[1]);
        result.setText(sl[2]);
        result.setOpenMultipleInstances(ValueManager.decodeBoolean(sl[3], false));
        result.setDecorated(ValueManager.decodeBoolean(sl[4], true));
        if (!sl[5].equals("null")) {
            result.setImage(sl[5]);
        }
        if (!sl[6].equals("null")) {
            result.setSelectorTitle(sl[6]);
        }
        if (!sl[7].equals("null")) {
            result.setWindowTitle(sl[7]);
        }
        result.setPopupSupported(ValueManager.decodeBoolean(sl[8], true));
        result.setCloseSupported(ValueManager.decodeBoolean(sl[9], true));
        if (!sl[10].equals("null")) {
            result.setStartSubWorkpageContainerId(sl[10]);
        }
        result.setExcludeFromSavePerspective(ValueManager.decodeBoolean(sl[11], false));
        if (!sl[12].equals("null")) {
            result.setPageBeanName(sl[12]);
        }
        if (!sl[13].equals("null")) {
            result.setFunctionClassName(sl[13]);
        }
        if (!sl[14].equals("null")) {
            result.setCode(sl[14]);
        }
        try {
            for (int i = 15; i < sl.length; i += 2) {
                if ("ccparam_comment".equals(sl[i])) {
                    result.setComment(sl[i + 1]);
                    continue;
                }
                if ("ccparam_commentImage".equals(sl[i])) {
                    result.setCommentImage(sl[i + 1]);
                    continue;
                }
                result.setParam(sl[i], sl[i + 1]);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return result;
    }

    public static WorkpageStartInfo decodeDroppedWorkpage(String dragsendType, String droppedString) {
        if (droppedString.startsWith(dragsendType + ":")) {
            droppedString = droppedString.substring((dragsendType + ":").length());
            WorkpageStartInfo result = WorkplaceUtil.decodeWorkpageStartInfoFromCSV(droppedString);
            return result;
        }
        return null;
    }

    public static WorkpageStartInfo decodeDroppedWorkpage(String droppedString) {
        return WorkplaceUtil.decodeDroppedWorkpage("workpage", droppedString);
    }

    public static String encodeWorkpageStartInfoToCSV(WorkpageStartInfo wpsi) {
        if (wpsi == null) {
            return null;
        }
        ArrayList<String> sl = new ArrayList<String>();
        sl.add(wpsi.getJspPage());
        sl.add(wpsi.getId());
        sl.add(wpsi.getText());
        sl.add(wpsi.getOpenMultipleInstances() + "");
        sl.add(wpsi.isDecorated() + "");
        sl.add(wpsi.getImage() + "");
        sl.add(wpsi.getSelectorTitle());
        sl.add(wpsi.getWindowTitle());
        sl.add("" + wpsi.isPopupSupported());
        sl.add("" + wpsi.isCloseSupported());
        sl.add("" + wpsi.getStartSubWorkpageContainerId());
        sl.add("" + wpsi.getExcludeFromSavePerspective());
        sl.add("" + wpsi.getPageBeanName());
        sl.add("" + wpsi.getFunctionClassName());
        sl.add("" + wpsi.getCode());
        for (String key : wpsi.getParamMap().keySet()) {
            sl.add(key);
            sl.add(wpsi.getParamMap().get(key));
        }
        if (wpsi.getComment() != null) {
            sl.add("ccparam_comment");
            sl.add(wpsi.getComment());
        }
        if (wpsi.getCommentImage() != null) {
            sl.add("ccparam_commentImage");
            sl.add(wpsi.getCommentImage());
        }
        String csv = ValueManager.encodeCSV(sl);
        csv = "VERSION2//" + csv;
        return csv;
    }

    public static String encodePageInfo(String dragsendType, WorkpageStartInfo wpsi) {
        if (wpsi == null) {
            return null;
        }
        String csv = WorkplaceUtil.encodeWorkpageStartInfoToCSV(wpsi);
        HashMap<String, String> cv = new HashMap<String, String>();
        cv.put(dragsendType, csv);
        return ValueManager.encodeComplexValue(cv);
    }

    public static String encodePageInfo(WorkpageStartInfo wpsi) {
        return WorkplaceUtil.encodePageInfo("workpage", wpsi);
    }

    public static void removeEmptyFolders(WorkplaceFunctionTreeInfoNode node) {
        HashMap<WorkplaceFunctionTreeInfoNode, WorkplaceFunctionTreeInfoNode> childParentRelations = new HashMap<WorkplaceFunctionTreeInfoNode, WorkplaceFunctionTreeInfoNode>();
        WorkplaceUtil.buildupChildParentRelations(node, childParentRelations);
        WorkplaceUtil.removeEmptyFolders(node, childParentRelations);
    }

    private static void removeEmptyFolders(WorkplaceFunctionTreeInfoNode node, Map<WorkplaceFunctionTreeInfoNode, WorkplaceFunctionTreeInfoNode> childParentRelations) {
        ArrayList<WorkplaceFunctionTreeInfoNode> subNodesClone = new ArrayList<WorkplaceFunctionTreeInfoNode>(node.getSubNodes());
        for (WorkplaceFunctionTreeInfoNode subNode : subNodesClone) {
            if (subNode.getSubNodes().size() == 0 && subNode.getWorkpageStartInfo() == null && subNode.getEmbeddedTreeName() == null) {
                WorkplaceUtil.removeNode(subNode, childParentRelations);
                continue;
            }
            WorkplaceUtil.removeEmptyFolders(subNode, childParentRelations);
        }
    }

    private static void removeNode(WorkplaceFunctionTreeInfoNode node, Map<WorkplaceFunctionTreeInfoNode, WorkplaceFunctionTreeInfoNode> childParentRelations) {
        WorkplaceFunctionTreeInfoNode parentNode = childParentRelations.get(node);
        if (parentNode != null) {
            parentNode.getSubNodes().remove(node);
            childParentRelations.remove(node);
            if (parentNode.getSubNodes().size() == 0) {
                WorkplaceUtil.removeNode(parentNode, childParentRelations);
            }
        }
    }

    private static void buildupChildParentRelations(WorkplaceFunctionTreeInfoNode node, Map<WorkplaceFunctionTreeInfoNode, WorkplaceFunctionTreeInfoNode> childParentRelations) {
        for (WorkplaceFunctionTreeInfoNode subNode : node.getSubNodes()) {
            childParentRelations.put(subNode, node);
            WorkplaceUtil.buildupChildParentRelations(subNode, childParentRelations);
        }
    }
}

