/*
 * Decompiled with CFR 0.152.
 */
package test;

import org.eclnt.util.classresolver.DefaultClassResolver;
import org.eclnt.util.classresolver.ENUMCallerType;
import org.eclnt.util.valuemgmt.ValueManager;
import org.junit.Assert;
import org.junit.Test;

public class TestDefaultClassResolver {
    static int LOOP_COUNT = 1000000;

    @Test
    public void testNaming() {
        try {
            DefaultClassResolver classResolver = new DefaultClassResolver();
            Class c = classResolver.resolveClass(ValueManager.class.getName(), ENUMCallerType.APPLICATION);
            Assert.assertTrue((c != null ? 1 : 0) != 0);
            long tsStart = System.nanoTime();
            for (int i = 0; i < LOOP_COUNT; ++i) {
                classResolver.resolveClass(ValueManager.class.getName(), ENUMCallerType.APPLICATION);
            }
            long tsEnd = System.nanoTime();
            System.out.println("BUFFERED  : " + (tsEnd - tsStart));
            System.out.println("BUFFERED  : " + (tsEnd - tsStart) / 1000000L);
            tsStart = System.nanoTime();
            for (int i = 0; i < LOOP_COUNT; ++i) {
                try {
                    Class.forName(ValueManager.class.getName());
                    continue;
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
            }
            tsEnd = System.nanoTime();
            System.out.println("UNBUFFERED: " + (tsEnd - tsStart));
            System.out.println("UNBUFFERED: " + (tsEnd - tsStart) / 1000000L);
            System.out.println("FINISHED");
        }
        catch (Throwable t) {
            t.printStackTrace();
            Assert.fail((String)t.getMessage());
        }
    }
}

